/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.pak.internal.install;

import com.ibm.ws.pak.internal.PakCoreMessages;
import com.ibm.ws.pak.internal.utils.events.ComponentActionEvent;
import com.ibm.ws.pak.internal.utils.events.NIFEvent;
import com.ibm.ws.pak.internal.utils.events.NIFEventMulticaster;
import com.ibm.ws.pak.internal.utils.events.NIFEventObserver;
import com.ibm.ws.pak.internal.utils.events.NIFPackageApplicationPluginEvent;
import com.ibm.ws.pak.internal.utils.logging.Logr;

public class NIFPackageApplicationPluginHelper {
    private boolean m_fPublishEvents = false;
    private boolean m_fIsABackupPackage = false;
    private final NIFEventObserver nifeoOurComponentActionObserver = new NIFEventObserver(){
        {
            NIFEventMulticaster.instance().subscribe(this, 2);
        }

        @Override
        public void eventOccured(NIFEvent nife) {
            NIFPackageApplicationPluginHelper.this.sendUpdateEventForComponentActions((ComponentActionEvent)nife);
        }
    };
    private static final int N_HUNDRED = 100;
    private final String className = "NIFPackageApplicationPluginHelper";

    public NIFPackageApplicationPluginHelper(boolean fPublishEvents, boolean fIsABackupPackage) {
        this.m_fPublishEvents = fPublishEvents;
        this.m_fIsABackupPackage = fIsABackupPackage;
    }

    public void startTrappingAndPublishingInstallEvents() {
        this.m_fPublishEvents = true;
    }

    public void stopTrappingAndPublishingInstallEvents() {
        this.m_fPublishEvents = false;
    }

    public void setBackupPackageFlag(boolean fIsABackupPackage) {
        Logr.methodEntry("NIFPackageApplicationPluginHelper", "setBackupPackageFlag");
        this.m_fIsABackupPackage = fIsABackupPackage;
        Logr.methodExit("NIFPackageApplicationPluginHelper", "setBackupPackageFlag");
    }

    private void sendUpdateEventForComponentActions(ComponentActionEvent cae) {
        if (!this.m_fPublishEvents) {
            return;
        }
        double dTotalPercentComplete = 0.0;
        int nFileNumber = 0;
        int nTotalFiles = 0;
        if (cae.getComponentActionFileEvent() != null) {
            double dCurrentFilePercentComplete = (cae.getComponentActionFileEvent().getFileNumber() + 1) / (cae.getComponentActionFileEvent().getTotalFiles() * cae.getTotalComponents());
            double dCurrentComponentPercentComplete = (double)cae.getCurrentComponentNumber() / (double)cae.getTotalComponents();
            dTotalPercentComplete = (dCurrentFilePercentComplete + dCurrentComponentPercentComplete) * 100.0;
            nFileNumber = cae.getComponentActionFileEvent().getFileNumber();
            nTotalFiles = cae.getComponentActionFileEvent().getTotalFiles();
        } else {
            dTotalPercentComplete = (double)(cae.getCurrentComponentNumber() + 1) / (double)cae.getTotalComponents() * 100.0;
            nFileNumber = 0;
            nTotalFiles = 0;
        }
        int nTotalPercentComplete = (int)dTotalPercentComplete;
        String sStatusMessage = null;
        sStatusMessage = !cae.isComponentBeingBackedUp() ? PakCoreMessages.bind((String)PakCoreMessages.PAK_CORE_S_UPDATING_PROGRESS_MESSAGE_TEXT, (Object)cae.getComponentName()) : PakCoreMessages.bind((String)PakCoreMessages.PAK_CORE_S_BACKUP_MODE_PROGRESS_MESSAGE_TEXT, (Object)cae.getComponentName());
        NIFEventMulticaster.instance().publishEvent(new NIFPackageApplicationPluginEvent(sStatusMessage, nTotalPercentComplete, nFileNumber, nTotalFiles, cae.getCurrentComponentNumber(), cae.getComponentName(), cae.isComponentBeingBackedUp(), cae.getTotalComponents(), this.m_fIsABackupPackage));
    }

    public NIFEventObserver getComponentActionObserver() {
        return this.nifeoOurComponentActionObserver;
    }
}

