/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.internal.adapters.pakAdapter;

import com.ibm.cic.agent.core.AbstractVariableSubstitution;
import com.ibm.cic.agent.core.InstallContext;
import com.ibm.cic.agent.core.PerformChildInstallOperation;
import com.ibm.cic.agent.core.commonNativeInstallAdapter.ICommonNativeInstallAdapter;
import com.ibm.cic.agent.internal.adapters.pakAdapter.LogrFactory;
import com.ibm.cic.agent.internal.adapters.pakAdapter.Messages;
import com.ibm.cic.common.commonNativeAdapterData.FileCommonNativeData;
import com.ibm.cic.common.commonNativeAdapterData.PerformCommonNativeData;
import com.ibm.cic.common.core.model.IInstallableUnit;
import com.ibm.cic.common.core.model.adapterdata.CommonAdapterData;
import com.ibm.cic.common.logging.Logger;
import com.ibm.cic.common.pakAdapterData.PakCommonAdapterData;
import com.ibm.cic.common.pakAdapterData.PakPropertyData;
import com.ibm.ws.pak.core.PakData;
import com.ibm.ws.pak.core.PakDataFactory;
import com.ibm.ws.pak.core.action.PakInvokeAction;
import com.ibm.ws.pak.internal.utils.logging.ILogr;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedWriter;
import java.io.File;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Properties;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.osgi.util.NLS;

public class PakInstallOperation
extends PerformChildInstallOperation
implements PropertyChangeListener {
    private static final String UNINSTALL = "UNINSTALL";
    private static final String INSTALL = "INSTALL";
    private static final Logger log = Logger.getLogger(PakInstallOperation.class);
    private final ICommonNativeInstallAdapter.SupplementaryLogWriter writer;
    private final PakCommonAdapterData pakAdapterData;
    private IProgressMonitor progressMonitor;
    private final InstallContext context;
    private String targetInstallLocation;
    private final int phase;
    private int oldStatusValue = 0;

    public PakInstallOperation(int phase, IInstallableUnit unit, InstallContext context, PakCommonAdapterData data, PerformCommonNativeData performData, ICommonNativeInstallAdapter.SupplementaryLogWriter writer) {
        super(phase, unit, context, performData);
        this.writer = writer;
        this.pakAdapterData = data;
        this.phase = phase;
        this.context = context;
    }

    protected CommonAdapterData getData() {
        return this.pakAdapterData;
    }

    protected Logger getLog() {
        return log;
    }

    protected String getName() {
        return "PAKOperation";
    }

    protected IStatus doPerform(IProgressMonitor monitor) {
        PrintWriter printWriter = null;
        try {
            try {
                printWriter = new PrintWriter((Writer)new BufferedWriter((Writer)this.writer), true);
                this.applyPak(printWriter, monitor);
            }
            catch (CoreException e) {
                log.error((Throwable)e);
                IStatus iStatus = e.getStatus();
                if (printWriter != null) {
                    printWriter.flush();
                }
                return iStatus;
            }
        }
        finally {
            if (printWriter != null) {
                printWriter.flush();
            }
        }
        return Status.OK_STATUS;
    }

    private void applyPak(PrintWriter printWriter, IProgressMonitor monitor) throws CoreException {
        FileCommonNativeData[] fileArray;
        this.progressMonitor = new SubProgressMonitor(monitor, 1);
        String operation = this.getOperation();
        this.targetInstallLocation = this.getInstallLocation();
        String productInfoFile = this.getProductInfoFile(this.targetInstallLocation);
        Properties optionalProperties = this.getProperties();
        PakDataFactory pakDataFactory = new PakDataFactory();
        pakDataFactory.setOperation(operation);
        pakDataFactory.setInstallLocation(this.targetInstallLocation);
        pakDataFactory.setProductProvidersXMLPath(productInfoFile);
        pakDataFactory.setOptionalProperties(optionalProperties);
        log.debug("Pak data attributes:");
        log.debug(" installLocation=" + this.targetInstallLocation);
        log.debug(" productInfoFile=" + productInfoFile);
        log.debug(" properties:" + productInfoFile);
        if (optionalProperties != null) {
            Enumeration<?> propertyNames = optionalProperties.propertyNames();
            while (propertyNames.hasMoreElements()) {
                String key = (String)propertyNames.nextElement();
                log.debug("  [" + key + "," + optionalProperties.getProperty(key) + "]");
            }
        }
        FileCommonNativeData[] fileCommonNativeDataArray = fileArray = this.pakAdapterData.getFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            FileCommonNativeData element = fileCommonNativeDataArray[n2];
            IPath pakPath = this.getPakFilePath(element.getFileText(), this.targetInstallLocation, operation);
            String pakFileName = pakPath.toFile().getName();
            String pakLocation = pakPath.toFile().getParent();
            pakDataFactory.setPakFileName(pakFileName);
            pakDataFactory.setPakLocation(pakLocation);
            String debugTag = String.valueOf(operation) + " " + pakFileName + " in " + pakLocation;
            log.debug("Start to " + debugTag);
            PakInvokeAction action = new PakInvokeAction();
            LogrFactory logrFactory = new LogrFactory("com.ibm.ws.PAKEngine");
            action.initializeLogger((ILogr)logrFactory.getLogr());
            action.initializeDebugLogger((ILogr)logrFactory.getDebugLogr());
            PakData pakData = null;
            try {
                pakData = pakDataFactory.createPakData();
            }
            catch (Exception e) {
                throw new CoreException((IStatus)new Status(4, "pakAdapter", e.getLocalizedMessage(), (Throwable)e));
            }
            this.progressMonitor.beginTask("PakInstallOperation", 100);
            this.setOldStatusValue(0);
            try {
                IStatus status = action.invokePakAction(pakData, (PropertyChangeListener)this);
                log.debug(String.valueOf(debugTag) + "Return Code = " + status.getCode());
                log.debug(String.valueOf(debugTag) + "Return Result = " + status.getMessage());
                log.debug("End " + debugTag);
                if (!status.isOK()) {
                    throw new CoreException(status);
                }
            }
            finally {
                logrFactory.getDebugLogr().close();
            }
            this.progressMonitor.done();
            ++n2;
        }
    }

    private String getOperation() {
        String operation = null;
        if (this.phase == 21 || this.phase == 10 || this.phase == 30) {
            operation = INSTALL;
        } else if (this.phase == 51 || this.phase == 40 || this.phase == 60) {
            operation = UNINSTALL;
        }
        return operation;
    }

    private String getProductInfoFile(String installLocation) throws CoreException {
        String productInfoFile = this.pakAdapterData.getProductInfoFile();
        if (!new Path(productInfoFile = this.performVariableSubstitutions(productInfoFile)).isAbsolute()) {
            productInfoFile = new Path(installLocation).append(productInfoFile).toOSString();
        }
        if (!new File(productInfoFile).isFile()) {
            log.debug("File " + new Path(productInfoFile).toOSString() + " is not found.");
            throw new CoreException((IStatus)new Status(4, "pakAdapter", NLS.bind((String)Messages.error_missing_file, (Object)new Path(productInfoFile).toOSString())));
        }
        return productInfoFile;
    }

    private IPath getPakFilePath(String fileValue, String installLocation, String operation) throws CoreException {
        Path pakPath = new Path(this.performVariableSubstitutions(fileValue, AbstractVariableSubstitution.AllowAbsolutePath.TRUE));
        if (!pakPath.isAbsolute()) {
            pakPath = new Path(this.targetInstallLocation).append((IPath)pakPath);
        }
        if (operation.equals(INSTALL) && !pakPath.toFile().exists()) {
            log.debug("Pak " + pakPath.toOSString() + " is not found.");
            throw new CoreException((IStatus)new Status(4, "pakAdapter", NLS.bind((String)Messages.error_missing_file, (Object)pakPath.toOSString())));
        }
        return pakPath;
    }

    private String getInstallLocation() {
        String installLocation = this.pakAdapterData.getInstallLocation();
        if (installLocation == null || installLocation.equals("")) {
            installLocation = this.context.getInstallLocation();
        }
        return installLocation;
    }

    private Properties getProperties() {
        PakPropertyData[] aPakPropertyData;
        Properties props = new Properties();
        PakPropertyData[] pakPropertyDataArray = aPakPropertyData = this.pakAdapterData.getProps();
        int n = aPakPropertyData.length;
        int n2 = 0;
        while (n2 < n) {
            PakPropertyData element = pakPropertyDataArray[n2];
            props.put(element.getPropertyName(), element.getPropertyValue());
            ++n2;
        }
        if (props.size() == 0) {
            return null;
        }
        return props;
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        String evtName = event.getPropertyName();
        try {
            if ("pakProcessingComponent" == evtName) {
                String compName = (String)event.getNewValue();
                this.progressMonitor.subTask(NLS.bind((String)Messages.ProcessingComponent, (Object)compName));
            } else {
                int evtValue = (Integer)event.getNewValue();
                int worked = evtValue - this.getOldStatusValue();
                if ("pakInstallOverallProgress" == evtName) {
                    log.debug("Overall install progress = " + evtValue);
                    log.debug("Install units worked = " + worked);
                } else if ("pakUninstallOverallProgress" == evtName) {
                    log.debug("Overall uninstall progress = " + evtValue);
                    log.debug("Uninstall units worked = " + worked);
                }
                this.progressMonitor.worked(worked);
                this.setOldStatusValue(evtValue);
            }
        }
        catch (Exception e) {
            log.debug("UNKNOWN ChangeEvent for PakInstallOperation = " + evtName + "; Value= " + event.getNewValue());
            log.debug((Throwable)e);
        }
    }

    public void setOldStatusValue(int value) {
        this.oldStatusValue = value;
    }

    public int getOldStatusValue() {
        return this.oldStatusValue;
    }
}

