/*
 * Decompiled with CFR 0.152.
 */
package com.certicom.ecc.scheme;

import com.certicom.ecc.interfaces.ECPrivateKey;
import com.certicom.ecc.interfaces.ECPublicKey;
import com.certicom.ecc.scheme.CryptoTransform;
import com.certicom.ecc.scheme.ECTransform;
import com.certicom.ecc.spec.ECPublicKeySpec;
import com.certicom.ecc.spec.SharedInfoParameterSpec;
import com.certicom.ecc.system.CryptoManager;
import java.util.Random;

public class ECES
extends ECTransform {
    private ECPrivateKey r = null;
    private byte[] t = null;
    protected CryptoTransform o = (CryptoTransform)CryptoManager.getInstance(CryptoTransform.TYPE, "KDF");
    private boolean q = false;
    protected int p = 0;
    private Boolean s = null;
    private byte[] u = null;
    protected byte[] v = null;

    public ECES() {
        this("ECES");
    }

    protected ECES(String string) {
        super(string);
    }

    public boolean hasInterData() {
        return true;
    }

    public void init(int n, Object[] objectArray, Random random) throws IllegalArgumentException {
        if (n != 3 && n != 4 || objectArray == null || random == null) {
            throw new IllegalArgumentException("wrong params");
        }
        this.reset();
        super.init(n, objectArray, random);
        if (objectArray.length == 2 && objectArray[1] != null) {
            if (objectArray[1] instanceof Boolean) {
                this.s = new Boolean((Boolean)objectArray[1]);
            } else {
                this.u = ((SharedInfoParameterSpec)objectArray[1]).getSharedInfo(0);
            }
        } else if (objectArray.length == 3) {
            if (objectArray[1] != null) {
                this.u = ((SharedInfoParameterSpec)objectArray[1]).getSharedInfo(0);
            }
            if (objectArray[2] != null) {
                this.s = new Boolean((Boolean)objectArray[2]);
            }
        }
        if (n == 3) {
            ECPublicKey eCPublicKey = (ECPublicKey)objectArray[0];
            try {
                CryptoTransform cryptoTransform = (CryptoTransform)CryptoManager.getInstance(CryptoTransform.TYPE, "KEYGEN");
                cryptoTransform.init(5, new Object[]{eCPublicKey.getECParams()}, random);
                Object[] objectArray2 = (Object[])cryptoTransform.transformToObject(null, 0, 0, true);
                this.t = ((ECPublicKey)objectArray2[1]).getPoint().getEncoded(this.j);
                this.p = this.t.length;
                this.a(objectArray2[0], eCPublicKey);
            }
            catch (Exception exception) {
                this.reset();
                throw new IllegalArgumentException("error in computation");
            }
        } else if (n == 4) {
            this.r = (ECPrivateKey)objectArray[0];
            this.p = -((this.r.getECParams().getSize() + 7) / 8 + 1);
        }
    }

    private void a(Object object, Object object2) {
        CryptoTransform cryptoTransform = (CryptoTransform)CryptoManager.getInstance(CryptoTransform.TYPE, "ECDH");
        cryptoTransform.init(6, new Object[]{object, object2, this.s}, this.rnd);
        this.v = cryptoTransform.transform(null, 0, 0, true);
        Object[] objectArray = this.i == 16 ? new Object[]{null, this.v, new byte[4], new Boolean(true)} : new Object[]{this.v, this.u, null, new Boolean(true)};
        this.o.init(5, objectArray, this.rnd);
    }

    public int outputSize(int n, boolean bl) throws IllegalStateException {
        if (this.mode != 3 && this.mode != 4) {
            throw new IllegalStateException("wrong mode");
        }
        if (this.q) {
            return n;
        }
        if (this.mode == 3) {
            return this.p + n;
        }
        int n2 = this.p > 0 ? n - this.p : this.p + n;
        return n2 > 0 ? n2 : 0;
    }

    public void reset() {
        super.reset();
        this.r = null;
        this.t = null;
        this.q = false;
        this.p = 0;
        this.o.reset();
        this.u = null;
        this.v = null;
    }

    public int transform(byte[] byArray, int n, int n2, byte[] byArray2, int n3, boolean bl) throws IllegalArgumentException, IllegalStateException {
        Object object;
        int n4;
        if (byArray == null || n + n2 > byArray.length) {
            throw new IllegalArgumentException("wrong params");
        }
        if (byArray == byArray2) {
            throw new IllegalArgumentException("in == out");
        }
        if (this.mode == 4 && !this.q) {
            if (this.p < 0) {
                if (byArray[n] > 3) {
                    this.p += this.p + 1;
                }
                this.p = -this.p;
            }
            if (this.t == null) {
                this.t = new byte[this.p];
            }
            if ((n4 = n2 - n) >= this.p) {
                n4 = this.p;
            }
            System.arraycopy(byArray, n, this.t, this.t.length - this.p, n4);
            this.p -= n4;
            n += n4;
            n2 -= n4;
            if (this.p == 0) {
                object = new ECPublicKeySpec(this.k, this.j, this.r.getECParams().getPoint().getDecoded(this.t, 0, this.t.length), this.r.getECParams());
                this.t = object.getPoint().getEncoded(this.j);
                this.a(this.r, object);
                this.q = true;
            }
        }
        if (n2 == 0) {
            return 0;
        }
        if (byArray2 == null) {
            throw new IllegalArgumentException("no output buffer");
        }
        n4 = 0;
        if (!this.q) {
            System.arraycopy(this.t, 0, byArray2, n3, this.p);
            n4 += this.p;
            n3 += this.p;
            this.p = 0;
            this.q = true;
        }
        if (n2 > byArray2.length - n3) {
            throw new IllegalArgumentException("buffer too short.");
        }
        object = this.o.transform(null, n, n2, bl);
        n4 += ((byte[])object).length;
        int n5 = n;
        int n6 = 0;
        while (n5 < n + n2) {
            byArray2[n3++] = (byte)(byArray[n5] ^ object[n6]);
            ++n5;
            ++n6;
        }
        return n4;
    }
}

