/*
 * Decompiled with CFR 0.152.
 */
package com.certicom.ecc.scheme;

import java.util.Random;

public abstract class CryptoTransform {
    public static final int UNINIT = 0;
    public static final int SIGN = 1;
    public static final int VERIFY = 2;
    public static final int ENCRYPT = 3;
    public static final int DECRYPT = 4;
    public static final int GENKEY = 5;
    public static final int RAW = 6;
    public static final int KDF = 7;
    public static final Class TYPE;
    protected Random rnd = null;
    protected int mode = 0;
    protected String alg = null;

    static {
        try {
            TYPE = Class.forName("com.certicom.ecc.scheme.CryptoTransform");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new IllegalStateException();
        }
    }

    protected CryptoTransform(String string) {
        this.alg = string;
    }

    public String getAlgorithm() {
        return this.alg;
    }

    public int getMode() {
        return this.mode;
    }

    public boolean hasInterData() {
        return false;
    }

    public void init(int n, Object[] objectArray, Random random) throws IllegalArgumentException {
        this.mode = n;
        this.rnd = random;
    }

    public int inputSize() {
        return 0;
    }

    public boolean isIncremental() {
        return true;
    }

    public boolean isVerifiable() {
        return false;
    }

    public abstract int outputSize(int var1, boolean var2) throws IllegalStateException;

    public void reset() {
        this.mode = 0;
        this.rnd = null;
    }

    public byte[] transform(byte[] byArray, int n, int n2, boolean bl) throws IllegalArgumentException, IllegalStateException {
        int n3 = this.outputSize(n2, bl);
        if (n3 > 0) {
            byte[] byArray2 = new byte[n3];
            if ((n3 = this.transform(byArray, n, n2, byArray2, 0, bl)) < byArray2.length) {
                byte[] byArray3 = new byte[n3];
                System.arraycopy(byArray2, 0, byArray3, 0, n3);
                return byArray3;
            }
            return byArray2;
        }
        this.transform(byArray, n, n2, null, 0, bl);
        return null;
    }

    public abstract int transform(byte[] var1, int var2, int var3, byte[] var4, int var5, boolean var6) throws IllegalArgumentException, IllegalStateException;

    public Object transformToObject(byte[] byArray, int n, int n2, boolean bl) throws IllegalArgumentException, IllegalStateException {
        return this.transform(byArray, n, n2, bl);
    }

    public boolean verify(byte[] byArray, int n, int n2) {
        return false;
    }
}

