/*
 * Decompiled with CFR 0.152.
 */
package com.certicom.ecc.rsa;

import com.certicom.ecc.rsa.RSAKey;
import com.certicom.ecc.rsa.RSAPrimitive;
import com.certicom.ecc.rsa.RSAPrivateKey;
import java.math.BigInteger;

public final class RSADP
extends RSAPrimitive {
    RSAPrivateKey a;

    public RSADP(RSAPrivateKey rSAPrivateKey) {
        this.a = rSAPrivateKey;
    }

    public BigInteger calc(BigInteger bigInteger) {
        if (this.a == null) {
            throw new IllegalStateException("no private key");
        }
        if (this.a.hasExponents()) {
            this.a(bigInteger, this.a.n());
        } else {
            this.a(bigInteger, this.a.p().multiply(this.a.q()));
        }
        if (this.a.hasCRT()) {
            BigInteger bigInteger2 = bigInteger.modPow(this.a.dP(), this.a.p());
            BigInteger bigInteger3 = bigInteger.modPow(this.a.dQ(), this.a.q());
            BigInteger bigInteger4 = this.a.qInv().multiply(bigInteger2.subtract(bigInteger3)).mod(this.a.p());
            return bigInteger3.add(bigInteger4.multiply(this.a.q()));
        }
        return bigInteger.modPow(this.a.d(), this.a.n());
    }

    public void reset() {
        this.a = null;
    }

    public void setKey(RSAKey rSAKey) {
        if (!(rSAKey instanceof RSAPrivateKey)) {
            throw new IllegalArgumentException("not private key.");
        }
        this.a = (RSAPrivateKey)rSAKey;
    }
}

