/*
 * Decompiled with CFR 0.152.
 */
package com.certicom.ecc.asn1;

import com.certicom.ecc.asn1.ECConverter;
import com.certicom.ecc.asn1.ECPrivateKey;
import com.certicom.ecc.asn1.Parameters;
import com.certicom.ecc.codec.ECCodec;
import com.trustpoint.asn.AsnException;
import com.trustpoint.asn.AsnObject;
import com.trustpoint.asn.AsnOctetString;

public class SECGPrivKeyCodec
extends ECCodec {
    public SECGPrivKeyCodec() {
        super("SECG");
    }

    protected SECGPrivKeyCodec(String string) {
        super(string);
    }

    protected void decode() {
        byte[] byArray = new byte[this.doff];
        System.arraycopy(this.data, 0, byArray, 0, this.doff);
        ECPrivateKey eCPrivateKey = new ECPrivateKey();
        try {
            eCPrivateKey.decode(byArray, 1);
        }
        catch (AsnException asnException) {
            throw new IllegalArgumentException("cannot decode key: " + asnException.getLocalizedMessage());
        }
        Object[] objectArray = ECConverter.toValues((Parameters)eCPrivateKey.getValue(2));
        if (objectArray == null || objectArray.length == 1) {
            this.initResult(3);
            this.result[1] = objectArray == null ? "ImplicitlyCA" : objectArray[0];
        } else {
            this.initResult(3 + objectArray.length);
            this.result[1] = "ECParameters";
            int n = 3;
            int n2 = 0;
            while (n2 < objectArray.length) {
                this.result[n] = objectArray[n2];
                ++n;
                ++n2;
            }
        }
        AsnObject asnObject = eCPrivateKey.getValue(1);
        this.result[2] = ((AsnOctetString)asnObject).getValue();
    }

    protected void encode() {
        this.initResult(this.outputSize());
        byte[] byArray = new byte[this.doff];
        System.arraycopy(this.data, 0, byArray, 0, this.doff);
        Parameters parameters = ECConverter.toParameters(this.curve);
        ECPrivateKey eCPrivateKey = new ECPrivateKey(1, byArray, parameters, null);
        try {
            byArray = eCPrivateKey.encode(2);
            this.result[1] = byArray;
        }
        catch (AsnException asnException) {
            throw new IllegalArgumentException("cannot encode key" + asnException.getLocalizedMessage());
        }
    }

    protected void initResult(int n) {
        super.initResult(n);
        this.result[0] = "ECPrivateKey";
    }

    public int outputSize() {
        return 2;
    }
}

