/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.logging;

import com.ibm.cic.common.core.internal.ComIbmCicCommonCorePlugin;
import com.ibm.cic.common.logging.ExceptionUtil;
import com.ibm.cic.common.logging.LogUtil;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.InvalidRegistryObjectException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Bundle;

class Translator {
    private Map inValueToKey;
    private Map outKeyToValue;
    private Map<String, Pattern> inValueToPattern;
    private final Locale targetLocale;
    private Class[] messages;
    public static final String EXPORT_MESSAGES = "exportMessages";
    public static final String CLASS = "class";
    private int numMatch = 0;
    private int numStops = 0;

    public Translator(Locale targetLocale) {
        this.getMessagesClasses();
        this.targetLocale = targetLocale;
        this.initializeMessageMap();
        this.initializePatternMap();
    }

    private void getMessagesClasses() {
        IExtension[] extensions;
        IExtensionRegistry er = Platform.getExtensionRegistry();
        IExtensionPoint ep = er.getExtensionPoint(ComIbmCicCommonCorePlugin.getPluginId(), EXPORT_MESSAGES);
        ArrayList<Class> messageClasses = new ArrayList<Class>();
        IExtension[] iExtensionArray = extensions = ep.getExtensions();
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement[] ces;
            IExtension extension = iExtensionArray[n2];
            String bundleId = extension.getContributor().getName();
            Bundle bundle = Platform.getBundle((String)bundleId);
            IConfigurationElement[] iConfigurationElementArray = ces = extension.getConfigurationElements();
            int n3 = ces.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement ce = iConfigurationElementArray[n4];
                try {
                    messageClasses.add(bundle.loadClass(ce.getAttribute(CLASS)));
                }
                catch (InvalidRegistryObjectException e) {
                    ExceptionUtil.debugLogToReview(e);
                }
                catch (ClassNotFoundException e) {
                    ExceptionUtil.debugLogToReview(e);
                }
                ++n4;
            }
            ++n2;
        }
        this.messages = messageClasses.toArray(new Class[messageClasses.size()]);
    }

    private void initializePatternMap() {
        this.inValueToPattern = new HashMap<String, Pattern>();
        Pattern hasNLS = Pattern.compile("\\{\\d+\\}");
        Matcher m = hasNLS.matcher("");
        for (String nlsValue : this.inValueToKey.keySet()) {
            if (!(m = m.reset(nlsValue.replaceAll("\\.", "\\\\."))).find()) continue;
            m.reset();
            StringBuffer reBuf = new StringBuffer(m.replaceAll("(.+)"));
            reBuf.insert(0, "(\\s*)").append("(\\s*)");
            String re = reBuf.toString();
            try {
                this.inValueToPattern.put(nlsValue, Pattern.compile(re));
            }
            catch (PatternSyntaxException e) {
                ExceptionUtil.debugLogIllegalArgumentException(e);
            }
        }
    }

    public String retranslate(String inValue) {
        StringTokenizer tokenzier = new StringTokenizer(inValue, LogUtil.NEWLINE);
        StringBuffer result = new StringBuffer();
        while (tokenzier.hasMoreTokens()) {
            result.append(this.translate(tokenzier.nextToken(), 0));
            if (!tokenzier.hasMoreTokens()) continue;
            result.append(LogUtil.NEWLINE);
        }
        return result.toString();
    }

    private String translate(String inValue, int depth) {
        if (depth == 2) {
            ++this.numStops;
            return inValue;
        }
        String outValue = inValue.trim();
        Object key = this.inValueToKey.get(inValue);
        if (key != null && this.outKeyToValue.containsKey(key)) {
            outValue = (String)this.outKeyToValue.get(key);
        } else {
            for (Map.Entry<String, Pattern> entry : this.inValueToPattern.entrySet()) {
                String value = entry.getKey();
                Pattern p = entry.getValue();
                Matcher m = p.matcher(inValue);
                ++this.numMatch;
                if (!m.matches() || m.groupCount() <= 2) continue;
                String leadWS = m.group(1);
                String trailWS = m.group(m.groupCount());
                String[] groups = new String[m.groupCount() - 2];
                int i = 2;
                while (i < m.groupCount()) {
                    groups[i - 2] = this.translate(m.group(i), depth + 1);
                    ++i;
                }
                m.reset(value);
                ++this.numMatch;
                if (!m.matches()) continue;
                int[] order = new int[m.groupCount() - 2];
                int i2 = 2;
                while (i2 < m.groupCount()) {
                    String subOrder = m.group(i2).trim();
                    subOrder = subOrder.substring(1, subOrder.length() - 1);
                    order[i2 - 2] = Integer.parseInt(subOrder);
                    ++i2;
                }
                Object[] orderedGroups = new String[m.groupCount() - 2];
                int i3 = 0;
                while (i3 < order.length) {
                    orderedGroups[order[i3]] = groups[i3];
                    ++i3;
                }
                String newMessage = (String)this.outKeyToValue.get(this.inValueToKey.get(value));
                StringBuffer message = new StringBuffer(leadWS).append(newMessage).append(trailWS);
                return NLS.bind((String)message.toString(), (Object[])orderedGroups);
            }
        }
        return outValue;
    }

    private void initializeMessageMap() {
        this.inValueToKey = new HashMap();
        this.outKeyToValue = new HashMap();
        int MOD_EXPECTED = 9;
        int MOD_MASK = 25;
        Class[] classArray = this.messages;
        int n = this.messages.length;
        int n2 = 0;
        while (n2 < n) {
            Field[] keys;
            Class message = classArray[n2];
            Field[] fieldArray = keys = message.getDeclaredFields();
            int n3 = keys.length;
            int n4 = 0;
            while (n4 < n3) {
                Field key = fieldArray[n4];
                try {
                    Object value;
                    if ((key.getModifiers() & 0x19) == 9 && key.getType() == String.class && (value = key.get(null)) != null) {
                        this.inValueToKey.put(value, key.getName());
                    }
                }
                catch (IllegalAccessException e) {
                    ExceptionUtil.debugLogToReview(e);
                }
                ++n4;
            }
            try {
                String[] variants;
                ClassLoader loader = message.getClassLoader();
                String packagePath = message.getPackage().getName().replace('.', '/');
                String[] stringArray = variants = Translator.buildVariants(String.valueOf(packagePath) + '/' + "messages", this.targetLocale);
                int n5 = variants.length;
                int n6 = 0;
                while (n6 < n5) {
                    String variant = stringArray[n6];
                    InputStream stream = loader.getResourceAsStream(variant);
                    if (stream != null) {
                        Properties targetKeys = new Properties();
                        targetKeys.load(stream);
                        this.outKeyToValue.putAll(targetKeys);
                        break;
                    }
                    ++n6;
                }
            }
            catch (IOException e) {
                ExceptionUtil.debugLogIOException(e);
            }
            ++n2;
        }
        this.removeBadKeys();
    }

    private void removeBadKeys() {
        HashSet<String> toRemove = new HashSet<String>();
        for (String in : this.inValueToKey.keySet()) {
            if (!in.matches("\\{\\d+\\}") && !in.matches("([\\{\\}0-9]|\\s)+")) continue;
            toRemove.add(in);
        }
        for (String in : toRemove) {
            this.inValueToKey.remove(in);
        }
    }

    private static String[] buildVariants(String root, Locale target) {
        int lastSeparator;
        String EXTENSION = ".properties";
        ArrayList<String> variants = new ArrayList<String>(4);
        String nl = target.toString();
        variants.add(String.valueOf(root) + '_' + nl + ".properties");
        while ((lastSeparator = nl.lastIndexOf(95)) != -1) {
            nl = nl.substring(0, lastSeparator);
            variants.add(String.valueOf(root) + '_' + nl + ".properties");
        }
        variants.add(String.valueOf(root) + ".properties");
        return variants.toArray(new String[variants.size()]);
    }

    public int getNumMatch() {
        return this.numMatch;
    }

    public int getNumStops() {
        return this.numStops;
    }
}

