/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.downloads.handlerImpl;

import com.ibm.cic.common.core.utils.NetworkInfo;
import com.ibm.cic.common.downloads.CredentialInfo;
import com.ibm.cic.common.downloads.CredentialPrompter;
import com.ibm.cic.common.downloads.CredentialRequested;
import com.ibm.cic.common.downloads.ICredentialPrompter;
import com.ibm.cic.common.downloads.ICredentialValidator;
import com.ibm.cic.common.downloads.UrlUserInfoUtil;
import java.io.IOException;
import java.net.URI;
import java.net.UnknownHostException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;

public class FtpUrlEncodedLogin {
    private static String EMPTY_PASSWORD = "";
    private static String ANONYMOUS_USER = "anonymous";
    private static final Object lockRetrieveCredentials = new Object();

    private static String getRealm(URI uri) {
        String realm = NLS.bind((String)"{0}://{1}", (Object)uri.getScheme(), (Object)uri.getRawAuthority());
        return realm;
    }

    public static CredentialRequested getRequested(URI uri) {
        String realm = FtpUrlEncodedLogin.getRealm(uri);
        int port = uri.getPort();
        if (port == -1) {
            port = 21;
        }
        CredentialRequested requested = new CredentialRequested("ftp", uri.getHost(), port, realm, Boolean.FALSE);
        return requested;
    }

    public static void login_askUser(URI uri, IFtpLogin login, IFtpCredentialProvider credProvider) throws IOException {
        String loginPassword;
        String loginUsername;
        String[] providedUserInfo = new String[2];
        if (credProvider.getUsernameAndPassword(uri, true, providedUserInfo)) {
            assert (providedUserInfo[0] != null);
            assert (providedUserInfo[1] != null);
            loginUsername = providedUserInfo[0];
            loginPassword = providedUserInfo[1];
        } else {
            String userInfo = uri.getUserInfo();
            String password = null;
            if (userInfo == null) {
                loginUsername = ANONYMOUS_USER;
            } else {
                String[] parsedUserInfo = UrlUserInfoUtil.parseUserInfo(userInfo);
                loginUsername = parsedUserInfo[0];
                password = parsedUserInfo[1];
            }
            String string = loginPassword = password == null ? EMPTY_PASSWORD : password;
        }
        if (!login.login(loginUsername, loginPassword)) {
            login.throwExceptionForLastResponse();
        }
    }

    public static String getAnonymousPassword() {
        NetworkInfo networkInfo;
        try {
            networkInfo = NetworkInfo.getNetworkInfo();
        }
        catch (UnknownHostException e) {
            networkInfo = null;
        }
        String domain = null;
        if (networkInfo != null) {
            domain = networkInfo.getDomainName();
        }
        if (domain == null || domain.length() == 0) {
            return EMPTY_PASSWORD;
        }
        String userName = "anonymous";
        return String.valueOf(userName) + "@" + domain;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void login_tryFirst(URI uri, IFtpLogin login, IFtpCredentialProvider credProvider) throws IOException {
        String[] promptedUserInfo = new String[2];
        String username = null;
        String password = null;
        if (credProvider.getUsernameAndPassword(uri, false, promptedUserInfo)) {
            username = promptedUserInfo[0];
            password = promptedUserInfo[1];
            if (login.login(username, password)) {
                return;
            }
        } else {
            String userInfo = uri.getUserInfo();
            if (userInfo == null) {
                username = ANONYMOUS_USER;
                password = FtpUrlEncodedLogin.getAnonymousPassword();
            } else {
                String[] parsedUserInfo = UrlUserInfoUtil.parseUserInfo(userInfo);
                username = parsedUserInfo[0];
                password = parsedUserInfo[1];
                if (password == null) {
                    password = ANONYMOUS_USER.equals(username) ? FtpUrlEncodedLogin.getAnonymousPassword() : EMPTY_PASSWORD;
                }
            }
            CredentialRequested requested = FtpUrlEncodedLogin.getRequested(uri);
            CredentialInfo credInfo = new CredentialInfo();
            credInfo.setPersist(false);
            credInfo.setUid(username);
            credInfo.setPwd(password);
            credInfo.setAutoGenerated(true);
            Object object = lockRetrieveCredentials;
            synchronized (object) {
                CredentialPrompterUseComputed prompter = new CredentialPrompterUseComputed(requested, credInfo);
                try {
                    boolean b = credProvider.getUsernameAndPassword(uri, true, promptedUserInfo);
                    assert (b);
                    assert (promptedUserInfo[0].equals(username));
                    assert (promptedUserInfo[1].equals(password));
                }
                finally {
                    prompter.restorePreviousPrompter();
                }
            }
            if (login.login(username, password)) {
                return;
            }
        }
        do {
            if (!credProvider.getUsernameAndPassword(uri, true, promptedUserInfo)) {
                login.throwExceptionForLastResponse();
            }
            assert (promptedUserInfo[0] != null);
            assert (promptedUserInfo[1] != null);
        } while (!login.login(promptedUserInfo[0], promptedUserInfo[1]));
    }

    public static void login(URI uri, IFtpLogin login, IFtpCredentialProvider credProvider) throws IOException {
        String userInfo = uri.getUserInfo();
        if (userInfo == null) {
            FtpUrlEncodedLogin.login_tryFirst(uri, login, credProvider);
        } else {
            String[] parsedUserInfo = UrlUserInfoUtil.parseUserInfo(userInfo);
            if (parsedUserInfo[1] != null) {
                FtpUrlEncodedLogin.login_tryFirst(uri, login, credProvider);
            } else {
                FtpUrlEncodedLogin.login_askUser(uri, login, credProvider);
            }
        }
    }

    static class CredentialPrompterUseComputed {
        private ICredentialPrompter previousPrompter;
        private Thread fThread;
        private CredentialRequested fRequested;
        private CredentialInfo fCredInfo;

        public CredentialPrompterUseComputed(CredentialRequested requested, CredentialInfo credInfo) {
            this.fRequested = requested;
            this.fCredInfo = credInfo;
            this.fThread = Thread.currentThread();
            this.previousPrompter = CredentialPrompter.INSTANCE.getPrompter();
            ICredentialPrompter prompter = new ICredentialPrompter(){

                @Override
                public IStatus askUserIdAndPassword(ICredentialValidator validator, String connectMessage, CredentialRequested arequested, CredentialInfo previous, CredentialInfo[] ret) {
                    if (fThread.equals(Thread.currentThread()) && fRequested.equals(arequested)) {
                        ret[0] = fCredInfo;
                        return Status.OK_STATUS;
                    }
                    if (previousPrompter == null) {
                        return null;
                    }
                    IStatus status = previousPrompter.askUserIdAndPassword(validator, connectMessage, arequested, previous, ret);
                    return status;
                }
            };
            CredentialPrompter.INSTANCE.setPrompter(prompter);
        }

        public void restorePreviousPrompter() {
            CredentialPrompter.INSTANCE.setPrompter(this.previousPrompter);
        }
    }

    public static interface IFtpCredentialProvider {
        public boolean getUsernameAndPassword(URI var1, boolean var2, String[] var3) throws IOException;
    }

    public static interface IFtpLogin {
        public boolean login(String var1, String var2) throws IOException;

        public void throwExceptionForLastResponse() throws IOException;
    }
}

