/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.downloads;

import com.ibm.cic.common.core.internal.ComIbmCicCommonCorePlugin;
import com.ibm.cic.common.downloads.IHasIsCanceled;
import com.ibm.cic.common.downloads.SocketEvents;
import com.ibm.cic.common.logging.Logger;
import java.io.IOException;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import java.util.Set;
import org.eclipse.core.runtime.Plugin;

public class WaitMonitor {
    private static final Logger log = Logger.getLogger(WaitMonitor.class, (Plugin)ComIbmCicCommonCorePlugin.getDefault());
    private static final Logger logAE = Logger.getLoggerUsingDebug("com.ibm.cic.common.core/debug/WaitMonitor/activityEnd");
    private static final IActivityFilter NULL_FILTER = new IActivityFilter(){

        @Override
        public boolean skip(ActivityInfo ai) {
            return false;
        }
    };
    private final LinkedList onGoingEvents;
    private final Set logActivityEnd = Collections.synchronizedSet(new HashSet());
    private IActivityFilter filter;

    public WaitMonitor() {
        this.onGoingEvents = new LinkedList();
        this.filter = NULL_FILTER;
    }

    public void setFilter(IActivityFilter filter) {
        this.filter = filter != null ? filter : NULL_FILTER;
    }

    private void logOnGoing() {
        long currentTime = System.currentTimeMillis();
        int size = this.onGoingEvents.size();
        if (size > 0) {
            if (log.isDebugLoggable()) {
                StringBuffer sb = new StringBuffer(size * 100);
                sb.append(size);
                for (ActivityInfo info : this.onGoingEvents) {
                    long age = currentTime - info.getStartTime();
                    long seconds = age / 1000L;
                    long ms = age % 1000L;
                    sb.append("\n");
                    sb.append("activityThread=[");
                    sb.append(info.getActivityThreadName());
                    sb.append("] ");
                    sb.append(info.getActivity());
                    sb.append(" age=");
                    sb.append(seconds);
                    sb.append("s ");
                    sb.append(ms);
                    sb.append("ms");
                }
                log.debug("{0}", sb.toString());
            }
        } else {
            log.debug("no open activities");
        }
    }

    public void setLogEndActivity(Object activity) {
        if (logAE.isDebugLoggable()) {
            this.logActivityEnd.add(activity);
        }
    }

    public synchronized void startActivity(Object activity) {
        ActivityInfo ai = new ActivityInfo(System.currentTimeMillis(), activity);
        this.onGoingEvents.add(ai);
        this.logOnGoing();
    }

    public synchronized void endActivity(Object activity) {
        Iterator iter = this.onGoingEvents.iterator();
        while (iter.hasNext()) {
            ActivityInfo ai = (ActivityInfo)iter.next();
            if (!ai.activity.equals(activity)) continue;
            iter.remove();
            break;
        }
        if (logAE.isDebugLoggable() && this.logActivityEnd.contains(activity)) {
            Throwable t = new Throwable();
            logAE.debug("activity {0}: {1}", activity, t);
            this.logActivityEnd.remove(activity);
        }
        this.logOnGoing();
    }

    public synchronized void forceCancel() {
        ArrayList<Socket> socketsToClose = new ArrayList<Socket>(this.onGoingEvents.size());
        for (ActivityInfo ai : this.onGoingEvents) {
            Socket socket = WaitMonitor.getSocket(ai);
            if (socket == null) continue;
            socketsToClose.add(socket);
        }
        for (Socket socket : socketsToClose) {
            try {
                socket.close();
            }
            catch (IOException e) {
                log.debug(e);
            }
        }
    }

    private static Socket getSocket(ActivityInfo ai) {
        Object activity = ai.getActivity();
        if (activity instanceof SocketEvents.SocketToConnect) {
            SocketEvents.SocketToConnect stc = (SocketEvents.SocketToConnect)activity;
            return stc.getSocket();
        }
        if (activity instanceof SocketEvents.IEventWithSocket) {
            SocketEvents.IEventWithSocket ews = (SocketEvents.IEventWithSocket)activity;
            return ews.getSocket();
        }
        return null;
    }

    public String toString() {
        try {
            long currentTime = System.currentTimeMillis();
            ActivityInfo[] activities = this.onGoingEvents.toArray(new ActivityInfo[this.onGoingEvents.size()]);
            ArrayList<String> array = new ArrayList<String>(activities.length);
            ActivityInfo[] activityInfoArray = activities;
            int n = activities.length;
            int n2 = 0;
            while (n2 < n) {
                ActivityInfo info = activityInfoArray[n2];
                StringBuffer sb = new StringBuffer();
                sb.append(info);
                sb.append(" age=");
                long age = currentTime - info.getStartTime();
                sb.append(age / 1000L);
                sb.append("s ");
                sb.append(age % 1000L);
                sb.append("ms");
                array.add(sb.toString());
                ++n2;
            }
            return array.toString();
        }
        catch (ConcurrentModificationException cme) {
            return this.toString();
        }
        catch (NoSuchElementException nse) {
            return this.toString();
        }
        catch (Throwable t) {
            log.error(t);
            return t.toString();
        }
    }

    public ActivityInfo getOldest(long msMinimumAge) {
        long msCurrentTime = System.currentTimeMillis();
        long msMinStartTime = msCurrentTime - msMinimumAge;
        return this.getOldest(msCurrentTime, msMinStartTime);
    }

    private ActivityInfo getOldest(long msCurrentTime, long msMinStartTime) {
        try {
            return this.getOldestUnsynchronized(msCurrentTime, msMinStartTime);
        }
        catch (ConcurrentModificationException cme) {
            log.debug(cme);
            return this.getOldest(msCurrentTime, msMinStartTime);
        }
        catch (NoSuchElementException nse) {
            log.debug(nse);
            return this.getOldest(msCurrentTime, msMinStartTime);
        }
    }

    private ActivityInfo getOldestUnsynchronized(long msCurrentTime, long msMinStartTime) {
        for (ActivityInfo ai : this.onGoingEvents) {
            if (ai == null || ai.getStartTime() > msMinStartTime || this.filter.skip(ai)) continue;
            return ai;
        }
        return null;
    }

    public Collection getAll(long msMinimumAge) {
        long msCurrentTime = System.currentTimeMillis();
        long msMinStartTime = msCurrentTime - msMinimumAge;
        return this.getAll(msCurrentTime, msMinStartTime);
    }

    private Collection getAll(long msCurrentTime, long msMinStartTime) {
        try {
            return this.getAllUnsynchronized(msCurrentTime, msMinStartTime);
        }
        catch (ConcurrentModificationException cme) {
            log.debug(cme);
            return this.getAll(msCurrentTime, msMinStartTime);
        }
        catch (NoSuchElementException nse) {
            log.debug(nse);
            return this.getAll(msCurrentTime, msMinStartTime);
        }
    }

    private Collection getAllUnsynchronized(long msCurrentTime, long msMinStartTime) {
        ArrayList<ActivityInfo> list = new ArrayList<ActivityInfo>(this.onGoingEvents.size());
        for (ActivityInfo ai : this.onGoingEvents) {
            if (ai == null || ai.getStartTime() > msMinStartTime || this.filter.skip(ai)) continue;
            list.add(ai);
        }
        return list;
    }

    public boolean isPendingActivity(ActivityInfo activity, long msMinimumAge) {
        long msCurrentTime = System.currentTimeMillis();
        long msMinStartTime = msCurrentTime - msMinimumAge;
        return this.isPendingActivity(activity, msCurrentTime, msMinStartTime);
    }

    private boolean isPendingActivity(ActivityInfo activity, long msCurrentTime, long msMinStartTime) {
        try {
            return this.isPendingActivityUnsynchronized(activity, msCurrentTime, msMinStartTime);
        }
        catch (ConcurrentModificationException cme) {
            log.debug(cme);
            return this.isPendingActivity(activity, msCurrentTime, msMinStartTime);
        }
        catch (NoSuchElementException nse) {
            log.debug(nse);
            return this.isPendingActivity(activity, msCurrentTime, msMinStartTime);
        }
    }

    private boolean isPendingActivityUnsynchronized(ActivityInfo activity, long msCurrentTime, long msMinStartTime) {
        for (ActivityInfo ai : this.onGoingEvents) {
            if (ai == null || !ai.equals(activity) || ai.getStartTime() > msMinStartTime || this.filter.skip(ai)) continue;
            return true;
        }
        return false;
    }

    public static abstract class AbstractWaitToProgressMonitorRunnable
    implements Runnable {
        private final IHasIsCanceled cancelMonitor;
        protected long msRefreshFrequency;
        protected long msMinimumAge;
        protected boolean isListening;
        protected boolean done;

        public AbstractWaitToProgressMonitorRunnable(IHasIsCanceled cancelMonitor, long msRefreshFrequency, long msMinimumAge) {
            this.cancelMonitor = cancelMonitor;
            this.isListening = false;
            this.done = false;
            this.msRefreshFrequency = msRefreshFrequency;
            this.msMinimumAge = msMinimumAge;
        }

        public boolean isListening() {
            return this.isListening;
        }

        protected abstract Object setupWaitListeners();

        protected abstract void removeWaitListeners(Object var1);

        protected abstract WaitMonitor getWaitMonitor(Object var1);

        protected boolean isCanceled() {
            if (this.cancelMonitor != null) {
                return this.cancelMonitor.isCanceled();
            }
            return false;
        }

        protected void heartbeat() {
        }

        protected abstract String getWaitText(ActivityInfo var1);
    }

    public static class ActivityInfo {
        private final long startTime;
        private final String activityThreadName;
        Object activity;

        ActivityInfo(long startTime, Object activity) {
            this.startTime = startTime;
            this.activityThreadName = Thread.currentThread().getName();
            this.activity = activity;
        }

        public long getStartTime() {
            return this.startTime;
        }

        public Object getActivity() {
            return this.activity;
        }

        public String getActivityThreadName() {
            return this.activityThreadName;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("startTime=");
            sb.append(this.startTime);
            sb.append("activityThread=");
            sb.append(this.activityThreadName);
            sb.append(this.startTime);
            sb.append(" activity=");
            sb.append(this.activity);
            return sb.toString();
        }
    }

    public static interface IActivityFilter {
        public boolean skip(ActivityInfo var1);
    }

    public static interface IWaitFeedbackArea {
        public void setText(String var1);

        public void restoreText(String var1);
    }

    public static interface IWaitSetFeedbackArea {
        public void setText(String var1);
    }

    public static abstract class MultithreadedWaitToProgressMonitorRunnable
    extends AbstractWaitToProgressMonitorRunnable
    implements Runnable {
        private final IWaitSetFeedbackArea waitFeedback;
        private final ArrayList reportedWaits = new ArrayList();
        private Iterator iterPendingWaits = null;
        private Iterator iterReportedWaits;

        public MultithreadedWaitToProgressMonitorRunnable(IWaitSetFeedbackArea waitFeedback, IHasIsCanceled cancelMonitor, long msRefreshFrequency, long msMinimumAge) {
            super(cancelMonitor, msRefreshFrequency, msMinimumAge);
            this.waitFeedback = waitFeedback;
        }

        public MultithreadedWaitToProgressMonitorRunnable(IWaitSetFeedbackArea waitFeedback, long msRefreshFrequency, long msMinimumAge) {
            this(waitFeedback, null, msRefreshFrequency, msMinimumAge);
        }

        protected abstract String getArrivedText(ActivityInfo var1);

        /*
         * Exception decompiling
         */
        @Override
        public void run() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [8[UNCONDITIONALDOLOOP]], but top level block is 0[TRYBLOCK]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        private ActivityInfo getNextReportedWaitArrived(WaitMonitor waitMonitor) {
            try {
                if (this.iterReportedWaits == null || !this.iterReportedWaits.hasNext()) {
                    this.iterReportedWaits = this.reportedWaits.iterator();
                }
                ActivityInfo nextReportedArrived = null;
                while (this.iterReportedWaits.hasNext()) {
                    ActivityInfo ai = (ActivityInfo)this.iterReportedWaits.next();
                    if (waitMonitor.isPendingActivity(ai, this.msMinimumAge)) continue;
                    nextReportedArrived = ai;
                    this.iterReportedWaits.remove();
                    break;
                }
                return nextReportedArrived;
            }
            catch (ConcurrentModificationException cme) {
                log.debug(cme);
                this.iterReportedWaits = null;
                return this.getNextReportedWaitArrived(waitMonitor);
            }
            catch (NoSuchElementException nse) {
                log.debug(nse);
                this.iterReportedWaits = null;
                return this.getNextReportedWaitArrived(waitMonitor);
            }
        }

        private ActivityInfo getNextWaitInfo(WaitMonitor waitMonitor) {
            try {
                ActivityInfo nextWaitInfo = null;
                while (this.iterPendingWaits != null && this.iterPendingWaits.hasNext()) {
                    ActivityInfo ai = (ActivityInfo)this.iterPendingWaits.next();
                    if (!waitMonitor.isPendingActivity(ai, this.msMinimumAge)) continue;
                    nextWaitInfo = ai;
                    break;
                }
                return nextWaitInfo;
            }
            catch (ConcurrentModificationException cme) {
                log.debug(cme);
                this.iterPendingWaits = null;
                return this.getNextWaitInfo(waitMonitor);
            }
            catch (NoSuchElementException nse) {
                log.debug(nse);
                this.iterPendingWaits = null;
                return this.getNextWaitInfo(waitMonitor);
            }
        }
    }

    public static abstract class OldestWaitToProgressMonitorRunnable
    extends AbstractWaitToProgressMonitorRunnable
    implements Runnable {
        private final IWaitFeedbackArea waitFeedback;
        private String myText;

        public OldestWaitToProgressMonitorRunnable(IWaitFeedbackArea waitFeedback, IHasIsCanceled cancelMonitor, long msRefreshFrequency, long msMinimumAge) {
            super(cancelMonitor, msRefreshFrequency, msMinimumAge);
            this.waitFeedback = waitFeedback;
        }

        public OldestWaitToProgressMonitorRunnable(IWaitFeedbackArea waitFeedback, long msRefreshFrequency, long msMinimumAge) {
            this(waitFeedback, null, msRefreshFrequency, msMinimumAge);
        }

        /*
         * Exception decompiling
         */
        @Override
        public void run() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[UNCONDITIONALDOLOOP]], but top level block is 0[TRYBLOCK]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }
    }
}

