/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.downloads;

import com.ibm.cic.common.core.internal.ComIbmCicCommonCorePlugin;
import com.ibm.cic.common.downloads.FormatUtil;
import com.ibm.cic.common.downloads.ISuspendResumeControllerUI;
import com.ibm.cic.common.downloads.ISuspendResumeUI;
import com.ibm.cic.common.downloads.Messages;
import com.ibm.cic.common.logging.Logger;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.osgi.util.NLS;

public class SuspendResumeUIController {
    private final ISuspendResumeControllerUI abstractUI;
    private static final String SUSPENDED = "suspended";
    private static final String RETRYING = "retrying";
    private static final String NORMAL = "normal";
    private static final String INTERRUPTED = "interrupted";
    private static final String RESUME = "resume";
    private static final String RETRY = "retry";
    private static final String SUSPEND = "suspend";
    private static final String UNKNOWN = "unknown";
    public static final Logger log = Logger.getLogger(SuspendResumeUIController.class, (Plugin)ComIbmCicCommonCorePlugin.getDefault());
    private int level = 0;
    private static final State NULL_STATE = new BasicState(){};
    private State state = NULL_STATE;
    private long retryCount = 0L;
    private boolean canceled = false;
    private final Object canceledLock = new Object();
    private static String lastCheckWaitLogKey = null;
    private static String lastCheckWaitLogThis = null;
    private static int checkWaitNotLoggedCount = 0;

    public SuspendResumeUIController(ISuspendResumeControllerUI abstractUI) {
        assert (abstractUI != null);
        this.abstractUI = abstractUI;
    }

    public static String getActionName(int actionId) {
        String action;
        switch (actionId) {
            case 2: {
                action = RESUME;
                break;
            }
            case 3: {
                action = RETRY;
                break;
            }
            case 1: {
                action = SUSPEND;
                break;
            }
            default: {
                action = UNKNOWN;
            }
        }
        return action;
    }

    public static String getStateName(int stateId) {
        String state;
        switch (stateId) {
            case 3: {
                state = INTERRUPTED;
                break;
            }
            case 1: {
                state = NORMAL;
                break;
            }
            case 2: {
                state = RETRYING;
                break;
            }
            case 4: {
                state = SUSPENDED;
                break;
            }
            default: {
                state = UNKNOWN;
            }
        }
        return state;
    }

    private void setUiState(int state, String text) {
        SuspendResumeUIController.getLog().debug("SuspendResumeUI: setState({0},{1})", SuspendResumeUIController.getStateName(state), text);
        ISuspendResumeControllerUI aui = this.getAbstractUI();
        if (aui != null) {
            aui.setState(state, text);
        }
    }

    private void setUiAction(int action, Runnable callback) {
        SuspendResumeUIController.getLog().debug("SuspendResumeUI: setAction({0},{1})", SuspendResumeUIController.getActionName(action), callback);
        ISuspendResumeControllerUI aui = this.getAbstractUI();
        if (aui != null) {
            aui.setAction(action, callback);
        }
    }

    private void disableUiAction() {
        SuspendResumeUIController.getLog().debug("SuspendResumeUI: disableAction()");
        ISuspendResumeControllerUI aui = this.getAbstractUI();
        if (aui != null) {
            aui.disableAction();
        }
    }

    private State getNormalState() {
        return new NormalState();
    }

    private State getSuspendState() {
        return new SuspendState();
    }

    private State getInterruptedState(long retryTimeout) {
        return new InterruptedState(retryTimeout);
    }

    private State getRetryState() {
        ++this.retryCount;
        return new RetryState();
    }

    private State getDoneState() {
        return new DoneState();
    }

    private State getCenacelState() {
        return new CancelState();
    }

    private ISuspendResumeControllerUI getAbstractUI() {
        return this.abstractUI;
    }

    private synchronized void setState(State newState) {
        if (this.level == 0) {
            SuspendResumeUIController.getLog().debug("Ignoring SuspendMultiResume.setState(): {0}", this);
            return;
        }
        SuspendResumeUIController.getLog().debug("Enter SuspendMultiResume.setState(): {0}", this);
        if (newState == null) {
            newState = NULL_STATE;
        }
        this.state.leave();
        this.state = newState;
        this.state.enter();
        SuspendResumeUIController.getLog().debug("Leave SuspendMultiResume.setState(): {0}", this);
    }

    private void runSuspendResumeCallback() {
        this.state.onSuspendResumeCallback();
    }

    private void setInterruptedWithTimeout(long timeout) {
        SuspendResumeUIController.getLog().debug("Enter SuspendMultiResume.setInterruptedWithTimeout({0}): {1}", timeout, this);
        this.setState(this.getInterruptedState(timeout));
    }

    public synchronized void begin() {
        ++this.level;
        if (this.level == 1) {
            SuspendResumeUIController.getLog().debug("Enter SuspendMultiResume.begin(): {0}", this);
            this.setState(this.getNormalState());
            this.setCanceled(false);
        } else if (this.level > 1) {
            SuspendResumeUIController.getLog().debug("Ignoring SuspendMultiResume.begin(): {0}", this);
        }
    }

    public synchronized void end() {
        if (this.level <= 0) {
            SuspendResumeUIController.getLog().error("SuspendMultiResume.end(): no matching begin call");
        }
        if (this.level == 1) {
            SuspendResumeUIController.getLog().debug("Enter SuspendMultiResume.end(): {0}: setting Done state.", this);
            this.setState(this.getDoneState());
            this.setCanceled(false);
        } else {
            SuspendResumeUIController.getLog().debug("Ignoring SuspendMultiResume.end(): {0}.", this);
        }
        --this.level;
    }

    private static void checkWaitLog(String key, Object o) {
        String thisString;
        if (!log.isDebugLoggable()) {
            return;
        }
        if (key.equals(lastCheckWaitLogKey) && (thisString = o.toString()).equals(lastCheckWaitLogThis)) {
            ++checkWaitNotLoggedCount;
            return;
        }
        log.debug(key, o);
        lastCheckWaitLogKey = key;
        lastCheckWaitLogThis = o.toString();
        checkWaitNotLoggedCount = 0;
    }

    private static Logger getLog() {
        if (log.isDebugLoggable() && checkWaitNotLoggedCount > 0) {
            log.debug("{0} duplicate check wait log messages not displayed", checkWaitNotLoggedCount);
        }
        checkWaitNotLoggedCount = 0;
        lastCheckWaitLogKey = null;
        lastCheckWaitLogThis = null;
        return log;
    }

    public synchronized boolean checkWait() {
        if (this.level == 0) {
            SuspendResumeUIController.checkWaitLog("Ignoring SuspendMultiResume.checkWait(): {0}", this);
            return false;
        }
        SuspendResumeUIController.checkWaitLog("Enter SuspendMultiResume.checkWait(): {0}", this);
        boolean didWait = this.state.checkWait();
        SuspendResumeUIController.checkWaitLog("Leaving SuspendMultiResume.checkWait(): {0}", this);
        return didWait;
    }

    public synchronized boolean requestInterruptedState(long timeout) {
        if (this.state instanceof InterruptedState) {
            return true;
        }
        ISuspendResumeControllerUI aui = this.getAbstractUI();
        if (aui == null) {
            return false;
        }
        if (!aui.requestInterruptedState()) {
            return false;
        }
        this.setInterruptedWithTimeout(timeout);
        return true;
    }

    public synchronized void cancel() {
        if (this.state instanceof CancelState) {
            return;
        }
        this.setState(this.getCenacelState());
    }

    private Runnable getSuspendResumeCallback() {
        return new Runnable(){

            @Override
            public void run() {
                SuspendResumeUIController.this.runSuspendResumeCallback();
            }
        };
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(100);
        sb.append("state=");
        sb.append(this.state != null ? this.state.toString() : "null");
        sb.append(" level=");
        sb.append(this.level);
        sb.append(" isCanceled()=");
        sb.append(this.isCanceled());
        sb.append(" retryCount=");
        sb.append(this.retryCount);
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isCanceled() {
        Object object = this.canceledLock;
        synchronized (object) {
            block4: {
                if (!this.canceled) break block4;
                return true;
            }
        }
        return this.abstractUI.isCanceled();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCanceled(boolean b) {
        Object object = this.canceledLock;
        synchronized (object) {
            this.canceled = b;
        }
    }

    static abstract class BasicState
    extends State {
        boolean active = false;

        BasicState() {
        }

        @Override
        public void enter() {
            this.active = true;
        }

        @Override
        public boolean checkWait() {
            return false;
        }

        @Override
        public void leave() {
            this.active = false;
        }

        protected boolean isActive() {
            return this.active;
        }

        @Override
        public void onSuspendResumeCallback() {
        }

        @Override
        public String toString() {
            String clsName = this.getClass().getName();
            int i = clsName.lastIndexOf(46);
            String simpleName = i == -1 ? clsName : clsName.substring(i + 1);
            int j = simpleName.lastIndexOf(36);
            simpleName = j == -1 ? simpleName : simpleName.substring(j + 1);
            return simpleName;
        }
    }

    static class CancelState
    extends EndState {
        CancelState() {
        }
    }

    class DoneState
    extends EndState {
        DoneState() {
        }

        @Override
        public void enter() {
            super.enter();
            SuspendResumeUIController.this.setUiState(1, null);
            SuspendResumeUIController.this.disableUiAction();
        }
    }

    static class EndState
    extends State {
        EndState() {
        }
    }

    class InterruptedState
    extends SleepState {
        long lastReportedRemainingSeconds;
        final long endTime;

        InterruptedState(long retryTimeout) {
            this.endTime = System.currentTimeMillis() + retryTimeout;
        }

        private synchronized void reportRemainingSeconds() {
            long remainingSeconds = this.getRemaining() / 1000L;
            if (remainingSeconds == this.lastReportedRemainingSeconds) {
                return;
            }
            String remainingMsg = FormatUtil.formatTimeSpan(remainingSeconds);
            String msg = NLS.bind((String)Messages.SuspendResume_retry, (Object)remainingMsg);
            SuspendResumeUIController.this.setUiState(3, msg);
            this.lastReportedRemainingSeconds = remainingSeconds;
        }

        private long getRemaining() {
            return this.endTime - System.currentTimeMillis();
        }

        @Override
        public void enter() {
            super.enter();
            SuspendResumeUIController.this.setUiAction(3, SuspendResumeUIController.this.getSuspendResumeCallback());
            this.reportRemainingSeconds();
        }

        protected boolean sleep() throws InterruptedException {
            while (true) {
                SuspendResumeUIController.this.wait(800L);
                if (!this.isActive()) {
                    return true;
                }
                if (SuspendResumeUIController.this.isCanceled()) {
                    SuspendResumeUIController.getLog().debug("Returning immediately because canceled was requested");
                    SuspendResumeUIController.this.cancel();
                    return false;
                }
                if (this.getRemaining() <= 0L) {
                    if (this.isActive()) {
                        SuspendResumeUIController.this.setState(SuspendResumeUIController.this.getRetryState());
                    }
                    return true;
                }
                this.reportRemainingSeconds();
            }
        }

        @Override
        public void onSuspendResumeCallback() {
            SuspendResumeUIController.this.setState(SuspendResumeUIController.this.getRetryState());
        }
    }

    class NormalState
    extends BasicState {
        NormalState() {
        }

        @Override
        public void enter() {
            super.enter();
            SuspendResumeUIController.this.retryCount = 0L;
            SuspendResumeUIController.this.setUiState(1, null);
            SuspendResumeUIController.this.setUiAction(1, SuspendResumeUIController.this.getSuspendResumeCallback());
        }

        @Override
        public void onSuspendResumeCallback() {
            SuspendResumeUIController.this.setState(SuspendResumeUIController.this.getSuspendState());
        }
    }

    class RetryState
    extends State {
        RetryState() {
        }

        @Override
        public void enter() {
            super.enter();
            SuspendResumeUIController.this.setUiState(2, null);
            SuspendResumeUIController.this.setUiAction(1, SuspendResumeUIController.this.getSuspendResumeCallback());
        }

        @Override
        public void onSuspendResumeCallback() {
            SuspendResumeUIController.this.setState(SuspendResumeUIController.this.getSuspendState());
        }
    }

    class SleepState
    extends BasicState {
        private boolean didWait = false;

        SleepState() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean checkWait() {
            SuspendResumeUIController suspendResumeUIController = SuspendResumeUIController.this;
            synchronized (suspendResumeUIController) {
                block7: {
                    if (!SuspendResumeUIController.this.isCanceled()) break block7;
                    SuspendResumeUIController.getLog().debug("Returning immediately because canceled was requested");
                    return false;
                }
                this.didWait = false;
                try {
                    while (!this.didWait) {
                        SuspendResumeUIController.this.wait();
                    }
                }
                catch (InterruptedException e) {
                    ComIbmCicCommonCorePlugin.getTrace().catching(e);
                }
                return this.didWait;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void leave() {
            super.leave();
            SuspendResumeUIController suspendResumeUIController = SuspendResumeUIController.this;
            synchronized (suspendResumeUIController) {
                this.didWait = true;
                SuspendResumeUIController.this.notifyAll();
            }
        }
    }

    static abstract class State {
        State() {
        }

        public void enter() {
        }

        public boolean checkWait() {
            return false;
        }

        public void leave() {
        }

        public void onSuspendResumeCallback() {
        }

        public String toString() {
            String clsName = this.getClass().getName();
            int i = clsName.lastIndexOf(46);
            String simpleName = i == -1 ? clsName : clsName.substring(i + 1);
            int j = simpleName.lastIndexOf(36);
            simpleName = j == -1 ? simpleName : simpleName.substring(j + 1);
            return simpleName;
        }
    }

    public static class SuspendResumeUIConnector
    implements ISuspendResumeUI {
        private final SuspendResumeUIController controller;

        public SuspendResumeUIConnector(ISuspendResumeControllerUI uiCallback) {
            this.controller = new SuspendResumeUIController(uiCallback);
        }

        @Override
        public void begin() {
            this.controller.begin();
        }

        @Override
        public void end() {
            this.controller.end();
        }

        @Override
        public boolean isCanceled() {
            return this.controller.isCanceled();
        }

        @Override
        public void cancel() {
            this.controller.setCanceled(true);
        }

        @Override
        public boolean requestInterruptedState(long milliseconds) {
            return this.controller.requestInterruptedState(milliseconds);
        }

        @Override
        public boolean waitUntilResumeOrRetry() {
            return this.controller.checkWait();
        }

        @Override
        public boolean autoRetryOnTimeoutOnly() {
            return false;
        }
    }

    class SuspendState
    extends SleepState {
        SuspendState() {
        }

        @Override
        public void enter() {
            super.enter();
            SuspendResumeUIController.this.setUiState(4, null);
            SuspendResumeUIController.this.setUiAction(2, SuspendResumeUIController.this.getSuspendResumeCallback());
        }

        @Override
        public void onSuspendResumeCallback() {
            SuspendResumeUIController.this.setState(SuspendResumeUIController.this.getNormalState());
        }
    }
}

