/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.downloads;

import com.ibm.cic.common.core.internal.ComIbmCicCommonCorePlugin;
import com.ibm.cic.common.downloads.DownloadCanceledException;
import com.ibm.cic.common.downloads.HostInfo;
import com.ibm.cic.common.downloads.IHasIsCanceled;
import com.ibm.cic.common.logging.Logger;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Plugin;

public class SocketEvents {
    private static final Logger log = Logger.getLogger(SocketEvents.class, (Plugin)ComIbmCicCommonCorePlugin.getDefault());
    public static final SocketEvents INSTANCE = new SocketEvents();
    public static final SocketListener FIRE = SocketEvents.INSTANCE.MY_FIRE;
    private final FireEvents MY_FIRE = new FireEvents();
    private final List<SocketListener> listeners = new ArrayList<SocketListener>(10);

    static String toStringWithId(Object o) {
        StringBuilder sb = new StringBuilder();
        sb.append(o);
        sb.append(' ');
        sb.append(o.getClass().getName());
        sb.append('@');
        sb.append(Integer.toHexString(o.hashCode()));
        return sb.toString();
    }

    private SocketEvents() {
    }

    public synchronized void addSocketListener(SocketListener listener) {
        if (this.listeners.contains(listener)) {
            return;
        }
        this.listeners.add(listener);
    }

    public synchronized void removeSocketListener(SocketListener listener) {
        this.listeners.remove(listener);
    }

    private synchronized SocketListener[] getListeners() {
        return this.listeners.toArray(new SocketListener[this.listeners.size()]);
    }

    private static abstract class EventWithSocket
    implements IEventWithSocket {
        private final Socket socket;

        EventWithSocket(Socket socket) {
            this.socket = socket;
        }

        @Override
        public Socket getSocket() {
            return this.socket;
        }

        public String toString() {
            return String.valueOf(this.getEventTypeName()) + ' ' + SocketEvents.toStringWithId(this.socket);
        }
    }

    class FireEvents
    extends SocketListener {
        FireEvents() {
        }

        @Override
        public void onBeforeSocketConnected(SocketToConnect stc) {
            log.debug(stc);
            SocketListener[] socketListenerArray = SocketEvents.this.getListeners();
            int n = socketListenerArray.length;
            int n2 = 0;
            while (n2 < n) {
                SocketListener listener = socketListenerArray[n2];
                try {
                    listener.onBeforeSocketConnected(stc);
                }
                catch (Throwable t) {
                    log.error(t);
                }
                ++n2;
            }
        }

        @Override
        public void onSocketConnected(SocketToConnect stc) throws IOException {
            log.debug(stc);
            SocketListener[] socketListenerArray = SocketEvents.this.getListeners();
            int n = socketListenerArray.length;
            int n2 = 0;
            while (n2 < n) {
                SocketListener listener = socketListenerArray[n2];
                try {
                    listener.onSocketConnected(stc);
                }
                catch (Throwable t) {
                    this.handleListenerException(listener, t);
                }
                ++n2;
            }
        }

        @Override
        public void onSocketConnectFailed(SocketToConnect stc, Throwable t) {
            log.debug(stc);
            SocketListener[] socketListenerArray = SocketEvents.this.getListeners();
            int n = socketListenerArray.length;
            int n2 = 0;
            while (n2 < n) {
                SocketListener listener = socketListenerArray[n2];
                try {
                    listener.onSocketConnectFailed(stc, t);
                }
                catch (Throwable t2) {
                    log.error(t2);
                }
                ++n2;
            }
        }

        private void handleListenerException(SocketListener listener, Throwable t) throws IOException {
            if (listener.isFakeExceptionGenerator() && t instanceof IOException) {
                IOException ioe = (IOException)t;
                throw ioe;
            }
            log.error(t);
        }

        @Override
        public void onBeforeSocketEvent(IEventWithSocket event) throws IOException {
            log.debug(event);
            SocketListener[] socketListenerArray = SocketEvents.this.getListeners();
            int n = socketListenerArray.length;
            int n2 = 0;
            while (n2 < n) {
                SocketListener listener = socketListenerArray[n2];
                try {
                    listener.onBeforeSocketEvent(event);
                }
                catch (Throwable t2) {
                    this.handleListenerException(listener, t2);
                }
                ++n2;
            }
        }

        @Override
        public void onFailedSocketEvent(IEventWithSocket event, Throwable e) {
            log.debug("{0} exception {1}", event, e);
            SocketListener[] socketListenerArray = SocketEvents.this.getListeners();
            int n = socketListenerArray.length;
            int n2 = 0;
            while (n2 < n) {
                SocketListener listener = socketListenerArray[n2];
                try {
                    listener.onFailedSocketEvent(event, e);
                }
                catch (Throwable t2) {
                    log.error(t2);
                }
                ++n2;
            }
        }

        @Override
        public void onPostSocketEvent(IEventWithSocket event) throws IOException {
            log.debug(event);
            SocketListener[] socketListenerArray = SocketEvents.this.getListeners();
            int n = socketListenerArray.length;
            int n2 = 0;
            while (n2 < n) {
                SocketListener listener = socketListenerArray[n2];
                try {
                    listener.onPostSocketEvent(event);
                }
                catch (Throwable t2) {
                    this.handleListenerException(listener, t2);
                }
                ++n2;
            }
        }

        @Override
        public void beginNoResponseExpected(Socket socket) {
            if (log.isDebugLoggable()) {
                log.debug("NoResponseExpected {0}", SocketEvents.toStringWithId(socket));
            }
            SocketListener[] socketListenerArray = SocketEvents.this.getListeners();
            int n = socketListenerArray.length;
            int n2 = 0;
            while (n2 < n) {
                SocketListener listener = socketListenerArray[n2];
                try {
                    listener.beginNoResponseExpected(socket);
                }
                catch (Throwable t2) {
                    log.error(t2);
                }
                ++n2;
            }
        }

        @Override
        public void endNoResponseExpected(Socket socket) {
            if (log.isDebugLoggable()) {
                log.debug("NoResponseExpected {0}", SocketEvents.toStringWithId(socket));
            }
            SocketListener[] socketListenerArray = SocketEvents.this.getListeners();
            int n = socketListenerArray.length;
            int n2 = 0;
            while (n2 < n) {
                SocketListener listener = socketListenerArray[n2];
                try {
                    listener.endNoResponseExpected(socket);
                }
                catch (Throwable t2) {
                    log.error(t2);
                }
                ++n2;
            }
        }
    }

    public static interface IEventWithSocket {
        public String getEventTypeName();

        public Socket getSocket();
    }

    public static interface ISocketToConnect {
        public HostInfo getHostInfo();

        public InetSocketAddress getHostAddress();

        public InetSocketAddress getLocalAddress();
    }

    public static class SocketClose
    extends EventWithSocket
    implements IEventWithSocket {
        SocketClose(Socket socket) {
            super(socket);
        }

        @Override
        public String getEventTypeName() {
            return "SocketClose";
        }
    }

    public static class SocketEventEmittingWrapper
    extends Socket {
        private final Socket socket;
        private final IHasIsCanceled cancelMonitor;

        private void throwDownloadCanceled(IEventWithSocket event) throws DownloadCanceledException {
            throw DownloadCanceledException.create(event, event.getSocket().toString(), null);
        }

        public SocketEventEmittingWrapper(Socket socket, IHasIsCanceled cancelMonitor) {
            this.socket = socket;
            this.cancelMonitor = cancelMonitor;
        }

        @Override
        public void bind(SocketAddress bindpoint) throws IOException {
            this.socket.bind(bindpoint);
        }

        @Override
        public void close() throws IOException {
            SocketClose event = new SocketClose(this);
            FIRE.onBeforeSocketEvent(event);
            try {
                this.socket.close();
                FIRE.onPostSocketEvent(event);
            }
            catch (IOException e) {
                FIRE.onFailedSocketEvent(event, e);
            }
        }

        @Override
        public void connect(SocketAddress endpoint, int timeout) throws IOException {
            this.socket.connect(endpoint, timeout);
        }

        @Override
        public void connect(SocketAddress endpoint) throws IOException {
            this.socket.connect(endpoint);
        }

        public boolean equals(Object obj) {
            return this.socket.equals(obj);
        }

        @Override
        public SocketChannel getChannel() {
            return this.socket.getChannel();
        }

        @Override
        public InetAddress getInetAddress() {
            return this.socket.getInetAddress();
        }

        @Override
        public InputStream getInputStream() throws IOException {
            return new SocketEventEmittingInputStream(this.socket.getInputStream());
        }

        @Override
        public boolean getKeepAlive() throws SocketException {
            return this.socket.getKeepAlive();
        }

        @Override
        public InetAddress getLocalAddress() {
            return this.socket.getLocalAddress();
        }

        @Override
        public int getLocalPort() {
            return this.socket.getLocalPort();
        }

        @Override
        public SocketAddress getLocalSocketAddress() {
            return this.socket.getLocalSocketAddress();
        }

        @Override
        public boolean getOOBInline() throws SocketException {
            return this.socket.getOOBInline();
        }

        @Override
        public OutputStream getOutputStream() throws IOException {
            return new SocketEventEmittingOutputStream(this.socket.getOutputStream());
        }

        @Override
        public int getPort() {
            return this.socket.getPort();
        }

        @Override
        public int getReceiveBufferSize() throws SocketException {
            return this.socket.getReceiveBufferSize();
        }

        @Override
        public SocketAddress getRemoteSocketAddress() {
            return this.socket.getRemoteSocketAddress();
        }

        @Override
        public boolean getReuseAddress() throws SocketException {
            return this.socket.getReuseAddress();
        }

        @Override
        public int getSendBufferSize() throws SocketException {
            return this.socket.getSendBufferSize();
        }

        @Override
        public int getSoLinger() throws SocketException {
            return this.socket.getSoLinger();
        }

        @Override
        public int getSoTimeout() throws SocketException {
            return this.socket.getSoTimeout();
        }

        @Override
        public boolean getTcpNoDelay() throws SocketException {
            return this.socket.getTcpNoDelay();
        }

        @Override
        public int getTrafficClass() throws SocketException {
            return this.socket.getTrafficClass();
        }

        public int hashCode() {
            return this.socket.hashCode();
        }

        @Override
        public boolean isBound() {
            return this.socket.isBound();
        }

        @Override
        public boolean isClosed() {
            return this.socket.isClosed();
        }

        @Override
        public boolean isConnected() {
            return this.socket.isConnected();
        }

        @Override
        public boolean isInputShutdown() {
            return this.socket.isInputShutdown();
        }

        @Override
        public boolean isOutputShutdown() {
            return this.socket.isOutputShutdown();
        }

        @Override
        public void sendUrgentData(int data) throws IOException {
            this.socket.sendUrgentData(data);
        }

        @Override
        public void setKeepAlive(boolean on) throws SocketException {
            this.socket.setKeepAlive(on);
        }

        @Override
        public void setOOBInline(boolean on) throws SocketException {
            this.socket.setOOBInline(on);
        }

        @Override
        public void setReceiveBufferSize(int size) throws SocketException {
            this.socket.setReceiveBufferSize(size);
        }

        @Override
        public void setReuseAddress(boolean on) throws SocketException {
            this.socket.setReuseAddress(on);
        }

        @Override
        public void setSendBufferSize(int size) throws SocketException {
            this.socket.setSendBufferSize(size);
        }

        @Override
        public void setSoLinger(boolean on, int linger) throws SocketException {
            this.socket.setSoLinger(on, linger);
        }

        @Override
        public void setSoTimeout(int timeout) throws SocketException {
            this.socket.setSoTimeout(timeout);
        }

        @Override
        public void setTcpNoDelay(boolean on) throws SocketException {
            this.socket.setTcpNoDelay(on);
        }

        @Override
        public void setTrafficClass(int tc) throws SocketException {
            this.socket.setTrafficClass(tc);
        }

        @Override
        public void shutdownInput() throws IOException {
            this.socket.shutdownInput();
        }

        @Override
        public void shutdownOutput() throws IOException {
            this.socket.shutdownOutput();
        }

        @Override
        public String toString() {
            return this.socket.toString();
        }

        class SocketEventEmittingInputStream
        extends InputStream {
            private final InputStream in;

            protected SocketEventEmittingInputStream(InputStream in) {
                this.in = in;
            }

            @Override
            public int available() throws IOException {
                return this.in.available();
            }

            @Override
            public void close() throws IOException {
                this.in.close();
            }

            @Override
            public void mark(int readlimit) {
                this.in.mark(readlimit);
            }

            @Override
            public boolean markSupported() {
                return this.in.markSupported();
            }

            @Override
            public void reset() throws IOException {
                this.in.reset();
            }

            @Override
            public long skip(long n) throws IOException {
                return this.in.skip(n);
            }

            @Override
            public int read() throws IOException {
                SocketRead read = new SocketRead(SocketEventEmittingWrapper.this);
                if (SocketEventEmittingWrapper.this.cancelMonitor != null && SocketEventEmittingWrapper.this.cancelMonitor.isCanceled()) {
                    SocketEventEmittingWrapper.this.throwDownloadCanceled(read);
                }
                FIRE.onBeforeSocketEvent(read);
                try {
                    int rc = this.in.read();
                    FIRE.onPostSocketEvent(read);
                    return rc;
                }
                catch (IOException e) {
                    FIRE.onFailedSocketEvent(read, e);
                    throw e;
                }
            }

            @Override
            public int read(byte[] b, int off, int len) throws IOException {
                SocketRead read = new SocketRead(SocketEventEmittingWrapper.this);
                if (SocketEventEmittingWrapper.this.cancelMonitor != null && SocketEventEmittingWrapper.this.cancelMonitor.isCanceled()) {
                    SocketEventEmittingWrapper.this.throwDownloadCanceled(read);
                }
                FIRE.onBeforeSocketEvent(read);
                try {
                    int rc = this.in.read(b, off, len);
                    FIRE.onPostSocketEvent(read);
                    FIRE.onPostSocketEvent(new SocketReadBytes(SocketEventEmittingWrapper.this, rc, b, off, len));
                    return rc;
                }
                catch (IOException e) {
                    FIRE.onFailedSocketEvent(read, e);
                    throw e;
                }
            }

            @Override
            public int read(byte[] b) throws IOException {
                SocketRead read = new SocketRead(SocketEventEmittingWrapper.this);
                if (SocketEventEmittingWrapper.this.cancelMonitor != null && SocketEventEmittingWrapper.this.cancelMonitor.isCanceled()) {
                    SocketEventEmittingWrapper.this.throwDownloadCanceled(read);
                }
                FIRE.onBeforeSocketEvent(read);
                try {
                    int rc = this.in.read(b);
                    FIRE.onPostSocketEvent(read);
                    FIRE.onPostSocketEvent(new SocketReadBytes(SocketEventEmittingWrapper.this, rc, b, 0, b.length));
                    return rc;
                }
                catch (IOException e) {
                    FIRE.onFailedSocketEvent(read, e);
                    throw e;
                }
            }
        }

        class SocketEventEmittingOutputStream
        extends OutputStream {
            private final OutputStream out;

            SocketEventEmittingOutputStream(OutputStream out) {
                this.out = out;
            }

            @Override
            public void close() throws IOException {
                this.out.close();
            }

            @Override
            public void flush() throws IOException {
                SocketWrite write = new SocketWrite(SocketEventEmittingWrapper.this);
                if (SocketEventEmittingWrapper.this.cancelMonitor != null && SocketEventEmittingWrapper.this.cancelMonitor.isCanceled()) {
                    SocketEventEmittingWrapper.this.throwDownloadCanceled(write);
                }
                FIRE.onBeforeSocketEvent(write);
                try {
                    this.out.flush();
                    FIRE.onPostSocketEvent(write);
                    return;
                }
                catch (IOException e) {
                    FIRE.onFailedSocketEvent(write, e);
                    throw e;
                }
            }

            @Override
            public void write(byte[] b, int off, int len) throws IOException {
                SocketWrite write = new SocketWrite(SocketEventEmittingWrapper.this);
                if (SocketEventEmittingWrapper.this.cancelMonitor != null && SocketEventEmittingWrapper.this.cancelMonitor.isCanceled()) {
                    SocketEventEmittingWrapper.this.throwDownloadCanceled(write);
                }
                FIRE.onBeforeSocketEvent(write);
                try {
                    this.out.write(b, off, len);
                    FIRE.onPostSocketEvent(write);
                    return;
                }
                catch (IOException e) {
                    FIRE.onFailedSocketEvent(write, e);
                    throw e;
                }
            }

            @Override
            public void write(byte[] b) throws IOException {
                SocketWrite write = new SocketWrite(SocketEventEmittingWrapper.this);
                if (SocketEventEmittingWrapper.this.cancelMonitor != null && SocketEventEmittingWrapper.this.cancelMonitor.isCanceled()) {
                    SocketEventEmittingWrapper.this.throwDownloadCanceled(write);
                }
                FIRE.onBeforeSocketEvent(write);
                try {
                    this.out.write(b);
                    FIRE.onPostSocketEvent(write);
                    return;
                }
                catch (IOException e) {
                    FIRE.onFailedSocketEvent(write, e);
                    throw e;
                }
            }

            @Override
            public void write(int b) throws IOException {
                SocketWrite write = new SocketWrite(SocketEventEmittingWrapper.this);
                if (SocketEventEmittingWrapper.this.cancelMonitor != null && SocketEventEmittingWrapper.this.cancelMonitor.isCanceled()) {
                    SocketEventEmittingWrapper.this.throwDownloadCanceled(write);
                }
                FIRE.onBeforeSocketEvent(write);
                try {
                    this.out.write(b);
                    FIRE.onPostSocketEvent(write);
                    return;
                }
                catch (IOException e) {
                    FIRE.onFailedSocketEvent(write, e);
                    throw e;
                }
            }
        }
    }

    public static abstract class SocketListener {
        public boolean isFakeExceptionGenerator() {
            return false;
        }

        public void onBeforeSocketConnected(SocketToConnect stc) {
        }

        public void onSocketConnected(SocketToConnect stc) throws IOException {
        }

        public void onSocketConnectFailed(SocketToConnect stc, Throwable t) {
        }

        public void onBeforeSocketEvent(IEventWithSocket event) throws IOException {
        }

        public void onPostSocketEvent(IEventWithSocket event) throws IOException {
        }

        public void onFailedSocketEvent(IEventWithSocket event, Throwable e) {
        }

        public void beginNoResponseExpected(Socket socket) {
        }

        public void endNoResponseExpected(Socket socket) {
        }
    }

    static class SocketRead
    extends EventWithSocket
    implements IEventWithSocket {
        SocketRead(Socket socket) {
            super(socket);
        }

        @Override
        public String getEventTypeName() {
            return "SocketRead";
        }
    }

    public static class SocketReadBytes
    extends EventWithSocket
    implements IEventWithSocket {
        public final int rc;
        public final byte[] b;
        public final int off;
        public final int len;

        SocketReadBytes(Socket socket, int rc, byte[] b, int off, int len) {
            super(socket);
            this.rc = rc;
            this.b = b;
            this.off = off;
            this.len = len;
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder(super.toString());
            sb.append(" rc=").append(this.rc);
            sb.append(" len=").append(this.len);
            return sb.toString();
        }

        @Override
        public String getEventTypeName() {
            return "SocketReadBytes";
        }
    }

    public static class SocketToConnect
    implements ISocketToConnect {
        private Socket socket;
        private final HostInfo hostInfo;
        private final InetSocketAddress hostAddress;
        private final InetSocketAddress localAddress;

        public SocketToConnect(Socket socket, InetSocketAddress address, InetSocketAddress localAddress) {
            this.socket = socket;
            this.hostAddress = address;
            this.hostInfo = new HostInfo(this.hostAddress.getHostName(), this.hostAddress.getPort());
            this.localAddress = localAddress;
        }

        public SocketToConnect(String host, int port) {
            this.socket = null;
            this.hostAddress = null;
            this.hostInfo = new HostInfo(host, port);
            this.localAddress = null;
        }

        public Socket getSocket() {
            return this.socket;
        }

        public void setSocket(Socket socket) {
            this.socket = socket;
        }

        @Override
        public HostInfo getHostInfo() {
            return this.hostInfo;
        }

        @Override
        public InetSocketAddress getHostAddress() {
            return this.hostAddress;
        }

        @Override
        public InetSocketAddress getLocalAddress() {
            return this.localAddress;
        }

        public String toString() {
            if (this.socket != null && this.socket.isConnected()) {
                return this.socket.toString();
            }
            if (this.hostAddress != null) {
                StringBuffer sb = new StringBuffer();
                sb.append(this.hostAddress.toString());
                if (this.localAddress != null) {
                    sb.append("[");
                    sb.append(this.localAddress);
                    sb.append("]");
                }
                return sb.toString();
            }
            return this.hostInfo.toString();
        }
    }

    static class SocketWrite
    extends EventWithSocket
    implements IEventWithSocket {
        SocketWrite(Socket socket) {
            super(socket);
        }

        @Override
        public String getEventTypeName() {
            return "SocketWrite";
        }
    }
}

