/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.downloads;

import com.ibm.cic.common.downloads.handlerImpl.DownloadHandlerUtil;
import java.util.Properties;

public class JavaProxyUtilities {
    private static final String S_HTTP_ENABLED = "http.proxySet";
    private static final String S_HTTP_HOST = "http.proxyHost";
    private static final String S_HTTP_PORT = "http.proxyPort";
    private static final String S_HTTPS_ENABLED = "https.proxySet";
    private static final String S_HTTPS_HOST = "https.proxyHost";
    private static final String S_HTTPS_PORT = "https.proxyPort";
    private static final String S_FTP_ENABLED = "ftp.proxySet";
    private static final String S_FTP_HOST = "ftp.proxyHost";
    private static final String S_FTP_PORT = "ftp.proxyPort";
    private static final String S_SOCKS_ENABLED = "socks.proxySet";
    private static final String S_SOCKS_HOST = "socksProxyHost";
    private static final String S_SOCKS_PORT = "socksProxyPort";

    private static void setProxySystemProperties(String protocol, String keyEnabled, String keyHost, String keyPort, boolean enabled, String host, String port) {
        if (host == null) {
            host = "";
        }
        if (port == null) {
            port = "";
        }
        if (host.length() == 0) {
            enabled = false;
        }
        Properties sys = System.getProperties();
        if (enabled) {
            sys.setProperty(keyEnabled, Boolean.toString(enabled));
            sys.setProperty(keyHost, host);
            sys.setProperty(keyPort, port);
        } else {
            sys.remove(keyEnabled);
            sys.remove(keyHost);
            sys.remove(keyPort);
        }
        JavaProxyUtilities.logInfo(protocol, keyEnabled, keyHost, keyPort);
    }

    public static void setHttpProxySystemProperties(boolean enabled, String host, String port) {
        JavaProxyUtilities.setProxySystemProperties("http", S_HTTP_ENABLED, S_HTTP_HOST, S_HTTP_PORT, enabled, host, port);
    }

    public static void clearHttpProxySystemProperties() {
        JavaProxyUtilities.setProxySystemProperties("http", S_HTTP_ENABLED, S_HTTP_HOST, S_HTTP_PORT, false, null, null);
    }

    public static void setHttpsProxySystemProperties(boolean enabled, String host, String port) {
        JavaProxyUtilities.setProxySystemProperties("https", S_HTTPS_ENABLED, S_HTTPS_HOST, S_HTTPS_PORT, enabled, host, port);
    }

    public static void clearHttpsProxySystemProperties() {
        JavaProxyUtilities.setProxySystemProperties("https", S_HTTPS_ENABLED, S_HTTPS_HOST, S_HTTPS_PORT, false, null, null);
    }

    public static void setFtpProxySystemProperties(boolean enabled, String host, String port) {
        JavaProxyUtilities.setProxySystemProperties("ftp", S_FTP_ENABLED, S_FTP_HOST, S_FTP_PORT, enabled, host, port);
    }

    public static void clearFtpProxySystemProperties() {
        JavaProxyUtilities.setProxySystemProperties("ftp", S_FTP_ENABLED, S_FTP_HOST, S_FTP_PORT, false, null, null);
    }

    public static void setSocksProxySystemProperties(boolean enabled, String host, String port) {
        JavaProxyUtilities.setProxySystemProperties("SOCKS", S_SOCKS_ENABLED, S_SOCKS_HOST, S_SOCKS_PORT, enabled, host, port);
    }

    public static void clearSocksProxySystemProperties() {
        JavaProxyUtilities.setSocksProxySystemProperties(false, null, null);
    }

    private static void logInfo(String protocol, String keyEnabled, String keyHost, String keyPort) {
        Properties sys = System.getProperties();
        if (sys.getProperty(keyEnabled) == null) {
            DownloadHandlerUtil.traceProxySettings.println("{0} proxy info: System.getProperty({1})==none", protocol, keyEnabled);
        } else {
            DownloadHandlerUtil.traceProxySettings.println("{0} proxy info: sys.prop({1})={2} sys.prop({3})={4} sys.prop({5})={6}", new String[]{protocol, keyEnabled, sys.getProperty(keyEnabled), keyHost, sys.getProperty(keyHost), keyPort, sys.getProperty(keyPort)});
        }
    }
}

