/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.downloads;

import com.ibm.cic.common.core.internal.ComIbmCicCommonCorePlugin;
import com.ibm.cic.common.downloads.IDownloadContext;
import com.ibm.cic.common.downloads.messages.IProtocolMessage;
import com.ibm.cic.common.logging.Logger;
import java.util.ArrayList;
import org.eclipse.core.runtime.Plugin;

public class HttpRequestEvents {
    private final ArrayList listeners;
    private static final Logger log = Logger.getLogger(HttpRequestEvents.class, (Plugin)ComIbmCicCommonCorePlugin.getDefault());
    private static final String DOWNLOAD_CONTEXT_KEY = "HttpRequestEvents";
    private static final HttpRequestListener NULL_FIRE = new HttpRequestListener(){

        @Override
        public void onEvent(HttpRequestEvent event) {
            if (log.isDebugLoggable()) {
                log.debug(event);
            }
        }
    };
    private final FireEvents MY_FIRE = new FireEvents();

    public static HttpRequestListener getFire(IDownloadContext ctxt) {
        HttpRequestEvents events = (HttpRequestEvents)ctxt.get(DOWNLOAD_CONTEXT_KEY);
        if (events != null) {
            return events.getFire();
        }
        return NULL_FIRE;
    }

    public static HttpRequestEvents getHttpRequestEvents(IDownloadContext ctxt) {
        HttpRequestEvents events = (HttpRequestEvents)ctxt.get(DOWNLOAD_CONTEXT_KEY);
        if (events == null) {
            events = new HttpRequestEvents();
            ctxt.put(DOWNLOAD_CONTEXT_KEY, events);
        }
        return events;
    }

    private HttpRequestListener getFire() {
        return this.MY_FIRE;
    }

    private HttpRequestEvents() {
        this.listeners = new ArrayList(10);
    }

    public synchronized void addListener(HttpRequestListener listener) {
        if (this.listeners.contains(listener)) {
            return;
        }
        this.listeners.add(listener);
    }

    public synchronized void removeListener(HttpRequestListener listener) {
        this.listeners.remove(listener);
    }

    private synchronized HttpRequestListener[] getListeners() {
        return this.listeners.toArray(new HttpRequestListener[this.listeners.size()]);
    }

    class FireEvents
    extends HttpRequestListener {
        FireEvents() {
        }

        @Override
        public void onEvent(HttpRequestEvent event) {
            HttpRequestListener[] aListeners;
            log.debug(event);
            HttpRequestListener[] httpRequestListenerArray = aListeners = HttpRequestEvents.this.getListeners();
            int n = aListeners.length;
            int n2 = 0;
            while (n2 < n) {
                HttpRequestListener listener = httpRequestListenerArray[n2];
                try {
                    listener.onEvent(event);
                }
                catch (Exception t) {
                    log.error(t);
                }
                ++n2;
            }
        }
    }

    public static interface HttpReceivedStatusLineAdapter
    extends HttpRequestAdapter {
        public String getStatusLine(Object var1);

        public int getCode(Object var1);
    }

    public static interface HttpRequestAdapter {
        public String getMethodName(Object var1);

        public String getUrlString(Object var1);

        public IProtocolMessage getRequestMessage(Object var1);

        public IProtocolMessage getResponseMessage(Object var1);
    }

    public static abstract class HttpRequestEvent {
        protected Object request;
        protected HttpRequestAdapter adapter;

        protected HttpRequestEvent(Object request, HttpRequestAdapter adapter) {
            this.request = request;
            this.adapter = adapter;
        }

        public String getMethodName() {
            return this.adapter.getMethodName(this.request);
        }

        public Object getUrlString() {
            return this.adapter.getUrlString(this.request);
        }

        public IProtocolMessage getRequestMessage() {
            return this.adapter.getRequestMessage(this.request);
        }

        public IProtocolMessage getResponseMessage() {
            return this.adapter.getResponseMessage(this.request);
        }

        public void appendToStringBuffer(StringBuffer sb) {
            sb.append(this.getMethodName());
            sb.append(' ');
            sb.append(this.getUrlString());
        }
    }

    public static abstract class HttpRequestListener {
        public void onEvent(HttpRequestEvent event) {
        }
    }

    public static class ReceivedStatusLineEvent
    extends HttpRequestEvent {
        public ReceivedStatusLineEvent(Object request, HttpReceivedStatusLineAdapter adapter) {
            super(request, adapter);
        }

        private HttpReceivedStatusLineAdapter getReceivedStatusLineAdapter() {
            return (HttpReceivedStatusLineAdapter)this.adapter;
        }

        public int getStatusCode() {
            return this.getReceivedStatusLineAdapter().getCode(this.request);
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("ReceivedStatusLineEvent ");
            this.appendToStringBuffer(sb);
            sb.append(": ");
            sb.append(this.getReceivedStatusLineAdapter().getStatusLine(this.request));
            return sb.toString();
        }
    }
}

