/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.downloads;

import com.ibm.cic.common.core.utils.ICicStatus;
import com.ibm.cic.common.downloads.ContentInfo;
import com.ibm.cic.common.downloads.IContentInfo;
import com.ibm.cic.common.downloads.IDownloaded;
import com.ibm.cic.common.downloads.IMutableContentInfo;
import com.ibm.cic.common.downloads.SimpleContentInfo;

public class Downloaded
implements IDownloaded {
    private final ICicStatus status;
    private IContentInfo downloadContentInfo;

    public Downloaded(ICicStatus status, IContentInfo downloadContentInfo) {
        this.status = status;
        this.setDownloadContentInfo(downloadContentInfo);
    }

    @Override
    public ICicStatus getStatus() {
        return this.status;
    }

    @Override
    public IContentInfo getDownloadContentInfo() {
        return this.downloadContentInfo;
    }

    @Override
    public IMutableContentInfo getMutableDownloadContentInfo() {
        if (this.downloadContentInfo instanceof IMutableContentInfo) {
            return (IMutableContentInfo)this.downloadContentInfo;
        }
        return new SimpleContentInfo(this.downloadContentInfo);
    }

    public void setDownloadContentInfo(IContentInfo downloadContentInfo) {
        this.downloadContentInfo = downloadContentInfo != null ? downloadContentInfo : ContentInfo.EMPTY_CONTENT_INFO;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("downloaded status=");
        sb.append(this.status.toString());
        sb.append(", dl contentInfo=");
        sb.append(this.downloadContentInfo.toString());
        return sb.toString();
    }
}

