/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.downloads;

import com.ibm.cic.common.core.internal.ComIbmCicCommonCorePlugin;
import com.ibm.cic.common.core.utils.Statuses;
import com.ibm.cic.common.downloads.DownloadUI;
import com.ibm.cic.common.downloads.IDownloadUI;
import com.ibm.cic.common.downloads.IHasIsCanceled;
import com.ibm.cic.common.downloads.ISuspendResumeUI;
import com.ibm.cic.common.downloads.Messages;
import com.ibm.cic.common.downloads.PreferencesHolder;
import com.ibm.cic.common.logging.Logger;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;

public class DownloadRetry {
    public static final Logger log = Logger.getLogger(DownloadRetry.class, (Plugin)ComIbmCicCommonCorePlugin.getDefault());

    public static void retry(IRetryHistory history, IRetriableCall retriable) {
        IDownloadUI ui = DownloadUI.INSTANCE.getUI();
        if (ui instanceof ISuspendResumeUI) {
            DownloadRetry.retryWithSuspendResumeUI((ISuspendResumeUI)ui, history, retriable);
            return;
        }
        if (ui instanceof DownloadUI.ICancelDownloadUI) {
            DownloadUI.ICancelDownloadUI cancelUI = (DownloadUI.ICancelDownloadUI)ui;
            DownloadRetry.retryWithCancelUI(cancelUI, history, retriable);
            return;
        }
        DownloadRetry.retryUnattended(history, retriable);
    }

    private static void retryUnattended(IRetryHistory history, IRetriableCall retriable) {
        int retryNpCount = 0;
        int retryNpLimit = PreferencesHolder.INSTANCE.getDownloadAutoRetryCount();
        boolean waitInSilentMode = true;
        if (retryNpLimit == 0) {
            waitInSilentMode = false;
            retryNpLimit = 1;
        }
        while (retryNpCount <= retryNpLimit) {
            boolean tryInterrupt;
            if (retryNpCount != 0) {
                if (retriable.isCanceled()) {
                    history.addStatus(Status.CANCEL_STATUS);
                    break;
                }
                String msg = Messages.ResumeableDownload_retryStalledDownload;
                history.addStatus(Statuses.INFO.get(msg, new Object[0]));
            }
            retriable.call(history);
            if (retriable.isDone()) {
                return;
            }
            if (retriable.isCanceled()) {
                history.addStatus(Status.CANCEL_STATUS);
                break;
            }
            Boolean lastCallMadeProgress = retriable.lastCallMadeProgress();
            boolean noProgressMade = lastCallMadeProgress != null ? !lastCallMadeProgress.booleanValue() : false;
            retryNpCount = noProgressMade ? retryNpCount + 1 : 0;
            boolean validationFailedLastDownload = retriable.hasValidationFailed();
            boolean bl = tryInterrupt = retryNpCount > 0 && !validationFailedLastDownload;
            if (!tryInterrupt || retryNpCount > retryNpLimit || !waitInSilentMode) continue;
            try {
                history.addStatus(Statuses.INFO.get(Messages.ResumeableDownload_retryNrOfTotalScheduledInOneMinuteFor, retryNpCount, retryNpLimit - 1, retriable.getSource()));
                Thread.sleep(60000L);
            }
            catch (InterruptedException e) {
                log.error(e);
            }
        }
    }

    private static void waitBeforeRetryCheckForCancel(IHasIsCanceled cancelMonitor, int waitPeriodInSeconds) {
        long now;
        long timeStarted = System.currentTimeMillis();
        long timeEnd = timeStarted + (long)(waitPeriodInSeconds * 1000);
        do {
            if (cancelMonitor.isCanceled()) {
                return;
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                log.error(e);
            }
        } while ((now = System.currentTimeMillis()) <= timeEnd);
    }

    private static void retryWithSuspendResumeUI(ISuspendResumeUI ui, IRetryHistory history, IRetriableCall retriable) {
        int retryNpCount = 0;
        SuspendResumeTimeoutDuration suspendResumeTimeout = new SuspendResumeTimeoutDuration();
        while (true) {
            if (retryNpCount != 0) {
                if (retriable.isCanceled()) {
                    history.addStatus(Status.CANCEL_STATUS);
                    break;
                }
                history.addStatus(Statuses.INFO.get(Messages.ResumeableDownload_retryStalledDownload, new Object[0]));
            }
            retriable.call(history);
            if (retriable.isDone()) {
                return;
            }
            if (retriable.isCanceled()) {
                history.addStatus(Status.CANCEL_STATUS);
                break;
            }
            Boolean lastCallMadeProgress = retriable.lastCallMadeProgress();
            boolean noProgressMade = lastCallMadeProgress != null ? !lastCallMadeProgress.booleanValue() : false;
            retryNpCount = noProgressMade ? retryNpCount + 1 : 0;
            boolean validationFailedInTotalStatus = retriable.hasValidationFailedInTotalStatus();
            if (!noProgressMade && !validationFailedInTotalStatus) {
                suspendResumeTimeout.reset();
            }
            boolean validationFailedLastDownload = retriable.hasValidationFailed();
            boolean tryInterrupt = retryNpCount > 1 && !validationFailedLastDownload;
            if (!tryInterrupt) continue;
            retriable.onBeforeTryInterrupt();
            long timeoutMillis = suspendResumeTimeout.getTimeoutDuration() * 1000L;
            ui.requestInterruptedState(timeoutMillis);
            boolean didWait = ui.waitUntilResumeOrRetry();
            if (didWait) continue;
            DownloadRetry.waitBeforeRetryCheckForCancel(ui, 3);
        }
    }

    public static void retryWithCancelUI(DownloadUI.ICancelDownloadUI cancelUI, IRetryHistory history, IRetriableCall retriable) {
        assert (cancelUI != null);
        DownloadUI.ICancelDownloadUI cancelMonitor = cancelUI;
        int retryNpCount = 0;
        while (true) {
            if (retryNpCount != 0) {
                if (retriable.isCanceled()) {
                    history.addStatus(Status.CANCEL_STATUS);
                    break;
                }
                String msg = Messages.ResumeableDownload_retryStalledDownload;
                history.addStatus(Statuses.INFO.get(msg, new Object[0]));
            }
            retriable.call(history);
            if (retriable.isDone()) {
                return;
            }
            if (retriable.isCanceled()) {
                history.addStatus(Status.CANCEL_STATUS);
                break;
            }
            Boolean lastCallMadeProgress = retriable.lastCallMadeProgress();
            boolean noProgressMade = lastCallMadeProgress != null ? !lastCallMadeProgress.booleanValue() : false;
            retryNpCount = noProgressMade ? retryNpCount + 1 : 0;
            boolean validationFailedLastDownload = retriable.hasValidationFailed();
            boolean tryInterrupt = retryNpCount > 0 && !validationFailedLastDownload;
            if (!tryInterrupt) continue;
            retriable.onBeforeTryInterrupt();
            if (cancelUI.cancelMonitorHasUserAttention()) {
                DownloadRetry.waitBeforeRetryCheckForCancel(cancelMonitor, 3);
                continue;
            }
            history.addStatus(Statuses.INFO.get(Messages.ResumeableDownload_retryNrScheduledInOneMinuteFor, retryNpCount, retriable.getSource()));
            DownloadRetry.waitBeforeRetryCheckForCancel(cancelMonitor, 60);
        }
    }

    public static interface IRetriableCall {
        public Object getSource();

        public void call(IRetryHistory var1);

        public boolean isCanceled();

        public boolean hasValidationFailed();

        public boolean hasValidationFailedInTotalStatus();

        public boolean isDone();

        public Boolean lastCallMadeProgress();

        public void onBeforeTryInterrupt();
    }

    public static interface IRetryHistory {
        public void addStatus(IStatus var1);
    }

    private static class SuspendResumeTimeoutDuration {
        private long previousTimeout = -1L;
        private int count = 0;

        private SuspendResumeTimeoutDuration() {
        }

        public long getTimeoutDuration() {
            long current = System.currentTimeMillis();
            if (this.previousTimeout == -1L) {
                this.previousTimeout = current;
                this.count = 1;
                return this.getCountTimeout();
            }
            if (current - this.previousTimeout < 10000L) {
                this.previousTimeout = current;
                return this.getCountTimeout();
            }
            this.previousTimeout = current;
            ++this.count;
            return this.getCountTimeout();
        }

        private long getCountTimeout() {
            long timeoutSeconds = this.count == 1 ? 60L : (this.count <= 2 ? 300L : (this.count <= 5 ? 600L : 900L));
            return timeoutSeconds;
        }

        public void reset() {
            this.previousTimeout = -1L;
            this.count = 0;
        }
    }
}

