/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.downloads;

public class ByteRange {
    private final long start;
    private final long end;
    private final boolean endIsAtEof;
    public static final long EOF_LIMIT = -1L;
    public static final ByteRange RANGE_ALL_BYTES = new ByteRange(0L, -1L, true);

    public static ByteRange remainingRange(long start) {
        return new ByteRange(start, -1L, true);
    }

    public static ByteRange remainingRange(long start, long end) {
        return new ByteRange(start, end, true);
    }

    public static ByteRange range(long start, long end) {
        return new ByteRange(start, end, false);
    }

    public ByteRange(long start, long end, boolean endIsAtEOF) {
        if (start < 0L) {
            throw new IndexOutOfBoundsException("start must be >= 0. But is " + Long.toString(start));
        }
        if (end != -1L) {
            if (!endIsAtEOF ? end <= start : end != start && end < start) {
                throw new IndexOutOfBoundsException("end must be either EOF_LIMIT or greater than start. start=" + Long.toString(start) + " end=" + Long.toString(end));
            }
        } else if (!endIsAtEOF) {
            throw new IllegalArgumentException("range to EOF_LIMIT must also set endIsAtEOF to true");
        }
        this.start = start;
        this.end = end;
        this.endIsAtEof = endIsAtEOF;
    }

    public boolean hasSpecifiedEnd() {
        return this.end != -1L;
    }

    public boolean extendsToSpecifiedEOF() {
        return this.hasSpecifiedEnd() && this.isEndAtEof();
    }

    public boolean isFullRange() {
        return this.start == 0L && this.isEndAtEof();
    }

    public boolean isEofRange() {
        return this.start == this.end && this.isEndAtEof();
    }

    public long size() {
        if (!this.hasSpecifiedEnd()) {
            throw new RuntimeException("Precondition violated: size() can only be called if this.hasSpecifiedEnd()");
        }
        return this.end - this.start;
    }

    public long sizeOrUnknown() {
        if (!this.hasSpecifiedEnd()) {
            return -1L;
        }
        return this.end - this.start;
    }

    public boolean equals(Object o) {
        if (o instanceof ByteRange) {
            ByteRange rhs = (ByteRange)o;
            return rhs.start == this.start && rhs.end == this.end && rhs.endIsAtEof == this.endIsAtEof;
        }
        return false;
    }

    public int hashCode() {
        return (int)(this.start * 7L + this.end + (long)(this.endIsAtEof ? 1 : 0));
    }

    public long getStart() {
        return this.start;
    }

    public long getEnd() {
        return this.end;
    }

    public boolean isEndAtEof() {
        return this.endIsAtEof;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("[");
        sb.append(this.start);
        sb.append("..");
        if (this.end == -1L) {
            sb.append("EOF_LIMIT");
        } else {
            sb.append(this.end);
            if (this.isEndAtEof()) {
                sb.append("=EOF");
            }
        }
        sb.append(")");
        return sb.toString();
    }
}

