/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.utils;

public class OutputFormatter {
    private static final int DISPLAY_WIDTH = 80;
    public static final String EQUALS = "=";
    public static final String EMPTY_STRING = "";
    public static final String COLUMN_SEPARATOR = " : ";
    public static final String COLUMN_SEPARATOR1 = ": ";
    public static final String SEPARATOR_COMMA = ", ";
    public static final String BRACKET_OPEN = "(";
    public static final String BRACKET_CLOSE = ") ";
    public static final String BRACKET_SQURE_OPEN = "[";
    public static final String BRACKET_SQURE_CLOSE = "] ";
    public static final String UNDERSCORE = "_";
    public static final String SPACE = " ";
    public static final String CHECK_MARK = "X";
    public static final String NEW_LINE_STR = System.getProperty("line.separator");
    public static final String TAB = "    ";
    public static final String ARROW = " --> ";
    public static final String SUB_PROGRESS_HEADER = "---- ";
    public static final String DOUBLE_QUOTE = "\"";
    private final StringBuffer buffer = new StringBuffer();
    private int tab;
    private int tabIncrement = 2;

    public OutputFormatter(int tabIncrement) {
        this.tabIncrement = tabIncrement;
    }

    public OutputFormatter() {
        this(2);
    }

    public void fitMultirow(String msg, String separator) {
        int tabCount = 0;
        String str = msg;
        int max = 80 - this.tab - separator.length();
        int start = 0;
        int index = 0;
        while (str.length() > max) {
            int previous_index = index;
            while (index < max && index != -1) {
                previous_index = index + separator.length();
                index = str.indexOf(separator, previous_index);
            }
            index = previous_index;
            this.appendTnl(str.substring(start, index));
            this.incTab();
            ++tabCount;
            start = index;
            str = str.substring(index);
        }
        this.appendTnl(str);
        int i = 0;
        while (i < tabCount) {
            this.decTab();
            ++i;
        }
        this.nl();
    }

    public void addSpace(int i) {
        while (i > 0) {
            this.buffer.append(SPACE);
            --i;
        }
    }

    public void addTab() {
        this.addSpace(this.tab);
    }

    public String toString() {
        return this.buffer.toString();
    }

    public boolean isEmpty() {
        return this.buffer.length() == 0;
    }

    public void incTab() {
        this.tab += this.tabIncrement;
    }

    public void decTab() {
        if (this.tab > 0) {
            this.tab -= this.tabIncrement;
        }
    }

    public void decTab(boolean force) {
        if (this.tab > 0 || force) {
            this.tab -= this.tabIncrement;
        }
    }

    public void appendNT(String ... strings) {
        String[] stringArray = strings;
        int n = strings.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            this.appendNT(s);
            ++n2;
        }
    }

    public void appendNT(String s) {
        this.buffer.append(s);
    }

    public void appendNT(long l) {
        this.buffer.append(l);
    }

    public void appendNTnl(String s) {
        this.appendNT(s);
        this.appendNT(NEW_LINE_STR);
    }

    public void appendTnl(String ... s1) {
        this.appendT(s1);
        this.appendNT(NEW_LINE_STR);
    }

    public void appendT(String ... s1) {
        this.addTab();
        String[] stringArray = s1;
        int n = s1.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            this.appendNT(s);
            ++n2;
        }
    }

    public void appendT(long ... l) {
        this.addTab();
        long[] lArray = l;
        int n = l.length;
        int n2 = 0;
        while (n2 < n) {
            long l1 = lArray[n2];
            this.appendNT(l1);
            ++n2;
        }
    }

    public void nl() {
        this.appendNT(NEW_LINE_STR);
    }

    public void nl(int i) {
        int j = 0;
        while (j < i) {
            this.nl();
            ++j;
        }
    }

    public void removeTrailingSpace() {
        this.buffer.setLength(this.findTrailingNewlines());
    }

    public String withoutNL() {
        return this.buffer.substring(0, this.findTrailingNewlines());
    }

    private int findTrailingNewlines() {
        int i = this.buffer.length();
        while (i > 0) {
            char c = this.buffer.charAt(i - 1);
            if (c != '\n' && c != '\r') {
                return i;
            }
            --i;
        }
        return 0;
    }
}

