/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.utils;

import java.util.Map;

public class NamedArgumentParserUtil {
    private NamedArgumentParserUtil() {
    }

    public static abstract class NamedArgumentParser {
        private final SeparatedArgsParser parserSepArgs;
        protected char nameValueSep;

        public NamedArgumentParser() {
            this(',', '=');
        }

        public NamedArgumentParser(char argSep, char nameValueSep) {
            this.nameValueSep = nameValueSep;
            this.parserSepArgs = new SeparatedArgsParser(argSep){

                @Override
                protected void onParsedArg(String arg) throws ParseException {
                    int i = arg.indexOf(nameValueSep);
                    if (i == -1) {
                        if (arg.trim().length() == 0) {
                            this.onEmptyArg();
                        }
                        this.onParsedNameOnly(arg);
                    } else {
                        this.onParsedNameValue(this.nameOf(arg.substring(0, i)), this.valueOf(arg.substring(i + 1)));
                    }
                }

                @Override
                protected void onParsedArgsCount(int n) throws ParseException {
                    this.onParsedArgsCount(n);
                }
            };
        }

        public void parse(String arg0) throws ParseException {
            this.parserSepArgs.parse(arg0);
        }

        public String unparse(Map map) {
            StringBuffer sb = new StringBuffer(200);
            int i = 0;
            for (Map.Entry entry : map.entrySet()) {
                String name = (String)entry.getKey();
                String value = (String)entry.getValue();
                if (i != 0) {
                    sb.append(this.parserSepArgs.getArgsSeparator());
                    sb.append(' ');
                }
                sb.append(name);
                if (value != null) {
                    sb.append(this.nameValueSep);
                    sb.append(value);
                }
                ++i;
            }
            return sb.toString();
        }

        protected abstract void onParsedArgsCount(int var1) throws ParseException;

        protected abstract void onParsedNameValue(String var1, String var2) throws ParseException;

        protected abstract void onParsedNameOnly(String var1) throws ParseException;

        protected abstract void onEmptyArg() throws ParseException;

        protected String nameOf(String s) {
            return s.trim();
        }

        protected String valueOf(String s) {
            return s.trim();
        }
    }

    public static class ParseException
    extends Exception {
        public ParseException(String message) {
            super(message);
        }
    }

    public static abstract class SeparatedArgsParser {
        private final char sep;

        public SeparatedArgsParser(char sep) {
            this.sep = sep;
        }

        public SeparatedArgsParser() {
            this('=');
        }

        public void parse(String args) throws ParseException {
            int n = SeparatedArgsParser.getSeparatedArgsCount(args, this.sep);
            this.onParsedArgsCount(n);
            if (n == 1) {
                this.onParsedArg(args);
                return;
            }
            int start = 0;
            int end = args.indexOf(this.sep);
            while (end != -1) {
                this.onParsedArg(args.substring(start, end));
                start = end + 1;
                end = args.indexOf(this.sep, start);
            }
            if (start < args.length()) {
                this.onParsedArg(args.substring(start));
            }
        }

        protected abstract void onParsedArgsCount(int var1) throws ParseException;

        protected abstract void onParsedArg(String var1) throws ParseException;

        public char getArgsSeparator() {
            return this.sep;
        }

        private static int getSeparatedArgsCount(String args, char sep) {
            int n = 1;
            int i = args.indexOf(sep);
            while (i != -1) {
                ++n;
                i = args.indexOf(i + 1, (int)sep);
            }
            return n;
        }
    }
}

