/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.utils;

import com.ibm.cic.common.core.repository.StatusCodes;
import com.ibm.cic.common.core.utils.Check;
import com.ibm.cic.common.core.utils.CicMultiStatus;
import com.ibm.cic.common.core.utils.ICicStatus;
import com.ibm.cic.common.core.utils.Statuses;
import com.ibm.cic.common.core.utils.Util;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;

public class MultiStatusUtil {
    private static final IStatusFilter StatusFilterIncludeAll = new IStatusFilter(){

        @Override
        public boolean considerChildren() {
            return true;
        }

        @Override
        public boolean include(IStatus status) {
            return true;
        }
    };
    public static final IStatusEqual StatusEqualByCodeSeverityPlugin = new IStatusEqual(){

        @Override
        public boolean isEqualStatus(IStatus a, IStatus b) {
            return a.getCode() == b.getCode() && a.getSeverity() == b.getSeverity() && MultiStatusUtil.isEqualString(a.getPlugin(), b.getPlugin());
        }
    };
    public static final IStatusEqual StatusEqualByCodeSeverityPluginMessage = new IStatusEqual(){

        @Override
        public boolean isEqualStatus(IStatus a, IStatus b) {
            return a.getCode() == b.getCode() && a.getSeverity() == b.getSeverity() && MultiStatusUtil.isEqualString(a.getPlugin(), b.getPlugin()) && MultiStatusUtil.isEqualString(a.getMessage(), b.getMessage());
        }
    };
    public static final IStatusEqual StatusEqualByCodePluginMessage = new IStatusEqual(){

        @Override
        public boolean isEqualStatus(IStatus a, IStatus b) {
            return a.getCode() == b.getCode() && MultiStatusUtil.isEqualString(a.getPlugin(), b.getPlugin()) && MultiStatusUtil.isEqualString(a.getMessage(), b.getMessage());
        }
    };
    public static final IStatusEqual StatusEqualByMessage = new IStatusEqual(){

        @Override
        public boolean isEqualStatus(IStatus a, IStatus b) {
            return MultiStatusUtil.isEqualString(a.getMessage(), b.getMessage());
        }
    };
    private static final IStatusEqual StatusEqualAll = new IStatusEqual(){

        @Override
        public boolean isEqualStatus(IStatus a, IStatus b) {
            return a.getCode() == b.getCode() && a.getSeverity() == b.getSeverity() && MultiStatusUtil.isEqualString(a.getPlugin(), b.getPlugin()) && MultiStatusUtil.isEqualString(a.getMessage(), b.getMessage()) && MultiStatusUtil.isEqualException(a.getException(), b.getException());
        }
    };

    private MultiStatusUtil() {
        Check.failNoInstances();
    }

    public static List<IStatus> getStatusLeavesBySeverityMask(IStatus root, int severityMask) {
        ArrayList<IStatus> leaves = new ArrayList<IStatus>();
        MultiStatusUtil.collectStatusLeaves(root, leaves, new StatusFilterBySeverityMask(severityMask));
        leaves.trimToSize();
        return leaves;
    }

    public static List<IStatus> getStatusLeaves(IStatus root) {
        ArrayList<IStatus> leaves = new ArrayList<IStatus>();
        if (root.getChildren().length > 0) {
            MultiStatusUtil.collectStatusLeaves(root, leaves, StatusFilterIncludeAll);
            leaves.trimToSize();
        }
        return leaves;
    }

    public static String getFailureMessage(IStatus status) {
        String msgSeparator = "; ";
        return MultiStatusUtil.getFailureMessage(status, "; ");
    }

    private static boolean isNewLineSeparator(String msgSeparator) {
        return msgSeparator.startsWith("\n") || msgSeparator.startsWith("\r\n");
    }

    public static String getFailureMessage(IStatus status, String msgSeparator) {
        if (status.isMultiStatus()) {
            String msg = status.getMessage().trim();
            StringBuffer sb = new StringBuffer(msg);
            List<IStatus> leaves = MultiStatusUtil.getStatusLeaves(status);
            ArrayList<String> failures = new ArrayList<String>(leaves.size());
            for (IStatus child : leaves) {
                String childMsg = child.getMessage();
                if (childMsg == null || (childMsg = childMsg.trim()).length() == 0) continue;
                failures.add(childMsg);
            }
            boolean hasNext = false;
            if (!failures.isEmpty()) {
                if (msg.length() > 0) {
                    sb.append(msgSeparator);
                }
                hasNext = true;
            }
            Iterator it = failures.iterator();
            while (hasNext) {
                String failure = (String)it.next();
                sb.append(failure);
                hasNext = it.hasNext();
                int lastIndex = sb.length() - 1;
                if (hasNext) {
                    if (lastIndex >= 0 && MultiStatusUtil.charIsPeriod(sb.charAt(lastIndex)) && !MultiStatusUtil.isNewLineSeparator(msgSeparator)) {
                        sb.deleteCharAt(lastIndex);
                    }
                    sb.append(msgSeparator);
                    continue;
                }
                if (sb.length() <= 0 || MultiStatusUtil.charIsPeriod(sb.charAt(lastIndex))) continue;
                sb.append('.');
            }
            return sb.toString();
        }
        return status.getMessage();
    }

    private static boolean charIsPeriod(char ch) {
        return ch == '.' || ch == '\u3002';
    }

    public static List getStatusNodes(IStatus root) {
        ArrayList nodes = new ArrayList();
        MultiStatusUtil.collectStatusNodes(root, nodes);
        nodes.trimToSize();
        return nodes;
    }

    private static void collectStatusLeaves(IStatus root, List<IStatus> leaves, IStatusFilter filter) {
        if (root.isMultiStatus()) {
            IStatus[] children = root.getChildren();
            if (children.length == 0) {
                if (filter.include(root)) {
                    leaves.add(root);
                }
            } else if (filter.considerChildren()) {
                IStatus[] iStatusArray = children;
                int n = children.length;
                int n2 = 0;
                while (n2 < n) {
                    IStatus child = iStatusArray[n2];
                    MultiStatusUtil.collectStatusLeaves(child, leaves, filter);
                    ++n2;
                }
            }
        } else if (filter.include(root)) {
            leaves.add(root);
        }
    }

    private static IStatus newNonMultiStatus(IStatus status) {
        if (status.isMultiStatus()) {
            return new Status(status.getSeverity(), status.getPlugin(), status.getCode(), status.getMessage(), status.getException());
        }
        return status;
    }

    private static void collectStatusNodes(IStatus root, List nodes) {
        nodes.add(MultiStatusUtil.newNonMultiStatus(root));
        if (root.isMultiStatus()) {
            IStatus[] iStatusArray = root.getChildren();
            int n = iStatusArray.length;
            int n2 = 0;
            while (n2 < n) {
                IStatus child = iStatusArray[n2];
                MultiStatusUtil.collectStatusNodes(child, nodes);
                ++n2;
            }
        }
    }

    public static IStatus newFlattenedStatus(String pluginId, IStatus root, String msg) {
        if (!root.isMultiStatus()) {
            return root;
        }
        List<IStatus> leaves = MultiStatusUtil.getStatusLeaves(root);
        if (leaves.isEmpty()) {
            return root;
        }
        IStatus[] children = leaves.toArray(new IStatus[leaves.size()]);
        return Statuses.ST.createMultiStatus(pluginId, 0, root.getCode(), children, null, msg);
    }

    public static boolean hasFilteredStatus(IStatus status, IStatusFilter filter) {
        if (filter.include(status)) {
            return true;
        }
        if (!filter.considerChildren()) {
            return false;
        }
        IStatus[] iStatusArray = status.getChildren();
        int n = iStatusArray.length;
        int n2 = 0;
        while (n2 < n) {
            IStatus child = iStatusArray[n2];
            if (MultiStatusUtil.hasFilteredStatus(child, filter)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static boolean hasFilteredStatusBySeverityMask(IStatus status, int severityMask) {
        StatusFilterBySeverityMask filter = new StatusFilterBySeverityMask(severityMask);
        return MultiStatusUtil.hasFilteredStatus(status, filter);
    }

    public static boolean hasStatus(IStatus status, int severity, String plugin, int code) {
        StatusFilterByCodeSeverityPlugin filter = new StatusFilterByCodeSeverityPlugin(severity, plugin, code);
        return MultiStatusUtil.hasFilteredStatus(status, filter);
    }

    public static boolean hasStatus(IStatus status, String plugin, int code) {
        StatusFilterByCodePlugin filter = new StatusFilterByCodePlugin(plugin, code);
        return MultiStatusUtil.hasFilteredStatus(status, filter);
    }

    public static boolean hasStatusCode(IStatus status, int code) {
        if (status.getCode() == code) {
            return true;
        }
        IStatus[] iStatusArray = status.getChildren();
        int n = iStatusArray.length;
        int n2 = 0;
        while (n2 < n) {
            IStatus child = iStatusArray[n2];
            if (MultiStatusUtil.hasStatusCode(child, code)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static IStatus newFilteredStatus(String message, IStatus status, IStatusFilter filter) {
        if (!status.isMultiStatus()) {
            return status;
        }
        LinkedList<IStatus> list = new LinkedList<IStatus>();
        IStatus[] iStatusArray = status.getChildren();
        int n = iStatusArray.length;
        int n2 = 0;
        while (n2 < n) {
            IStatus child = iStatusArray[n2];
            if (MultiStatusUtil.hasFilteredStatus(child, filter)) {
                list.add(child);
            }
            ++n2;
        }
        IStatus[] newChildren = list.toArray(new IStatus[list.size()]);
        if (newChildren.length == 0) {
            return status;
        }
        return Statuses.ST.createMultiStatus(status.getPlugin(), 0, status.getCode(), newChildren, status.getException(), message);
    }

    public static boolean isEqualStatus(IStatusEqual eq, IStatus a, IStatus b) {
        if (a == b) {
            return true;
        }
        if (a != null && b != null) {
            return eq.isEqualStatus(a, b);
        }
        return false;
    }

    public static boolean isDeepEqualStatus(IStatusEqual eq, IStatus a, IStatus b) {
        IStatus[] bchildren;
        IStatus[] achildren;
        if (a == b) {
            return true;
        }
        if (!MultiStatusUtil.isEqualStatus(eq, a, b)) {
            return false;
        }
        if (a != null && b != null && a.isMultiStatus() == b.isMultiStatus() && (achildren = a.getChildren()).length == (bchildren = b.getChildren()).length) {
            int i = 0;
            while (i < achildren.length) {
                IStatus achild = achildren[i];
                IStatus bchild = bchildren[i];
                if (!MultiStatusUtil.isDeepEqualStatus(eq, achild, bchild)) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    private static boolean isEqualString(String a, String b) {
        return Util.equals(a, b);
    }

    private static boolean isEqualException(Throwable e1, Throwable e2) {
        if (e1 == e2) {
            return true;
        }
        if (e1 == null || e2 == null) {
            return false;
        }
        if (!e1.getClass().equals(e2.getClass())) {
            return false;
        }
        return e1.toString().equals(e2.toString());
    }

    public static void addReduceStatus(IStatusEqual eq, CicMultiStatus collectStatus, IStatus status) {
        if (!MultiStatusUtil.isEqualStatus(eq, collectStatus, status)) {
            collectStatus.add(status);
        } else {
            collectStatus.addAll(status);
        }
    }

    public static Throwable getAnyException(IStatus status) {
        IStatus[] children;
        Throwable t = status.getException();
        if (t != null || !status.isMultiStatus()) {
            return t;
        }
        IStatus[] iStatusArray = children = status.getChildren();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            IStatus childStatus = iStatusArray[n2];
            t = MultiStatusUtil.getAnyException(childStatus);
            if (t != null) {
                return t;
            }
            ++n2;
        }
        return null;
    }

    public static Throwable getStatusOnSubException(IStatus status) {
        return MultiStatusUtil.getStatusOnSubException(StatusEqualByCodeSeverityPlugin, status, status);
    }

    private static Throwable getStatusOnSubException(IStatusEqual eq, IStatus root, IStatus status) {
        if (StatusCodes.isEqualByCodeSeverityPlugin(root, status) && status.getException() != null) {
            return status.getException();
        }
        if (status.isMultiStatus()) {
            IStatus[] children;
            IStatus[] iStatusArray = children = status.getChildren();
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                IStatus child = iStatusArray[n2];
                Throwable t = MultiStatusUtil.getStatusOnSubException(eq, root, child);
                if (t != null) {
                    return t;
                }
                ++n2;
            }
        }
        return null;
    }

    public static IStatus removeDuplicates(IStatus status) {
        final HashSet seen = new HashSet();
        IStatusFilter filter = new IStatusFilter(){

            @Override
            public boolean considerChildren() {
                return false;
            }

            @Override
            public boolean include(IStatus s) {
                StatusEqualWrapper w = new StatusEqualWrapper(s);
                if (seen.contains(w)) {
                    return false;
                }
                seen.add(w);
                return true;
            }
        };
        return MultiStatusUtil.newFilteredStatus(status.getMessage(), status, filter);
    }

    private static boolean needsRecoding(IStatus status, IStatusRecoder recoder) {
        IStatus[] children;
        if (!status.isMultiStatus()) {
            return recoder.needsRecoding(status);
        }
        if (recoder.needsRecoding(status)) {
            return true;
        }
        IStatus[] iStatusArray = children = status.getChildren();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            IStatus child = iStatusArray[n2];
            if (MultiStatusUtil.needsRecoding(child, recoder)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private static IStatus doSingleRecode(IStatus status, IStatusRecoder recoder) {
        if (recoder.needsRecoding(status)) {
            return recoder.recode(status);
        }
        return status;
    }

    private static IStatus doSingleRecode(IStatus status, IStatus[] recodedChildren, IStatusRecoder recoder) {
        if (recoder.needsRecoding(status)) {
            return recoder.recode(status, recodedChildren);
        }
        return new MultiStatus(status.getPlugin(), status.getCode(), recodedChildren, status.getMessage(), status.getException());
    }

    private static IStatus doRecodeStatus(IStatus status, IStatusRecoder recoder) {
        if (!status.isMultiStatus()) {
            return MultiStatusUtil.doSingleRecode(status, recoder);
        }
        IStatus[] children = status.getChildren();
        IStatus[] recodedChildren = new IStatus[children.length];
        int i = 0;
        while (i < children.length) {
            IStatus childRecoded;
            IStatus child = children[i];
            recodedChildren[i] = childRecoded = MultiStatusUtil.doRecodeStatus(child, recoder);
            ++i;
        }
        IStatus recoded = MultiStatusUtil.doSingleRecode(status, recodedChildren, recoder);
        return recoded;
    }

    public static IStatus recodeStatus(IStatus status, IStatusRecoder recoder) {
        if (!MultiStatusUtil.needsRecoding(status, recoder)) {
            return status;
        }
        return MultiStatusUtil.doRecodeStatus(status, recoder);
    }

    public static IStatus recodeLevel(IStatus status, final int severityMask, final int newSeverity) {
        return MultiStatusUtil.recodeStatus(status, new IStatusRecoder(){

            @Override
            public boolean needsRecoding(IStatus s) {
                return !s.isMultiStatus() && s.matches(severityMask);
            }

            @Override
            public IStatus recode(IStatus s) {
                return new Status(newSeverity, s.getPlugin(), s.getCode(), s.getMessage(), s.getException());
            }

            @Override
            public IStatus recode(IStatus multiStatus, IStatus[] children) {
                throw new AssertionError((Object)"should never be called");
            }
        });
    }

    public static CicMultiStatus convertToOKifNoChildren(CicMultiStatus status) {
        return status.hasChildren() ? status : Statuses.OK.getMultiStatus();
    }

    public static boolean severityNotSame(IStatus status, int newSeverity) {
        return newSeverity == 0 && !status.isOK() || newSeverity != 0 && !status.matches(newSeverity);
    }

    public static IStatus recodeLevel(IStatus status, final int newSeverity) {
        return MultiStatusUtil.recodeStatus(status, new IStatusRecoder(){

            @Override
            public boolean needsRecoding(IStatus s) {
                return !s.isMultiStatus() && MultiStatusUtil.severityNotSame(s, newSeverity);
            }

            @Override
            public IStatus recode(IStatus s) {
                return new Status(newSeverity, s.getPlugin(), s.getCode(), s.getMessage(), s.getException());
            }

            @Override
            public IStatus recode(IStatus multiStatus, IStatus[] children) {
                throw new AssertionError((Object)"should never be called");
            }
        });
    }

    public static CicMultiStatus fixErrorMessage(CicMultiStatus status, String newMsg, Object ... newMsgArgs) {
        if (!status.getMessage().isEmpty()) {
            return status;
        }
        if (status.isCancel()) {
            return Statuses.ST.createMultiStatusFromStatus(status, ICicStatus.CANCEL_STATUS.getMessage(), new Object[0]);
        }
        if (status.isError()) {
            return Statuses.ST.createMultiStatusFromStatus(status, newMsg, newMsgArgs);
        }
        return status;
    }

    public static interface IStatusEqual {
        public boolean isEqualStatus(IStatus var1, IStatus var2);
    }

    public static interface IStatusFilter {
        public boolean include(IStatus var1);

        public boolean considerChildren();
    }

    public static interface IStatusRecoder {
        public boolean needsRecoding(IStatus var1);

        public IStatus recode(IStatus var1);

        public IStatus recode(IStatus var1, IStatus[] var2);
    }

    private static class StatusEqualWrapper {
        private final IStatus status;

        StatusEqualWrapper(IStatus status) {
            this.status = status;
        }

        public int hashCode() {
            int h = this.status.getCode();
            h = h * 17 + this.status.getSeverity();
            h = h * 17 + (this.status.getException() != null ? this.status.getException().hashCode() : 0);
            h = h * 17 + (this.status.getMessage() != null ? this.status.getMessage().hashCode() : 0);
            h = h * 17 + (this.status.getPlugin() != null ? this.status.getPlugin().hashCode() : 0);
            return h;
        }

        public boolean equals(Object o) {
            if (o instanceof StatusEqualWrapper) {
                StatusEqualWrapper b = (StatusEqualWrapper)o;
                return MultiStatusUtil.isDeepEqualStatus(StatusEqualAll, this.status, b.status);
            }
            return false;
        }

        public String toString() {
            return this.status.toString();
        }
    }

    public static abstract class StatusFilter
    implements IStatusFilter {
        private final boolean considerChildren;

        public StatusFilter(boolean considerChildren) {
            this.considerChildren = considerChildren;
        }

        @Override
        public boolean considerChildren() {
            return this.considerChildren;
        }
    }

    private static class StatusFilterByCodePlugin
    extends StatusFilter {
        private final Status desiredStatus;

        StatusFilterByCodePlugin(String plugin, int code) {
            super(true);
            this.desiredStatus = new Status(0, plugin, code, "", null);
        }

        @Override
        public boolean include(IStatus status) {
            return this.desiredStatus.getCode() == status.getCode() && MultiStatusUtil.isEqualString(this.desiredStatus.getPlugin(), status.getPlugin());
        }
    }

    private static class StatusFilterByCodeSeverityPlugin
    extends StatusFilter {
        private final IStatus desiredStatus;

        StatusFilterByCodeSeverityPlugin(int severity, String plugin, int code) {
            super(true);
            this.desiredStatus = new Status(severity, plugin, code, "", null);
        }

        @Override
        public boolean include(IStatus status) {
            return StatusEqualByCodeSeverityPlugin.isEqualStatus(this.desiredStatus, status);
        }
    }

    private static class StatusFilterBySeverityMask
    extends StatusFilter {
        private final int severityMask;

        StatusFilterBySeverityMask(int severityMask) {
            super(true);
            this.severityMask = severityMask;
        }

        @Override
        public boolean include(IStatus status) {
            return status.matches(this.severityMask);
        }
    }
}

