/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.utils;

import com.ibm.cic.common.core.utils.MapCollection;
import com.ibm.cic.common.core.utils.UnsupportedOperationException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class MapList<K, V>
extends MapCollection<K, V, List<V>> {
    public static final MapList EMPTY = new MapList(Collections.EMPTY_MAP){

        @Override
        protected List createCollection() {
            throw new UnsupportedOperationException();
        }
    };

    public static <K, V> MapList<K, V> empty() {
        return EMPTY;
    }

    public static <K, V> MapList<K, V> newMapList() {
        return new MapList<K, V>();
    }

    public static <K, V> MapList<K, V> newMapList(int initialCapacity) {
        return new MapHashCapacityList(initialCapacity);
    }

    public MapList() {
        this(new LinkedHashMap());
    }

    public MapList(Map<K, List<V>> map) {
        super(map);
        if (!map.isEmpty()) {
            throw new IllegalArgumentException("map must be empty");
        }
    }

    @Override
    protected List<V> createCollection() {
        return new ArrayList();
    }

    @Override
    protected List<V> createCollection(V value) {
        return Collections.singletonList(value);
    }

    @Override
    protected List<V> createCollection(Collection<? extends V> values) {
        return new ArrayList<V>(values);
    }

    @Override
    protected List<V> createCollection(V value, Collection<? extends V> values) {
        ArrayList<V> result = new ArrayList<V>(values.size() + 1);
        result.add(value);
        result.addAll(values);
        return result;
    }

    public List<V> get(K key) {
        List list = (List)this.getCollection(key);
        return list == null ? Collections.emptyList() : Collections.unmodifiableList(list);
    }

    @Override
    public Iterator<List<V>> valuesIterator() {
        return new ListValuesIterator(this);
    }

    public List<V> remove(K key) {
        List list = (List)this.removeCollection(key);
        return list == null ? Collections.emptyList() : list;
    }

    public MapList<K, V> unmodifiableView() {
        return new UnmodifiableMapList(this);
    }

    private static class ListValuesIterator<V>
    extends MapCollection.ValuesIterator<V, List<V>> {
        ListValuesIterator(MapCollection<?, V, List<V>> x) {
            super(x);
        }

        @Override
        public List<V> next() {
            return Collections.unmodifiableList((List)this.iter.next());
        }
    }

    public static class MapHashCapacityList<K, V>
    extends MapList<K, V> {
        private final int initialCapacity;

        public MapHashCapacityList(int initialCapacity) {
            this(new LinkedHashMap(), initialCapacity);
        }

        public MapHashCapacityList(Map<K, List<V>> map, int initialCapacity) {
            super(map);
            this.initialCapacity = initialCapacity;
        }

        @Override
        protected List<V> createCollection() {
            return new ArrayList(this.initialCapacity);
        }
    }

    private static class UnmodifiableMapList<K, V>
    extends MapList<K, V> {
        public UnmodifiableMapList(MapList<K, V> mapList) {
            super(Collections.unmodifiableMap(mapList.map));
        }

        @Override
        protected List<V> createCollection() {
            throw new UnsupportedOperationException();
        }
    }
}

