/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.utils;

import com.ibm.cic.common.core.utils.UnsupportedOperationException;
import com.ibm.cic.common.core.utils.Util;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public abstract class MapCollection<K, V, C extends Collection<V>> {
    protected final Map<K, C> map;

    protected MapCollection(Map<K, C> map) {
        this.map = map;
    }

    protected abstract C createCollection();

    protected C createCollection(V value) {
        C result = this.createCollection();
        result.add(value);
        return result;
    }

    protected C createCollection(V value1, V value2) {
        C result = this.createCollection();
        result.add(value1);
        result.add(value2);
        return result;
    }

    protected C createCollection(Collection<? extends V> values) {
        C result = this.createCollection();
        result.addAll(values);
        return result;
    }

    protected C createCollection(V value, Collection<? extends V> values) {
        C result = this.createCollection();
        result.add(value);
        result.addAll(values);
        return result;
    }

    public String toString() {
        return Util.toString(this.map, new Util.MapFormatter(){

            @Override
            protected String emptyString() {
                return "(empty)";
            }

            @Override
            protected String formatValue(Object value) {
                return Util.toString((Collection)value, new Util.Formatter(", "));
            }
        });
    }

    public final boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof MapCollection)) {
            return false;
        }
        MapCollection that = (MapCollection)obj;
        if (this.size() != that.size()) {
            return false;
        }
        Set<K> keys = this.keySet();
        if (!keys.equals(that.keySet())) {
            return false;
        }
        for (K key : keys) {
            if (this.getCollection(key).equals(that.getCollection(key))) continue;
            return false;
        }
        return true;
    }

    public final int hashCode() {
        int h = 0;
        for (K key : this.keySet()) {
            h ^= key.hashCode();
            h ^= this.getCollection(key).hashCode();
        }
        return h;
    }

    public String getStats() {
        if (this.isEmpty()) {
            return "empty";
        }
        int min = Integer.MAX_VALUE;
        int max = 0;
        long total = 0L;
        for (Collection col : this.map.values()) {
            int size = col.size();
            total += (long)size;
            if (size < min) {
                min = size;
            }
            if (size <= max) continue;
            max = size;
        }
        int avg = (int)(total / (long)this.map.size());
        return String.valueOf(this.map.size()) + " collections; avg size: " + avg + ", min: " + min + ", max: " + max;
    }

    public int size() {
        return this.map.size();
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public Map<K, C> toMap() {
        return Collections.unmodifiableMap(this.map);
    }

    protected C getCollection(K key) {
        return (C)((Collection)this.map.get(key));
    }

    public boolean contains(K key) {
        return this.map.containsKey(key);
    }

    public boolean contains(K key, V value) {
        C collection = this.getCollection(key);
        return collection != null && collection.contains(value);
    }

    public Set<K> keySet() {
        return Collections.unmodifiableSet(this.map.keySet());
    }

    public Set<Map.Entry<K, C>> entrySet() {
        return Collections.unmodifiableSet(this.map.entrySet());
    }

    public abstract Iterator<C> valuesIterator();

    public Iterable<C> valuesIterable() {
        return new Iterable<C>(){

            @Override
            public Iterator<C> iterator() {
                return MapCollection.this.valuesIterator();
            }
        };
    }

    public void clear() {
        this.map.clear();
    }

    public boolean add(K key, V value) {
        Collection collection = (Collection)this.map.get(key);
        if (collection == null) {
            this.map.put(key, this.createCollection(value));
            return true;
        }
        if (collection.size() == 1) {
            Object elem = collection.iterator().next();
            if (elem.equals(value)) {
                return false;
            }
            this.map.put(key, this.createCollection(elem, value));
            return true;
        }
        return collection.add(value);
    }

    public boolean addAll(K key, Collection<? extends V> values) {
        if (values.isEmpty()) {
            return false;
        }
        if (values.size() == 1) {
            return this.add(key, values.iterator().next());
        }
        Collection collection = (Collection)this.map.get(key);
        if (collection == null) {
            this.map.put(key, this.createCollection(values));
            return true;
        }
        if (collection.size() == 1) {
            this.map.put(key, this.createCollection(collection.iterator().next(), values));
            return true;
        }
        return collection.addAll(values);
    }

    public boolean addAll(MapCollection<K, V, C> other) {
        boolean result = false;
        for (Map.Entry<K, C> entry : other.entrySet()) {
            result |= this.addAll(entry.getKey(), (Collection)entry.getValue());
        }
        return result;
    }

    protected C removeCollection(K key) {
        return (C)((Collection)this.map.remove(key));
    }

    public boolean remove(K key, V value) {
        Collection collection = (Collection)this.map.get(key);
        if (collection == null || !collection.remove(value)) {
            return false;
        }
        if (collection.isEmpty()) {
            this.map.remove(key);
        }
        return true;
    }

    protected static abstract class UnmodifiableMapCollection<K, V, C extends Collection<V>>
    extends MapCollection<K, V, C> {
        UnmodifiableMapCollection(MapCollection<K, V, C> c) {
            super(Collections.unmodifiableMap(c.map));
        }
    }

    protected static abstract class ValuesIterator<V, C extends Collection<V>>
    implements Iterator<C> {
        protected final Iterator<C> iter;

        ValuesIterator(MapCollection<?, V, C> x) {
            this.iter = x.map.values().iterator();
        }

        @Override
        public boolean hasNext() {
            return this.iter.hasNext();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

