/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.utils;

import java.io.PrintWriter;

public class IndentWriter {
    private static final String INDENT_STR = "  ";
    private int level = -1;
    private final PrintWriter pw;
    private int lastIndentCall = -1;

    public IndentWriter(PrintWriter pw) {
        this.pw = pw;
    }

    public void enter() {
        ++this.level;
    }

    public void leave() {
        --this.level;
    }

    public void indent() {
        int i = this.level;
        while (i > 0) {
            this.pw.print(INDENT_STR);
            --i;
        }
        this.lastIndentCall = -2;
    }

    public PrintWriter getPrintWriter() {
        if (this.lastIndentCall != this.level) {
            this.pw.println();
            this.indent();
        }
        return this.pw;
    }
}

