/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.utils;

import com.ibm.cic.common.core.internal.ComIbmCicCommonCorePlugin;
import com.ibm.cic.common.core.utils.DeviceSystem;
import com.ibm.cic.common.core.utils.FileUtil;
import com.ibm.cic.common.core.utils.Messages;
import com.ibm.cic.common.core.utils.Statuses;
import com.ibm.cic.common.downloads.FormatUtil;
import com.ibm.cic.common.logging.Logger;
import java.io.File;
import java.io.IOException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;

public class DeviceSystemUtil {
    private static final Logger log = Logger.getLogger(DeviceSystemUtil.class, (Plugin)ComIbmCicCommonCorePlugin.getDefault());
    public static final int LOW_DISK_SPACE_THRESHOLD_FOR_UNKNOWN_REQUIRED = 102400;
    public static final int LOW_DISK_SPACE_THRESHOLD_FOR_KNOWN_REQUIRED = 32768;

    public static IStatus getDiskSpaceStatus(IOException e, File file, long requiredSpace, int lowSpaceSeverity) {
        File mountPoint = DeviceSystem.getMountPoint(file);
        File spaceAt = mountPoint != null ? mountPoint : file;
        long freeSpace = DeviceSystem.getFreeSpace(spaceAt);
        IStatus statusDiskSpace = Status.OK_STATUS;
        if (freeSpace != -1L) {
            if (requiredSpace == -1L) {
                if (lowSpaceSeverity != 0 && freeSpace < 102400L) {
                    statusDiskSpace = lowSpaceSeverity == 4 ? Statuses.ERROR.get(6255, e, Messages.DeviceSystemUtil_lowDiskSpaceOnError, spaceAt, FormatUtil.formatBytes(freeSpace)) : (lowSpaceSeverity == 2 ? Statuses.WARNING.get(6255, e, Messages.DeviceSystemUtil_lowDiskSpaceOnWarning, spaceAt, FormatUtil.formatBytes(freeSpace)) : Statuses.INFO.get(6255, e, Messages.DeviceSystemUtil_lowDiskSpaceOnInfo, spaceAt, FormatUtil.formatBytes(freeSpace)));
                }
            } else if ((requiredSpace = FileUtil.getSizeOnDisk4kBlocks(requiredSpace)) >= freeSpace) {
                statusDiskSpace = Statuses.ERROR.get(6254, e, Messages.DeviceSystemUtil_insufficientDiskSpaceOn, spaceAt, FormatUtil.formatBytes(freeSpace), FormatUtil.formatBytes(requiredSpace));
            } else if (lowSpaceSeverity != 0 && requiredSpace + 32768L > freeSpace) {
                statusDiskSpace = lowSpaceSeverity == 4 ? Statuses.ERROR.get(6255, e, Messages.DeviceSystemUtil_lowDiskSpaceBeyondRequestedError, spaceAt, FormatUtil.formatBytes(freeSpace - requiredSpace), FormatUtil.formatBytes(requiredSpace)) : (lowSpaceSeverity == 2 ? Statuses.WARNING.get(6255, e, Messages.DeviceSystemUtil_lowDiskSpaceBeyondRequestedWarning, spaceAt, FormatUtil.formatBytes(freeSpace - requiredSpace), FormatUtil.formatBytes(requiredSpace)) : Statuses.INFO.get(6255, e, Messages.DeviceSystemUtil_lowDiskSpaceBeyondRequestedInfo, spaceAt, FormatUtil.formatBytes(freeSpace - requiredSpace), FormatUtil.formatBytes(requiredSpace)));
            }
        }
        return statusDiskSpace;
    }

    public static long getOverrideDiskSpace() {
        long diskSpace = -1L;
        String propValue = System.getProperty("cic.override.disk.space");
        if (propValue != null && propValue.length() > 0) {
            if (propValue.equalsIgnoreCase("true")) {
                diskSpace = Long.MAX_VALUE;
            } else {
                String lastChar = propValue.substring(propValue.length() - 1);
                try {
                    diskSpace = lastChar.equalsIgnoreCase("g") ? Long.parseLong(propValue.substring(0, propValue.length() - 1)) * 0x40000000L : (lastChar.equalsIgnoreCase("m") ? Long.parseLong(propValue.substring(0, propValue.length() - 1)) * 0x100000L : (lastChar.equalsIgnoreCase("k") ? Long.parseLong(propValue.substring(0, propValue.length() - 1)) * 1024L : Long.parseLong(propValue)));
                    if (diskSpace < 0L) {
                        log.warning(Messages.Invalid_Override_Disk_Space, "cic.override.disk.space", propValue);
                        diskSpace = -1L;
                    }
                }
                catch (NumberFormatException e) {
                    log.warning(Messages.Invalid_Override_Disk_Space, "cic.override.disk.space", propValue);
                }
            }
        }
        return diskSpace;
    }
}

