/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.repository.nls;

import com.ibm.cic.common.core.repository.ICicLocation;
import com.ibm.cic.common.core.repository.IZipFileHandler;
import com.ibm.cic.common.core.repository.nls.ContentResourceManager;
import com.ibm.cic.common.logging.Logger;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import org.eclipse.core.runtime.Platform;

public class ContentArcResourceManager
extends ContentResourceManager {
    public ContentArcResourceManager(IZipFileHandler a_arcHandler, ICicLocation subLoc) {
        super(subLoc.toString(), new RepositoryArcClassLoader(a_arcHandler));
    }

    private static class RepositoryArcClassLoader
    extends URLClassLoader {
        IZipFileHandler m_arcHandler;

        public RepositoryArcClassLoader(IZipFileHandler a_arcHandler) {
            super(new URL[0], (ClassLoader)null);
            this.m_arcHandler = a_arcHandler;
        }

        @Override
        public InputStream getResourceAsStream(String name) {
            try {
                String path = ContentArcResourceManager.resourceNameToLocation(name);
                if (this.m_arcHandler.containsFile(path)) {
                    return this.m_arcHandler.getInputStream(path);
                }
            }
            catch (IOException e) {
                Logger.getLogger(ContentArcResourceManager.class).error(e);
            }
            return null;
        }

        @Override
        public URL getResource(String name) {
            String nlLocation = ContentArcResourceManager.resourceNameToLocation(name);
            File file = this.m_arcHandler.getFile();
            try {
                URL urlZip = file.toURI().toURL();
                URL urlEntry = new URL("jar:" + urlZip + "!/" + nlLocation);
                if ("win32".equals(Platform.getOS())) {
                    urlEntry.openConnection().setDefaultUseCaches(false);
                }
                return urlEntry;
            }
            catch (IOException e) {
                Logger.getLogger(ContentArcResourceManager.class).error(e);
                return null;
            }
        }
    }
}

