/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.repository.digest;

import com.ibm.cic.common.core.model.IIdentity;
import com.ibm.cic.common.core.model.IOfferingOrFix;
import com.ibm.cic.common.core.model.Information;
import com.ibm.cic.common.core.repository.ICicLocation;
import com.ibm.cic.common.core.repository.IContentRepository;
import com.ibm.cic.common.core.repository.digest.PlatformSlice;
import com.ibm.cic.common.core.repository.digest.RepositoryDigestDictionary;
import com.ibm.cic.common.core.repository.digest.RepositoryDigestRepositoryData;
import com.ibm.cic.common.core.repository.digest.RepositoryDigestToc;
import com.ibm.cic.common.core.repository.digest.RepositoryDigestTocEntry;
import com.ibm.cic.common.core.repository.nls.NLSUtils;
import com.ibm.cic.common.core.utils.FileUtil;
import com.ibm.cic.common.core.utils.LinkedProperties;
import com.ibm.cic.common.core.utils.NLS;
import com.ibm.cic.common.core.utils.XMLWriter;
import com.ibm.cic.common.downloads.IContentInfo;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.eclipse.core.runtime.IStatus;
import org.osgi.framework.Version;

public abstract class RepositoryDigestOfferingOrFixData {
    private static final List<String> LANG_LIST = new ArrayList<String>(NLSUtils.calculateBundleNames("default"));
    private final IIdentity m_identity;
    private final Version m_version;
    private Information m_information;
    private final Map<String, RepositoryDigestDictionary> m_dictionaries = new LinkedHashMap<String, RepositoryDigestDictionary>();
    private final LinkedProperties m_untranslatedProperties = new LinkedProperties();
    private LinkedProperties m_translatedProperties = null;
    private final RepositoryDigestToc m_tableOfContents = new RepositoryDigestToc();
    private RepositoryDigestRepositoryData m_parent = null;
    private PlatformSlice m_platformSlice = PlatformSlice.NULL;
    private String m_unavailable = null;

    RepositoryDigestOfferingOrFixData(IIdentity id, Version version) {
        this.m_identity = id;
        this.m_version = version;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        RepositoryDigestOfferingOrFixData that = (RepositoryDigestOfferingOrFixData)obj;
        return this.m_identity.equals(that.m_identity) && this.m_version.equals((Object)that.m_version);
    }

    public int hashCode() {
        return this.m_identity.hashCode() ^ this.m_version.hashCode();
    }

    void emitCommonXML(XMLWriter writer) {
        if (this.m_information != null) {
            writer.start("information");
            writer.attribute("name", this.m_information.getNameKey());
            writer.attribute("version", this.m_information.getVersionKey());
            String description = this.m_information.getDescriptionKey();
            if (description != null) {
                writer.cdataLines(description, true);
            }
            writer.end("information");
        }
        this.writeUntranslatedProperties(writer);
        for (RepositoryDigestDictionary dict : this.m_dictionaries.values()) {
            dict.emitXML(writer);
        }
        for (RepositoryDigestTocEntry entry : this.getToc().getEntries()) {
            entry.emitXML(writer);
        }
    }

    void writeUntranslatedProperties(XMLWriter writer) {
        writer.write(this.m_untranslatedProperties);
    }

    public String getName() {
        String name;
        if (this.m_information != null && (name = this.m_information.getName()) != null && name.length() != 0) {
            return name;
        }
        return this.m_identity.getId();
    }

    public Information getInformation() {
        return this.m_information;
    }

    public Version getVersion() {
        return this.m_version;
    }

    public IIdentity getIdentity() {
        return this.m_identity;
    }

    void setInformation(String name, String version) {
        this.m_information = new Information(name);
        this.m_information.setVersion(version);
    }

    void setInformation(Information information) {
        this.m_information = information;
    }

    public void addToSiteProperties(LinkedProperties siteProperties) {
        String key = PlatformSlice.getPropertyKey(this.m_identity, this.m_version);
        String value = this.m_platformSlice.toPropertyValue();
        if (value.length() == 0) {
            siteProperties.remove(key);
        } else {
            siteProperties.setProperty(key, value);
        }
    }

    public void removeFromSiteProperties(LinkedProperties siteProperties) {
        String key = PlatformSlice.getPropertyKey(this.m_identity, this.m_version);
        siteProperties.remove(key);
    }

    public boolean isPlatformSlice() {
        return this.m_platformSlice != PlatformSlice.NULL;
    }

    public void setPlatformSlice(LinkedProperties siteProperties) {
        String key = PlatformSlice.getPropertyKey(this.m_identity, this.m_version);
        this.m_platformSlice = siteProperties.containsKey(key) ? new PlatformSlice(siteProperties.getProperty(key)) : PlatformSlice.NULL;
    }

    public void setPlatformSlice(String os, String arch) {
        this.m_platformSlice = new PlatformSlice(os, arch);
    }

    public void clearPlatformSlices() {
        this.m_platformSlice = PlatformSlice.NULL;
    }

    public void addPlatformSlices(RepositoryDigestOfferingOrFixData other) {
        this.m_platformSlice = this.m_platformSlice.add(other.m_platformSlice);
    }

    public IStatus checkPlatformSlice(String os, String arch) {
        return this.m_platformSlice.checkPlatform(os, arch);
    }

    public List<String> getListOfPlatformSlices() {
        return this.m_platformSlice.getPlatformSliceDisplayNames();
    }

    public String getUnavailableReason() {
        return this.m_unavailable;
    }

    public void setUnavailableReason(LinkedProperties siteProperties) {
        this.m_unavailable = this.getPropertyIgnoreCase("Unavailable", siteProperties);
    }

    private String getPropertyIgnoreCase(String property, LinkedProperties properties) {
        Set entrySet = properties.entrySet();
        for (Map.Entry entry : entrySet) {
            if (!((String)entry.getKey()).equalsIgnoreCase(property)) continue;
            return ((String)entry.getValue()).trim();
        }
        return null;
    }

    private String getUnavailableToString() {
        if (this.m_unavailable != null) {
            return "Unavailable: " + this.getUnavailableReason();
        }
        return "Available";
    }

    void performNlUpdate() {
        if (this.m_information != null) {
            this.m_information.setName(this.resolveNL(this.m_information.getName()));
            this.m_information.setDescription(this.resolveNL(this.m_information.getDescription()));
        }
    }

    private String resolveNL(String val) {
        if (NLSUtils.isNLKey(val)) {
            for (String lang : LANG_LIST) {
                RepositoryDigestDictionary dict;
                String val1;
                if (!this.m_dictionaries.containsKey(lang) || (val1 = (dict = this.m_dictionaries.get(lang)).getProperty(val.substring(1))) == null) continue;
                return val1;
            }
        }
        return val;
    }

    void addDictionary(RepositoryDigestDictionary a_dict) {
        this.m_dictionaries.put(a_dict.getLang(), a_dict);
    }

    public String toString() {
        String parentString = this.getParent() == null ? "No Parent" : this.getParent().toSimpleString();
        return NLS.bind("{0}_{1}: {2} dictionaries\n  Info: {3}\n  Properties: {4}\n  {5}\n  {6} \n Parent: {7}", this.m_identity, this.m_version, this.m_dictionaries.size(), this.m_information, this.m_untranslatedProperties, this.getUnavailableToString(), this.m_platformSlice, parentString);
    }

    public LinkedProperties getTranslatedProperties() {
        if (this.m_translatedProperties == null) {
            this.m_translatedProperties = new LinkedProperties();
            for (String key : this.m_untranslatedProperties.getPropertyKeysCollection()) {
                this.m_translatedProperties.setProperty(key, this.resolveNL(this.m_untranslatedProperties.getProperty(key)));
            }
        }
        return this.m_translatedProperties;
    }

    void addUntranslatedProperty(String key, Object value) {
        this.m_untranslatedProperties.put(key, value);
    }

    public RepositoryDigestToc getToc() {
        return this.m_tableOfContents;
    }

    void addTocEntryList(ICicLocation fileLocation, IContentRepository subRepository) {
        IContentInfo contentInfo = subRepository.getElementContentInfo();
        HashMap secondary = subRepository.getSecondaryContentInfoMap();
        ICicLocation path = fileLocation.removeLastSegment();
        this.m_tableOfContents.addEntry(new RepositoryDigestTocEntry(fileLocation, null, contentInfo));
        for (Map.Entry entry : secondary.entrySet()) {
            this.m_tableOfContents.addEntry(new RepositoryDigestTocEntry(path.append((String)entry.getKey()), null, (IContentInfo)entry.getValue()));
        }
    }

    public ICicLocation getLocation() {
        return this.m_tableOfContents.getFirstEntryFileName();
    }

    void setParent(RepositoryDigestRepositoryData rep) {
        this.m_parent = rep;
    }

    RepositoryDigestRepositoryData getParent() {
        return this.m_parent;
    }

    Collection addUntranslatedProperties(IOfferingOrFix a_ofOrFix, String[] keys) {
        ArrayList return_value = new ArrayList();
        String[] stringArray = keys;
        int n = keys.length;
        int n2 = 0;
        while (n2 < n) {
            String key = stringArray[n2];
            String val = (String)a_ofOrFix.getPropertyKeys().get(key);
            if (val != null) {
                NLSUtils.addKeyToCollectionIfNlKey(val, return_value);
            } else {
                val = (String)a_ofOrFix.getProperties().get(key);
            }
            if (val == null) {
                val = "";
            }
            this.addUntranslatedProperty(key, val);
            ++n2;
        }
        return return_value;
    }

    void addRepositoryDigestDictionaryList(ArrayList translatable, IContentRepository contRep) {
        if (translatable != null && !translatable.isEmpty() && contRep != null) {
            String[] fileList;
            String[] stringArray = fileList = contRep.getNLSFileList();
            int n = fileList.length;
            int n2 = 0;
            while (n2 < n) {
                String element = stringArray[n2];
                Properties prop = new Properties();
                try {
                    String lang;
                    InputStream is = contRep.openNLSFileStream(element);
                    try {
                        prop.load(is);
                    }
                    finally {
                        FileUtil.close(is);
                    }
                    int b = element.indexOf(95);
                    if (b == -1) {
                        lang = "default";
                    } else {
                        int e = element.lastIndexOf(46);
                        lang = element.substring(b + 1, e);
                    }
                    RepositoryDigestDictionary dict = new RepositoryDigestDictionary(lang);
                    for (String name : translatable) {
                        String val = prop.getProperty(name);
                        if (val == null) continue;
                        dict.addProperty(name, val);
                    }
                    if (!dict.isEmpty()) {
                        this.addDictionary(dict);
                    }
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
                ++n2;
            }
        }
    }
}

