/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.repository.digest;

import com.ibm.cic.common.core.model.IFixApplicableOffering;
import com.ibm.cic.common.core.model.IIdentity;
import com.ibm.cic.common.core.model.IOfferingOrFix;
import com.ibm.cic.common.core.model.Information;
import com.ibm.cic.common.core.model.SimpleIdentity;
import com.ibm.cic.common.core.model.internal.FixApplicableOffering;
import com.ibm.cic.common.core.repository.ICicLocation;
import com.ibm.cic.common.core.repository.IContentRepository;
import com.ibm.cic.common.core.repository.digest.RepositoryDigestDictionary;
import com.ibm.cic.common.core.repository.digest.RepositoryDigestOfferingOrFixData;
import com.ibm.cic.common.core.repository.digest.RepositoryDigestRepositoryData;
import com.ibm.cic.common.core.utils.XMLWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.osgi.service.resolver.VersionRange;
import org.osgi.framework.Version;

public class RepositoryDigestFixData
extends RepositoryDigestOfferingOrFixData {
    public static final RepositoryDigestFixData NULL = new NullRepositoryDigestFixData();
    private static final String APPLICABLE_OFFERING = "applicable.offerings";
    private static final SimpleIdentity ENHANCED_DUMMY_ID = new SimpleIdentity("EnhancedFix");
    private static final Version ENHANCED_DUMMY_VERSION = new Version("0.0.0.EnhancedFix");
    private final IIdentity m_offeringIdentity;
    private final Version m_offeringVersion;
    private final List<IFixApplicableOffering> m_applicableOfferings = new ArrayList<IFixApplicableOffering>();

    RepositoryDigestFixData(IIdentity id, Version version, IIdentity offeringId, Version offeringVersion) {
        super(id, version);
        this.m_offeringIdentity = offeringId;
        this.m_offeringVersion = offeringVersion;
    }

    RepositoryDigestFixData(String id, String version, String offeringId, String offeringVersion) {
        this(new SimpleIdentity(id), new Version(version), new SimpleIdentity(offeringId), new Version(offeringVersion));
    }

    RepositoryDigestFixData(IIdentity id, Version version, List applicableOfferings) {
        this(id, version, ENHANCED_DUMMY_ID, ENHANCED_DUMMY_VERSION);
        if (applicableOfferings != null && !applicableOfferings.isEmpty()) {
            this.m_applicableOfferings.addAll(applicableOfferings);
        }
    }

    public IIdentity getOfferingId() {
        return this.isEnhancedFix() ? null : this.m_offeringIdentity;
    }

    public Version getOfferingVersion() {
        return this.isEnhancedFix() ? null : this.m_offeringVersion;
    }

    @Override
    void addUntranslatedProperty(String key, Object value) {
        if (key.equals(APPLICABLE_OFFERING)) {
            this.addFixApplicableOffering(value.toString());
        } else {
            super.addUntranslatedProperty(key, value);
        }
    }

    private void addFixApplicableOffering(String applicableOfferingValue) {
        String[] applicableOfferings;
        String[] stringArray = applicableOfferings = applicableOfferingValue.split(";");
        int n = applicableOfferings.length;
        int n2 = 0;
        while (n2 < n) {
            String applicableOffering = stringArray[n2];
            String[] appOffering = applicableOffering.split(" ");
            this.m_applicableOfferings.add(new FixApplicableOffering(new SimpleIdentity(appOffering[0]), new VersionRange(appOffering[1])));
            ++n2;
        }
    }

    void emitXML(XMLWriter writer) {
        writer.start("fix");
        writer.attribute("id", this.getIdentity());
        writer.attribute("version", this.getVersion());
        writer.attribute("offeringId", this.m_offeringIdentity);
        writer.attribute("offeringVersion", this.m_offeringVersion);
        this.emitCommonXML(writer);
        writer.end("fix");
    }

    @Override
    void writeUntranslatedProperties(XMLWriter writer) {
        if (!this.m_applicableOfferings.isEmpty()) {
            StringBuilder appOfferingsValue = new StringBuilder();
            String delimiter = "";
            for (IFixApplicableOffering fao : this.m_applicableOfferings) {
                appOfferingsValue.append(delimiter);
                appOfferingsValue.append(fao.getIdentity() + " " + fao.getTolerance());
                delimiter = ";";
            }
            writer.writeProperty(APPLICABLE_OFFERING, appOfferingsValue.toString());
        }
        super.writeUntranslatedProperties(writer);
    }

    public boolean isEnhancedFix() {
        return this.m_offeringIdentity.equals(ENHANCED_DUMMY_ID);
    }

    public List<IFixApplicableOffering> getApplicableOfferings() {
        return Collections.unmodifiableList(this.m_applicableOfferings);
    }

    private static class NullRepositoryDigestFixData
    extends RepositoryDigestFixData {
        NullRepositoryDigestFixData() {
            super(null, null, Collections.EMPTY_LIST);
        }

        @Override
        public String toString() {
            return "No fix data";
        }

        @Override
        void emitXML(XMLWriter writer) {
        }

        @Override
        void setInformation(String name, String version) {
            throw new UnsupportedOperationException();
        }

        @Override
        void setInformation(Information information) {
            throw new UnsupportedOperationException();
        }

        @Override
        void performNlUpdate() {
            throw new UnsupportedOperationException();
        }

        @Override
        void addDictionary(RepositoryDigestDictionary a_dict) {
            throw new UnsupportedOperationException();
        }

        @Override
        void addUntranslatedProperty(String key, Object value) {
            throw new UnsupportedOperationException();
        }

        @Override
        void addTocEntryList(ICicLocation fileLocation, IContentRepository subRepository) {
            throw new UnsupportedOperationException();
        }

        @Override
        void setParent(RepositoryDigestRepositoryData rep) {
            throw new UnsupportedOperationException();
        }

        @Override
        Collection addUntranslatedProperties(IOfferingOrFix a_ofOrFix, String[] keys) {
            throw new UnsupportedOperationException();
        }

        @Override
        void addRepositoryDigestDictionaryList(ArrayList translatable, IContentRepository contRep) {
            throw new UnsupportedOperationException();
        }
    }
}

