/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.repository;

import com.ibm.cic.common.core.artifactrepo.IArtifactSession;
import com.ibm.cic.common.core.artifactrepo.impl.Messages;
import com.ibm.cic.common.core.internal.repository.TableOfContents;
import com.ibm.cic.common.core.model.adapterdata.IArtifact;
import com.ibm.cic.common.core.repository.ICicLocation;
import com.ibm.cic.common.core.repository.RemoteArtifactRepository;
import com.ibm.cic.common.core.utils.ICicStatus;
import com.ibm.cic.common.core.utils.Statuses;
import com.ibm.cic.common.downloads.ContentInfo;
import java.io.FileNotFoundException;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.osgi.util.NLS;

public abstract class ShortNameArtifactRepository
extends RemoteArtifactRepository {
    private final Map mapDirToToc = new HashMap();

    private TableOfContents.Toc getToc(IArtifactSession session, ICicLocation location, IPath relDir, IProgressMonitor monitor) throws CoreException {
        TableOfContents.Toc toc;
        Object o = this.mapDirToToc.get(relDir);
        if (o == null) {
            URL urlDir = ShortNameArtifactRepository.makeURL(location, relDir);
            try {
                toc = TableOfContents.getToc(session, urlDir, ContentInfo.EMPTY_CONTENT_INFO, monitor);
            }
            catch (FileNotFoundException e) {
                toc = new TableOfContents.Toc();
            }
            catch (Exception e) {
                String msg = NLS.bind((String)Messages.get_shortname_toc_failed, (Object)this.getRepository().getUserNames().getSystemName(), (Object)relDir.toString());
                ICicStatus status = Statuses.ERROR.get(6, e, msg, new Object[0]);
                this.mapDirToToc.put(relDir, Collections.EMPTY_MAP);
                throw new CoreException((IStatus)status);
            }
            this.mapDirToToc.put(relDir, toc);
        } else {
            toc = (TableOfContents.Toc)o;
        }
        return toc;
    }

    @Override
    protected URL getRepositoryURL(IArtifactSession session, IArtifact artifact, IProgressMonitor monitor) throws CoreException {
        ICicLocation location = this.getRepository().getLocation();
        IPath relPath = ShortNameArtifactRepository.getUpdateSiteCompatiblePath(artifact);
        IPath relDir = relPath.removeLastSegments(1);
        String simpleName = relPath.segment(relPath.segmentCount() - 1);
        TableOfContents.Toc toc = this.getToc(session, location, relDir, monitor);
        TableOfContents.TocEntry tocEntry = toc.getEntryByAlias(simpleName);
        if (tocEntry == null) {
            String msg = NLS.bind((String)Messages.get_shortname_failed, (Object)this.getRepository().getUserNames().getSystemName(), (Object)relPath.toString());
            ICicStatus status = Statuses.ERROR.get(7, msg, new Object[0]);
            throw new CoreException((IStatus)status);
        }
        IPath relShortPath = relDir.append(tocEntry.getFileName());
        URL artifactUrl = ShortNameArtifactRepository.makeURL(location, relShortPath);
        return artifactUrl;
    }
}

