/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.repository;

import com.ibm.cic.common.core.definitions.CommonDef;
import com.ibm.cic.common.core.model.IIdentity;
import com.ibm.cic.common.core.model.IOffering;
import com.ibm.cic.common.core.model.Information;
import com.ibm.cic.common.core.model.SimpleIdentity;
import com.ibm.cic.common.core.preferences.CicPreferenceManager;
import com.ibm.cic.common.core.preferences.ICicPreferenceConstants;
import com.ibm.cic.common.core.repository.IRepository;
import com.ibm.cic.common.core.repository.IRepositoryGroup;
import com.ibm.cic.common.core.repository.IRepositoryInfo;
import com.ibm.cic.common.core.repository.RepositoryGroup;
import com.ibm.cic.common.core.repository.RepositoryUtils;
import com.ibm.cic.common.core.utils.CicMultiStatus;
import com.ibm.cic.common.core.utils.Statuses;
import com.ibm.icu.util.StringTokenizer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.osgi.service.resolver.VersionRange;
import org.osgi.service.prefs.Preferences;

public class ServiceRepositoryUtils
implements IEclipsePreferences.IPreferenceChangeListener {
    private static final String SEPARATOR = "~";
    private static final String ALL = "*";
    private static final String DEFAULT = "-";
    private static final String NO = "!";
    private static final String CHECK_FOR_MY_FIXES = "checkForMyFixes";
    public static ServiceRepositoryUtils INSTANCE = new ServiceRepositoryUtils();
    private static Collection m_srMapData;
    private static final IOpenServiceRepo DEFAULT_OPEN_SERVICE_REPO;

    static {
        DEFAULT_OPEN_SERVICE_REPO = new DefaultOpenServiceRepo();
    }

    private static Collection getServiceRepositoryCollection() {
        if (m_srMapData == null) {
            String[] map;
            m_srMapData = new ArrayList();
            if (CicPreferenceManager.getInstance().isReady() && (map = CicPreferenceManager.getInstance().getStringArray(ICicPreferenceConstants.SERVICE_REPOSITORY_MAP.key())).length > 0) {
                String[] stringArray = map;
                int n = map.length;
                int n2 = 0;
                while (n2 < n) {
                    String verStr;
                    String idStr;
                    String element = stringArray[n2];
                    StringTokenizer st = new StringTokenizer(element, SEPARATOR);
                    SimpleIdentity id = null;
                    if (st.hasMoreTokens() && !(idStr = st.nextToken().trim()).equals(ALL)) {
                        id = new SimpleIdentity(idStr);
                    }
                    VersionRange verRange = null;
                    if (st.hasMoreTokens() && !(verStr = st.nextToken().trim()).equals(ALL)) {
                        verRange = new VersionRange(verStr);
                    }
                    String srLocation = null;
                    if (st.hasMoreTokens() && (srLocation = st.nextToken().trim()).equals(NO)) {
                        srLocation = null;
                    }
                    m_srMapData.add(new MapElement(id, verRange, srLocation));
                    ++n2;
                }
            }
        }
        return m_srMapData;
    }

    public static IStatus loadServiceRepositoriesIfPrefIsSet(boolean includeUnavailable, Map repositoryStatus, IRepositoryGroup destinationGroup, IOffering[] processedOfferings, IProgressMonitor progressMonitor) {
        if (CicPreferenceManager.getInstance().getBoolean(ICicPreferenceConstants.USE_SERVICE_REPOSITORIES.key())) {
            return ServiceRepositoryUtils.loadServiceRepositories(includeUnavailable, repositoryStatus, null, destinationGroup, processedOfferings, progressMonitor);
        }
        return Status.OK_STATUS;
    }

    public static IStatus loadServiceRepositoriesIfPrefIsSet(Map repositoryStatus, IRepositoryGroup destinationGroup, IOffering[] processedOfferings, IProgressMonitor progressMonitor) {
        return ServiceRepositoryUtils.loadServiceRepositoriesIfPrefIsSet(false, repositoryStatus, destinationGroup, processedOfferings, progressMonitor);
    }

    public static IStatus loadServiceRepositoriesIfPrefIsSet(IRepositoryGroup destinationGroup, IOffering[] processedOfferings, IProgressMonitor progressMonitor) {
        return ServiceRepositoryUtils.loadServiceRepositoriesIfPrefIsSet(null, destinationGroup, processedOfferings, progressMonitor);
    }

    public static IStatus loadServiceRepositories(Map repositoryStatus, CicMultiStatus ms, IRepositoryGroup destinationGroup, IOffering[] processedOfferings, IProgressMonitor progressMonitor) {
        return ServiceRepositoryUtils.loadServiceRepositories(false, DEFAULT_OPEN_SERVICE_REPO, repositoryStatus, ms, destinationGroup, processedOfferings, progressMonitor);
    }

    public static IStatus loadServiceRepositories(boolean includeUnavailable, Map repositoryStatus, CicMultiStatus ms, IRepositoryGroup destinationGroup, IOffering[] processedOfferings, IProgressMonitor progressMonitor) {
        return ServiceRepositoryUtils.loadServiceRepositories(includeUnavailable, DEFAULT_OPEN_SERVICE_REPO, repositoryStatus, ms, destinationGroup, processedOfferings, progressMonitor);
    }

    public static IStatus loadServiceRepositories(IOpenServiceRepo openCallback, Map repositoryStatus, CicMultiStatus ms, IRepositoryGroup destinationGroup, IOffering[] processedOfferings, IProgressMonitor progressMonitor) {
        return ServiceRepositoryUtils.loadServiceRepositories(false, openCallback, repositoryStatus, ms, destinationGroup, processedOfferings, progressMonitor);
    }

    public static IStatus loadServiceRepositories(boolean includeUnavailable, IOpenServiceRepo openCallback, Map repositoryStatus, CicMultiStatus ms, IRepositoryGroup destinationGroup, IOffering[] processedOfferings, IProgressMonitor progressMonitor) {
        if (ms == null) {
            ms = Statuses.ST.createMultiStatus();
        }
        RepositoryGroup newGroup = new RepositoryGroup("tmp");
        IOffering[] iOfferingArray = processedOfferings;
        int n = processedOfferings.length;
        int n2 = 0;
        while (n2 < n) {
            IOffering processedOffering = iOfferingArray[n2];
            String repInfoString = ServiceRepositoryUtils.retrieveServiceRepositoryInfo(processedOffering);
            if (repInfoString != null && repInfoString.length() > 0) {
                StringTokenizer st = new StringTokenizer(repInfoString, ";");
                while (st.hasMoreTokens()) {
                    CicMultiStatus substatuses;
                    IRepository rep;
                    String serializedRepInfo = st.nextToken();
                    IRepositoryInfo repInfo = destinationGroup.createRepositoryInfo(null, null, null, null, serializedRepInfo);
                    boolean b = Boolean.getBoolean(CHECK_FOR_MY_FIXES);
                    if (b) {
                        repInfo.setProperty(CHECK_FOR_MY_FIXES, "true");
                    }
                    if (repInfo == null || (rep = destinationGroup.findRepository(repInfo)) != null) continue;
                    try {
                        rep = openCallback.openServiceRepository(destinationGroup, processedOffering, repInfo);
                        if (rep != null) {
                            rep.getRepositoryInfo().setProperty("offering.service.repositories", repInfoString);
                            newGroup.addExistingRepository(rep, false);
                        }
                    }
                    catch (CoreException e) {
                        IStatus canAdd = e.getStatus();
                        ms.add((IStatus)new Status(canAdd.getSeverity(), canAdd.getPlugin(), repInfo.getLocationStr()));
                        ms.setMessage(String.valueOf(ms.getMessage()) + DEFAULT + repInfo.getLocationStr() + "\n");
                    }
                    if (repositoryStatus == null) continue;
                    ArrayList<IStatus> stat_list = new ArrayList<IStatus>();
                    if (repInfo.getRepositoryReportedStatus() != null) {
                        stat_list.add(repInfo.getRepositoryReportedStatus());
                    }
                    if ((substatuses = (CicMultiStatus)repInfo.getProperty("RepositoryReportedStatuses")) != null) {
                        IStatus[] stats;
                        IStatus[] iStatusArray = stats = substatuses.getChildren();
                        int n3 = stats.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            IStatus stat = iStatusArray[n4];
                            stat_list.add(stat);
                            ++n4;
                        }
                    }
                    if (stat_list.isEmpty()) continue;
                    repositoryStatus.put(repInfo.getLocationStr(), stat_list);
                }
            }
            ++n2;
        }
        List moreOfferings = newGroup.getAllOfferings(includeUnavailable, progressMonitor);
        newGroup.removeAllRepositories();
        if (moreOfferings.size() > 0) {
            IOffering[] ofs = moreOfferings.toArray(new IOffering[moreOfferings.size()]);
            return ServiceRepositoryUtils.loadServiceRepositories(includeUnavailable, openCallback, repositoryStatus, ms, destinationGroup, ofs, progressMonitor);
        }
        return ms;
    }

    public static IStatus unloadServiceRepositories(IRepositoryGroup targetGroup) {
        IStatus return_value = Status.OK_STATUS;
        for (IRepository rep : targetGroup) {
            if (rep.getRepositoryInfo().getProperty("offering.service.repositories") == null) continue;
            targetGroup.removeRepository(rep);
        }
        return return_value;
    }

    public static IStatus moveServiceRepositories(IRepositoryGroup targetGroup, IRepositoryGroup sourceGroup) {
        IStatus return_value = Status.OK_STATUS;
        for (IRepository rep : sourceGroup) {
            if (rep.getRepositoryInfo().getProperty("offering.service.repositories") == null) continue;
            targetGroup.addExistingRepository(rep, false);
            sourceGroup.removeRepository(rep);
        }
        return return_value;
    }

    public static boolean areServiceRepositoriesLoaded(IRepositoryGroup targetGroup) {
        for (IRepository element : targetGroup) {
            IRepository rep = element;
            if (rep.getRepositoryInfo().getProperty("offering.service.repositories") == null) continue;
            return true;
        }
        return false;
    }

    public static String retrieveServiceRepositoryInfo(IOffering offering) {
        Collection map = ServiceRepositoryUtils.getServiceRepositoryCollection();
        for (MapElement element : map) {
            if (element.id() != null && !offering.getIdentity().equals(element.id()) || element.version() != null && !element.version().isIncluded(offering.getVersion())) continue;
            String location = element.getNewServiceRepository();
            if (DEFAULT.equals(location)) break;
            return location;
        }
        String prop = offering.getProperties().getProperty("offering.service.repositories");
        if (prop == null || prop.length() == 0) {
            String version = offering.getProperties().getProperty("offering.efdVersion");
            Information information = offering.getInformation();
            if (version == null && information != null) {
                version = information.getVersion();
            }
            StringBuffer buf = new StringBuffer(CommonDef.Urls.ServiceRepositoryBaseUrl).append("/").append(offering.getIdentity().getId());
            if (version != null && version.trim().length() > 0) {
                buf.append("/").append(version);
            }
            prop = buf.toString();
        }
        return prop;
    }

    public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
        Preferences node = event.getNode();
        String key = event.getKey();
        if (key != null && node != null && key.startsWith(ICicPreferenceConstants.SERVICE_REPOSITORY_MAP.key()) && node.equals(CicPreferenceManager.getInstance().getCurrentPreferenceHandler().getPreferences())) {
            m_srMapData = null;
        }
    }

    public static class CantAddServiceRepo {
        public final IOffering offering;
        public final IRepositoryInfo serviceRepoInfo;
        public final IStatus status;

        public CantAddServiceRepo(IOffering offering, IRepositoryInfo serviceRepoInfo, IStatus status) {
            this.offering = offering;
            this.serviceRepoInfo = serviceRepoInfo;
            this.status = status;
        }
    }

    public static class DefaultOpenServiceRepo
    implements IOpenServiceRepo {
        @Override
        public IRepository openServiceRepository(IRepositoryGroup destinationGroup, IOffering offering, IRepositoryInfo repInfo) throws CoreException {
            IStatus canAdd = destinationGroup.canAddExistingRepository(repInfo, null);
            if (canAdd.isOK()) {
                return RepositoryUtils.addExistingRepository(destinationGroup, repInfo, false);
            }
            throw new CoreException(canAdd);
        }
    }

    public static interface IOpenServiceRepo {
        public IRepository openServiceRepository(IRepositoryGroup var1, IOffering var2, IRepositoryInfo var3) throws CoreException;
    }

    private static class MapElement {
        private final IIdentity m_id;
        private final VersionRange m_versionRange;
        private final String m_newServiceRepository;

        public MapElement(IIdentity id, VersionRange version, String serviceRepository) {
            this.m_id = id;
            this.m_versionRange = version;
            this.m_newServiceRepository = serviceRepository;
        }

        public IIdentity id() {
            return this.m_id;
        }

        public String toString() {
            return "<" + this.m_id + '|' + this.m_versionRange + "|" + this.m_newServiceRepository + '>';
        }

        public String getNewServiceRepository() {
            return this.m_newServiceRepository;
        }

        public VersionRange version() {
            return this.m_versionRange;
        }
    }
}

