/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.repository;

import com.ibm.cic.common.core.internal.ComIbmCicCommonCorePlugin;
import com.ibm.cic.common.core.internal.Messages;
import com.ibm.cic.common.core.internal.repository.RepositoryRef;
import com.ibm.cic.common.core.internal.utils.CicConstants;
import com.ibm.cic.common.core.model.IAssembly;
import com.ibm.cic.common.core.model.IContent;
import com.ibm.cic.common.core.model.IFeature;
import com.ibm.cic.common.core.model.IFeatureBase;
import com.ibm.cic.common.core.model.IFeatureGroup;
import com.ibm.cic.common.core.model.IFix;
import com.ibm.cic.common.core.model.IIdentity;
import com.ibm.cic.common.core.model.IOffering;
import com.ibm.cic.common.core.model.IOfferingOrFix;
import com.ibm.cic.common.core.model.IShareableUnit;
import com.ibm.cic.common.core.model.Walker;
import com.ibm.cic.common.core.model.Writer;
import com.ibm.cic.common.core.model.internal.CicResolver;
import com.ibm.cic.common.core.repository.AbstractBaseRepository;
import com.ibm.cic.common.core.repository.CicFileLocation;
import com.ibm.cic.common.core.repository.ContentElementRepository;
import com.ibm.cic.common.core.repository.ContentJar2Repository;
import com.ibm.cic.common.core.repository.ICicLocation;
import com.ibm.cic.common.core.repository.IContentRepository;
import com.ibm.cic.common.core.repository.IRepository;
import com.ibm.cic.common.core.repository.IRepositoryGroup;
import com.ibm.cic.common.core.repository.IRepositoryInfo;
import com.ibm.cic.common.core.repository.IRepositoryRef;
import com.ibm.cic.common.core.repository.MemoryRepositoryCacheHandler;
import com.ibm.cic.common.core.repository.RemoteRepository;
import com.ibm.cic.common.core.repository.RepositoryDescriptor;
import com.ibm.cic.common.core.repository.RepositoryFileBasedSiteProperties;
import com.ibm.cic.common.core.repository.RepositoryGroup;
import com.ibm.cic.common.core.repository.RepositoryStatus;
import com.ibm.cic.common.core.utils.CicMultiStatus;
import com.ibm.cic.common.core.utils.FileURLUtil;
import com.ibm.cic.common.core.utils.ICicStatus;
import com.ibm.cic.common.core.utils.NLS;
import com.ibm.cic.common.core.utils.SplitProgressMonitor;
import com.ibm.cic.common.core.utils.Statuses;
import com.ibm.cic.common.logging.Logger;
import com.ibm.icu.util.StringTokenizer;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class RepositoryUtils {
    private static final Logger log = Logger.getLogger(RemoteRepository.class);

    public static IStatus resolve(IOfferingOrFix offeringOrFix, IProgressMonitor progressMonitor) {
        return RepositoryUtils.resolve(offeringOrFix, false, progressMonitor);
    }

    public static IStatus resolve(IOfferingOrFix offeringOrFix, boolean forceResolve, IProgressMonitor progressMonitor) {
        if (!forceResolve && offeringOrFix.isResolved()) {
            return Status.OK_STATUS;
        }
        if (offeringOrFix instanceof IFix) {
            return CicResolver.resolveIUAdapterData(offeringOrFix);
        }
        IContentRepository cer = RepositoryUtils.getContentRepository(offeringOrFix);
        if (cer != null) {
            IStatus return_value = cer.resolve(offeringOrFix, progressMonitor);
            return return_value;
        }
        if (progressMonitor.isCanceled()) {
            return Status.CANCEL_STATUS;
        }
        return RepositoryStatus.ST_ERROR_CONTENT_ELEMENT_CANT_BE_RESOLVED;
    }

    public static IStatus unresolve(IOfferingOrFix offeringOrFix) {
        if (offeringOrFix instanceof IOffering) {
            IOffering offering = (IOffering)offeringOrFix;
            if (offering.getAssembly() == null) {
                return Status.OK_STATUS;
            }
            offering.setAssembly(null);
            RepositoryUtils.unresolveFeatures(offering.getFeatureGroup());
        } else if (offeringOrFix instanceof IFix) {
            IFix fix = (IFix)offeringOrFix;
            fix.setResolved(false);
        }
        return Status.OK_STATUS;
    }

    private static void unresolveFeatures(IFeatureGroup group) {
        if (group != null) {
            for (IFeatureBase child : group.getChildren()) {
                if (child instanceof IFeature) {
                    IFeature feature = (IFeature)child;
                    feature.setSelector(null);
                    continue;
                }
                if (child instanceof IFeatureGroup) {
                    RepositoryUtils.unresolveFeatures((IFeatureGroup)child);
                    continue;
                }
                assert (false) : child;
            }
        }
    }

    public static IStatus resolveRepositoryBased(IOffering offering, IProgressMonitor progressMonitor) {
        IRepository rep;
        if (offering != null && (rep = offering.getRepository()) != null) {
            IStatus return_value = rep.resolve(offering, progressMonitor);
            RepositoryUtils.performNLSRepositoryBasedUpdate(offering);
            return return_value;
        }
        return RepositoryStatus.ST_ERROR_CONTENT_ELEMENT_CANT_BE_RESOLVED;
    }

    public static IContentRepository getContentRepository(IContent content) {
        IRepository containingRepository;
        if (content != null && (containingRepository = content.getRepository()) != null) {
            if (containingRepository instanceof RepositoryRef && ((RepositoryRef)containingRepository).getReferenceCount() == 0) {
                log.error(Messages.RepositoryUtils_accessingDeadRepositoryObject, content.getName(), content.getVersion(), containingRepository);
            }
            return content.getRepository().getContentRepository(content);
        }
        return null;
    }

    public static IStatus performNLSOfferingBasedUpdate(IOffering offering) {
        final IContentRepository cer = RepositoryUtils.getContentRepository(offering);
        if (cer != null) {
            cer.performNLSupdate(offering);
            if (offering.getAssembly() != null) {
                Walker wlk = new Walker(){

                    @Override
                    public void doUnit(IContent element) throws Exception {
                        IContentRepository subRep = cer.getContentRepository(element);
                        if (subRep != null) {
                            subRep.performNLSupdate(element);
                        }
                    }

                    @Override
                    protected boolean canHaveUnresolvedIncludes() {
                        return true;
                    }
                };
                try {
                    wlk.walkIncludes(offering.getAssembly());
                }
                catch (InvocationTargetException e) {
                    e.printStackTrace();
                }
            }
        }
        return Status.OK_STATUS;
    }

    public static IStatus performNLSRepositoryBasedUpdate(IOffering offering) {
        IContentRepository cer = RepositoryUtils.getContentRepository(offering);
        if (cer != null) {
            cer.performNLSupdate(offering);
            if (offering.getAssembly() != null) {
                Walker wlk = new Walker(){

                    @Override
                    public void doUnit(IContent element) throws Exception {
                        IContentRepository subRep = RepositoryUtils.getContentRepository(element);
                        if (subRep != null) {
                            subRep.performNLSupdate(element);
                        }
                    }

                    @Override
                    protected boolean canHaveUnresolvedIncludes() {
                        return true;
                    }
                };
                try {
                    wlk.walkIncludes(offering.getAssembly());
                }
                catch (InvocationTargetException e) {
                    e.printStackTrace();
                }
            }
        }
        return Status.OK_STATUS;
    }

    public static ICicLocation getFullyQualifiedPath(IContent content) {
        if (content.getRepository() != null) {
            return content.getRepository().getLocation().append(content.getLocation());
        }
        return null;
    }

    public static String[] getShareableEntityFiles(IContent content) {
        final ArrayList files = new ArrayList();
        Walker walker = new Walker(){

            @Override
            public void doAssembly(IAssembly assembly) {
                files.add(Writer.getFileName(assembly));
            }

            @Override
            public void doShareableUnit(IShareableUnit su) {
                files.add(Writer.getFileName(su));
            }

            @Override
            protected boolean canHaveUnresolvedIncludes() {
                return true;
            }
        };
        try {
            walker.walkIncludes(content);
        }
        catch (InvocationTargetException e) {
            ComIbmCicCommonCorePlugin.getTrace().catching(e.getTargetException());
        }
        return files.toArray(new String[files.size()]);
    }

    public static IStatus writeToFile(IContent content, File output) throws IOException {
        if (content instanceof IOffering) {
            Writer.writeOffering((IOffering)content, output);
        } else if (content instanceof IFix) {
            Writer.writeFix((IFix)content, output);
        } else {
            Writer.write(content, output);
        }
        return Status.OK_STATUS;
    }

    public static IStatus writeToStream(IContent content, OutputStream output) {
        if (content instanceof IOffering) {
            Writer.writeOffering((IOffering)content, output);
        } else if (content instanceof IFix) {
            Writer.writeFix((IFix)content, output);
        } else {
            Writer.write(content, output);
        }
        return Status.OK_STATUS;
    }

    public static IContentRepository getContentRepository(String path) {
        CicFileLocation fqLocation = new CicFileLocation(path);
        IRepositoryInfo subRepositoryInfo = null;
        AbstractBaseRepository rep = null;
        try {
            if (path.endsWith(CicConstants.getJarFileDotExt())) {
                subRepositoryInfo = RepositoryGroup.getDefault().createRepositoryInfo(String.valueOf(fqLocation.getName().substring(0, fqLocation.getName().lastIndexOf(46))) + ".offering", "ContentJar2", "0.0.0.1", fqLocation, null);
                rep = ContentJar2Repository.createRepositoryObject(subRepositoryInfo);
            } else if (path.endsWith(CicConstants.getZipFileDotExt())) {
                subRepositoryInfo = RepositoryGroup.getDefault().createRepositoryInfo(String.valueOf(fqLocation.getName().substring(0, fqLocation.getName().lastIndexOf(46))) + ".offering", "ContentZip2", "0.0.0.1", fqLocation, null);
                rep = ContentJar2Repository.createRepositoryObject(subRepositoryInfo);
            } else {
                subRepositoryInfo = RepositoryGroup.getDefault().createRepositoryInfo(fqLocation.getName(), "ContentElementRepository", "0.0.0.1", fqLocation.removeLastSegment(), null);
                rep = ContentElementRepository.createRepositoryObject(subRepositoryInfo);
            }
            if (rep.addExistingRepository().isOK()) {
                return (IContentRepository)((Object)rep);
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        return null;
    }

    public static boolean addExistingRepository(IRepositoryGroup destGroup, String serializeRepositoryInfo) {
        StringTokenizer st = new StringTokenizer(serializeRepositoryInfo, ";");
        while (st.hasMoreTokens()) {
            String serializedRepInfo = st.nextToken();
            if (destGroup.addExistingRepository(serializedRepInfo, false) != null) continue;
            return false;
        }
        return true;
    }

    public static IRepositoryInfo createRepInfoForNewRepository(File location) {
        return RepositoryUtils.createRepInfoForNewRepository(location.getAbsolutePath());
    }

    public static IRepository addExistingRepository(IRepositoryGroup group, IRepositoryInfo info, boolean findPriorityBasedLocation) {
        IRepository return_value = null;
        try {
            return_value = group.addExistingRepository(info, findPriorityBasedLocation);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return return_value;
    }

    public static Collection findOfferings(IRepository a_rep, IIdentity id, IProgressMonitor progressMonitor) {
        return RepositoryUtils.findOfferings(false, a_rep, id, progressMonitor);
    }

    public static Collection findOfferings(boolean includeUnavailable, IRepository a_rep, IIdentity id, IProgressMonitor progressMonitor) {
        ArrayList<IOffering> return_value = new ArrayList<IOffering>();
        List offerings = a_rep.getAllOfferings(includeUnavailable, progressMonitor);
        for (IOffering offering : offerings) {
            if (!offering.getIdentity().equals(id)) continue;
            return_value.add(offering);
        }
        return return_value;
    }

    public static IRepositoryInfo createRepInfoForNewRepository(String location) {
        IRepositoryInfo repInfo = null;
        CicFileLocation cicLoc = new CicFileLocation(location);
        File cicLocFile = cicLoc.toFile();
        repInfo = cicLoc.toString().endsWith(CicConstants.getZipFileDotExt()) && !cicLocFile.isDirectory() ? RepositoryGroup.getDefault().createRepositoryInfo(location, "Zip", "0.0.0.1", new CicFileLocation(location), null) : (cicLoc.toString().endsWith(CicConstants.getJarFileDotExt()) && !cicLocFile.isDirectory() ? RepositoryGroup.getDefault().createRepositoryInfo(location, "Jar", "0.0.0.1", new CicFileLocation(location), null) : (RepositoryFileBasedSiteProperties.REP_MAIN_SITE_PROPERTY_FILES.contains(cicLoc.getName()) ? RepositoryGroup.getDefault().createRepositoryInfo(location, "Dir", "0.0.0.1", new CicFileLocation(cicLoc.getPathSegments()), null) : RepositoryGroup.getDefault().createRepositoryInfo(location, "Dir", "0.0.0.1", new CicFileLocation(location), null)));
        return repInfo;
    }

    public static IRepositoryInfo createRepInfoForExistingRepository(IRepositoryGroup repoSvc, String name, String type, String version, String location, String specialSettings) {
        return repoSvc.createRepositoryInfo(name, type, version, new CicFileLocation(location), specialSettings);
    }

    public static IRepositoryInfo createRepInfoForExistingRepository(IRepositoryGroup repoSvc, String location) {
        return RepositoryUtils.createRepInfoForExistingRepository(repoSvc, location, null, null, location, null);
    }

    public static IRepository openExistingRepository(String unspecificMsg, String specificMsg, IRepositoryGroup group, String location, IProgressMonitor monitor) throws CoreException {
        assert (location != null && location.length() > 0);
        IRepositoryInfo repInfo = RepositoryUtils.createRepInfoForExistingRepository(group, location);
        return RepositoryUtils.openExistingRepository(group, repInfo, monitor);
    }

    public static IRepository openExistingRepository(IRepositoryGroup group, IRepositoryInfo repInfo, IProgressMonitor monitor) throws CoreException {
        assert (repInfo != null);
        IStatus status = group.canAddExistingRepository(repInfo, monitor);
        if (!status.isOK()) {
            IStatus repStatus = repInfo.getRepositoryReportedStatus();
            if (repStatus != null && repStatus.getSeverity() == 4 && repStatus.getMessage().trim().length() > 0) {
                throw new CoreException(repStatus);
            }
            String unspecificMsg = NLS.bind(Messages.RepositoryUtils_failedToConnectToRepositoryGenericMessage, (Object)repInfo.getName());
            String specificMsg = NLS.bind(Messages.RepositoryUtils_failedToConnectToRepository, (Object)repInfo.getName());
            IStatus displayStatus = RepositoryStatus.getDisplayStatusForCanAddExisting(unspecificMsg, specificMsg, status);
            throw new CoreException(displayStatus);
        }
        boolean findPriorityBasedLocation = true;
        IRepository repo = null;
        try {
            repo = group.addExistingRepository(repInfo, findPriorityBasedLocation);
        }
        catch (IOException e) {
            status = Statuses.ERROR.get(e, Messages.RepositoryUtils_failedToConnectToRepository, repInfo.getName());
            throw new CoreException(status);
        }
        return repo;
    }

    public static IStatus addRepositoryOrRefreshStatus(IRepositoryInfo repInfo, IProgressMonitor monitor) {
        IStatus status;
        block6: {
            IRepository rep = RepositoryGroup.getDefault().findRepository(repInfo);
            status = null;
            if (rep == null) {
                try {
                    status = RepositoryGroup.getDefault().canAddExistingRepository(repInfo, monitor);
                    if (!status.isOK()) break block6;
                    rep = RepositoryGroup.getDefault().addExistingRepository(repInfo, false);
                    if (rep == null) {
                        status = Statuses.ST.createMultiStatus(4, -1, new IStatus[0], null, "", new Object[0]);
                        break block6;
                    }
                    status = Statuses.ST.createMultiStatus();
                }
                catch (Exception e) {
                    status = Statuses.ST.createMultiStatus(-1, e, "", new Object[0]);
                }
            } else {
                status = rep.getStatus(true, monitor);
                repInfo.setRepositoryReportedStatus(rep.getRepositoryInfo().getRepositoryReportedStatus());
                if (!status.isOK()) {
                    RepositoryGroup.getDefault().removeRepository(rep);
                }
            }
        }
        return status;
    }

    public static IRepository addSpecificInnerRepository(IRepositoryGroup group, IRepositoryInfo repInfo, boolean findPriorityBasedLocation, IProgressMonitor monitor) throws CoreException {
        assert (group != null);
        assert (repInfo != null);
        assert (repInfo.getType() != null && repInfo.getType().length() > 0);
        try {
            IStatus status = group.canAddExistingRepository(repInfo, monitor);
            if (status.matches(12)) {
                throw new CoreException(status);
            }
            log.statusNotOK(status);
            IRepository repo = group.addExistingRepository(repInfo, findPriorityBasedLocation);
            if (repo == null) {
                ICicStatus errorStatus = Statuses.ERROR.get(6023, Messages.Repo_CantAddExistingRepositoryBadInnerRepository, repInfo.getLocationStr());
                throw new CoreException((IStatus)errorStatus);
            }
            return repo;
        }
        catch (CoreException e) {
            CicMultiStatus ms = RepositoryStatus.createSpecificMultiStatus(Statuses.ERROR.get(6023, Messages.Repo_CantAddExistingRepositoryBadInnerRepository, repInfo.getLocationStr()), null);
            ms.add(e.getStatus());
            throw new CoreException((IStatus)ms);
        }
        catch (Exception e) {
            CicMultiStatus status = RepositoryStatus.createSpecificMultiStatus(Statuses.ERROR.get(6023, Messages.Repo_CantAddExistingRepositoryBadInnerRepository, repInfo.getLocationStr()), e);
            throw new CoreException((IStatus)status);
        }
    }

    public static IStatus createNewRepositoryDigest(IRepository a_rep, IProgressMonitor pm) {
        SplitProgressMonitor spm = new SplitProgressMonitor(pm, 2);
        a_rep.updateRepositoryDigest(2, spm.next());
        a_rep.refresh();
        return a_rep.updateRepositoryDigest(1, spm.next());
    }

    public static IRepository addOrCreateRepository(IRepositoryGroup repositoryGroup, String location) {
        RepositoryUtils.prepareDirectory(location);
        IRepositoryInfo repInfo = RepositoryUtils.createRepInfoForNewRepository(location);
        IRepository return_value = null;
        try {
            return_value = repositoryGroup.addOrCreateRepository(repInfo);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return return_value;
    }

    public static IRepository addOrCreateRepository(IRepositoryGroup repositoryGroup, File location) {
        return RepositoryUtils.addOrCreateRepository(repositoryGroup, location.getAbsolutePath());
    }

    public static void prepareDirectory(String location) {
        if (!FileURLUtil.isURLString(location, true)) {
            CicFileLocation loc = new CicFileLocation(location);
            File locFile = loc.toFile();
            if (loc.getName().endsWith(CicConstants.getZipFileDotExt()) && !locFile.isDirectory()) {
                locFile.getParentFile().mkdirs();
            } else if (loc.getName().endsWith(CicConstants.getJarFileDotExt()) && !locFile.isDirectory()) {
                locFile.getParentFile().mkdirs();
            } else {
                locFile.mkdirs();
            }
        }
    }

    public static IRepository addOrCreateRepositoryToDefaultGroup(String location) {
        return RepositoryUtils.addOrCreateRepository((IRepositoryGroup)RepositoryGroup.getDefault(), location);
    }

    public static IRepository obtainStandaloneRepository(File location) {
        location.mkdirs();
        IRepositoryInfo repInfo = RepositoryUtils.createRepInfoForNewRepository(location);
        RepositoryDescriptor descr = repInfo.getRepositoryDescriptor();
        try {
            return descr.createInitializedExistingOrNewRepositoryObject(repInfo, true);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static IRepository getRawRepository(IRepository repository) {
        IRepositoryRef ref;
        IRepository actualRepository = null;
        if (repository != null && (actualRepository = (ref = (IRepositoryRef)repository.getRepositoryReference()).getRepository()) instanceof MemoryRepositoryCacheHandler) {
            MemoryRepositoryCacheHandler rep = (MemoryRepositoryCacheHandler)actualRepository;
            actualRepository = rep.getRepository();
        }
        return actualRepository;
    }
}

