/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.repository;

import com.ibm.cic.common.core.artifactrepo.IReadArtifactRepo;
import com.ibm.cic.common.core.model.IAssembly;
import com.ibm.cic.common.core.model.IContent;
import com.ibm.cic.common.core.model.IFix;
import com.ibm.cic.common.core.model.IIdentity;
import com.ibm.cic.common.core.model.IInstallableUnit;
import com.ibm.cic.common.core.model.IOffering;
import com.ibm.cic.common.core.model.IOfferingOrFix;
import com.ibm.cic.common.core.model.IShareableEntity;
import com.ibm.cic.common.core.model.IShareableUnit;
import com.ibm.cic.common.core.model.ISuFragment;
import com.ibm.cic.common.core.repository.ICicLocation;
import com.ibm.cic.common.core.repository.IContentRepository;
import com.ibm.cic.common.core.repository.IRepositoryInfo;
import com.ibm.cic.common.core.repository.RepositorySiteProperties;
import com.ibm.cic.common.core.repository.digest.RepositoryDigestRepositoryData;
import com.ibm.cic.common.core.repository.listeners.IRepositoryPropertyEventListener;
import com.ibm.cic.common.core.utils.CicMultiStatus;
import com.ibm.cic.common.core.utils.UserNames;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.osgi.service.resolver.VersionRange;
import org.osgi.framework.Version;

public interface IRepository
extends IReadArtifactRepo {
    public List getAllOfferings(IProgressMonitor var1);

    public List getAllOfferings(boolean var1, IProgressMonitor var2);

    public List getAllFixes(IProgressMonitor var1);

    public List getAllFixes(boolean var1, IProgressMonitor var2);

    public List getAllAssemblies(IProgressMonitor var1);

    public List getAllSus(IProgressMonitor var1);

    public List getAllSuFragments(IProgressMonitor var1);

    public List getAllIus(IProgressMonitor var1);

    public List getAllShareableEntities(IProgressMonitor var1);

    public List getShareableEntities(IIdentity var1, Version var2, VersionRange var3, IProgressMonitor var4);

    public List getAllContentElements(IProgressMonitor var1);

    public IOffering findOffering(IIdentity var1, Version var2, IProgressMonitor var3);

    public IOffering findOffering(boolean var1, IIdentity var2, Version var3, IProgressMonitor var4);

    public IOffering findUpdate(IIdentity var1, Version var2, IProgressMonitor var3);

    public IOffering findUpdate(boolean var1, IIdentity var2, Version var3, IProgressMonitor var4);

    public List getAllUpdates(IIdentity var1, Version var2, IProgressMonitor var3);

    public List getAllUpdates(boolean var1, IIdentity var2, Version var3, IProgressMonitor var4);

    public IStatus unsetUpdateOffering(IOffering var1);

    public IFix findFix(IIdentity var1, Version var2, IProgressMonitor var3);

    public IFix findFix(boolean var1, IIdentity var2, Version var3, IProgressMonitor var4);

    public IAssembly findAssembly(IIdentity var1, Version var2, IProgressMonitor var3);

    public IShareableUnit findShareableUnit(IIdentity var1, Version var2, IProgressMonitor var3);

    public ISuFragment findSuFragment(IIdentity var1, Version var2, IProgressMonitor var3);

    public IShareableEntity findShareableEntity(IIdentity var1, Version var2, IProgressMonitor var3);

    public IInstallableUnit findInstallableUnit(IIdentity var1, Version var2, IProgressMonitor var3);

    public boolean isOpen();

    public void setOpen(boolean var1);

    public IStatus getStatus(boolean var1, IProgressMonitor var2);

    public boolean isWritable();

    public void setName(String var1);

    public String getName();

    public String getType();

    public String getVersion();

    public ICicLocation getLocation();

    public String getLocationStr();

    public IRepositoryInfo getRepositoryInfo();

    public String serializeRepositoryInfo();

    public UserNames getUserNames();

    public void registerListener(IRepositoryPropertyEventListener var1);

    public void unregisterListener(IRepositoryPropertyEventListener var1);

    public void refresh();

    public IContent refreshContent(IContent var1);

    public boolean containsMetadata();

    public boolean containsArtifacts();

    public boolean canStoreMetadata();

    public boolean canStoreArtifacts();

    public InputStream getContentInputStream(IContent var1) throws IOException;

    public InputStream getInputStream(String var1) throws IOException;

    public IContent addContent(IContent var1) throws IOException;

    public IStatus addContent(List var1) throws IOException;

    public IStatus saveContent(IContent var1) throws IOException;

    public IContent moveContent(IContent var1) throws IOException;

    public IStatus deleteContent(IContent var1) throws IOException;

    public IAssembly createAssembly(IIdentity var1, Version var2) throws IOException;

    public IOffering createOffering(IIdentity var1, Version var2) throws IOException;

    public IFix createFix(IIdentity var1, Version var2) throws IOException;

    public IShareableUnit createSu(IIdentity var1, Version var2) throws IOException;

    public ISuFragment createSuFragment(IIdentity var1, Version var2) throws IOException;

    public IInstallableUnit createIu(IIdentity var1, Version var2) throws IOException;

    public IStatus clear();

    public IStatus delete(boolean var1);

    public void dispose();

    public RepositorySiteProperties getSiteProperties();

    public IRepository getRepositoryReference();

    public void setRepositoryReference(IRepository var1);

    public IStatus canCreateRepository();

    public IStatus canAddExistingRepository(IProgressMonitor var1);

    public IStatus isRepInfoMatchingRepositoryObject(IRepositoryInfo var1);

    public IContentRepository getContentRepository(IContent var1);

    public IStatus resolve(IOfferingOrFix var1, IProgressMonitor var2);

    public IStatus updateRepositoryDigest(int var1, IProgressMonitor var2);

    public RepositoryDigestRepositoryData getRepositoryDigestData();

    public RepositoryDigestRepositoryData generateRepositoryDigestData(CicMultiStatus var1, IProgressMonitor var2);

    public IStatus importP2Repository(File var1, IProgressMonitor var2);

    public IStatus deleteP2Repository(IProgressMonitor var1);

    public IStatus exportP2Repository(File var1, IProgressMonitor var2);

    public boolean containsP2Repository(IProgressMonitor var1);

    public String[] getNLSFileList();

    public InputStream openNLSFileStream(String var1) throws IOException;

    public IStatus addNLSFile(String var1, InputStream var2) throws IOException;

    public IStatus deleteNLSFile(String var1) throws IOException;
}

