/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.repository;

import com.ibm.cic.common.core.artifactrepo.IArtifactLocator;
import com.ibm.cic.common.core.artifactrepo.impl.AbstractPathWriteArtifactRepository;
import com.ibm.cic.common.core.artifactrepo.impl.ArtifactFormatterUtil;
import com.ibm.cic.common.core.artifactrepo.impl.ArtifactToPathUtil;
import com.ibm.cic.common.core.artifactrepo.impl.Messages;
import com.ibm.cic.common.core.internal.artifactrepo.IRevealArtifactFileLocations;
import com.ibm.cic.common.core.model.adapterdata.IArtifactKey;
import com.ibm.cic.common.core.repository.IRepository;
import com.ibm.cic.common.core.utils.Statuses;
import java.io.File;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.osgi.util.NLS;

public abstract class DirectoryArtifactRepository
extends AbstractPathWriteArtifactRepository
implements IRevealArtifactFileLocations {
    @Override
    public abstract IRepository getRepository();

    @Override
    protected IPath getRepositoryPath(IArtifactKey key) throws CoreException {
        Path destPath = new Path(this.getRepository().getLocationStr());
        IPath relPath = ArtifactToPathUtil.getUpdateSiteCompatiblePath(key);
        if (relPath == null) {
            String msg = NLS.bind((String)Messages.couldnt_determine_target_location, (Object)ArtifactFormatterUtil.toUserString(key));
            throw new CoreException((IStatus)Statuses.ERROR.get(9, msg, new Object[0]));
        }
        return destPath.append(relPath);
    }

    @Override
    public Object getAdapter(Class adapter) {
        if (adapter == IRevealArtifactFileLocations.class) {
            DirectoryArtifactRepository ral = this;
            return ral;
        }
        return super.getAdapter(adapter);
    }

    @Override
    public File[] revealUsedArtifactRoots() {
        File[] files = ArtifactToPathUtil.revealUsedArtifactRoots(this.getRepository().getLocation().toFile());
        return files;
    }

    @Override
    public String[] revealArtifactRootNames() {
        return ArtifactToPathUtil.revealArtifactRootNames();
    }

    @Override
    protected IPath getRepositoryPath() {
        return new Path(this.getRepository().getLocationStr());
    }

    @Override
    protected void doRemoveArtifactFile(IArtifactLocator locator, IPath path, IProgressMonitor monitor) throws CoreException {
        try {
            monitor.beginTask("", 1);
            File file = path.toFile();
            DirectoryArtifactRepository.removeFile(file);
        }
        finally {
            monitor.done();
        }
    }

    private static void removeFile(File file) throws CoreException {
        if (!file.delete()) {
            String msg = NLS.bind((String)Messages.delete_file_failed, (Object)file.getAbsolutePath());
            throw new CoreException((IStatus)Statuses.ERROR.get(13, msg, new Object[0]));
        }
    }
}

