/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.repository;

import com.ibm.cic.common.core.repository.ICicLocation;
import com.ibm.icu.util.StringTokenizer;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class CicFileLocation
implements ICicLocation {
    public static final String SEGMENT_DOT = ".";
    public static final String SEGMENT_DOTDOT = "..";
    public static final char SEGMENT_FORWARD_SLASH = '/';
    public static final char SEGMENT_BACK_SLASH = '\\';
    public static final char SEPARATOR = '/';
    String m_stringPath = "";
    List m_segments;
    int m_size = -1;
    String m_name;

    public CicFileLocation() {
        this.setPath(null);
    }

    public CicFileLocation(String a_path) {
        this.setPath(a_path);
    }

    public CicFileLocation(List a_segments) {
        StringBuffer buf = new StringBuffer();
        boolean firstAppend = true;
        Iterator I = a_segments.iterator();
        while (I.hasNext()) {
            if (!firstAppend) {
                buf.append('/');
            } else {
                firstAppend = true;
            }
            buf.append(I.next());
        }
        this.setPath(buf.toString());
    }

    @Override
    public void setPath(String a_path) {
        this.m_stringPath = a_path == null ? "" : a_path;
        this.m_segments = null;
        this.m_size = -1;
        this.m_name = null;
    }

    @Override
    public String getPathSegments() {
        int lastIndex = this.m_stringPath.lastIndexOf(this.getName());
        return lastIndex < 1 ? "" : this.m_stringPath.substring(0, lastIndex - 1);
    }

    @Override
    public ICicLocation removeLastSegment() {
        return new CicFileLocation(this.getPathSegments());
    }

    @Override
    public String getNextSegment(ICicLocation a_parentSegments) {
        if (a_parentSegments.getSize() < this.getSize()) {
            String[] mySegments = this.getSegments();
            String[] parentSegments = a_parentSegments.getSegments();
            int Imy = 0;
            while (Imy < parentSegments.length) {
                if (!mySegments[Imy].equals(parentSegments[Imy])) {
                    return null;
                }
                ++Imy;
            }
            return mySegments[Imy];
        }
        return null;
    }

    @Override
    public String getName() {
        if (this.m_name == null) {
            this.m_name = this.getSize() > 0 ? (String)this.getSegmentsList().get(this.getSize() - 1) : "";
        }
        return this.m_name;
    }

    public String toString() {
        if (this.m_stringPath == null) {
            return "";
        }
        return this.m_stringPath;
    }

    @Override
    public int getSize() {
        return this.m_size == -1 ? (this.m_size = this.getSegmentsList().size()) : this.m_size;
    }

    @Override
    public String[] getSegments() {
        return this.getSegmentsList().toArray(new String[this.getSize()]);
    }

    private List getSegmentsList() {
        if (this.m_segments == null) {
            this.m_segments = new ArrayList();
            StringTokenizer tok = new StringTokenizer(this.m_stringPath, "/\\");
            while (tok.hasMoreTokens()) {
                this.m_segments.add(tok.nextToken());
            }
        }
        return this.m_segments;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean equals(Object o) {
        if (o instanceof CicFileLocation) {
            return this.getSegmentsList().equals(((CicFileLocation)o).getSegmentsList());
        }
        return false;
    }

    @Override
    public ICicLocation append(String str) {
        return new CicFileLocation(CicFileLocation.append(this.m_stringPath, str));
    }

    public static String append(String str, String apnd) {
        StringBuffer sb = new StringBuffer();
        sb.append(str);
        if (!(str.startsWith("http") && apnd.startsWith("?") || str.length() <= 0 || CicFileLocation.endsWithSeparator(str) || CicFileLocation.beginsWithSeparator(apnd))) {
            sb.append('/');
        }
        sb.append(apnd);
        return sb.toString();
    }

    @Override
    public ICicLocation append(ICicLocation path) {
        return this.append(path.toString());
    }

    @Override
    public ICicLocation appendRelative(ICicLocation path) {
        ICicLocation return_value = this;
        String[] newSegments = path.getSegments();
        int i = 0;
        while (i < newSegments.length) {
            if (!newSegments[i].equals(SEGMENT_DOT)) {
                return_value = newSegments[i].equals(SEGMENT_DOTDOT) ? return_value.removeLastSegment() : return_value.append(newSegments[i]);
            }
            ++i;
        }
        return return_value;
    }

    @Override
    public File toFile() {
        return new File(this.m_stringPath);
    }

    public static boolean endsWithSeparator(String str) {
        int index = str.length() - 1;
        if (index > 0) {
            char c = str.charAt(index);
            return c == '\\' || c == '/';
        }
        return false;
    }

    public static boolean beginsWithSeparator(String str) {
        return str.length() > 0 && (str.charAt(0) == '\\' || str.charAt(0) == '/');
    }

    public static boolean isSeparator(char c) {
        return c == '\\' || c == '/';
    }

    @Override
    public URL toURL() {
        URL return_value = null;
        try {
            if (this.m_stringPath.length() > 0) {
                try {
                    return_value = new URL(this.m_stringPath);
                }
                catch (Throwable e) {
                    File file = this.toFile();
                    return_value = file.toURI().toURL();
                }
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        return return_value;
    }

    @Override
    public int length() {
        return this.toString().length();
    }

    @Override
    public String getFileName() {
        String name = this.getName();
        int index = name.indexOf("?");
        if (index > -1) {
            return name.substring(0, index);
        }
        return name;
    }
}

