/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.repository;

import com.ibm.cic.common.core.artifactrepo.impl.ArtifactToPathUtil;
import com.ibm.cic.common.core.internal.ComIbmCicCommonCorePlugin;
import com.ibm.cic.common.core.model.IInstallableUnit;
import com.ibm.cic.common.core.model.adapterdata.IArtifact;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.core.runtime.IPath;

public class Artifacts {
    private final Collection artifactsPath;

    public Artifacts(IInstallableUnit iu) {
        Collection artifacts = iu.getAdapterData().getArtifacts();
        this.artifactsPath = new ArrayList(artifacts.size());
        for (IArtifact artifact : artifacts) {
            IPath path = ArtifactToPathUtil.getUpdateSiteCompatiblePath(artifact);
            if (path == null) {
                ComIbmCicCommonCorePlugin.log("ArtifactKeyPathUtil.getUpdateSiteCompatiblePath(" + artifact.toString() + ") returns null, ignoring this artifacts");
                continue;
            }
            this.artifactsPath.add(path.toString());
        }
    }

    public int size() {
        return this.artifactsPath.size();
    }

    public Iterator iterator() {
        return this.artifactsPath.iterator();
    }
}

