/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.repository;

import com.ibm.cic.common.core.artifactrepo.IArtifactSession;
import com.ibm.cic.common.core.artifactrepo.IReadArtifactRepo;
import com.ibm.cic.common.core.artifactrepo.impl.AbstractReadArtifactRepo;
import com.ibm.cic.common.core.internal.Messages;
import com.ibm.cic.common.core.internal.downloads.FileContentInfo;
import com.ibm.cic.common.core.internal.repository.RepositoryPool;
import com.ibm.cic.common.core.internal.repository.RepositoryUpdateOfferingHandler;
import com.ibm.cic.common.core.internal.repository.TableOfContents;
import com.ibm.cic.common.core.internal.utils.CicConstants;
import com.ibm.cic.common.core.model.IAssembly;
import com.ibm.cic.common.core.model.IContent;
import com.ibm.cic.common.core.model.IFix;
import com.ibm.cic.common.core.model.IIdentity;
import com.ibm.cic.common.core.model.IOffering;
import com.ibm.cic.common.core.model.IOfferingOrFix;
import com.ibm.cic.common.core.model.IShareableEntity;
import com.ibm.cic.common.core.model.IShareableUnit;
import com.ibm.cic.common.core.model.ISuFragment;
import com.ibm.cic.common.core.model.internal.CicResolver;
import com.ibm.cic.common.core.model.proxy.FixReference;
import com.ibm.cic.common.core.model.proxy.IFixReference;
import com.ibm.cic.common.core.model.proxy.IOfferingReference;
import com.ibm.cic.common.core.model.proxy.OfferingOrFixReference;
import com.ibm.cic.common.core.model.proxy.OfferingReference;
import com.ibm.cic.common.core.model.utils.OfferingOrFixProperty;
import com.ibm.cic.common.core.preferences.CicCommonSettings;
import com.ibm.cic.common.core.repository.AbstractBaseRepository;
import com.ibm.cic.common.core.repository.ContentElementRepository;
import com.ibm.cic.common.core.repository.ContentJar2Repository;
import com.ibm.cic.common.core.repository.ContentZip2Repository;
import com.ibm.cic.common.core.repository.ICicLocation;
import com.ibm.cic.common.core.repository.IContentRepository;
import com.ibm.cic.common.core.repository.IRepositoryInfo;
import com.ibm.cic.common.core.repository.IZipFileHandler;
import com.ibm.cic.common.core.repository.LayoutPolicy;
import com.ibm.cic.common.core.repository.RepositoryContext;
import com.ibm.cic.common.core.repository.RepositoryGroup;
import com.ibm.cic.common.core.repository.RepositoryStatus;
import com.ibm.cic.common.core.repository.digest.RepositoryDigest;
import com.ibm.cic.common.core.repository.digest.RepositoryDigestOfferingOrFixData;
import com.ibm.cic.common.core.repository.digest.RepositoryDigestToc;
import com.ibm.cic.common.core.repository.digest.RepositoryDigestTocEntry;
import com.ibm.cic.common.core.repository.listeners.RepositoryEventFileAdded;
import com.ibm.cic.common.core.repository.listeners.RepositoryEventFileRemoved;
import com.ibm.cic.common.core.utils.FileUtil;
import com.ibm.cic.common.core.utils.LinkedProperties;
import com.ibm.cic.common.core.utils.NLS;
import com.ibm.cic.common.core.utils.SplitProgressMonitor;
import com.ibm.cic.common.downloads.ContentInfo;
import com.ibm.cic.common.downloads.FileCacheManager;
import com.ibm.cic.common.downloads.IContentInfo;
import com.ibm.cic.common.downloads.IDownloadSession;
import com.ibm.cic.common.downloads.IFileContentInfo;
import com.ibm.cic.common.logging.ExceptionUtil;
import com.ibm.cic.common.logging.Logger;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.osgi.framework.Version;

public abstract class AbstractFileBasedRepository
extends AbstractBaseRepository {
    static final String MAIN_CONTENT_INFO = "MAIN_CONTENT_INFO";
    static final String SECONDARY_CONTENT_INFO = "SECONDARY_CONTENT_INFO";
    private static final Logger log = Logger.getLogger(AbstractFileBasedRepository.class);
    private static final String TESTED_OFFERINGS = "cic.testedOfferings";
    private LayoutPolicy layoutPolicy;
    private AbstractReadArtifactRepo artifactRepository;
    private final RepositoryUpdateOfferingHandler m_updateOfferingHandler;
    private final FileCacheManager m_fcm = RepositoryPool.getDefault().getFileCacheManager();

    protected AbstractFileBasedRepository(String type, String version) {
        super(type, version);
        this.m_updateOfferingHandler = new RepositoryUpdateOfferingHandler(this);
    }

    @Override
    public List getAllAssemblies(IProgressMonitor progressMonitor) {
        return this.getElements(progressMonitor, new Filter(IAssembly.class, Messages.Filter_assemblies));
    }

    private List filterOutNonPortableOfferingsOrFixes(List allOfferingsOrFixesList) {
        if (!CicCommonSettings.isPortable()) {
            return allOfferingsOrFixesList;
        }
        String propertyValue = this.getSiteProperties().getProperty("DisablePortableFilter");
        if (propertyValue.equals("true")) {
            return allOfferingsOrFixesList;
        }
        ArrayList<IOfferingOrFix> filteredOfferingsOrFixesList = new ArrayList<IOfferingOrFix>();
        for (IOfferingOrFix offeringOrFix : allOfferingsOrFixesList) {
            if (!OfferingOrFixProperty.supportsPortable(offeringOrFix)) continue;
            filteredOfferingsOrFixesList.add(offeringOrFix);
        }
        return filteredOfferingsOrFixesList;
    }

    @Override
    public List getAllFixes(boolean includeUnavailable, IProgressMonitor progressMonitor) {
        List<Object> allFixesList = new ArrayList();
        RepositoryDigest dg = this.getSiteProperties().getRepositoryDigest();
        if (this.getSiteProperties().isRepositoryDigestInUse()) {
            List<IFixReference> fixes = dg.getAllFixes(includeUnavailable);
            if (!fixes.isEmpty()) {
                for (IFixReference fixRef : fixes) {
                    fixRef.setRepository(this);
                }
                allFixesList = fixes;
            }
        } else {
            allFixesList = this.getElements(progressMonitor, new Filter(IFix.class, Messages.Filter_fixes));
        }
        return this.filterOutNonPortableOfferingsOrFixes(allFixesList);
    }

    @Override
    public List getAllOfferings(boolean includeUnavailable, IProgressMonitor progressMonitor) {
        List<Object> allOfferingsList = new ArrayList();
        RepositoryDigest dg = this.getSiteProperties().getRepositoryDigest();
        if (this.getSiteProperties().isRepositoryDigestInUse()) {
            List<IOfferingReference> offerings = dg.getAllOfferings(includeUnavailable);
            if (!offerings.isEmpty()) {
                for (IOfferingReference ofRef : offerings) {
                    ofRef.setRepository(this);
                }
                allOfferingsList = offerings;
            }
        } else {
            allOfferingsList = this.getElements(progressMonitor, new OfferingsAndUpdateFilter(false));
        }
        return this.filterOutNonPortableOfferingsOrFixes(allOfferingsList);
    }

    @Override
    public List getAllUpdates(boolean includeUnavailable, IIdentity offeringId, Version offeringVersion, IProgressMonitor progressMonitor) {
        List<IOfferingReference> allOfferingsList = new ArrayList();
        RepositoryDigest dg = this.getSiteProperties().getRepositoryDigest();
        if (this.getSiteProperties().isRepositoryDigestInUse()) {
            List<IOfferingReference> updates = dg.getAllUpdates(includeUnavailable);
            if (!updates.isEmpty()) {
                for (IOfferingReference ofRef : updates) {
                    if (!this.m_updateOfferingHandler.updateMatchesIdAndVersion(ofRef, offeringId, offeringVersion)) continue;
                    ofRef.setRepository(this);
                    allOfferingsList.add(ofRef);
                }
            }
        } else {
            allOfferingsList = this.getElements(progressMonitor, new OfferingsAndUpdateFilter(offeringId, offeringVersion, true));
        }
        return this.filterOutNonPortableOfferingsOrFixes(allOfferingsList);
    }

    @Override
    public List getAllSus(IProgressMonitor monitor) {
        return this.getElements(monitor, new Filter(IShareableUnit.class, Messages.Filter_sus));
    }

    @Override
    public List getAllSuFragments(IProgressMonitor monitor) {
        return this.getElements(monitor, new Filter(ISuFragment.class, Messages.Filter_suFragments));
    }

    @Override
    public List getAllShareableEntities(IProgressMonitor monitor) {
        return this.getElements(monitor, new Filter(IShareableEntity.class, Messages.Filter_ses));
    }

    private int countFiles(Map locationsAndFiles) {
        int return_value = 0;
        for (String[] array : locationsAndFiles.values()) {
            return_value += array.length;
        }
        return return_value;
    }

    private List getElements(IProgressMonitor monitor, Filter filter) {
        List return_value = new ArrayList();
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        try {
            monitor.beginTask("", 100);
            monitor.subTask(NLS.bind(Messages.Monitor_getFileNames, (Object)this.getName()));
            Map relativeSearchLocations = this.getRelativeSearchLocationsAndFileNames(filter);
            monitor.worked(10);
            if (!monitor.isCanceled()) {
                monitor.setTaskName(NLS.bind(Messages.Monitor_getElements, (Object)filter.getLabel(), (Object)this.getName()));
                return_value = this.getElementObjects((IProgressMonitor)new SubProgressMonitor(monitor, 90, 4), filter, relativeSearchLocations);
            }
        }
        finally {
            monitor.done();
        }
        return return_value;
    }

    /*
     * Exception decompiling
     */
    private List getElementObjects(IProgressMonitor monitor, Filter filter, Map locationsAndFiles) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 5[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private IFileContentInfo getTocXmlContentInfo(ICicLocation relativeDirLocation) {
        return new FileContentInfo(this.getLocation().append(relativeDirLocation), TableOfContents.TOC_XML_LOCATION);
    }

    /*
     * Unable to fully structure code
     */
    protected String[] getFileNames(ICicLocation relativeDirLocation, Filter filter) {
        block6: {
            return_value = new ArrayList<String>();
            location = this.getLocation().append(relativeDirLocation);
            monitor = new NullProgressMonitor();
            spm1 = new SplitProgressMonitor((IProgressMonitor)monitor, 2);
            contentInfo = this.getTocXmlContentInfo(relativeDirLocation);
            try {
                tocFile = this.m_fcm.getFile(contentInfo, false, false, this.getDownloader(), spm1.next());
                toc = TableOfContents.getToc(tocFile, (IContentInfo)contentInfo, spm1.next());
                entries = toc.getEntries();
                for (TableOfContents.TocEntry entry : entries) {
                    if (!filter.acceptableFileName(entry.getFileName())) continue;
                    return_value.add(entry.getFileName());
                }
                extraOfferingsFiles = System.getProperty("cic.testedOfferings");
                if (extraOfferingsFiles == null || extraOfferingsFiles.length() <= 0) break block6;
                strTok = new StringTokenizer(extraOfferingsFiles, ",");
                while (strTok.hasMoreTokens()) {
                    tok = strTok.nextToken();
                    if (!filter.acceptableFileName(tok)) continue;
                    return_value.add(tok);
                }
                break block6;
            }
            catch (Exception e) {
                path = location.toFile();
                if (!path.isDirectory() || (names = path.listFiles()) == null) break block6;
                var14_20 = names;
                var13_19 = names.length;
                var12_17 = 0;
                ** while (var12_17 < var13_19)
            }
lbl-1000:
            // 1 sources

            {
                name = var14_20[var12_17];
                if (name.isFile() && filter.acceptableFileName(fileName = name.getName())) {
                    return_value.add(fileName);
                }
                ++var12_17;
                continue;
            }
        }
        return return_value.toArray(new String[return_value.size()]);
    }

    @Override
    public void refresh() {
        super.refresh();
        this.m_updateOfferingHandler.refresh();
    }

    Map getRelativeSearchLocationsAndFileNames(Filter filter) {
        String[] fileNames;
        LinkedHashMap<ICicLocation, String[]> return_value = new LinkedHashMap<ICicLocation, String[]>();
        ICicLocation dirLocation = this.getLP().getRelativeTopDirPath(filter.getClassType());
        if (dirLocation != null && (fileNames = this.getFileNames(dirLocation, filter)).length > 0) {
            return_value.put(dirLocation, fileNames);
        }
        return return_value;
    }

    protected IContent customizeNewIContentObject(IContentRepository subRepository, IContent o, ICicLocation relativeLocation) {
        if (o != null) {
            o.setLocation(null);
            this.initializeExtModel(o, relativeLocation);
            if (o instanceof IOffering) {
                subRepository.performNLSupdate(o);
                IOffering offering = (IOffering)o;
                OfferingReference offeringRef = new OfferingReference(offering);
                String prefOfferingVersion = this.getSiteProperties().getProperty("RECOMMENDED_OFFERING_" + offering.getIdentity().getId());
                if (prefOfferingVersion.equals(offering.getVersion().toString())) {
                    offeringRef.setRecommended(true);
                }
                this.m_updateOfferingHandler.handleUpdate(offeringRef);
                offeringRef.setFromSiteProperties(this.getSiteProperties());
                return offeringRef;
            }
            if (o instanceof IFix) {
                subRepository.performNLSupdate(o);
                return new FixReference((IFix)o);
            }
        }
        return o;
    }

    protected IContentRepository createSubRepository(IContent content, String simpleFileName, ICicLocation relativeLocation) {
        ICicLocation fqLocation = this.getLocation().append(relativeLocation);
        AbstractBaseRepository return_value = null;
        IRepositoryInfo subRepositoryInfo = null;
        AbstractBaseRepository rep = null;
        if (content != null) {
            try {
                boolean includeBuildData = this.getRepositoryInfo().getIncludeBuildData();
                if (simpleFileName.endsWith(CicConstants.getJarFileDotExt())) {
                    fqLocation = fqLocation.append(simpleFileName);
                    subRepositoryInfo = this.createAndInitializeSubRepositoryInfo(String.valueOf(simpleFileName.substring(0, simpleFileName.lastIndexOf(46))) + ".offering", "ContentJar2", "0.0.0.1", fqLocation, relativeLocation, simpleFileName, content, includeBuildData, true);
                    rep = ContentJar2Repository.createRepositoryObject(subRepositoryInfo);
                } else if (simpleFileName.endsWith(CicConstants.getZipFileDotExt())) {
                    fqLocation = fqLocation.append(simpleFileName);
                    subRepositoryInfo = this.createAndInitializeSubRepositoryInfo(String.valueOf(simpleFileName.substring(0, simpleFileName.lastIndexOf(46))) + ".offering", "ContentZip2", "0.0.0.1", fqLocation, relativeLocation, simpleFileName, content, includeBuildData, true);
                    rep = ContentZip2Repository.createRepositoryObject(subRepositoryInfo);
                } else if (CicConstants.fileMatchesDEFAULT_EXTENSIONS(simpleFileName)) {
                    subRepositoryInfo = this.createAndInitializeSubRepositoryInfo(simpleFileName, "ContentElementRepository", "0.0.0.1", fqLocation, relativeLocation, simpleFileName, content, includeBuildData, true);
                    rep = ContentElementRepository.createRepositoryObject(subRepositoryInfo);
                }
                if (rep != null) {
                    IStatus status = rep.addExistingRepository();
                    if (!status.isOK()) {
                        status = rep.createRepository();
                    }
                    if (status.isOK()) {
                        return_value = rep;
                        return_value.setRepositoryReference(this.getRepositoryReference());
                    }
                }
            }
            catch (Throwable e) {
                ExceptionUtil.debugLogToReview(e);
                e.printStackTrace();
            }
        }
        return (IContentRepository)((Object)return_value);
    }

    protected IContentRepository findSubRepository(IContent content, String simpleFileName, ICicLocation relativeLocation) {
        ICicLocation fqLocation = this.getLocation().append(relativeLocation);
        AbstractBaseRepository return_value = null;
        IRepositoryInfo subRepositoryInfo = null;
        AbstractBaseRepository rep = null;
        try {
            IStatus status;
            boolean includeBuildData = this.getRepositoryInfo().getIncludeBuildData();
            if (simpleFileName.endsWith(CicConstants.getJarFileDotExt())) {
                fqLocation = fqLocation.append(simpleFileName);
                subRepositoryInfo = this.createAndInitializeSubRepositoryInfo(String.valueOf(simpleFileName.substring(0, simpleFileName.lastIndexOf(46))) + ".offering", "ContentJar2", "0.0.0.1", fqLocation, relativeLocation, simpleFileName, content, includeBuildData, false);
                rep = ContentJar2Repository.createRepositoryObject(subRepositoryInfo);
            } else if (simpleFileName.endsWith(CicConstants.getZipFileDotExt())) {
                fqLocation = fqLocation.append(simpleFileName);
                subRepositoryInfo = this.createAndInitializeSubRepositoryInfo(String.valueOf(simpleFileName.substring(0, simpleFileName.lastIndexOf(46))) + ".offering", "ContentZip2", "0.0.0.1", fqLocation, relativeLocation, simpleFileName, content, includeBuildData, false);
                rep = ContentZip2Repository.createRepositoryObject(subRepositoryInfo);
            } else if (CicConstants.fileMatchesDEFAULT_EXTENSIONS(simpleFileName)) {
                subRepositoryInfo = this.createAndInitializeSubRepositoryInfo(simpleFileName, "ContentElementRepository", "0.0.0.1", fqLocation, relativeLocation, simpleFileName, content, includeBuildData, false);
                rep = ContentElementRepository.createRepositoryObject(subRepositoryInfo);
            }
            if (rep != null && (status = rep.addExistingRepository()).isOK()) {
                return_value = rep;
                return_value.setRepositoryReference(this.getRepositoryReference());
            }
        }
        catch (Throwable e) {
            ExceptionUtil.debugLogToReview(e);
            e.printStackTrace();
        }
        return (IContentRepository)((Object)return_value);
    }

    private IRepositoryInfo createAndInitializeSubRepositoryInfo(String subRepositoryName, String type, String version, ICicLocation location, ICicLocation relativePath, String shortFileName, IContent content, boolean includeBuildData, boolean findAndTryToCreate) {
        IRepositoryInfo return_value = RepositoryGroup.getDefault().createRepositoryInfo(subRepositoryName, type, version, location, null);
        return_value.setIncludeBuildData(includeBuildData);
        return_value.setProperty("RepositoryElement", findAndTryToCreate ? content : null);
        if (this.getRepositoryInfo().isReadOnlyRepositoryRequested()) {
            return_value.requestReadOnlyRepository();
        }
        try {
            Object toc;
            boolean tocProcessed = false;
            if (content instanceof OfferingOrFixReference && !findAndTryToCreate) {
                FileContentInfo ci;
                RepositoryDigestTocEntry tocEntry;
                OfferingOrFixReference ref = (OfferingOrFixReference)content;
                RepositoryDigestOfferingOrFixData ofOrFixData = ref.getContentData();
                toc = ofOrFixData.getToc();
                List<RepositoryDigestTocEntry> entries = ((RepositoryDigestToc)toc).getEntries();
                Iterator<RepositoryDigestTocEntry> I = entries.iterator();
                if (I.hasNext()) {
                    tocEntry = I.next();
                    ci = tocEntry.getContentInfo();
                    ci.setFilePath(this.getLP().getFQTopBaseDirPath());
                    return_value.setProperty(MAIN_CONTENT_INFO, ci);
                }
                if (I.hasNext()) {
                    tocEntry = I.next();
                    ci = tocEntry.getContentInfo();
                    ci.setFilePath(this.getLP().getFQTopBaseDirPath());
                    return_value.setProperty(SECONDARY_CONTENT_INFO, ci);
                }
                tocProcessed = true;
            }
            if (!tocProcessed) {
                IFileContentInfo tocXMLContentInfo = this.getTocXmlContentInfo(relativePath);
                ICicLocation path = this.getLP().getFQTopBaseDirPath().append(relativePath);
                File tocFile = this.m_fcm.getFile(tocXMLContentInfo, false, false, this.getDownloader(), null);
                toc = TableOfContents.getToc(tocFile, (IContentInfo)tocXMLContentInfo, null);
                TableOfContents.TocEntry tocEntry = ((TableOfContents.Toc)toc).getEntry(shortFileName);
                if (tocEntry != null) {
                    FileContentInfo ci = tocEntry.getContentInfo();
                    ci.setFilePath(path);
                    FileContentInfo cir = tocEntry.getContentInfo2();
                    cir.setFilePath(path);
                    return_value.setProperty(MAIN_CONTENT_INFO, ci);
                    return_value.setProperty(SECONDARY_CONTENT_INFO, cir);
                }
            }
        }
        catch (Exception e) {
            log.debug(e);
        }
        return return_value;
    }

    @Override
    public IContentRepository getContentRepository(IContent content) {
        IContentRepository return_value = null;
        if (content != null && content.getLocation() != null && (return_value = this.findSubRepository(content, content.getLocation().getName(), content.getLocation().removeLastSegment())) != null) {
            return_value.registerListener(this);
        }
        return return_value;
    }

    @Override
    public IStatus resolve(IOfferingOrFix element, IProgressMonitor progressMonitor) {
        SplitProgressMonitor pm = new SplitProgressMonitor(progressMonitor).split(50, 1);
        List units = this.getAllShareableEntities(pm.next());
        units.addAll(this.getAllSuFragments(pm.next()));
        if (units.size() > 0) {
            return CicResolver.resolve(element, units);
        }
        String str = this.getLP().getFQTopSeDirPath().toString();
        IStatus return_value = RepositoryStatus.createErrorStatus(Messages.Repo_OfferingShareableEntitiesCantBeFound, element.getName(), str, 6058, log);
        return return_value;
    }

    protected void setLayoutPolicy(LayoutPolicy layoutPolicy) {
        this.layoutPolicy = layoutPolicy;
    }

    public LayoutPolicy getLP() {
        return this.layoutPolicy;
    }

    protected void setArtifactRepository(AbstractReadArtifactRepo artifactRepository) {
        this.artifactRepository = artifactRepository;
    }

    protected AbstractReadArtifactRepo getArtifactRepository() {
        return this.artifactRepository;
    }

    @Override
    public Object getAdapter(Class adapter) {
        Object return_value = this.artifactRepository != null ? this.artifactRepository.getAdapter(adapter) : null;
        return return_value != null ? return_value : super.getAdapter(adapter);
    }

    @Override
    public boolean hasArtifactToc(IArtifactSession session, IProgressMonitor monitor) throws CoreException {
        return this.artifactRepository != null ? this.artifactRepository.hasArtifactToc(session, monitor) : false;
    }

    @Override
    public IReadArtifactRepo.IArtifactToc readArtifactToc(IArtifactSession session, IProgressMonitor monitor) throws CoreException {
        return this.artifactRepository != null ? this.artifactRepository.readArtifactToc(session, monitor) : null;
    }

    @Override
    public IReadArtifactRepo.IArtifactToc readCachedArtifactToc(IArtifactSession session, IPath tocCache, IProgressMonitor monitor) throws CoreException {
        return this.artifactRepository != null ? this.artifactRepository.readCachedArtifactToc(session, tocCache, monitor) : null;
    }

    @Override
    public IReadArtifactRepo.IArtifactTocCapabilities getArtifactTocCapabilities() {
        return this.artifactRepository != null ? this.artifactRepository.getArtifactTocCapabilities() : null;
    }

    @Override
    public IStatus unsetUpdateOffering(IOffering updateOffering) {
        this.m_updateOfferingHandler.unsetUpdateOffering(updateOffering);
        if (updateOffering instanceof IOfferingReference) {
            IOfferingReference ref = (IOfferingReference)updateOffering;
            ref.unsetUpdate();
            ref.addToSiteProperties(this.getSiteProperties());
        }
        return this.getSiteProperties().save();
    }

    @Override
    public void dispose() {
        RepositoryPool.getDefault().getFileCacheManager().resetPathTreeWithNoTimout(this.getLocation());
        super.dispose();
    }

    @Override
    public IStatus getStatus(boolean reEvaluate, IProgressMonitor progressMonitor) {
        if (reEvaluate) {
            RepositoryGroup.getDefault().getFileCacheManager().resetPathTree(this.getLocation());
        }
        this.setStatus(this.getSiteProperties().exists(reEvaluate, super.getStatus(false, progressMonitor), this.getDownloader(), progressMonitor));
        return super.getStatus(false, progressMonitor);
    }

    @Override
    public IStatus canAddExistingRepository(IProgressMonitor progressMonitor) {
        LinkedProperties properties;
        IStatus return_value = super.canAddExistingRepository(progressMonitor);
        if (return_value.isOK() && (properties = this.getSiteProperties().getProperties()) != null) {
            IStatus stat = this.getRepositoryInfo().getRepositoryReportedStatus();
            if (stat != null && stat.getSeverity() == 4) {
                return_value = stat;
            }
            if (return_value.isOK()) {
                IStatus statusCheckContext = RepositoryContext.getInstance().checkRequiredContext(this.getRepositoryInfo(), properties);
                if (statusCheckContext.matches(4)) {
                    return_value = statusCheckContext;
                } else if (statusCheckContext.matches(2)) {
                    log.status(statusCheckContext);
                }
            }
        }
        return return_value;
    }

    @Override
    protected IStatus doCreateRepository() {
        return this.getLP().setDefaultSiteInformation();
    }

    protected RepositoryUpdateOfferingHandler getUpdatesHandler() {
        return this.m_updateOfferingHandler;
    }

    protected IStatus exportZippedP2Repository(IZipFileHandler zipFileHandler, File destinationFile) {
        if (!this.containsP2Repository(null)) {
            return RepositoryStatus.createErrorStatus(Messages.Repo_CantExportP2RepositoryNoRepository, this, 6076, log);
        }
        if (!FileUtil.ensureDestinationDirectory(destinationFile)) {
            return RepositoryStatus.createErrorStatus(Messages.Repo_CantExportP2RepositoryBadDestination, destinationFile != null ? destinationFile.getAbsolutePath() : "null", this, 6077, log);
        }
        return zipFileHandler.export(this.getLP().getRelativeP2FilePath().toString(), destinationFile);
    }

    @Override
    public IStatus exportP2Repository(File destinationFile, IProgressMonitor monitor) {
        IStatus return_value = null;
        SplitProgressMonitor pm = new SplitProgressMonitor(monitor, 2);
        File p2RepositoryFile = this.getP2RepositoryFile(pm.next());
        if (p2RepositoryFile != null && p2RepositoryFile.exists()) {
            if (FileUtil.ensureDestinationDirectory(destinationFile)) {
                try {
                    FileUtil.copyFile(p2RepositoryFile, destinationFile, pm.next());
                    return_value = Status.OK_STATUS;
                }
                catch (FileNotFoundException e) {
                    return_value = RepositoryStatus.createErrorStatus(Messages.Repo_CantExportP2RepositoryNoRepository, this, 6076, log, e);
                }
                catch (IOException e) {
                    return_value = RepositoryStatus.createErrorStatus(Messages.Repo_CantExportP2Repository, this, 6075, log, e);
                }
            } else {
                return_value = RepositoryStatus.createErrorStatus(Messages.Repo_CantExportP2RepositoryBadDestination, destinationFile != null ? destinationFile.getAbsolutePath() : "null", this, 6077, log);
            }
        } else {
            return_value = RepositoryStatus.createErrorStatus(Messages.Repo_CantExportP2RepositoryNoRepository, this, 6076, log);
        }
        pm.done();
        return return_value;
    }

    @Override
    public boolean containsP2Repository(IProgressMonitor monitor) {
        File file = this.getP2RepositoryFile(monitor);
        return file != null && file.exists();
    }

    @Override
    public IStatus deleteP2Repository(IProgressMonitor monitor) {
        IStatus return_value = this.doDeleteP2Repository(monitor);
        if (return_value != null && return_value.isOK()) {
            this.publishEvent(new RepositoryEventFileRemoved(this, this.getLP().getRelativeP2FilePath()));
        }
        return return_value;
    }

    protected IStatus doDeleteP2Repository(IProgressMonitor monitor) {
        IStatus return_value = null;
        if (this.isWritable()) {
            File destFileLocation = this.getP2RepositoryFile(monitor);
            if (destFileLocation == null || !destFileLocation.exists() || destFileLocation.delete()) {
                return_value = Status.OK_STATUS;
            }
        } else {
            return_value = RepositoryStatus.createErrorStatus(Messages.Repo_CantDeleteP2RepositoryReadOnly, this, 6074, log);
        }
        if (return_value == null) {
            return_value = RepositoryStatus.createErrorStatus(Messages.Repo_CantDeleteP2Repository, this, 6073, log);
        }
        return return_value;
    }

    private File getP2RepositoryFile(IProgressMonitor monitor) {
        File file = null;
        try {
            file = this.m_fcm.getFile(new FileContentInfo(this.getLP().getFQTopP2Path()), false, true, this.getDownloader(), monitor);
        }
        catch (Exception e) {
            ExceptionUtil.debugLogToReview(e);
        }
        return file;
    }

    @Override
    public String[] getNLSFileList() {
        String[] return_value = new String[]{};
        try {
            TableOfContents.Toc toc = TableOfContents.getToc(IDownloadSession.NO_SESSION, this.getLP().getFQTopNLSPath().toURL(), ContentInfo.EMPTY_CONTENT_INFO, (IProgressMonitor)new NullProgressMonitor());
            List fileNames = toc.getFileNames();
            return_value = fileNames.toArray(new String[fileNames.size()]);
        }
        catch (FileNotFoundException e) {
            File dir = this.getLP().getFQTopNLSPath().toFile();
            if (dir.exists()) {
                return_value = dir.list(new FilenameFilter(){

                    @Override
                    public boolean accept(File d, String name) {
                        return name.endsWith(".properties");
                    }
                });
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return return_value;
    }

    @Override
    public InputStream openNLSFileStream(String fileName) throws IOException {
        return this.getInputStream(this.getLP().getRelativeTopNLSDirPath() + fileName);
    }

    protected IStatus doAddNLSFile(String fileName, InputStream source) throws IOException {
        ICicLocation contentFolderPath;
        if (this.isWritable() && this.getStatus(true, null).isOK() && (contentFolderPath = this.getLP().getFQTopNLSPath()) != null) {
            File contentFolder = contentFolderPath.toFile();
            if (!contentFolder.exists()) {
                contentFolder.mkdirs();
            }
            ArrayList<TableOfContents.TocEntry> list = new ArrayList<TableOfContents.TocEntry>(1);
            IContentInfo contentInfo = null;
            list.add(new TableOfContents.TocEntry(fileName, null, contentInfo));
            File destination = new File(contentFolder, fileName);
            FileOutputStream ofs = null;
            try {
                int num;
                ofs = new FileOutputStream(destination);
                byte[] buf = new byte[1024];
                while ((num = source.read(buf, 0, 1024)) != -1) {
                    ofs.write(buf, 0, num);
                }
                TableOfContents.addTocEntries(IDownloadSession.NO_SESSION, contentFolderPath, ContentInfo.EMPTY_CONTENT_INFO, list, null, (IProgressMonitor)new NullProgressMonitor());
                IStatus iStatus = Status.OK_STATUS;
                return iStatus;
            }
            finally {
                try {
                    if (ofs != null) {
                        ofs.close();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return RepositoryStatus.ST_ERROR_REPOSITORY_IS_NOT_WRITABLE;
    }

    @Override
    public IStatus addNLSFile(String fileName, InputStream source) throws IOException {
        IStatus return_value = this.doAddNLSFile(fileName, source);
        if (return_value.isOK()) {
            this.publishEvent(new RepositoryEventFileAdded(this, fileName));
        }
        return return_value;
    }

    @Override
    public IStatus deleteNLSFile(String fileName) throws IOException {
        IStatus return_value = this.doDeleteNLSFile(fileName);
        if (return_value.isOK()) {
            this.publishEvent(new RepositoryEventFileAdded(this, fileName));
        }
        return return_value;
    }

    protected IStatus doDeleteNLSFile(String fileName) throws IOException {
        IStatus return_value = null;
        if (this.isWritable()) {
            File destFileLocation = this.getLP().getFQTopNLSPath().append(fileName).toFile();
            if (destFileLocation == null || !destFileLocation.exists() || destFileLocation.delete()) {
                ArrayList<String> list = new ArrayList<String>(1);
                list.add(fileName);
                TableOfContents.removeTocEntries(IDownloadSession.NO_SESSION, this.getLP().getFQTopNLSPath(), ContentInfo.EMPTY_CONTENT_INFO, list, null, (IProgressMonitor)new NullProgressMonitor());
                return_value = Status.OK_STATUS;
            }
        } else {
            return_value = RepositoryStatus.createErrorStatus(Messages.Repo_CantDeleteNLFileReadOnly, fileName, this, 6081, log);
        }
        if (return_value == null) {
            return_value = RepositoryStatus.createErrorStatus(Messages.Repo_CantDeleteNLFile, fileName, this, 6080, log);
        }
        return return_value;
    }

    protected static class Filter {
        private final Class m_classType;
        private final String m_label;
        String m_allowedFileExtension1;
        String m_allowedFileExtension2;

        Filter(Class a_classType, String label) {
            this.m_classType = a_classType;
            this.m_label = label;
            if (a_classType.isAssignableFrom(IShareableEntity.class)) {
                this.m_allowedFileExtension1 = "assembly";
                this.m_allowedFileExtension2 = "su";
            } else {
                this.m_allowedFileExtension1 = CicConstants.getFileExt(a_classType);
            }
        }

        public boolean acceptableElement(IContent element) {
            return this.m_classType.isInstance(element);
        }

        Class getClassType() {
            return this.m_classType;
        }

        String getLabel() {
            return this.m_label;
        }

        public boolean acceptableFileName(String fileName) {
            String ext;
            int index = fileName.lastIndexOf(46);
            return index > 0 && ((ext = fileName.substring(index + 1)).equals(this.m_allowedFileExtension1) || ext.equals(this.m_allowedFileExtension2));
        }
    }

    private class OfferingsAndUpdateFilter
    extends Filter {
        private final boolean m_isUpdate;
        private final IIdentity m_id;
        private final Version m_version;

        public OfferingsAndUpdateFilter(boolean isUpdate) {
            this(null, null, isUpdate);
        }

        public OfferingsAndUpdateFilter(IIdentity offeringId, Version offeringVersion, boolean isUpdate) {
            super(IOffering.class, Messages.Filter_packages);
            this.m_allowedFileExtension2 = this.m_allowedFileExtension1;
            this.m_allowedFileExtension1 = CicConstants.getJarFileExt();
            this.m_id = offeringId;
            this.m_version = offeringVersion;
            this.m_isUpdate = isUpdate;
        }

        @Override
        public boolean acceptableElement(IContent element) {
            boolean return_value = super.acceptableElement(element);
            if (return_value) {
                IOffering offeringOrUpdate = (IOffering)element;
                boolean bl = return_value = AbstractFileBasedRepository.this.m_updateOfferingHandler.isUpdateOffering(offeringOrUpdate) == this.m_isUpdate;
                if (return_value && this.m_isUpdate) {
                    return_value = AbstractFileBasedRepository.this.m_updateOfferingHandler.updateMatchesIdAndVersion(offeringOrUpdate, this.m_id, this.m_version);
                }
            }
            return return_value;
        }

        @Override
        public boolean acceptableFileName(String fileName) {
            return !fileName.endsWith("_SE.jar") && !fileName.endsWith("_SE.zip") && super.acceptableFileName(fileName) && AbstractFileBasedRepository.this.m_updateOfferingHandler.isUpdateOfferingFile(fileName) == this.m_isUpdate;
        }
    }
}

