/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.model.utils;

import com.ibm.cic.common.core.internal.ComIbmCicCommonCorePlugin;
import com.ibm.cic.common.core.model.IAssembly;
import com.ibm.cic.common.core.model.IContentSelector;
import com.ibm.cic.common.core.model.IIdentity;
import com.ibm.cic.common.core.model.IIncludedShareableEntity;
import com.ibm.cic.common.core.model.IIncludedSuFragment;
import com.ibm.cic.common.core.model.IInstallableUnit;
import com.ibm.cic.common.core.model.IRequiredShareableEntity;
import com.ibm.cic.common.core.model.ISelectableNode;
import com.ibm.cic.common.core.model.ISelectionExpression;
import com.ibm.cic.common.core.model.IShareableEntity;
import com.ibm.cic.common.core.model.IShareableUnit;
import com.ibm.cic.common.core.model.ISuFragment;
import com.ibm.cic.common.core.model.IncludedShareableEntity;
import com.ibm.cic.common.core.model.IncludedShareableEntitySelector;
import com.ibm.cic.common.core.model.internal.IncludedSuFragment;
import com.ibm.cic.common.core.model.internal.InstallationContext;
import com.ibm.cic.common.core.model.internal.Messages;
import com.ibm.cic.common.core.model.utils.SelectorContext;
import com.ibm.cic.common.core.model.utils.TwoTierMap;
import com.ibm.cic.common.core.utils.CicMultiStatus;
import com.ibm.cic.common.core.utils.ICicStatus;
import com.ibm.cic.common.core.utils.NLS;
import com.ibm.cic.common.core.utils.Statuses;
import com.ibm.cic.common.core.utils.UserOptions;
import com.ibm.cic.common.core.utils.Util;
import com.ibm.cic.common.logging.Logger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.osgi.service.resolver.VersionRange;

public class SelectorExpander {
    private static final Logger log = Logger.getLogger(SelectorExpander.class, (Plugin)ComIbmCicCommonCorePlugin.getDefault());
    private static final int ERROR_CODE_RSE_INCOMPATIBLE_WITH_ISE = 1;
    private static final int ERROR_CODE_RSE_TO_IC_RESOLVED_TO_NON_IC = 2;
    private final IShareableEntity rootEntity;
    private final Set<IContentSelector> rootEntitySelectors;
    private final boolean expandSUs;
    private final CicMultiStatus rootStatus;
    private ShareableEntityMap shareableEntities;
    private Set<ISuFragment> suFragments;
    private TwoTierMap installableUnits;
    private IShareableEntity currentEntity;

    public SelectorExpander(IShareableEntity entity, Set<IContentSelector> entitySelectors) {
        this(entity, entitySelectors, true);
    }

    protected SelectorExpander(IShareableEntity entity, Set<IContentSelector> entitySelectors, boolean expandSUs) {
        Assert.isNotNull((Object)entity, (String)" Entity");
        Assert.isNotNull(entitySelectors, (String)" Selectors");
        this.rootEntity = entity;
        this.rootEntitySelectors = entitySelectors;
        this.expandSUs = expandSUs;
        this.rootStatus = Statuses.ST.createMultiStatus();
    }

    public IStatus getExpansionStatus() {
        if (this.rootStatus.isOK()) {
            return Status.OK_STATUS;
        }
        if (this.rootStatus.matches(8)) {
            return Status.CANCEL_STATUS;
        }
        if (this.rootStatus.getMessage().length() == 0) {
            this.rootStatus.setMessage(NLS.bind(Messages.SelectorExpander_Expanding_features, (Object)this.rootEntity.getName()));
        }
        return this.rootStatus;
    }

    public IStatus expand(SelectorContext context, IProgressMonitor monitor) {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        this.currentEntity = null;
        int policy = 3;
        this.installableUnits = this.expandSUs ? new TwoTierMap(8, policy) : null;
        this.shareableEntities = new ShareableEntityMap(8, policy);
        this.suFragments = new LinkedHashSet<ISuFragment>();
        this.selectIf(true, this.rootEntity, this.rootEntitySelectors);
        this.expandShareableEntity(this.rootEntity, context, monitor);
        if (this.expandSUs) {
            this.addFragmentIUs(context);
        }
        log.debug(this);
        return this.getExpansionStatus();
    }

    public IStatus expand(IProgressMonitor monitor) {
        SelectorContext context = new SelectorContext(this.rootEntity, this.rootEntitySelectors);
        return this.expand(context, monitor);
    }

    public final IInstallableUnit[] getIUs() {
        this.checkIUs();
        Collection ius = this.installableUnits.values();
        return ius.toArray(new IInstallableUnit[ius.size()]);
    }

    public final int getIUCount() {
        this.checkIUs();
        return this.installableUnits.values().size();
    }

    public final Collection<ShareableEntityAndSelection> getShareableEntitiesAndSelection() {
        return this.getShareableEntityMap().getValues();
    }

    public final ShareableEntityMap getShareableEntityMap() {
        this.checkExpanded();
        return this.shareableEntities;
    }

    public final Set<ISuFragment> getSuFragments() {
        this.checkExpanded();
        return this.suFragments;
    }

    public String toString() {
        StringBuffer result = new StringBuffer(100);
        result.append(this.rootEntity.getIdentity()).append(' ').append(this.rootEntity.getVersion()).append(": ").append(Util.toSelectorIdString(this.rootEntitySelectors));
        if (this.shareableEntities != null && this.shareableEntities.size() > 0) {
            result.append("\nshareable entities:");
            for (ShareableEntityAndSelection seAndSel : this.getShareableEntitiesAndSelection()) {
                IShareableEntity se = seAndSel.getSE();
                result.append("\n  ").append(se.getIdentity()).append(' ').append(se.getVersion()).append(": ").append(Util.toSelectorIdString(seAndSel.getSelection()));
            }
        }
        if (this.suFragments != null && !this.suFragments.isEmpty()) {
            result.append("\nsuFragments:");
            for (ISuFragment fragment : this.suFragments) {
                result.append("\n  ").append(fragment.getIdentity()).append(' ').append(fragment.getVersion());
            }
        }
        if (this.installableUnits != null && this.installableUnits.size() > 0) {
            result.append("\ninstallable units:");
            Collection ius = this.installableUnits.values();
            for (IInstallableUnit iu : ius) {
                result.append("\n  ").append(iu.getIdentity()).append(' ').append(iu.getVersion());
            }
        }
        return result.toString();
    }

    protected final IInstallableUnit getInstallableUnit(IInstallableUnit iu) {
        this.checkIUs();
        return (IInstallableUnit)this.installableUnits.get(iu.getQualifiedId(), iu.getVersion());
    }

    protected IShareableEntity findShareableEntity(IIncludedShareableEntity ise, IProgressMonitor monitor) {
        return ise.getShareableEntity();
    }

    protected IShareableEntity findShareableEntity(IRequiredShareableEntity rse) {
        this.checkExpanded();
        IIdentity id = rse.getShareableId();
        VersionRange tolerance = rse.getTolerance();
        LinkedList<String> notSatisfiedByAnyIncludes = new LinkedList<String>();
        for (ShareableEntityAndSelection seAndSel : this.shareableEntities.getAll(id)) {
            IShareableEntity includedSE = seAndSel.getSE();
            if (tolerance.isIncluded(includedSE.getVersion())) {
                return includedSE;
            }
            notSatisfiedByAnyIncludes.add(NLS.bind(Messages.SelectorExpander_Required_component_incompatible_with_included_component, this.getContainingEntityInfo(), id, tolerance, includedSE.getVersion()));
        }
        this.reportErrorMessages(notSatisfiedByAnyIncludes);
        return null;
    }

    protected List<IShareableUnit> findTargetSUs(ISuFragment suFragment) {
        LinkedList<IShareableUnit> targetSUs = new LinkedList<IShareableUnit>();
        IIdentity targetSUID = suFragment.getTargetId();
        VersionRange tolerance = suFragment.getTargetTolerance();
        for (ShareableEntityAndSelection seAndSel : this.shareableEntities.getAll(targetSUID)) {
            IShareableEntity includedSE = seAndSel.getSE();
            if (!(includedSE instanceof IShareableUnit) || !tolerance.isIncluded(includedSE.getVersion())) continue;
            targetSUs.add((IShareableUnit)includedSE);
        }
        return targetSUs;
    }

    protected boolean isValid(IShareableEntity child, IShareableEntity parent, IncludedShareableEntity ise) {
        return child != null;
    }

    protected boolean selectIf(boolean assertion, IShareableEntity se, Set<IContentSelector> selectors) {
        if (assertion) {
            return this.getShareableEntityMap().put(se, selectors);
        }
        return se != null && this.getShareableEntityMap().contains(se);
    }

    protected boolean selectIf(boolean assertion, IInstallableUnit iu) {
        this.checkIUs();
        if (assertion) {
            IInstallableUnit existing = this.installableUnits.put(iu.getQualifiedId(), iu.getVersion(), iu);
            return existing == null || existing.getParent().equals(iu.getParent());
        }
        return this.installableUnits.containsKey(iu.getQualifiedId(), iu.getVersion());
    }

    private void expandShareableEntity(IShareableEntity se, SelectorContext context, IProgressMonitor monitor) {
        log.debug("Expanding {0} {1}", se.getIdentity(), se.getVersion());
        IShareableEntity previousEntity = this.currentEntity;
        this.currentEntity = se;
        if (monitor.isCanceled()) {
            this.rootStatus.setCanceled();
        } else if (se instanceof IAssembly) {
            this.expandAssembly((IAssembly)se, context, monitor);
        } else if (se instanceof IShareableUnit) {
            this.expandShareableUnit((IShareableUnit)se, context, monitor);
        } else {
            throw new AssertionError(se);
        }
        this.currentEntity = previousEntity;
    }

    private void expandAssembly(IAssembly asm, SelectorContext context, IProgressMonitor monitor) {
        List children = asm.getChildren();
        SubMonitor sm = SubMonitor.convert((IProgressMonitor)monitor, (int)(1 + 2 * children.size()));
        this.selectDependentSelectors(asm, context, (IProgressMonitor)sm.newChild(1));
        for (ISelectableNode unit : children) {
            if (unit instanceof IIncludedSuFragment) {
                ISuFragment fragment = ((IncludedSuFragment)unit).getSuFragment();
                if (fragment == null) continue;
                this.suFragments.add(fragment);
                continue;
            }
            IncludedShareableEntity ise = (IncludedShareableEntity)unit;
            IShareableEntity se = this.findShareableEntity(ise, (IProgressMonitor)sm.newChild(1));
            Set<IContentSelector> selection = se != null ? this.getShareableEntitySelection(se) : null;
            boolean selectionWasNull = false;
            if (selection == null) {
                selection = new LinkedHashSet<IContentSelector>(4);
                selectionWasNull = true;
            }
            boolean newSelectorsSelected = false;
            if (this.includeAllArtifacts(se, context)) {
                Set selectors = se.getSelectors();
                for (IContentSelector selector : selectors) {
                    if (context.isSelected(se, selector) && selection.contains(selector) || selector.getExpression() != null) continue;
                    newSelectorsSelected = true;
                    context.select(se, selector);
                    selection.add(selector);
                }
            } else {
                Set ises = ise.getIncludedShareableEntitySelectors();
                for (IncludedShareableEntitySelector sel : ises) {
                    IIdentity selectorId = sel.getSelectorId();
                    if (!context.isSelected((IShareableEntity)asm, sel.getExpression()) || !this.isValid(se, asm, ise) || se == null) continue;
                    IContentSelector selector = se.getSelector(selectorId, false);
                    if (selector == null) {
                        this.reportUndefinedSelector(se, selectorId);
                        continue;
                    }
                    if (context.isSelected(se, selector) && selection.contains(selector)) continue;
                    newSelectorsSelected = true;
                    context.select(se, selector);
                    selection.add(selector);
                }
            }
            boolean selected = this.selectIf(selectionWasNull && newSelectorsSelected, se, selection);
            if (!selected || !newSelectorsSelected) continue;
            this.expandShareableEntity(se, context, (IProgressMonitor)sm.newChild(1));
        }
    }

    private boolean includeAllArtifacts(IShareableEntity se, SelectorContext context) {
        if (!(se instanceof IShareableUnit) || !context.includeAllSuArtifacts()) {
            return false;
        }
        IShareableUnit su = (IShareableUnit)se;
        String propVal = su.getProperty("includeAllArtifacts");
        return Boolean.parseBoolean(propVal);
    }

    private void expandShareableUnit(IShareableUnit su, SelectorContext context, IProgressMonitor monitor) {
        if (this.isInstallationContext(su)) {
            return;
        }
        SubMonitor sm = SubMonitor.convert((IProgressMonitor)monitor, (int)2);
        this.selectDependentSelectors(su, context, (IProgressMonitor)sm.newChild(1));
        if (!this.expandSUs) {
            return;
        }
        List children = su.getChildren();
        SubMonitor pm = sm.newChild(1);
        pm.beginTask("", children.size());
        for (IInstallableUnit iu : children) {
            ISelectionExpression selExpr = iu.getExpression();
            this.selectIf(selExpr == null || context.isSelected((IShareableEntity)su, selExpr), iu);
            pm.worked(1);
        }
    }

    protected void addFragmentIUs(SelectorContext context) {
        for (ISuFragment fragment : this.getSuFragments()) {
            List<IShareableUnit> targetSUs = this.findTargetSUs(fragment);
            if (targetSUs.size() > 0) {
                for (IShareableUnit su : targetSUs) {
                    this.addFragmentIUs(context, fragment, su);
                }
                continue;
            }
            this.addFragmentIUs(context, fragment, null);
        }
    }

    private void addFragmentIUs(SelectorContext context, ISuFragment fragment, IShareableUnit targetSU) {
        List fragmentIUs = fragment.getChildren();
        for (IInstallableUnit iu : fragmentIUs) {
            this.selectIf(context.isSelected(targetSU, fragment, iu.getExpression()), iu);
        }
    }

    private void checkIUs() {
        this.checkExpanded();
        if (this.installableUnits == null) {
            throw new IllegalStateException("expandSUs is not set");
        }
    }

    private void checkExpanded() {
        if (this.shareableEntities == null) {
            throw new IllegalStateException("expand() has not yet been called");
        }
    }

    private void selectDependentSelectors(IShareableEntity se, SelectorContext context, IProgressMonitor monitor) {
        Set selectors = se.getSelectors();
        SubMonitor sm = SubMonitor.convert((IProgressMonitor)monitor, (int)selectors.size());
        for (IContentSelector sel : selectors) {
            if (!context.isSelected(se, sel)) continue;
            this.selectDependentSelectors(se, context, sel, (IProgressMonitor)sm.newChild(1));
        }
    }

    private void selectDependentSelectors(IShareableEntity se, SelectorContext context, IContentSelector selector, IProgressMonitor monitor) {
        SubMonitor sm = SubMonitor.convert((IProgressMonitor)monitor, (int)2);
        Set<IContentSelector> currSelection = this.getShareableEntitySelection(se);
        if (currSelection == null) {
            currSelection = new HashSet<IContentSelector>();
        }
        currSelection.add(selector);
        boolean success = this.processInternalSelections(se, context, currSelection, selector.getInternalSelections(), (IProgressMonitor)sm.newChild(1));
        if (!success) {
            currSelection.remove(selector);
            context.deselect(se, selector);
            if (currSelection.isEmpty()) {
                this.getShareableEntityMap().remove(se);
            }
        } else {
            this.selectReqdShareableEntities(context, selector.getRequiredShareableEntities(), (IProgressMonitor)sm.newChild(1));
        }
    }

    private boolean processInternalSelections(IShareableEntity se, SelectorContext context, Set<IContentSelector> currSelection, Set<IContentSelector> internalSelection, IProgressMonitor monitor) {
        SubMonitor sm = SubMonitor.convert((IProgressMonitor)monitor, (int)internalSelection.size());
        for (IContentSelector depSel : internalSelection) {
            if (context.isSelected(se, depSel) || depSel.getExpression() == null) continue;
            return false;
        }
        for (IContentSelector depSel : internalSelection) {
            if (context.isSelected(se, depSel)) continue;
            context.select(se, depSel);
            currSelection.add(depSel);
            this.selectDependentSelectors(se, context, depSel, (IProgressMonitor)sm.newChild(1));
        }
        return true;
    }

    private void selectReqdShareableEntities(SelectorContext context, Set<IRequiredShareableEntity> reqdSEs, IProgressMonitor monitor) {
        SubMonitor sm = SubMonitor.convert((IProgressMonitor)monitor, (int)reqdSEs.size());
        for (IRequiredShareableEntity rse : reqdSEs) {
            IShareableEntity se = this.findShareableEntity(rse);
            if (se == null) continue;
            if (rse.requiresInstallationContext()) {
                this.ensureInstallationContextSE(rse, se);
                continue;
            }
            this.selectAndExpandAsNeeded(se, rse.getSelectorIds(), context, (IProgressMonitor)sm.newChild(1));
        }
    }

    private void reportErrorMessages(List<String> errMessages) {
        for (String errMsg : errMessages) {
            this.addError(1, errMsg);
        }
    }

    private String getContainingEntityInfo() {
        return this.getEntityInfo(this.currentEntity != null ? this.currentEntity : this.rootEntity);
    }

    private String getEntityInfo(IShareableEntity se) {
        return NLS.bind("{0} \"{1} {2}\"", se instanceof IAssembly ? "assembly" : "su", se.getIdentity(), se.getVersion());
    }

    private boolean ensureInstallationContextSE(IRequiredShareableEntity rse, IShareableEntity resolvedSE) {
        if (!this.isInstallationContext(resolvedSE)) {
            this.addError(2, NLS.bind(Messages.SelectorExpander_RSE_to_Install_context_resolved_to_wrong_SE, this.getContainingEntityInfo(), rse.getShareableId(), this.getEntityInfo(resolvedSE)));
            return false;
        }
        return true;
    }

    protected boolean selectAndExpandAsNeeded(IShareableEntity se, Set<IIdentity> selectorIds, SelectorContext context, IProgressMonitor monitor) {
        SubMonitor sm = SubMonitor.convert((IProgressMonitor)monitor, (int)(2 * selectorIds.size()));
        Set<IContentSelector> selection = this.getShareableEntitySelection(se);
        boolean newSelectorsSelected = false;
        boolean selectionWasNull = false;
        if (selection == null) {
            selection = new LinkedHashSet<IContentSelector>(4);
            selectionWasNull = true;
        }
        if (!this.selectIf(selectionWasNull && !selectorIds.isEmpty(), se, selection)) {
            return false;
        }
        for (IIdentity selId : selectorIds) {
            IContentSelector sel = se.getSelector(selId, false);
            if (sel == null) {
                this.reportUndefinedSelector(se, selId);
                continue;
            }
            if (context.isSelected(se, sel) && selection.contains(sel)) continue;
            newSelectorsSelected = true;
            selection.add(sel);
            context.select(se, sel);
            this.selectDependentSelectors(se, context, sel, (IProgressMonitor)sm.newChild(1));
        }
        if (newSelectorsSelected) {
            this.expandShareableEntity(se, context, (IProgressMonitor)sm.newChild(selectorIds.size()));
            return true;
        }
        return false;
    }

    private Set<IContentSelector> getShareableEntitySelection(IShareableEntity se) {
        return this.getShareableEntityMap().get(se);
    }

    private boolean isInstallationContext(IShareableEntity se) {
        return se instanceof InstallationContext && ((InstallationContext)se).definesAnInstallationContext();
    }

    private void reportUndefinedSelector(IShareableEntity se, IIdentity selId) {
        this.addError(0, NLS.bind(Messages.SelectorExpander_Undefined_selector, selId, se.getIdentity(), se.getVersion(), this.currentEntity));
    }

    private void addError(int code, String msg) {
        int severity = UserOptions.CIC_EXPANDER_ALLOW_ERRORS.isSet() ? 2 : 4;
        ICicStatus status = Statuses.ST.createStatus(severity, code, null, msg, new Object[0]);
        this.rootStatus.add(status);
        log.debug(status);
    }

    public static final class ShareableEntityAndSelection {
        private final IShareableEntity se;
        private final Set<IContentSelector> selection;

        public ShareableEntityAndSelection(IShareableEntity se, Set<IContentSelector> selection) {
            this.se = se;
            this.selection = selection;
        }

        public IShareableEntity getSE() {
            return this.se;
        }

        public Set<IContentSelector> getSelection() {
            return this.selection;
        }

        public String toString() {
            return String.valueOf(this.se.getIdentity().toString()) + ' ' + this.se.getVersion() + ": " + Util.toSelectorIdString(this.selection);
        }
    }

    public static final class ShareableEntityMap {
        private final TwoTierMap map;

        ShareableEntityMap(int initialCapacity, int policy) {
            this.map = new TwoTierMap(initialCapacity, policy);
        }

        public String toString() {
            if (this.size() == 0) {
                return "(empty)";
            }
            StringBuilder sb = new StringBuilder(64 * this.size());
            Set entries = this.map.entrySet();
            for (Map.Entry entry : entries) {
                sb.append("  ").append(entry.getKey());
                Map inner = entry.getValue();
                String sep = inner.size() < 2 ? " " : "\n    ";
                for (Map.Entry innerEntry : inner.entrySet()) {
                    sb.append(sep).append(innerEntry.getKey()).append(": ");
                    sb.append(Util.toSelectorIdString(((ShareableEntityAndSelection)innerEntry.getValue()).getSelection()));
                }
                sb.append('\n');
            }
            sb.setLength(sb.length() - 1);
            return sb.toString();
        }

        public int size() {
            return this.map.size();
        }

        public boolean contains(IShareableEntity se) {
            return this.map.containsKey(se.getIdentity(), se.getVersion());
        }

        public Set<IContentSelector> get(IShareableEntity se) {
            ShareableEntityAndSelection seAndSel = (ShareableEntityAndSelection)this.map.get(se.getIdentity(), se.getVersion());
            return seAndSel == null ? null : seAndSel.selection;
        }

        boolean put(IShareableEntity se, Set<IContentSelector> selectors) {
            if (selectors.equals(this.get(se))) {
                return true;
            }
            return this.map.put(se.getIdentity(), se.getVersion(), new ShareableEntityAndSelection(se, selectors)) == null;
        }

        ShareableEntityAndSelection remove(IShareableEntity se) {
            return (ShareableEntityAndSelection)this.map.remove(se.getIdentity(), se.getVersion());
        }

        public Collection<ShareableEntityAndSelection> getAll(IIdentity id) {
            return this.map.getAll(id);
        }

        Collection<ShareableEntityAndSelection> getValues() {
            return this.map.values();
        }

        public Collection<IRequiredShareableEntity> getRequiredShareableEntities() {
            ArrayList<IRequiredShareableEntity> result = new ArrayList<IRequiredShareableEntity>();
            for (ShareableEntityAndSelection entry : this.getValues()) {
                for (IContentSelector selector : entry.getSelection()) {
                    result.addAll(selector.getRequiredShareableEntities());
                }
            }
            return result;
        }
    }
}

