/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.model.internal;

import com.ibm.cic.common.core.model.IIdentity;
import com.ibm.cic.common.core.model.IOfferingIncludes;
import com.ibm.cic.common.core.utils.XMLUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.osgi.framework.Version;

public class OfferingIncludes
implements IOfferingIncludes {
    private final String profileId;
    private final String profileDir;
    private List<IOfferingIncludes.IOfferingInProfile> offeringsInProfile = Collections.emptyList();

    public OfferingIncludes(String profileId, String profileDir) {
        this.profileId = profileId;
        this.profileDir = profileDir;
    }

    public String toString() {
        return XMLUtil.simpleElement("includes-profile", new String[]{"id", this.profileId});
    }

    @Override
    public String getProfileId() {
        return this.profileId;
    }

    @Override
    public String getProfileDir() {
        return this.profileDir;
    }

    @Override
    public List<IOfferingIncludes.IOfferingInProfile> getOfferingsInProfile() {
        return this.offeringsInProfile.isEmpty() ? this.offeringsInProfile : Collections.unmodifiableList(this.offeringsInProfile);
    }

    public void addOfferingInProfile(IOfferingIncludes.IOfferingInProfile offeringInProfile) {
        if (this.offeringsInProfile.isEmpty()) {
            this.offeringsInProfile = new ArrayList<IOfferingIncludes.IOfferingInProfile>(4);
        }
        this.offeringsInProfile.add(offeringInProfile);
    }

    public static class OfferingInProfile
    implements IOfferingIncludes.IOfferingInProfile {
        private final IOfferingIncludes.IOfferingInProfile.Kind kind;
        private final IIdentity id;
        private final Version minVersion;
        private final Version maxVersion;
        private String name;
        private String minUserVersion;
        private String maxUserVersion;

        public OfferingInProfile(IOfferingIncludes.IOfferingInProfile.Kind kind, IIdentity id, Version minVersion, Version maxVersion) {
            this.kind = kind;
            this.id = id;
            this.minVersion = minVersion;
            this.maxVersion = maxVersion;
            this.name = null;
            this.minUserVersion = null;
            this.maxUserVersion = null;
        }

        public String toString() {
            return XMLUtil.simpleElement("includes-offering", new String[]{"id", this.id.toString(), "kind", this.kind.toString(), "minVersion", this.minVersion.toString(), "maxVersion", this.maxVersion.toString()});
        }

        public void setInfo(String name, String minUserVersion, String maxUserVersion) {
            this.name = name;
            this.minUserVersion = minUserVersion;
            this.maxUserVersion = maxUserVersion;
        }

        @Override
        public IOfferingIncludes.IOfferingInProfile.Kind getKind() {
            return this.kind;
        }

        @Override
        public IIdentity getIdentity() {
            return this.id;
        }

        @Override
        public Version getMinVersion() {
            return this.minVersion;
        }

        @Override
        public Version getMaxVersion() {
            return this.maxVersion;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getMinUserVersion() {
            return this.minUserVersion;
        }

        @Override
        public String getMaxUserVersion() {
            return this.maxUserVersion;
        }
    }
}

