/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.model.internal;

import com.ibm.cic.common.core.model.IFix;
import com.ibm.cic.common.core.model.IFixApplicableOffering;
import com.ibm.cic.common.core.model.IFixCategory;
import com.ibm.cic.common.core.model.IIdentity;
import com.ibm.cic.common.core.model.IOffering;
import com.ibm.cic.common.core.model.IProblemsResolved;
import com.ibm.cic.common.core.model.internal.FixApplicableOffering;
import com.ibm.cic.common.core.model.internal.IFixInternal;
import com.ibm.cic.common.core.model.internal.OfferingOrFix;
import com.ibm.cic.common.core.utils.NLS;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.osgi.service.resolver.VersionRange;
import org.osgi.framework.Version;

public class Fix
extends OfferingOrFix
implements IFix,
IFixInternal {
    private IIdentity offeringId;
    private Version offeringVersion;
    private IOffering offering;
    private ArrayList applicableOfferings;
    private ArrayList categories;
    private transient boolean resolved = false;

    public Fix(IIdentity id, Version version) {
        super(id, version);
    }

    @Override
    @Deprecated
    public IOffering getOffering() {
        return this.offering;
    }

    @Override
    @Deprecated
    public void setOffering(IOffering offering) {
        this.offering = offering;
    }

    @Override
    @Deprecated
    public IIdentity getOfferingId() {
        return this.offering != null ? this.offering.getIdentity() : this.offeringId;
    }

    @Override
    @Deprecated
    public void setOfferingId(IIdentity id) {
        this.offeringId = id;
    }

    @Override
    @Deprecated
    public Version getOfferingVersion() {
        return this.offering != null ? this.offering.getVersion() : this.offeringVersion;
    }

    @Override
    public IIdentity getInternalOfferingId() {
        return this.getOfferingId();
    }

    @Override
    public Version getInternalOfferingVersion() {
        return this.getOfferingVersion();
    }

    @Override
    public void setInternalOfferingId(IIdentity offeringId) {
        this.setOfferingId(offeringId);
    }

    @Override
    public void setInternalOfferingVersion(Version version) {
        this.setOfferingVersion(version);
    }

    @Override
    @Deprecated
    public void setOfferingVersion(Version version) {
        this.offeringVersion = version;
    }

    @Override
    public boolean isEnhancedFix() {
        return this.offeringId == null && this.offering == null;
    }

    @Override
    public void addProblemsResolved(IProblemsResolved problemsResolved) {
        if (!this.isEnhancedFix()) {
            throw new IllegalStateException(NLS.bind("Fix {0} does not support listing problems resolved. Only enhanced fixes do.", (Object)this));
        }
        super.addProblemsResolved(problemsResolved);
    }

    @Override
    public void addApplicableOffering(IFixApplicableOffering applicableOffering) {
        if (!this.isEnhancedFix()) {
            throw new IllegalStateException(NLS.bind("Fix {0} does not support applicable offerings. Only enhanced fixes do.", (Object)this));
        }
        if (this.applicableOfferings == null) {
            this.applicableOfferings = new ArrayList(3);
        }
        this.applicableOfferings.add(applicableOffering);
    }

    @Override
    public List getApplicableOfferings() {
        if (this.applicableOfferings == null) {
            if (this.isEnhancedFix()) {
                return Collections.EMPTY_LIST;
            }
            FixApplicableOffering applicableOffering = new FixApplicableOffering(this.getOfferingId(), new VersionRange(this.getOfferingVersion(), true, this.getOfferingVersion(), true));
            return Collections.singletonList(applicableOffering);
        }
        return Collections.unmodifiableList(this.applicableOfferings);
    }

    @Override
    public void addCategory(IFixCategory category) {
        if (!this.isEnhancedFix()) {
            throw new IllegalStateException(NLS.bind("Fix {0} does not support categories. Only enhanced fixes do.", (Object)this));
        }
        if (this.categories == null) {
            this.categories = new ArrayList();
        }
        this.categories.add(category);
    }

    @Override
    public List getCategories() {
        if (this.categories == null) {
            return Collections.EMPTY_LIST;
        }
        return Collections.unmodifiableList(this.categories);
    }

    @Override
    public boolean isResolved() {
        return this.resolved;
    }

    @Override
    public void setResolved(boolean resolved) {
        this.resolved = resolved;
    }
}

