/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.model.internal;

import com.ibm.cic.common.core.internal.ComIbmCicCommonCorePlugin;
import com.ibm.cic.common.core.internal.utils.CicConstants;
import com.ibm.cic.common.core.internal.utils.UniqueFeatureIdGenerator;
import com.ibm.cic.common.core.model.CicFactory;
import com.ibm.cic.common.core.model.FeatureKind;
import com.ibm.cic.common.core.model.IAssembly;
import com.ibm.cic.common.core.model.IBuildDataElement;
import com.ibm.cic.common.core.model.IBuilderDataOwner;
import com.ibm.cic.common.core.model.ICicResolver;
import com.ibm.cic.common.core.model.IContent;
import com.ibm.cic.common.core.model.IFeature;
import com.ibm.cic.common.core.model.IFeatureGroup;
import com.ibm.cic.common.core.model.IFix;
import com.ibm.cic.common.core.model.IFixApplicableOffering;
import com.ibm.cic.common.core.model.IFixCategory;
import com.ibm.cic.common.core.model.IIdentity;
import com.ibm.cic.common.core.model.IIncludedShareableEntity;
import com.ibm.cic.common.core.model.IIncludedSuFragment;
import com.ibm.cic.common.core.model.IInstallableUnit;
import com.ibm.cic.common.core.model.IInstallableUnitContainer;
import com.ibm.cic.common.core.model.IInstallableUnitSelector;
import com.ibm.cic.common.core.model.IInstallationContext;
import com.ibm.cic.common.core.model.IOffering;
import com.ibm.cic.common.core.model.IOfferingIncludes;
import com.ibm.cic.common.core.model.IOfferingOrFix;
import com.ibm.cic.common.core.model.IParseInfoStore;
import com.ibm.cic.common.core.model.IProblemResolved;
import com.ibm.cic.common.core.model.IProblemsResolved;
import com.ibm.cic.common.core.model.ISelectionExpression;
import com.ibm.cic.common.core.model.ISelectionExpressionContainer;
import com.ibm.cic.common.core.model.IShareableEntitySelector;
import com.ibm.cic.common.core.model.IShareableUnit;
import com.ibm.cic.common.core.model.ISuFragment;
import com.ibm.cic.common.core.model.ISuFragmentSelector;
import com.ibm.cic.common.core.model.IncludedShareableEntity;
import com.ibm.cic.common.core.model.IncludedShareableEntitySelector;
import com.ibm.cic.common.core.model.Information;
import com.ibm.cic.common.core.model.InstallationContextScope;
import com.ibm.cic.common.core.model.PredefinedSelectors;
import com.ibm.cic.common.core.model.SimpleIdentity;
import com.ibm.cic.common.core.model.adapterdata.ArtifactCommonAttributes;
import com.ibm.cic.common.core.model.adapterdata.CommonAdapterData;
import com.ibm.cic.common.core.model.adapterdata.IAdapterData;
import com.ibm.cic.common.core.model.adapterdata.IAdapterDataParser;
import com.ibm.cic.common.core.model.adapterdata.IArtifact;
import com.ibm.cic.common.core.model.adapterdata.IErrorReporter;
import com.ibm.cic.common.core.model.build.internal.BuilderData;
import com.ibm.cic.common.core.model.build.internal.BuilderDataElement;
import com.ibm.cic.common.core.model.internal.AbstractFeatureBase;
import com.ibm.cic.common.core.model.internal.CicResolver;
import com.ibm.cic.common.core.model.internal.ContentSelector;
import com.ibm.cic.common.core.model.internal.DigestAttributes;
import com.ibm.cic.common.core.model.internal.IFixInternal;
import com.ibm.cic.common.core.model.internal.IXMLConstants;
import com.ibm.cic.common.core.model.internal.InstallableUnitSelector;
import com.ibm.cic.common.core.model.internal.Messages;
import com.ibm.cic.common.core.model.internal.Offering;
import com.ibm.cic.common.core.model.internal.OfferingIncludes;
import com.ibm.cic.common.core.model.internal.RequiredShareableEntity;
import com.ibm.cic.common.core.model.internal.SelectionExpression;
import com.ibm.cic.common.core.model.internal.SelectionOperator;
import com.ibm.cic.common.core.model.internal.ShareableEntitySelector;
import com.ibm.cic.common.core.model.internal.Util;
import com.ibm.cic.common.core.utils.MetaInfo;
import com.ibm.cic.common.core.utils.NLS;
import com.ibm.cic.common.core.utils.Ref;
import com.ibm.cic.common.core.utils.VersionUtil;
import com.ibm.cic.common.core.utils.XMLParser;
import com.ibm.cic.common.core.utils.XMLUtil;
import com.ibm.cic.common.downloads.IMutableContentInfo;
import com.ibm.cic.common.downloads.SizeInfo;
import com.ibm.cic.common.logging.Logger;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.osgi.service.resolver.VersionRange;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Version;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.DefaultHandler;

public class CICParser
extends XMLParser
implements IXMLConstants,
IErrorReporter {
    private static final Logger log = Logger.getLogger(CICParser.class, (Plugin)ComIbmCicCommonCorePlugin.getDefault());
    private SAXParser parser = null;
    private static final int IGNORED_ELEMENT_STATE = 0;
    private static final int NO_CONTENT_STATE = 1;
    private static final int INITIAL_STATE = 2;
    private static final int OFFERING_STATE = 3;
    private static final int ASSEMBLY_STATE = 4;
    private static final int SHAREABLE_UNIT_STATE = 5;
    private static final int INSTALLATION_CONTEXT_STATE = 6;
    private static final int INSTALLABLE_UNIT_STATE = 7;
    private static final int ADAPTER_SPECIFIC_DATA_STATE = 8;
    private static final int SELECTOR_STATE = 9;
    private static final int REQUIRED_SHAREABLE_ENTITY_STATE = 10;
    private static final int INCLUDED_SHAREABLE_ENTITY_STATE = 11;
    private static final int INCLUDED_SELECTOR_STATE = 12;
    private static final int INFORMATION_STATE = 13;
    private static final int FEATURE_GROUP_STATE = 14;
    private static final int FEATURE_STATE = 15;
    private static final int FEATURE_KIND_STATE = 16;
    private static final int ARTIFACT_STATE = 17;
    private static final int FIX_STATE = 18;
    private static final int SELECTED_BY_EXPR_STATE = 19;
    private static final int SEL_EXPR_OP_AND_STATE = 20;
    private static final int SEL_EXPR_OP_OR_STATE = 21;
    private static final int SEL_EXPR_OP_XOR_STATE = 22;
    private static final int SEL_EXPR_OP_NOT_STATE = 23;
    private static final int SU_FRAGMENT_STATE = 24;
    private static final int INCLUDED_SU_FRAGMENT_STATE = 25;
    private static final int ENHANCED_FIX_STATE = 26;
    private static final int OFFERING_RESOLVES_STATE = 27;
    private static final int FIX_RESOLVES_STATE = 28;
    private static final int FIX_APPLICABILITY_STATE = 29;
    private static final int FIX_CATEGORIES_STATE = 30;
    private static final int OFFERING_INCLUDES_STATE = 31;
    private static final int OFFERING_INCLUDES_PROFILE_STATE = 32;
    private static final int OFFERING_INCLUDES_PROFILE_OFFERING_STATE = 33;
    private static final int BUILDER_CONTENT_STATE = 34;
    private static final int DUMMY_LAST_STATE = 35;
    private static final String[] STATE_NAMES = new String[]{"IGNORED", "NO CONTENT", "INITIAL", "offering", "assembly", "su", "installContext", "iu", "adapterSpecificData", "selector", "requiredShareableEntity", "includedShareableEntity", "includedSelector", "information", "featureGroup", "feature", "kind", "artifact", "fix", "selectedByExpression", "and", "or", "xor", "not", "suFragment", "includedSuFragment", "enhanced-fix", "offering-resolves", "fix-resolves", "applicability", "categories", "includes", "profile", "offering", "builder data"};
    private static final Version VER_SANS_FEATURE_ID = new Version(0, 0, 2);
    private ICicResolver parserInfoResolver;
    private String rootUnit = null;
    private String fileName;
    private String fileFullName;
    private UniqueFeatureIdGenerator ufidGen;
    private boolean relaxedValidation = false;
    private boolean includeBuildData;

    public CICParser(BundleContext context) {
        super(context, ComIbmCicCommonCorePlugin.getPluginId());
    }

    public void setIncludeBuildData(boolean value) {
        this.includeBuildData = value;
    }

    @Override
    protected Logger getLogger() {
        return log;
    }

    @Override
    protected Object getRootObject() {
        return this.rootUnit;
    }

    @Override
    protected synchronized String getErrorPrefix() {
        if (this.fileName == null) {
            return null;
        }
        return String.valueOf(this.fileName) + ": ";
    }

    @Override
    protected synchronized String getErrorSuffix() {
        if (this.fileFullName == null) {
            return null;
        }
        return String.valueOf(Logger.NEWLINE) + "\t(" + this.fileFullName + ")";
    }

    @Override
    protected String getErrorMessage() {
        return Messages.CICParser_error_parsing_meta_data;
    }

    @Override
    protected String processCharacters(String trimmedChars) {
        switch (this.peekState()) {
            case 8: {
                this.peekObject(IAdapterDataParser.class).characters(trimmedChars);
                break;
            }
            case 13: {
                this.peekObject(Information.class).setDescription(trimmedChars);
                break;
            }
            case 34: {
                this.peekObject(IBuildDataElement.class).setValue(trimmedChars);
                break;
            }
            case 0: {
                break;
            }
            default: {
                this.unexpectedCharacterData(trimmedChars);
            }
        }
        return trimmedChars;
    }

    public synchronized ICicResolver parseAll(File dir) {
        this.parserInfoResolver = new CicResolver(this);
        this.status = null;
        this.rootUnit = null;
        File[] files = dir.listFiles();
        if (files != null) {
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                try {
                    this.fileName = file.getName();
                    this.fileFullName = file.getAbsolutePath();
                    this.parse(new FileInputStream(file));
                }
                catch (Exception e) {
                    this.addError(Messages.CICParser_error_parsing, file, e.getMessage());
                }
                ++n2;
            }
        }
        this.parserInfoResolver.resolve(true);
        return this.parserInfoResolver;
    }

    public synchronized ICicResolver parseJar(File jarFile) throws IOException {
        this.rootUnit = null;
        this.fileName = jarFile.getName();
        this.fileFullName = jarFile.getAbsolutePath();
        this.parserInfoResolver = new CicResolver(this);
        this.status = null;
        try (ZipFile zf = new ZipFile(jarFile);){
            Enumeration<? extends ZipEntry> entries = zf.entries();
            while (entries.hasMoreElements()) {
                ZipEntry ze = entries.nextElement();
                if (!CicConstants.fileMatchesDEFAULT_EXTENSIONS(ze.getName())) continue;
                try {
                    this.parse(zf.getInputStream(ze));
                }
                catch (Exception e) {
                    this.addError(Messages.CICParser_error_parsing_jar, ze.getName(), jarFile, e.getMessage());
                }
            }
        }
        this.parserInfoResolver.resolve(true);
        return this.parserInfoResolver;
    }

    public synchronized IContent parse(InputStream in, String filePath) throws SAXException, IOException, ParserConfigurationException {
        this.parserInfoResolver = new CicResolver(this);
        this.status = null;
        this.rootUnit = null;
        this.fileName = this.extractFileName(filePath);
        this.fileFullName = filePath;
        this.parse(in);
        this.parserInfoResolver.resolve(false);
        return this.parserInfoResolver.getContent();
    }

    private void parse(InputStream in) throws ParserConfigurationException, SAXException, IOException {
        if (this.parser == null) {
            this.parser = this.getParser();
        }
        this.parser.parse(in, (DefaultHandler)this);
    }

    private String extractFileName(String filePath) {
        if (filePath != null && filePath.length() > 0) {
            int otherSlash = File.separatorChar == '/' ? 92 : 47;
            int slashPos = filePath.lastIndexOf(File.separatorChar);
            int otherSlashPos = filePath.lastIndexOf(otherSlash);
            if (slashPos < 0 && otherSlashPos < 0) {
                return filePath;
            }
            if (slashPos < otherSlashPos) {
                return filePath.substring(otherSlashPos + 1);
            }
            return filePath.substring(slashPos + 1);
        }
        return null;
    }

    @Override
    public void processingInstruction(String target, String data) {
        if ("metadata".equals(target)) {
            Version version = MetaInfo.extractVersion(data);
            this.parserInfoResolver.setMetadataVersion(version);
        } else if ("nonstrict".equals(target)) {
            this.relaxedValidation = true;
        }
    }

    @Override
    public void startDocument() {
        assert (STATE_NAMES.length == 35);
        this.stateStack = new XMLParser.StateStack(STATE_NAMES);
        this.push(2, null);
        this.relaxedValidation = false;
    }

    @Override
    public void endDocument() {
        this.stateStack = null;
    }

    @Override
    public void startElement(String uri, String name, String qName, Attributes attributes) throws SAXParseException {
        this.trace(name, attributes);
        this.finishCharacters();
        if (uri != null && "http://www.ibm.com/cic/build".equals(uri)) {
            this.handleBuilderDataTransition(qName, attributes);
            return;
        }
        switch (this.peekState()) {
            case 0: {
                this.push(0, "error: " + name);
                break;
            }
            case 2: {
                this.handleInitialState(name, attributes);
                break;
            }
            case 3: {
                this.handleOfferingState(name, attributes);
                break;
            }
            case 18: {
                this.handleFixState(name, attributes);
                break;
            }
            case 26: {
                this.handleEnhancedFixState(name, attributes);
                break;
            }
            case 31: {
                this.handleOfferingIncludesState(name, attributes);
                break;
            }
            case 32: {
                this.handleOfferingIncludesProfileState(name, attributes);
                break;
            }
            case 33: {
                this.handleOfferingIncludesProfileOfferingState(name, attributes);
                break;
            }
            case 27: {
                this.handleOfferingResolvesState(name, attributes);
                break;
            }
            case 28: {
                this.handleFixResolvesState(name, attributes);
                break;
            }
            case 29: {
                this.handleApplicabilityState(name, attributes);
                break;
            }
            case 30: {
                this.handleCategoriesState(name, attributes);
                break;
            }
            case 4: {
                this.handleAssemblyState(name, attributes);
                break;
            }
            case 5: {
                this.handleShareableUnitState(name, attributes);
                break;
            }
            case 24: {
                this.handleSuFragmentState(name, attributes);
                break;
            }
            case 6: {
                this.handleInstallationContextState(name, attributes);
                break;
            }
            case 7: {
                this.handleInstallableUnitState(name, attributes);
                break;
            }
            case 8: {
                if (name.equals("artifact") || name.equals("zip")) {
                    this.handleArtifactElement(uri, name, qName, attributes);
                    break;
                }
                IAdapterDataParser p = this.peekObject(IAdapterDataParser.class);
                IAdapterData adapterData = p.getAdapterData();
                int dataIndex = adapterData.getChildCount();
                p.startElement(uri, name, qName, attributes);
                this.setDataLineNumber(adapterData, dataIndex);
                this.push(8, p);
                break;
            }
            case 17: {
                if (name.equals("artifact")) {
                    this.unexpectedElementError(name, attributes);
                    break;
                }
                IAdapterDataParser p = this.peekObject(IAdapterDataParser.class);
                p.startElement(uri, name, qName, attributes);
                this.push(17, p);
                break;
            }
            case 9: {
                this.handleSelectorState(name, attributes);
                break;
            }
            case 10: {
                this.handleRequiredShareableEntityState(name, attributes);
                break;
            }
            case 11: {
                this.handleIncludedShareableEntityState(name, attributes);
                break;
            }
            case 25: {
                this.handleIncludedSuFragmentState(name, attributes);
                break;
            }
            case 12: 
            case 16: {
                this.handleSelExpr(name, attributes);
                break;
            }
            case 14: {
                this.handleFeatureGroupState(name, attributes);
                break;
            }
            case 15: {
                this.handleFeatureState(name, attributes);
                break;
            }
            case 19: {
                this.handleSelExprOp(name, attributes);
                break;
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                this.handleSelExprOpState(name, attributes);
                break;
            }
            case 1: 
            case 13: {
                this.unexpectedElementError(name, attributes);
                break;
            }
            case 34: {
                this.handleBuilderDataState(name, attributes);
                break;
            }
            default: {
                throw new XMLParser.BadStateError(this, name);
            }
        }
        IParseInfoStore infoStore = this.peekObjectOpt(IParseInfoStore.class);
        if (infoStore != null) {
            infoStore.setLineNumber(this.locator.getLineNumber());
        }
    }

    private void setDataLineNumber(IAdapterData adapterData, int dataIndex) {
        int count = adapterData.getChildCount();
        if (dataIndex >= count) {
            return;
        }
        CommonAdapterData data = adapterData.getChild(dataIndex);
        data.setLineNumber(this.getLastCharactersLineNumber());
    }

    @Override
    public void endElement(String uri, String name, String qName) {
        this.trace(name, null);
        this.finishCharacters();
        switch (this.peekState()) {
            case 3: {
                IOffering offering = this.peekObject(IOffering.class);
                this.checkOffering(offering);
                this.parserInfoResolver.addOffering(offering);
                this.parserInfoResolver.addUnresolved(offering);
                break;
            }
            case 18: 
            case 26: {
                IFix fix = this.peekObject(IFix.class);
                this.parserInfoResolver.addFix(fix);
                this.parserInfoResolver.addUnresolved(fix);
                break;
            }
            case 27: 
            case 28: {
                IProblemsResolved resolves = this.peekObject(IProblemsResolved.class);
                this.completeResolvesElement(resolves, this.peekParentObject(IOfferingOrFix.class));
                break;
            }
            case 4: {
                this.parserInfoResolver.addAssembly(this.peekObject(IAssembly.class));
                break;
            }
            case 5: {
                this.parserInfoResolver.addSU(this.peekObject(IShareableUnit.class));
                break;
            }
            case 24: {
                ISuFragment fragment = this.peekObject(ISuFragment.class);
                this.parserInfoResolver.addSuFragment(fragment);
                this.addDefaultSelectionExpression(fragment.getSelectors(), ISelectionExpression.FALSE);
                this.addDefaultSelectionExpression(fragment.getChildren(), ISelectionExpression.FALSE);
                break;
            }
            case 6: {
                this.parserInfoResolver.addSU(this.peekObject(IShareableUnit.class));
                break;
            }
            case 7: {
                this.parserInfoResolver.addIU(this.peekObject(IInstallableUnit.class));
                break;
            }
            case 11: {
                IncludedShareableEntity ise = this.peekObject(IncludedShareableEntity.class);
                this.parserInfoResolver.addUnresolved(ise);
                if (ise.hasIncludedShareableEntitySelectors() || this.relaxedValidation) break;
                this.addError(Messages.CICParser_element_should_have_atleast_one_element, "includedShareableEntity", "includedSelector");
                break;
            }
            case 10: {
                RequiredShareableEntity rse = this.peekObject(RequiredShareableEntity.class);
                if (rse.hasSelectorIds() || this.relaxedValidation) break;
                this.addError(Messages.CICParser_element_should_have_atleast_one_element, "requiredShareableEntity", "requiredSelector");
                break;
            }
            case 25: {
                this.parserInfoResolver.addUnresolved(this.peekObject(IIncludedSuFragment.class));
                break;
            }
            case 8: {
                IAdapterDataParser p = this.peekObject(IAdapterDataParser.class);
                Object parent = this.peekParentObject();
                if (parent instanceof IInstallableUnit) {
                    IInstallableUnit iu = (IInstallableUnit)parent;
                    iu.setAdapterData(p.getAdapterData());
                    break;
                }
                p.endElement(uri, name, qName);
                break;
            }
            case 17: {
                this.peekObject(IAdapterDataParser.class).endArtifact();
                break;
            }
            case 16: {
                this.validateFeatureKind(this.peekObject(ISelectionExpressionContainer.class), this.peekParentObject(AbstractFeatureBase.class));
                break;
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                ISelectionExpression selExpr = this.createSelectionExpression(this.peekObject(SelectionOperator.class));
                if (this.peekParentState() == 19) {
                    this.peekParentObject(Ref.class).set(selExpr);
                    break;
                }
                this.addSelectionExpressionOperand(this.peekParentObject(SelectionOperator.class), selExpr);
                break;
            }
            case 19: {
                this.setSelectionExpression(this.peekParentObject(ISelectionExpressionContainer.class), (ISelectionExpression)this.peekObject(Ref.class).get(), "selectedByExpression");
                break;
            }
        }
        this.pop();
    }

    private void checkOffering(IOffering offering) {
        HashSet<IIdentity> seen = new HashSet<IIdentity>();
        for (IOfferingIncludes include : offering.getIncludes()) {
            for (IOfferingIncludes.IOfferingInProfile offeringInProfile : include.getOfferingsInProfile()) {
                IIdentity id = offeringInProfile.getIdentity();
                if (seen.add(id)) continue;
                this.addError(Messages.CICParser_duplicate_offering_include, id);
            }
        }
    }

    private void addDefaultSelectionExpression(Collection<ISelectionExpressionContainer> containers, ISelectionExpression expr) {
        for (ISelectionExpressionContainer container : containers) {
            if (container.getExpression() != null) continue;
            container.setExpression(expr);
        }
    }

    private void validateFeatureKind(ISelectionExpressionContainer kindExprHolder, AbstractFeatureBase featureOrGroup) {
        if (!featureOrGroup.hasKindExpression()) {
            this.addError(Messages.CICParser_feature_kind_dynamic_should_have_expression, FeatureKind.DYNAMICALLY_SELECTED.getName());
            featureOrGroup.setKind(FeatureKind.OPTIONAL_NOT_SELECTED);
        }
    }

    private void handleInitialState(String element, Attributes attributes) throws SAXParseException {
        if (element.equals("offering")) {
            this.parseOfferingAttributes(attributes);
        } else if (element.equals("fix")) {
            this.parseFixAttributes(attributes);
        } else if (element.equals("assembly")) {
            this.parseAssemblyAttributes(attributes);
        } else if (element.equals("su")) {
            this.parseShareableUnitAttributes(attributes);
        } else if (element.equals("suFragment")) {
            this.parseSuFragmentAttributes(attributes);
        } else if (element.equals("iu")) {
            this.parseInstallableUnitAttributes(attributes);
        } else {
            this.unexpectedElementError(element, attributes);
        }
        this.computeRootUnit(element);
        this.ensureVersionCompatibility();
    }

    private void computeRootUnit(String element) {
        IContent content;
        if (this.rootUnit != null) {
            return;
        }
        if (this.peekState() != 0 && (content = this.peekObjectOpt(IContent.class)) != null) {
            this.setRootUnit(element, content.getIdentity().getId());
        }
    }

    private void ensureVersionCompatibility() throws SAXParseException {
        Version metadataVersion = this.parserInfoResolver.getMetadataVersion();
        if (metadataVersion == null) {
            String unit = this.rootUnit == null ? "" : "(" + this.rootUnit + ") ";
            String msg = Messages.CICParser_missing_metadata_version;
            throw new SAXParseException(NLS.bind(msg, (Object)unit), this.locator);
        }
        if (!MetaInfo.METADATA_TOLERANCE.isIncluded(metadataVersion)) {
            String unit = this.rootUnit == null ? "" : "(" + this.rootUnit + ") ";
            throw new SAXParseException(NLS.bind(Messages.CICParser_unit_has_incompatible_version, unit, metadataVersion, MetaInfo.METADATA_TOLERANCE), this.locator);
        }
    }

    private void setRootUnit(String element, String idStr) {
        this.rootUnit = String.valueOf(element) + ' ' + idStr;
    }

    private void parseInstallableUnitAttributes(Attributes attributes) {
        IInstallableUnitContainer container;
        String identity = null;
        String version = null;
        String adapterId = null;
        String updateRange = null;
        int i = 0;
        while (i < attributes.getLength()) {
            String name = attributes.getLocalName(i);
            String value = attributes.getValue(i).trim();
            if (name.equals("id")) {
                identity = value;
            } else if (name.equals("version")) {
                version = value;
            } else if (name.equals("adapterId")) {
                adapterId = value;
            } else if (name.equals("updateRange")) {
                updateRange = value;
            } else if (!name.equals("phases")) {
                this.unexpectedAttribute("iu", name, value);
            }
            ++i;
        }
        this.checkRequiredAttribute("iu", "id", identity);
        this.checkRequiredAttribute("iu", "version", version);
        this.checkRequiredAttribute("iu", "adapterId", adapterId);
        IInstallableUnit iu = CicFactory.getInstance().createInstallableUnit(new SimpleIdentity(identity), Version.parseVersion((String)version));
        iu.setAdapterId(adapterId);
        if (updateRange != null) {
            iu.setUpdateRange(new VersionRange(updateRange));
        }
        if ((container = this.peekObjectOpt(IInstallableUnitContainer.class)) != null) {
            iu.setParent(container);
            if (container.getInstallableUnits().contains(iu)) {
                this.addError(Messages.CICParser_duplicate_iu, iu, container);
            } else {
                container.addInstallableUnit(iu);
            }
        }
        this.push(7, iu);
    }

    private void handleInstallableUnitState(String element, Attributes attributes) {
        if (element.equals("information")) {
            this.parseInformationAttributes(attributes);
        } else if (element.equals("adapterSpecificData")) {
            this.parseAdapterSpecificDataAttributes(attributes);
        } else if (element.equals("property")) {
            this.parsePropertyAttributes(attributes);
        } else {
            this.handleSelExpr(element, attributes);
        }
    }

    private boolean isArtifactElementWithKeyAttribute(Attributes attributes) {
        int i = 0;
        while (i < attributes.getLength()) {
            String name = attributes.getLocalName(i);
            if (name.equals("key")) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private void handleArtifactElement(String uri, String element, String qName, Attributes attributes) {
        if (this.isArtifactElementWithKeyAttribute(attributes)) {
            this.handleArtifactElementWithKey(uri, element, qName, attributes);
        } else {
            this.handleArtifactElementWithoutKey(uri, element, qName, attributes);
        }
    }

    private void handleArtifactElementWithKey(String uri, String element, String qName, Attributes attributes) {
        AttributesImpl specificAttributes = new AttributesImpl();
        String key = null;
        SizeInfo sizeInfo = new SizeInfo();
        int i = 0;
        while (i < attributes.getLength()) {
            String name = attributes.getLocalName(i);
            String value = attributes.getValue(i).trim();
            if (name.equals("key")) {
                key = value;
            } else if (name.equals("downloadSize")) {
                try {
                    sizeInfo.setDownloadSize(Long.parseLong(value));
                }
                catch (NumberFormatException e) {
                    this.invalidAttributeValue(element, name, value);
                }
            } else if (name.equals("installSize")) {
                try {
                    sizeInfo.setInstallSize(Long.parseLong(value));
                }
                catch (NumberFormatException e) {
                    this.invalidAttributeValue(element, name, value);
                }
            } else if (!DigestAttributes.isDigest(name)) {
                specificAttributes.addAttribute(attributes.getURI(i), name, attributes.getQName(i), attributes.getType(i), value);
            }
            ++i;
        }
        this.checkRequiredAttribute("artifact", "key", key);
        IAdapterDataParser p = this.peekObject(IAdapterDataParser.class);
        IAdapterData adapterData = p.getAdapterData();
        int dataIndex = adapterData.getChildCount();
        IArtifact artifact = p.startArtifact(uri, element, qName, specificAttributes, key);
        this.setDataLineNumber(adapterData, dataIndex);
        if (artifact != null) {
            IMutableContentInfo info = artifact.getMutableContentInfo();
            info.setSizeInfo(sizeInfo);
            DigestAttributes.setDigestValues(attributes, true, info);
        }
        this.push(17, p);
    }

    private void handleArtifactElementWithoutKey(String uri, String element, String qName, Attributes attributes) {
        AttributesImpl specificAttributes = new AttributesImpl();
        ArtifactCommonAttributes aca = new ArtifactCommonAttributes();
        SizeInfo sizeInfo = new SizeInfo();
        int i = 0;
        while (i < attributes.getLength()) {
            String name = attributes.getLocalName(i);
            String value = attributes.getValue(i).trim();
            if (name.equals("active")) {
                boolean active = false;
                if (value != null) {
                    active = XMLUtil.isAttributeTrue(value);
                }
                aca.setActive(active);
            } else if (name.equals("id")) {
                aca.setId(value);
            } else if (name.equals("version")) {
                aca.setVersion(Version.parseVersion((String)value));
            } else if (name.equals("type")) {
                aca.setType(value);
            } else if (name.equals("downloadSize")) {
                try {
                    sizeInfo.setDownloadSize(Long.parseLong(value));
                }
                catch (NumberFormatException e) {
                    this.invalidAttributeValue(element, name, value);
                }
            } else if (name.equals("installSize")) {
                try {
                    sizeInfo.setInstallSize(Long.parseLong(value));
                }
                catch (NumberFormatException e) {
                    this.invalidAttributeValue(element, name, value);
                }
            } else if (!DigestAttributes.isDigest(name)) {
                specificAttributes.addAttribute(attributes.getURI(i), name, attributes.getQName(i), attributes.getType(i), value);
            }
            ++i;
        }
        IAdapterDataParser p = this.peekObject(IAdapterDataParser.class);
        IArtifact artifact = null;
        if (aca.getType() == null && element.equals("zip")) {
            aca.setType("zip");
        }
        this.checkRequiredAttribute("artifact", "id", aca.getId());
        this.checkRequiredAttribute("artifact", "version", aca.getVersion());
        this.checkRequiredAttribute("artifact", "type", aca.getType());
        IAdapterData adapterData = p.getAdapterData();
        int dataIndex = adapterData.getChildCount();
        artifact = p.startArtifactNoKey(uri, element, qName, specificAttributes, aca);
        this.setDataLineNumber(adapterData, dataIndex);
        if (artifact != null) {
            IMutableContentInfo info = artifact.getMutableContentInfo();
            info.setSizeInfo(sizeInfo);
            DigestAttributes.setDigestValues(attributes, true, info);
        }
        this.push(17, p);
    }

    private void parseSelectedByAttributes(Attributes attributes) {
        String id = null;
        String value = null;
        int i = 0;
        while (i < attributes.getLength()) {
            String attrName = attributes.getLocalName(i);
            String attrValue = attributes.getValue(i).trim();
            if (attrName.equals("id")) {
                id = attrValue;
            } else if (attrName.equals("value")) {
                value = attrValue;
            } else {
                this.unexpectedAttribute("selectedBy", attrName, attrValue);
            }
            ++i;
        }
        this.checkRequiredAttribute("selectedBy", "id", id);
        ISelectionExpression expr = SelectionExpression.create(id, value);
        switch (this.peekState()) {
            case 7: 
            case 9: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 25: {
                this.setSelectionExpression(this.peekObject(ISelectionExpressionContainer.class), expr, "selectedBy");
                this.push(1, null);
                break;
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                this.addSelectionExpressionOperand(this.peekObject(SelectionOperator.class), expr);
                this.push(1, null);
                break;
            }
            default: {
                throw new XMLParser.BadStateError(this, "selectedBy");
            }
        }
    }

    private void parseInformationAttributes(Attributes attributes) {
        Information info = new Information();
        int i = 0;
        while (i < attributes.getLength()) {
            String name = attributes.getLocalName(i);
            String value = attributes.getValue(i).trim();
            if (name.equals("name")) {
                info.setNameKey(value);
            } else if (name.equals("version")) {
                info.setVersionKey(value);
            } else if (name.equals("provider")) {
                info.setProviderKey(value);
            } else {
                this.unexpectedAttribute("information", name, value);
            }
            ++i;
        }
        this.checkRequiredAttribute("information", "name", info.getName());
        switch (this.peekState()) {
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 18: 
            case 26: {
                this.peekObject(IContent.class).setInformation(info);
                break;
            }
            case 9: {
                this.peekObject(ContentSelector.class).setInformation(info);
                break;
            }
            case 14: {
                this.peekObject(IFeatureGroup.class).setInformation(info);
                break;
            }
            case 15: {
                this.peekObject(IFeature.class).setInformation(info);
                break;
            }
            default: {
                throw new XMLParser.BadStateError(this, "information");
            }
        }
        this.push(13, info);
    }

    private void parseShareableUnitAttributes(Attributes attributes) {
        String identity = null;
        String version = null;
        boolean visible = true;
        int childCount = 0;
        boolean installContext = false;
        boolean shareable = true;
        boolean qualifiable = false;
        String scope = InstallationContextScope.NONE_SCOPE.getName();
        String adaptors = null;
        int i = 0;
        while (i < attributes.getLength()) {
            String name = attributes.getLocalName(i);
            String value = attributes.getValue(i).trim();
            if (name.equals("id")) {
                identity = value;
            } else if (name.equals("version")) {
                version = value;
            } else if (name.equals("visible")) {
                visible = Boolean.valueOf(value);
            } else if (name.equals("iuCount")) {
                childCount = Integer.parseInt(value);
            } else if (name.equals("installContext")) {
                installContext = Boolean.valueOf(value);
            } else if (name.equals("shareable")) {
                shareable = Boolean.valueOf(value);
            } else if (name.equals("qualifiable")) {
                qualifiable = Boolean.valueOf(value);
            } else if (name.equals("scope")) {
                scope = value;
            } else if (name.equals("adapters")) {
                adaptors = value;
            } else {
                this.unexpectedAttribute("su", name, value);
            }
            ++i;
        }
        this.checkRequiredAttribute("su", "id", identity);
        this.checkRequiredAttribute("su", "version", version);
        IShareableUnit su = null;
        if (!installContext) {
            if (!shareable) {
                this.unexpectedAttribute("su", "shareable", Boolean.valueOf(shareable).toString());
            }
            if (qualifiable) {
                this.unexpectedAttribute("su", "qualifiable", Boolean.valueOf(qualifiable).toString());
            }
            if (!InstallationContextScope.NONE_SCOPE.getName().equals(scope)) {
                this.unexpectedAttribute("su", "scope", scope);
            }
            if (adaptors != null) {
                this.unexpectedAttribute("su", "adapters", adaptors);
            }
            su = CicFactory.getInstance().createShareableUnit(new SimpleIdentity(identity), Version.parseVersion((String)version));
            this.push(5, su);
        } else {
            this.checkRequiredAttribute("installContext", "adapters", adaptors);
            IInstallationContext ic = CicFactory.getInstance().createInstallationContext(new SimpleIdentity(identity), Version.parseVersion((String)version));
            ic.setIsShareable(shareable);
            ic.setIsQualifiable(qualifiable);
            ic.setScope(InstallationContextScope.nameToInstallContextScope(scope));
            ic.setAdaptorTypes(adaptors);
            this.push(6, ic);
            su = ic;
        }
        su.setVisible(visible);
        if (childCount > 0) {
            su.setChildrenCount(childCount);
        }
    }

    private void parseSuFragmentAttributes(Attributes attributes) {
        String identity = null;
        String version = null;
        String suIdentity = null;
        String suTolerance = null;
        int childCount = 0;
        boolean strict = false;
        int i = 0;
        while (i < attributes.getLength()) {
            String name = attributes.getLocalName(i);
            String value = attributes.getValue(i).trim();
            if (name.equals("id")) {
                identity = value;
            } else if (name.equals("version")) {
                version = value;
            } else if (name.equals("iuCount")) {
                childCount = Integer.parseInt(value);
            } else if (name.equals("targetSuId")) {
                suIdentity = value;
            } else if (name.equals("targetSuTolerance")) {
                suTolerance = value;
            } else if (name.equals("strict")) {
                strict = Boolean.valueOf(value);
            } else {
                this.unexpectedAttribute("suFragment", name, value);
            }
            ++i;
        }
        this.checkRequiredAttribute("suFragment", "id", identity);
        this.checkRequiredAttribute("suFragment", "version", version);
        this.checkRequiredAttribute("suFragment", "targetSuId", suIdentity);
        this.checkRequiredAttribute("suFragment", "targetSuTolerance", suTolerance);
        ISuFragment fragment = CicFactory.getInstance().createSuFragment(new SimpleIdentity(identity), Version.parseVersion((String)version));
        fragment.setTargetId(new SimpleIdentity(suIdentity));
        fragment.setTargetTolerance(new VersionRange(suTolerance));
        fragment.setStrict(strict);
        this.push(24, fragment);
        if (childCount > 0) {
            fragment.setChildrenCount(childCount);
        }
    }

    private void handleInstallationContextState(String element, Attributes attributes) {
        if (element.equals("property")) {
            this.parsePropertyAttributes(attributes);
        } else {
            this.handleShareableUnitState(element, attributes);
        }
    }

    private void handleShareableUnitState(String element, Attributes attributes) {
        if (element.equals("information")) {
            this.parseInformationAttributes(attributes);
        } else if (element.equals("selector")) {
            this.parseSelectorAttributes(attributes);
        } else if (element.equals("iu")) {
            this.parseInstallableUnitAttributes(attributes);
        } else if (element.equals("property")) {
            this.parsePropertyAttributes(attributes);
        } else {
            this.unexpectedElementError(element, attributes);
        }
    }

    private void handleSuFragmentState(String element, Attributes attributes) {
        if (element.equals("selector")) {
            this.parseSelectorAttributes(attributes);
        } else if (element.equals("iu")) {
            this.parseInstallableUnitAttributes(attributes);
        } else if (element.equals("property")) {
            this.parsePropertyAttributes(attributes);
        } else {
            this.unexpectedElementError(element, attributes);
        }
    }

    private void parseSelectorAttributes(Attributes attributes) {
        String id = null;
        boolean isPrivate = false;
        boolean isRestricted = false;
        boolean isInternal = false;
        int i = 0;
        while (i < attributes.getLength()) {
            String attrName = attributes.getLocalName(i);
            String attrValue = attributes.getValue(i).trim();
            if (attrName.equals("id")) {
                id = attrValue;
            } else if (attrName.equals("private")) {
                isPrivate = Boolean.valueOf(attrValue);
            } else if (attrName.equals("restricted")) {
                isRestricted = Boolean.valueOf(attrValue);
            } else if (attrName.equals("internal")) {
                isInternal = Boolean.valueOf(attrValue);
            } else {
                this.unexpectedAttribute("selector", attrName, attrValue);
            }
            ++i;
        }
        this.checkRequiredAttribute("selector", "id", id);
        boolean valid = this.ensureNotOneOfThePredefineds(id);
        if (!valid) {
            this.push(0, "Ignored element: selector");
            return;
        }
        SimpleIdentity identity = new SimpleIdentity(id);
        switch (this.peekState()) {
            case 24: {
                ISuFragment fragment = this.peekObject(ISuFragment.class);
                ISuFragmentSelector sufs = fragment.getSelector(identity, true);
                fragment.addSelector(sufs);
                this.push(9, sufs);
                break;
            }
            case 5: 
            case 6: {
                IShareableUnit su = this.peekObject(IShareableUnit.class);
                InstallableUnitSelector ius = (InstallableUnitSelector)su.getSelector(identity, true);
                ius.setKeepPrivate(isPrivate);
                ius.setRestricted(isRestricted);
                ius.setInternal(isInternal);
                su.addSelector(ius);
                this.push(9, ius);
                break;
            }
            case 4: {
                IAssembly asm = this.peekObject(IAssembly.class);
                ShareableEntitySelector ses = (ShareableEntitySelector)asm.getSelector(identity, true);
                ses.setKeepPrivate(isPrivate);
                ses.setRestricted(isRestricted);
                asm.addSelector(ses);
                this.push(9, ses);
                break;
            }
            default: {
                throw new XMLParser.BadStateError(this, "selector");
            }
        }
    }

    private boolean ensureNotOneOfThePredefineds(String selIdStr) {
        String errMsg = CICParser.getErrMsgIfOneOfThePredefineds(selIdStr);
        if (errMsg != null) {
            this.addError(errMsg);
            return false;
        }
        return true;
    }

    static String getErrMsgIfOneOfThePredefineds(String selIdStr) {
        if (!selIdStr.equals("isBeta") && PredefinedSelectors.contains(selIdStr)) {
            return NLS.bind(Messages.CICParser_selector_id_is_one_of_the_predefineds, (Object)selIdStr, (Object)PredefinedSelectors.getIDs());
        }
        return null;
    }

    private void handleSelectorState(String element, Attributes attributes) {
        if (element.equals("information")) {
            this.parseInformationAttributes(attributes);
        } else if (element.equals("internalSelection")) {
            this.parseInternalSelectionAttributes(attributes);
        } else if (element.equals("requiredShareableEntity")) {
            this.parseRequiredShareableEntityAttributes(attributes);
        } else {
            this.handleSelExpr(element, attributes);
        }
    }

    private void ensureEmpty(String element, Attributes attributes) {
        int i = 0;
        while (i < attributes.getLength()) {
            String attrName = attributes.getLocalName(i);
            String attrValue = attributes.getValue(i).trim();
            this.unexpectedAttribute(element, attrName, attrValue);
            ++i;
        }
    }

    private void handleSelExpr(String element, Attributes attributes) {
        if (element.equals("selectedBy")) {
            this.parseSelectedByAttributes(attributes);
        } else if (element.equals("selectedByExpression")) {
            this.parseSelectedByExpressionAttributes(attributes);
        } else if (element.equals("selectedByBundle")) {
            this.parseSelectedByBundleAttributes(attributes);
        } else if (element.equals("selectedByTarget")) {
            this.parseSelectedByTargetAttributes(attributes);
        } else {
            this.unexpectedElementError(element, attributes);
        }
    }

    private void handleSelExprOp(String element, Attributes attributes) {
        if (element.equals("and")) {
            this.parseSelExprOpAndAttributes(attributes);
        } else if (element.equals("or")) {
            this.parseSelExprOpOrAttributes(attributes);
        } else if (element.equals("xor")) {
            this.parseSelExprOpXorAttributes(attributes);
        } else if (element.equals("not")) {
            this.parseSelExprOpNotAttributes(attributes);
        } else {
            this.unexpectedElementError(element, attributes);
        }
    }

    private void parseSelectedByExpressionAttributes(Attributes attributes) {
        this.ensureEmpty("selectedByExpression", attributes);
        ISelectionExpressionContainer parent = this.peekObject(ISelectionExpressionContainer.class);
        if (parent.getExpression() != null) {
            this.reportDuplicateSelectionExpressionError("selectedByExpression");
        }
        this.push(19, new Ref<Object>(null));
    }

    private void reportDuplicateSelectionExpressionError(String element) {
        this.addError(Messages.CICParser_there_can_be_only_one_selection_expression, element);
    }

    private void parseSelExprBinaryOpAttributes(SelectionOperator.BinaryOperator op, Attributes attributes) {
        int i = 0;
        while (i < attributes.getLength()) {
            String name = attributes.getLocalName(i);
            String value = attributes.getValue(i).trim();
            if (name.equals("shortCircuit")) {
                op.setShortCircuit(Boolean.valueOf(value));
            } else {
                this.unexpectedAttribute(op.getOpImage(), name, value);
            }
            ++i;
        }
    }

    private void parseSelExprOpAndAttributes(Attributes attributes) {
        SelectionOperator.BinaryOperator andOp = SelectionOperator.AND();
        this.parseSelExprBinaryOpAttributes(andOp, attributes);
        this.push(20, andOp);
    }

    private void parseSelExprOpOrAttributes(Attributes attributes) {
        SelectionOperator.BinaryOperator orOp = SelectionOperator.OR();
        this.parseSelExprBinaryOpAttributes(orOp, attributes);
        this.push(21, orOp);
    }

    private void parseSelExprOpXorAttributes(Attributes attributes) {
        SelectionOperator.BinaryOperator xorOp = SelectionOperator.XOR();
        this.parseSelExprBinaryOpAttributes(xorOp, attributes);
        this.push(22, xorOp);
    }

    private void parseSelExprOpNotAttributes(Attributes attributes) {
        this.ensureEmpty("not", attributes);
        this.push(23, SelectionOperator.NOT());
    }

    private void handleSelExprOpState(String element, Attributes attributes) {
        if (element.equals("selectedBy")) {
            this.parseSelectedByAttributes(attributes);
        } else if (element.equals("selectedByBundle")) {
            this.parseSelectedByBundleAttributes(attributes);
        } else if (element.equals("selectedByTarget")) {
            this.parseSelectedByTargetAttributes(attributes);
        } else {
            this.handleSelExprOp(element, attributes);
        }
    }

    private void parseSelectedByBundleAttributes(Attributes attributes) {
        String id = null;
        String klass = null;
        int i = 0;
        while (i < attributes.getLength()) {
            String name = attributes.getLocalName(i);
            String value = attributes.getValue(i).trim();
            if (name.equals("id")) {
                id = value;
            } else if (name.equals("class")) {
                klass = value;
            } else {
                this.unexpectedAttribute("selectedByBundle", name, value);
            }
            ++i;
        }
        this.checkRequiredAttribute("selectedByBundle", "id", id);
        ISelectionExpression.ISelectedByBundle expr = SelectionExpression.createSelectedByBundle(id, klass);
        switch (this.peekState()) {
            case 7: 
            case 9: 
            case 12: 
            case 14: 
            case 15: 
            case 16: {
                this.setSelectionExpression(this.peekObject(ISelectionExpressionContainer.class), expr, "selectedByBundle");
                this.push(1, null);
                break;
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                this.addSelectionExpressionOperand(this.peekObject(SelectionOperator.class), expr);
                this.push(1, null);
                break;
            }
            default: {
                throw new XMLParser.BadStateError(this, "selectedByBundle");
            }
        }
    }

    private void parseSelectedByTargetAttributes(Attributes attributes) {
        String id = null;
        int i = 0;
        while (i < attributes.getLength()) {
            String name = attributes.getLocalName(i);
            String value = attributes.getValue(i).trim();
            if (name.equals("id")) {
                id = value;
            } else {
                this.unexpectedAttribute("selectedByTarget", name, value);
            }
            ++i;
        }
        this.checkRequiredAttribute("selectedByTarget", "id", id);
        ISelectionExpression.ISelectedByTarget expr = SelectionExpression.createSelectedByTarget(id);
        switch (this.peekState()) {
            case 7: 
            case 9: 
            case 25: {
                this.setSelectionExpression(this.peekObject(ISelectionExpressionContainer.class), expr, "selectedByTarget");
                this.push(1, null);
                break;
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                this.addSelectionExpressionOperand(this.peekObject(SelectionOperator.class), expr);
                this.push(1, null);
                break;
            }
            default: {
                throw new XMLParser.BadStateError(this, "selectedByTarget");
            }
        }
    }

    private void setSelectionExpression(ISelectionExpressionContainer parent, ISelectionExpression expr, String elementName) {
        if (expr == null) {
            return;
        }
        if (parent.getExpression() != null) {
            if (!"selectedByExpression".equals(elementName)) {
                this.reportDuplicateSelectionExpressionError(elementName);
            }
        } else {
            parent.setExpression(expr);
        }
    }

    private ISelectionExpression createSelectionExpression(SelectionOperator operator) {
        try {
            return SelectionExpression.createSelectedByOperator(operator);
        }
        catch (IllegalArgumentException e) {
            this.addError(e.getLocalizedMessage());
            return null;
        }
    }

    private void addSelectionExpressionOperand(SelectionOperator operator, ISelectionExpression operand) {
        if (operand != null) {
            try {
                operator.addOperand(operand);
            }
            catch (IllegalArgumentException e) {
                this.addError(e.getLocalizedMessage());
            }
        }
    }

    private void parseAssemblyAttributes(Attributes attributes) {
        String identity = null;
        String version = null;
        boolean visible = true;
        int childCount = 0;
        int i = 0;
        while (i < attributes.getLength()) {
            String name = attributes.getLocalName(i);
            String value = attributes.getValue(i).trim();
            if (name.equals("id")) {
                identity = value;
            } else if (name.equals("version")) {
                version = value;
            } else if (name.equals("visible")) {
                visible = Boolean.valueOf(value);
            } else if (name.equals("seCount")) {
                childCount = Integer.parseInt(value);
            } else {
                this.unexpectedAttribute("assembly", name, value);
            }
            ++i;
        }
        this.checkRequiredAttribute("assembly", "id", identity);
        this.checkRequiredAttribute("assembly", "version", version);
        IAssembly x = CicFactory.getInstance().createAssembly(new SimpleIdentity(identity), Version.parseVersion(version));
        x.setVisible(visible);
        if (childCount > 0) {
            x.setChildrenCount(childCount);
        }
        this.push(4, x);
    }

    private void handleAssemblyState(String element, Attributes attributes) {
        if (element.equals("information")) {
            this.parseInformationAttributes(attributes);
        } else if (element.equals("selector")) {
            this.parseSelectorAttributes(attributes);
        } else if (element.equals("includedShareableEntity")) {
            this.parseIncludedShareableEntityAttributes(attributes);
        } else if (element.equals("includedSuFragment")) {
            this.parseIncludedSuFragmentAttributes(attributes);
        } else if (element.equals("property")) {
            this.parsePropertyAttributes(attributes);
        } else {
            this.unexpectedElementError(element, attributes);
        }
    }

    private void parseRequiredShareableEntityAttributes(Attributes attributes) {
        String shareableId = null;
        String tolerance = null;
        boolean installContext = false;
        int i = 0;
        while (i < attributes.getLength()) {
            String name = attributes.getLocalName(i);
            String value = attributes.getValue(i).trim();
            if (name.equals("shareableId")) {
                shareableId = value;
            } else if (name.equals("tolerance")) {
                tolerance = value;
            } else if (name.equals("installContext")) {
                installContext = Boolean.valueOf(value);
            } else {
                this.unexpectedAttribute("requiredShareableEntity", name, value);
            }
            ++i;
        }
        this.checkRequiredAttribute("requiredShareableEntity", "shareableId", shareableId);
        this.checkRequiredAttribute("requiredShareableEntity", "tolerance", tolerance);
        RequiredShareableEntity x = new RequiredShareableEntity(new SimpleIdentity(shareableId));
        x.setTolerance(new VersionRange(tolerance));
        x.setRequiresInstallationContext(installContext);
        this.peekObject(ContentSelector.class).addRequiredShareableEntity(x);
        this.push(10, x);
    }

    private void handleRequiredShareableEntityState(String element, Attributes attributes) {
        if (element.equals("requiredSelector")) {
            this.parseRequiredSelectorAttributes(attributes);
        } else {
            this.unexpectedElementError(element, attributes);
        }
    }

    private void parseAdapterSpecificDataAttributes(Attributes attributes) {
        int i = 0;
        while (i < attributes.getLength()) {
            String name = attributes.getLocalName(i);
            String value = attributes.getValue(i).trim();
            this.unexpectedAttribute("adapterSpecificData", name, value);
            ++i;
        }
        IInstallableUnit parent = this.peekObject(IInstallableUnit.class);
        if (parent.getAdapterData() != null) {
            this.addError(Messages.CICParser_err_multiple_adapterSpecificData);
        }
        IAdapterDataParser p = Util.getAdapterDataParser(parent.getAdapterId());
        p.initialize(parent, this);
        this.push(8, p);
    }

    private void parseInternalSelectionAttributes(Attributes attributes) {
        String id = null;
        int i = 0;
        while (i < attributes.getLength()) {
            String name = attributes.getLocalName(i);
            String value = attributes.getValue(i).trim();
            if (name.equals("id")) {
                id = value;
            } else {
                this.unexpectedAttribute("internalSelection", name, value);
            }
            ++i;
        }
        this.checkRequiredAttribute("internalSelection", "id", id);
        Object container = this.peekParentObject();
        if (container instanceof ISuFragment) {
            ISuFragment fragment = (ISuFragment)container;
            ISuFragmentSelector sfs = fragment.getSelector(new SimpleIdentity(id), true);
            this.peekObject(ISuFragmentSelector.class).addInternalSelection(sfs);
        } else if (container instanceof IShareableUnit) {
            IShareableUnit su = (IShareableUnit)container;
            IInstallableUnitSelector ius = (IInstallableUnitSelector)su.getSelector(new SimpleIdentity(id), true);
            this.peekObject(IInstallableUnitSelector.class).addInternalSelection(ius);
        } else if (container instanceof IAssembly) {
            IAssembly asm = (IAssembly)container;
            IShareableEntitySelector ses = (IShareableEntitySelector)asm.getSelector(new SimpleIdentity(id), true);
            this.peekObject(IShareableEntitySelector.class).addInternalSelection(ses);
        }
        this.push(1, null);
    }

    private VersionRange computeDefaultTolerance(Version version) {
        return new VersionRange(new Version(version.getMajor(), 0, 0), true, new Version(version.getMajor() + 1, 0, 0), false);
    }

    private void parseIncludedShareableEntityAttributes(Attributes attributes) {
        String identity = null;
        String toleranceValue = null;
        String versionValue = null;
        int i = 0;
        while (i < attributes.getLength()) {
            String name = attributes.getLocalName(i);
            String value = attributes.getValue(i).trim();
            if (name.equals("id")) {
                identity = value;
            } else if (name.equals("version")) {
                versionValue = value;
            } else if (name.equals("tolerance")) {
                toleranceValue = value;
            } else {
                this.unexpectedAttribute("includedShareableEntity", name, value);
            }
            ++i;
        }
        this.checkRequiredAttribute("includedShareableEntity", "id", identity);
        this.checkRequiredAttribute("includedShareableEntity", "version", versionValue);
        Version version = Version.parseVersion(versionValue);
        VersionRange tolerance = toleranceValue == null ? this.computeDefaultTolerance(version) : new VersionRange(toleranceValue);
        IIncludedShareableEntity x = CicFactory.getInstance().createIncludedShareableEntity(new SimpleIdentity(identity), version, tolerance);
        this.peekObject(IAssembly.class).addChild(x);
        this.push(11, x);
    }

    private void parseIncludedSuFragmentAttributes(Attributes attributes) {
        String identity = null;
        String versionValue = null;
        int i = 0;
        while (i < attributes.getLength()) {
            String name = attributes.getLocalName(i);
            String value = attributes.getValue(i).trim();
            if (name.equals("id")) {
                identity = value;
            } else if (name.equals("version")) {
                versionValue = value;
            } else {
                this.unexpectedAttribute("includedSuFragment", name, value);
            }
            ++i;
        }
        this.checkRequiredAttribute("includedSuFragment", "id", identity);
        Version version = null;
        if (!this.relaxedValidation) {
            this.checkRequiredAttribute("includedSuFragment", "version", versionValue);
            version = Version.parseVersion(versionValue);
        }
        IIncludedSuFragment includedSuFragment = CicFactory.getInstance().createIncludedSuFragment(new SimpleIdentity(identity), version);
        this.peekObject(IAssembly.class).addChild(includedSuFragment);
        this.push(25, includedSuFragment);
    }

    private void handleIncludedShareableEntityState(String element, Attributes attributes) {
        if (element.equals("includedSelector")) {
            this.parseIncludedSelectorAttributes(attributes);
        } else {
            this.unexpectedElementError(element, attributes);
        }
    }

    private void handleIncludedSuFragmentState(String element, Attributes attributes) {
        if (element.equals("selectedBy")) {
            this.parseSelectedByAttributes(attributes);
        } else {
            this.unexpectedElementError(element, attributes);
        }
    }

    private void parseIncludedSelectorAttributes(Attributes attributes) {
        String selectorId = null;
        int i = 0;
        while (i < attributes.getLength()) {
            String name = attributes.getLocalName(i);
            String value = attributes.getValue(i).trim();
            if (name.equals("selectorId")) {
                selectorId = value;
            } else {
                this.unexpectedAttribute("includedSelector", name, value);
            }
            ++i;
        }
        this.checkRequiredAttribute("includedSelector", "selectorId", selectorId);
        IncludedShareableEntitySelector sel = new IncludedShareableEntitySelector(new SimpleIdentity(selectorId));
        this.peekObject(IncludedShareableEntity.class).addIncludedSelector(sel);
        this.push(12, sel);
    }

    private void parseRequiredSelectorAttributes(Attributes attributes) {
        String selectorId = null;
        int i = 0;
        while (i < attributes.getLength()) {
            String name = attributes.getLocalName(i);
            String value = attributes.getValue(i).trim();
            if (name.equals("selectorId")) {
                selectorId = value;
            } else {
                this.unexpectedAttribute("requiredSelector", name, value);
            }
            ++i;
        }
        this.checkRequiredAttribute("requiredSelector", "selectorId", selectorId);
        this.peekObject(RequiredShareableEntity.class).addSelectorId(new SimpleIdentity(selectorId));
        this.push(1, null);
    }

    private void parseFixAttributes(Attributes attributes) {
        String identity = null;
        String version = null;
        String offeringIdentity = null;
        String offeringVersion = null;
        String assemblyIdentity = null;
        String assemblyVersion = null;
        int childCount = 0;
        int i = 0;
        while (i < attributes.getLength()) {
            String name = attributes.getLocalName(i);
            String value = attributes.getValue(i).trim();
            if (name.equals("id")) {
                identity = value;
                this.setRootUnit("fix", identity);
            } else if (name.equals("version")) {
                version = value;
            } else if (name.equals("offeringId")) {
                offeringIdentity = value;
            } else if (name.equals("offeringVersion")) {
                offeringVersion = value;
            } else if (name.equals("assemblyId")) {
                assemblyIdentity = value;
            } else if (name.equals("assemblyVersion")) {
                assemblyVersion = value;
            } else if (name.equals("iseCount")) {
                childCount = Integer.parseInt(value);
            } else if (!name.equals("schemaLocation")) {
                this.unexpectedAttribute("fix", name, value);
            }
            ++i;
        }
        this.checkRequiredAttribute("fix", "id", identity);
        this.checkRequiredAttribute("fix", "version", version);
        this.checkRequiredAttribute("fix", "assemblyId", assemblyIdentity);
        this.checkRequiredAttribute("fix", "assemblyVersion", assemblyVersion);
        if (offeringIdentity != null) {
            this.checkRequiredAttribute("fix", "offeringId", offeringIdentity);
            this.checkRequiredAttribute("fix", "offeringVersion", offeringVersion);
        } else {
            this.checkEnhancedFixUnsupportedAttribute("fix", "offeringVersion", offeringVersion);
        }
        IFix fix = CicFactory.getInstance().createFix(identity, version);
        if (assemblyIdentity != null) {
            fix.setAssemblyId(new SimpleIdentity(assemblyIdentity));
        }
        if (assemblyVersion != null) {
            fix.setAssemblyVersion(Version.parseVersion((String)assemblyVersion));
        }
        if (offeringIdentity != null) {
            IFixInternal fixInternal = (IFixInternal)((Object)fix);
            fixInternal.setInternalOfferingId(new SimpleIdentity(offeringIdentity));
            if (offeringVersion != null) {
                fixInternal.setInternalOfferingVersion(Version.parseVersion((String)offeringVersion));
            }
        }
        if (childCount > 0) {
            fix.setChildrenCount(childCount);
        }
        if (fix.isEnhancedFix()) {
            this.push(26, fix);
        } else {
            this.push(18, fix);
        }
    }

    private void checkEnhancedFixUnsupportedAttribute(String element, String name, Object value) {
        if (value != null) {
            this.addError(Messages.CICParser_attributeIgnoredInEnhancedFix, name, value);
        }
    }

    private boolean handleCommonFixState(String element, Attributes attributes) {
        if (element.equals("information")) {
            this.parseInformationAttributes(attributes);
            return true;
        }
        if (element.equals("assembly")) {
            this.parseAssemblyAttributes(attributes);
            return true;
        }
        if (element.equals("su")) {
            this.parseShareableUnitAttributes(attributes);
            return true;
        }
        if (element.equals("suFragment")) {
            this.parseSuFragmentAttributes(attributes);
            return true;
        }
        if (element.equals("iu")) {
            this.parseInstallableUnitAttributes(attributes);
            return true;
        }
        if (element.equals("property")) {
            this.parsePropertyAttributes(attributes);
            return true;
        }
        return false;
    }

    private void handleFixState(String element, Attributes attributes) {
        if (!this.handleCommonFixState(element, attributes)) {
            this.unexpectedElementError(element, attributes);
        }
    }

    private void handleEnhancedFixState(String element, Attributes attributes) {
        if (!this.handleCommonFixState(element, attributes)) {
            if (element.equals("resolves")) {
                this.parseFixResolvesAttributes(attributes);
            } else if (element.equals("applicability")) {
                this.parseFixApplicabilityAttributes(attributes);
            } else if (element.equals("categories")) {
                this.parseFixCategoriesAttributes(attributes);
            } else {
                this.unexpectedElementError(element, attributes);
            }
        }
    }

    private void handleApplicabilityState(String element, Attributes attributes) {
        if (element.equals("offering")) {
            this.parseFixApplicableOfferingAttributes(attributes);
        } else {
            this.unexpectedElementError(element, attributes);
        }
    }

    private void handleCategoriesState(String element, Attributes attributes) {
        if (element.equals("category")) {
            this.parseFixCategoryAttributes(attributes);
        } else {
            this.unexpectedElementError(element, attributes);
        }
    }

    private void handleOfferingResolvesState(String element, Attributes attributes) {
        if (element.equals("problem")) {
            this.parseOfferingProblemAttributes(attributes);
        } else {
            this.unexpectedElementError(element, attributes);
        }
    }

    private void handleFixResolvesState(String element, Attributes attributes) {
        if (element.equals("problem")) {
            this.parseFixProblemAttributes(attributes);
        } else {
            this.unexpectedElementError(element, attributes);
        }
    }

    private void parseFixCategoriesAttributes(Attributes attributes) {
        this.ensureEmpty("categories", attributes);
        this.push(30, this.peekObject(IFix.class));
    }

    private void parseFixCategoryAttributes(Attributes attributes) {
        String catId = null;
        String catName = null;
        int i = 0;
        while (i < attributes.getLength()) {
            String name = attributes.getLocalName(i);
            String value = attributes.getValue(i).trim();
            if (name.equals("id")) {
                catId = value;
            } else if (name.equals("name")) {
                catName = value;
            } else {
                this.unexpectedAttribute("category", name, value);
            }
            ++i;
        }
        IFixCategory category = CicFactory.getInstance().createFixCategory(this.checkRequiredAttributeStdDefault("category", "id", catId), this.checkRequiredAttributeStdDefault("category", "name", catName));
        this.peekObject(IFix.class).addCategory(category);
        this.push(1, null);
    }

    private void parseOfferingProblemAttributes(Attributes attributes) {
        String identity = null;
        String description = null;
        String displayId = null;
        int i = 0;
        while (i < attributes.getLength()) {
            String name = attributes.getLocalName(i);
            String value = attributes.getValue(i).trim();
            if (name.equals("id")) {
                identity = value;
            } else if (name.equals("description")) {
                description = value;
            } else if (name.equals("displayId")) {
                displayId = value;
            } else {
                this.unexpectedAttribute("problem", name, value);
            }
            ++i;
        }
        identity = this.checkRequiredAttributeStdDefault("problem", "id", identity);
        displayId = this.checkRequiredAttributeStdDefault("problem", "displayId", displayId);
        IProblemResolved problem = CicFactory.getInstance().createProblem(identity, displayId);
        if (description != null) {
            problem.setDescriptionKey(description);
            problem.setDescription(description);
        }
        this.peekObject(IProblemsResolved.class).addProblem(problem);
        this.push(1, null);
    }

    private void parseFixProblemAttributes(Attributes attributes) {
        String identity = null;
        String description = null;
        String displayId = null;
        boolean hide = false;
        int i = 0;
        while (i < attributes.getLength()) {
            String name = attributes.getLocalName(i);
            String value = attributes.getValue(i).trim();
            if (name.equals("id")) {
                identity = value;
            } else if (name.equals("description")) {
                description = value;
            } else if (name.equals("displayId")) {
                displayId = value;
            } else if (name.equals("hide")) {
                hide = Boolean.valueOf(value);
            } else {
                this.unexpectedAttribute("problem", name, value);
            }
            ++i;
        }
        identity = this.checkRequiredAttributeStdDefault("problem", "id", identity);
        displayId = this.checkRequiredAttributeStdDefault("problem", "displayId", displayId);
        IProblemResolved problem = CicFactory.getInstance().createProblem(identity, displayId);
        if (description != null) {
            problem.setDescriptionKey(description);
            problem.setDescription(description);
        }
        problem.setHide(hide);
        this.peekObject(IProblemsResolved.class).addProblem(problem);
        this.push(1, null);
    }

    private void parseFixApplicabilityAttributes(Attributes attributes) {
        this.ensureEmpty("applicability", attributes);
        this.push(29, this.peekObject(IFix.class));
    }

    private void parseFixApplicableOfferingAttributes(Attributes attributes) {
        String identity = null;
        String toleranceValue = null;
        int i = 0;
        while (i < attributes.getLength()) {
            String name = attributes.getLocalName(i);
            String value = attributes.getValue(i).trim();
            if (name.equals("id")) {
                identity = value;
            } else if (name.equals("tolerance")) {
                toleranceValue = value;
            } else {
                this.unexpectedAttribute("offering", name, value);
            }
            ++i;
        }
        identity = this.checkRequiredAttributeStdDefault("offering", "id", identity);
        VersionRange tolerance = toleranceValue == null ? VersionRange.emptyRange : new VersionRange(toleranceValue);
        IFixApplicableOffering applicableOffering = CicFactory.getInstance().createFixApplicableOffering(new SimpleIdentity(identity), tolerance);
        this.peekObject(IFix.class).addApplicableOffering(applicableOffering);
        this.push(1, null);
    }

    private void parseOfferingResolvesAttributes(Attributes attributes) {
        int count = 0;
        int i = 0;
        while (i < attributes.getLength()) {
            String name = attributes.getLocalName(i);
            String value = attributes.getValue(i).trim();
            if (name.equals("problemCount")) {
                count = Integer.parseInt(value);
            } else {
                this.unexpectedAttribute("resolves", name, value);
            }
            ++i;
        }
        IProblemsResolved resolves = CicFactory.getInstance().createProblemsResolved();
        if (count > 0) {
            resolves.setProblemCount(count);
        }
        this.push(27, resolves);
    }

    private void handleOfferingIncludesState(String element, Attributes attributes) {
        if (element.equals("profile")) {
            this.parseOfferingIncludesProfileAttributes(attributes);
        } else {
            this.unexpectedElementError(element, attributes);
        }
    }

    private void handleOfferingIncludesProfileState(String element, Attributes attributes) {
        if (element.equals("offering")) {
            this.parseOfferingIncludesProfileOfferingAttributes(attributes);
        } else {
            this.unexpectedElementError(element, attributes);
        }
    }

    private void handleOfferingIncludesProfileOfferingState(String element, Attributes attributes) {
        if (element.equals("information")) {
            this.parseOfferingIncludesProfileOfferingInformationAttributes(attributes);
        } else {
            this.unexpectedElementError(element, attributes);
        }
    }

    private void parseOfferingIncludesAttributes(Attributes attributes) {
        int i = 0;
        while (i < attributes.getLength()) {
            String name = attributes.getLocalName(i);
            String value = attributes.getValue(i).trim();
            this.unexpectedAttribute("includes", name, value);
            ++i;
        }
        IOffering offering = this.peekObject(IOffering.class);
        this.push(31, offering);
    }

    private void parseOfferingIncludesProfileAttributes(Attributes attributes) {
        String profileId = null;
        String dir = null;
        for (XMLParser.Attr attr : XMLParser.Attr.iterable(attributes)) {
            if (attr.is("id")) {
                profileId = attr.value;
                continue;
            }
            if (attr.is("dir")) {
                dir = attr.value;
                continue;
            }
            this.unexpectedAttribute("profile", attr);
        }
        OfferingIncludes offeringIncludes = new OfferingIncludes(this.checkRequiredAttributeStdDefault("profile", "id", profileId), dir);
        this.peekObject(Offering.class).addInclude(offeringIncludes);
        this.push(32, offeringIncludes);
    }

    private void parseOfferingIncludesProfileOfferingAttributes(Attributes attributes) {
        String id = null;
        IOfferingIncludes.IOfferingInProfile.Kind kind = IOfferingIncludes.IOfferingInProfile.Kind.RequiredAndVisible;
        String minVersion = null;
        String maxVersion = null;
        for (XMLParser.Attr attr : XMLParser.Attr.iterable(attributes)) {
            if (attr.is("id")) {
                id = attr.value;
                continue;
            }
            if (attr.is("kind")) {
                try {
                    kind = IOfferingIncludes.IOfferingInProfile.Kind.valueOf(attr.value);
                }
                catch (IllegalArgumentException e) {
                    this.invalidAttributeValue("offering", attr);
                }
                continue;
            }
            if (attr.is("minVersion")) {
                minVersion = attr.value;
                continue;
            }
            if (attr.is("maxVersion")) {
                maxVersion = attr.value;
                continue;
            }
            this.unexpectedAttribute("offering", attr);
        }
        OfferingIncludes.OfferingInProfile offeringInProfile = new OfferingIncludes.OfferingInProfile(kind, new SimpleIdentity(this.checkRequiredAttributeStdDefault("offering", "id", id)), this.parseVersion(this.checkRequiredAttributeStdDefault("offering", "minVersion", minVersion)), this.parseVersion(this.checkRequiredAttributeStdDefault("offering", "maxVersion", maxVersion)));
        this.peekObject(OfferingIncludes.class).addOfferingInProfile(offeringInProfile);
        this.push(33, offeringInProfile);
    }

    private void parseOfferingIncludesProfileOfferingInformationAttributes(Attributes attributes) {
        String name = null;
        String minVersion = null;
        String maxVersion = null;
        for (XMLParser.Attr attr : XMLParser.Attr.iterable(attributes)) {
            if (attr.is("name")) {
                name = attr.value;
                continue;
            }
            if (attr.is("minVersion")) {
                minVersion = attr.value;
                continue;
            }
            if (attr.is("maxVersion")) {
                maxVersion = attr.value;
                continue;
            }
            this.unexpectedAttribute("information", attr);
        }
        OfferingIncludes.OfferingInProfile offeringInProfile = this.peekObject(OfferingIncludes.OfferingInProfile.class);
        offeringInProfile.setInfo(this.checkRequiredAttributeStdDefault("information", "name", name), minVersion != null ? minVersion : VersionUtil.toExternalVersion(offeringInProfile.getMinVersion()), maxVersion != null ? maxVersion : VersionUtil.toExternalVersion(offeringInProfile.getMaxVersion()));
        this.push(1, null);
    }

    private void parseFixResolvesAttributes(Attributes attributes) {
        int count = 0;
        String description = null;
        boolean showList = false;
        int i = 0;
        while (i < attributes.getLength()) {
            String name = attributes.getLocalName(i);
            String value = attributes.getValue(i).trim();
            if (name.equals("problemCount")) {
                count = Integer.parseInt(value);
            } else if (name.equals("showList")) {
                showList = Boolean.valueOf(value);
            } else if (name.equals("description")) {
                description = value;
            } else {
                this.unexpectedAttribute("resolves", name, value);
            }
            ++i;
        }
        IProblemsResolved resolves = CicFactory.getInstance().createProblemsResolved();
        if (description != null) {
            resolves.setDescriptionKey(description);
            resolves.setDescription(description);
        }
        resolves.setShowList(showList);
        if (count > 0) {
            resolves.setProblemCount(count);
        }
        this.push(28, resolves);
    }

    private void completeResolvesElement(IProblemsResolved resolves, Object parent) {
        IOfferingOrFix oof = (IOfferingOrFix)parent;
        if (oof.getProblemsResolvedList().size() == 1) {
            this.addError(Messages.CICParser_onlyFirstElementUsed, "resolves");
        } else if (oof.getProblemsResolvedList().isEmpty()) {
            oof.addProblemsResolved(resolves);
        }
    }

    private void parseOfferingAttributes(Attributes attributes) {
        String identity = null;
        String version = null;
        String assemblyIdentity = null;
        String assemblyVersion = null;
        int childCount = 0;
        int i = 0;
        while (i < attributes.getLength()) {
            String name = attributes.getLocalName(i);
            String value = attributes.getValue(i).trim();
            if (name.equals("id")) {
                identity = value;
                this.setRootUnit("offering", identity);
            } else if (name.equals("version")) {
                version = value;
            } else if (name.equals("assemblyId")) {
                assemblyIdentity = value;
            } else if (name.equals("assemblyVersion")) {
                assemblyVersion = value;
            } else if (name.equals("iuCount")) {
                childCount = Integer.parseInt(value);
            } else if (!name.equals("schemaLocation")) {
                this.unexpectedAttribute("offering", name, value);
            }
            ++i;
        }
        this.checkRequiredAttribute("offering", "id", identity);
        this.checkRequiredAttribute("offering", "version", version);
        this.checkRequiredAttribute("offering", "assemblyId", assemblyIdentity);
        this.checkRequiredAttribute("offering", "assemblyVersion", assemblyVersion);
        IOffering offering = CicFactory.getInstance().createOffering(new SimpleIdentity(identity), Version.parseVersion((String)version));
        if (assemblyIdentity != null) {
            offering.setAssemblyId(new SimpleIdentity(assemblyIdentity));
        }
        if (assemblyVersion != null) {
            offering.setAssemblyVersion(Version.parseVersion((String)assemblyVersion));
        }
        if (childCount > 0) {
            offering.setChildrenCount(childCount);
        }
        this.ufidGen = new UniqueFeatureIdGenerator(null);
        this.push(3, offering);
    }

    private void handleOfferingState(String element, Attributes attributes) {
        if (element.equals("information")) {
            this.parseInformationAttributes(attributes);
        } else if (element.equals("featureGroup")) {
            this.parseFeatureGroupAttributes(attributes);
        } else if (element.equals("su")) {
            this.parseShareableUnitAttributes(attributes);
        } else if (element.equals("assembly")) {
            this.ufidGen = null;
            this.parseAssemblyAttributes(attributes);
        } else if (element.equals("suFragment")) {
            this.parseSuFragmentAttributes(attributes);
        } else if (element.equals("iu")) {
            this.parseInstallableUnitAttributes(attributes);
        } else if (element.equals("property")) {
            this.parsePropertyAttributes(attributes);
        } else if (element.equals("resolves")) {
            this.parseOfferingResolvesAttributes(attributes);
        } else if (element.equals("includes")) {
            this.parseOfferingIncludesAttributes(attributes);
        } else {
            this.unexpectedElementError(element, attributes);
        }
    }

    private void parseFeatureGroupAttributes(Attributes attributes) {
        String featureGroupKind = null;
        boolean childrenAreExclusive = false;
        int i = 0;
        while (i < attributes.getLength()) {
            String name = attributes.getLocalName(i);
            String value = attributes.getValue(i).trim();
            if (name.equals("kind")) {
                featureGroupKind = value;
            } else if (name.equals("exclusive")) {
                childrenAreExclusive = Boolean.valueOf(value);
            } else {
                this.unexpectedAttribute("featureGroup", name, value);
            }
            ++i;
        }
        if (this.peekState() != 3) {
            this.checkRequiredAttribute("feature", "kind", featureGroupKind);
        } else if (featureGroupKind == null) {
            featureGroupKind = FeatureKind.REQUIRED_VISIBLE.getName();
        }
        IFeatureGroup featureGroup = CicFactory.getInstance().createFeatureGroup();
        featureGroup.setKind(FeatureKind.nameToFeatureKind(featureGroupKind));
        featureGroup.setMutuallyExclusiveChildren(childrenAreExclusive);
        switch (this.peekState()) {
            case 3: {
                IOffering offering = this.peekObject(IOffering.class);
                if (offering.getFeatureGroup() != null) {
                    this.addError(Messages.CICParser_offering_extra_feature_group, offering.getIdentity(), "featureGroup");
                    this.push(0, featureGroup);
                    break;
                }
                offering.setFeatureGroup(featureGroup);
                this.push(14, featureGroup);
                break;
            }
            case 14: {
                this.peekObject(IFeatureGroup.class).addGroup(featureGroup);
                this.push(14, featureGroup);
                break;
            }
            default: {
                throw new XMLParser.BadStateError(this, "featureGroup");
            }
        }
    }

    private void handleFeatureState(String element, Attributes attributes) {
        if (element.equals("information")) {
            this.parseInformationAttributes(attributes);
        } else if (element.equals("kind")) {
            this.parseFeatureKindAttributes(element, attributes);
        } else {
            this.handleSelExpr(element, attributes);
        }
    }

    private void handleFeatureGroupState(String element, Attributes attributes) {
        if (element.equals("information")) {
            this.parseInformationAttributes(attributes);
        } else if (element.equals("featureGroup")) {
            this.parseFeatureGroupAttributes(attributes);
        } else if (element.equals("feature")) {
            this.parseFeatureAttributes(attributes);
        } else if (element.equals("kind")) {
            this.parseFeatureKindAttributes(element, attributes);
        } else {
            this.handleSelExpr(element, attributes);
        }
    }

    private boolean featuresShouldHaveId() {
        Version metadataVersion = this.parserInfoResolver.getMetadataVersion();
        return metadataVersion.compareTo(VER_SANS_FEATURE_ID) > 0;
    }

    private void parseFeatureAttributes(Attributes attributes) {
        String featureId = null;
        String selectorIdentity = null;
        String featureKind = null;
        int i = 0;
        while (i < attributes.getLength()) {
            String name = attributes.getLocalName(i);
            String value = attributes.getValue(i).trim();
            if (name.equals("id")) {
                featureId = value;
            } else if (name.equals("selectionId")) {
                selectorIdentity = value;
            } else if (name.equals("kind")) {
                featureKind = value;
            } else {
                this.unexpectedAttribute("feature", name, value);
            }
            ++i;
        }
        if (this.featuresShouldHaveId()) {
            this.checkRequiredAttribute("feature", "id", featureId);
        }
        if (featureId == null) {
            featureId = this.ufidGen.generateIdFrom(selectorIdentity);
        }
        this.checkRequiredAttribute("feature", "selectionId", selectorIdentity);
        this.checkRequiredAttribute("feature", "kind", featureKind);
        IFeature feature = CicFactory.getInstance().createFeature(new SimpleIdentity(featureId));
        feature.setSelectorIdentity(new SimpleIdentity(selectorIdentity));
        feature.setKind(FeatureKind.nameToFeatureKind(featureKind));
        this.peekObject(IFeatureGroup.class).addFeature(feature);
        this.push(15, feature);
    }

    private void parseFeatureKindAttributes(String element, Attributes attributes) {
        this.ensureEmpty(element, attributes);
        AbstractFeatureBase featureOrGroup = this.peekObjectOpt(AbstractFeatureBase.class);
        if (featureOrGroup != null) {
            FeatureKind kind = featureOrGroup.getKind();
            if (kind.equals(FeatureKind.DYNAMICALLY_SELECTED)) {
                this.push(16, featureOrGroup.getKindExpressionHolder());
            } else {
                this.addError(Messages.CICParser_only_feature_kind_dynamic_can_have_expression, kind.getName());
                this.push(0, kind);
            }
        } else {
            this.push(0, null);
        }
    }

    private void handleBuilderDataTransition(String element, Attributes attributes) {
        BuilderData data = new BuilderData(element);
        int i = 0;
        while (i < attributes.getLength()) {
            data.setAttribute(attributes.getLocalName(i), attributes.getValue(i));
            ++i;
        }
        IBuilderDataOwner modelObject = this.peekObject(IBuilderDataOwner.class);
        this.push(34, data);
        if (this.includeBuildData && modelObject != null) {
            modelObject.addBuilderData(data);
        }
    }

    private void handleBuilderDataState(String element, Attributes attributes) {
        BuilderDataElement data = new BuilderDataElement(element);
        int i = 0;
        while (i < attributes.getLength()) {
            data.setAttribute(attributes.getLocalName(i), attributes.getValue(i));
            ++i;
        }
        IBuildDataElement buildData = this.peekObject(IBuildDataElement.class);
        this.push(34, data);
        if (buildData != null) {
            buildData.addChild(data);
        }
    }

    private void parsePropertyAttributes(Attributes attributes) {
        XMLParser.PropertyPair property = this.parseProperty(attributes);
        if (property.isValid()) {
            IContent parent = this.peekObject(IContent.class);
            parent.getProperties().setProperty(property.getName(), property.getValue());
        }
        this.push(1, null);
    }
}

