/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.model.internal;

import com.ibm.cic.common.core.artifactrepo.impl.ArtifactFormatterUtil;
import com.ibm.cic.common.core.model.adapterdata.IArtifact;
import com.ibm.cic.common.core.model.adapterdata.IArtifactKey;
import com.ibm.cic.common.core.model.adapterdata.IInstallSizeInfo;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IAdapterFactory;

public class ArtifactToInstallSizeAdapterFactory
implements IAdapterFactory {
    public Object getAdapter(Object adaptableObject, Class adapterType) {
        if (adaptableObject instanceof IArtifact) {
            return new ArtifactToInstallSizeAdapter((IArtifact)adaptableObject);
        }
        return null;
    }

    public Class[] getAdapterList() {
        return new Class[]{IInstallSizeInfo.class};
    }

    private static class ArtifactToInstallSizeAdapter
    implements IAdaptable,
    IInstallSizeInfo {
        private final IArtifact artifact;

        public ArtifactToInstallSizeAdapter(IArtifact artifact) {
            this.artifact = artifact;
        }

        @Override
        public IArtifact getArtifact() {
            return this.artifact;
        }

        public boolean equals(Object obj) {
            if (obj instanceof ArtifactToInstallSizeAdapter) {
                ArtifactToInstallSizeAdapter rhs = (ArtifactToInstallSizeAdapter)obj;
                return this.artifact.equals(rhs.artifact);
            }
            return false;
        }

        public int hashCode() {
            return this.artifact.hashCode();
        }

        @Override
        public long getInstallSize() {
            return this.artifact.getContentInfo().getSizeInfo().getInstallSize();
        }

        public IArtifactKey getArtifactKey() {
            return this.artifact.getKey();
        }

        public long getDownloadSize() {
            return this.artifact.getContentInfo().getSizeInfo().getDownloadSize();
        }

        public Object getAdapter(Class adapter) {
            if (adapter == IArtifact.class) {
                return this.artifact;
            }
            if (adapter.isInstance(this)) {
                return this;
            }
            return null;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append(ArtifactFormatterUtil.toUserString(this.getArtifactKey()));
            sb.append(" installSize=").append(this.getInstallSize());
            sb.append(" downloadSize=").append(this.getDownloadSize());
            return sb.toString();
        }
    }
}

