/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.model.expander;

import com.ibm.cic.common.core.internal.Messages;
import com.ibm.cic.common.core.model.IAssembly;
import com.ibm.cic.common.core.model.IContentSelector;
import com.ibm.cic.common.core.model.IIdentity;
import com.ibm.cic.common.core.model.IIncludedShareableEntity;
import com.ibm.cic.common.core.model.IInstallableUnit;
import com.ibm.cic.common.core.model.IInstallableUnitContainer;
import com.ibm.cic.common.core.model.IInstallationContext;
import com.ibm.cic.common.core.model.IOffering;
import com.ibm.cic.common.core.model.IRequiredShareableEntity;
import com.ibm.cic.common.core.model.ISelectionExpression;
import com.ibm.cic.common.core.model.IShareableEntity;
import com.ibm.cic.common.core.model.IShareableItem;
import com.ibm.cic.common.core.model.IShareableUnit;
import com.ibm.cic.common.core.model.ISuFragment;
import com.ibm.cic.common.core.model.expander.ExpanderUtils;
import com.ibm.cic.common.core.model.expander.IContextState;
import com.ibm.cic.common.core.model.expander.SelectorExpander;
import com.ibm.cic.common.core.model.expander.SimpleContextState;
import com.ibm.cic.common.core.model.utils.OfferingUtil;
import com.ibm.cic.common.core.model.utils.SelectorContext;
import com.ibm.cic.common.core.utils.CicMultiStatus;
import com.ibm.cic.common.core.utils.Comparators;
import com.ibm.cic.common.core.utils.MapList;
import com.ibm.cic.common.core.utils.MapMap;
import com.ibm.cic.common.core.utils.MapSet;
import com.ibm.cic.common.core.utils.NLS;
import com.ibm.cic.common.core.utils.StatusUtil;
import com.ibm.cic.common.core.utils.Statuses;
import com.ibm.cic.common.core.utils.Util;
import com.ibm.cic.common.core.utils.VersionUtil;
import com.ibm.cic.common.logging.Logger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.osgi.service.resolver.VersionRange;
import org.osgi.framework.Version;

class ContextState
extends SimpleContextState
implements IContextState {
    private static final Logger log = SelectorExpander.log;
    private static final Logger sizeLog = Logger.getLogger(log, "sizes");
    private static final Logger seLog = Logger.getLogger(log, "ses");
    private static final SelectorContext NULL_CONTEXT = new SelectorContext(){

        @Override
        public void select(IShareableEntity se, Set<IContentSelector> selectors) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void select(IShareableEntity se, IContentSelector selector) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void deselect(IShareableEntity se, IContentSelector selector) {
            throw new UnsupportedOperationException();
        }
    };
    private CicMultiStatus status = null;
    private Set<IIdentity> included = new LinkedHashSet<IIdentity>(32);
    private final Map<IRequiredShareableEntity, IShareableEntity> required = new LinkedHashMap<IRequiredShareableEntity, IShareableEntity>(32);
    private Set<IIdentity> done = new HashSet<IIdentity>(32);
    private SelectorContext selectorContext = NULL_CONTEXT;
    private final MapList<IShareableItem, IInstallableUnit> ius = MapList.newMapList();
    private IInstallationContext ic = null;
    private Map<IIdentity, IInstallationContext> ics = new HashMap<IIdentity, IInstallationContext>(4);
    private boolean hasToleranceError = false;
    private MapMap<IIdentity, IIdentity, VersionRange> savedSelections = MapMap.newHashHash();
    private final MapMap<IShareableEntity, IIdentity, VersionRange> tolerances = new ToleranceMap();

    ContextState() {
        this(null, null);
    }

    private ContextState(IIdentity id, ContextState parent) {
        super(id, parent);
        this.done.add(DUMMY);
    }

    @Override
    SimpleContextState createSubContext(IIdentity childId) {
        return new ContextState(childId, this);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(32);
        sb.append(this.isRoot() ? "root" : this.getFullId()).append(" (");
        sb.append(this.getShareableEntities().size()).append(" SEs");
        if (!this.getSuFragments().isEmpty()) {
            sb.append(", ").append(this.getSuFragments().size()).append(" fragments");
        }
        if (!this.getSubContexts().isEmpty()) {
            sb.append(' ').append(this.getSubContexts());
        }
        sb.append(')');
        return sb.toString();
    }

    private boolean isEmpty() {
        return this.getSubContexts().isEmpty() && this.ius.isEmpty();
    }

    @Override
    public Collection<IInstallableUnit> getIUs() {
        ArrayList<IInstallableUnit> result = new ArrayList<IInstallableUnit>(2 * this.ius.size());
        for (List list : this.ius.valuesIterable()) {
            result.addAll(list);
        }
        return result;
    }

    @Override
    public List<IInstallableUnit> getIUs(IShareableItem si) {
        return this.ius.get(si);
    }

    @Override
    public void ensureSubContext(IIdentity childId) {
        this.getSubContext(childId);
    }

    public Collection<ContextState> getSubContexts() {
        return super.getSubContexts();
    }

    @Override
    public Collection<IShareableEntity> getShareableEntities() {
        return this.selectorContext.getShareableEntities();
    }

    @Override
    public Set<IContentSelector> getSelected(IShareableEntity se) {
        return this.selectorContext.getSelected(se);
    }

    @Override
    public Map<IIdentity, VersionRange> getTolerances(IShareableEntity se) {
        return this.tolerances.get(se);
    }

    public void addFragmentIUs() {
        if (this.hasSuFragments()) {
            for (Map.Entry entry : this.getFragmentMap().entrySet()) {
                ISuFragment fragment = (ISuFragment)entry.getKey();
                HashSet<IInstallableUnit> seen = new HashSet<IInstallableUnit>();
                for (IShareableUnit su : (List)entry.getValue()) {
                    for (IInstallableUnit iu : this.getSelectedIUs(su, fragment)) {
                        if (!seen.add(iu)) continue;
                        this.add(iu);
                    }
                }
            }
        }
        for (ContextState contextState : this.getSubContexts()) {
            contextState.addFragmentIUs();
        }
    }

    @Override
    public MapList<ISuFragment, IShareableUnit> getFragmentMap() {
        MapList<IIdentity, ISuFragment> targetToFragment = MapList.newMapList();
        for (Set fragmentSet : this.getSuFragments().valuesIterable()) {
            for (ISuFragment fragment : fragmentSet) {
                targetToFragment.add(fragment.getTargetId(), fragment);
            }
        }
        if (targetToFragment.isEmpty()) {
            return MapList.empty();
        }
        MapList<ISuFragment, IShareableUnit> result = MapList.newMapList();
        MapList<ISuFragment, IAssembly> fragmentTargetsAssembly = MapList.newMapList();
        for (IShareableEntity se : this.getShareableEntities()) {
            for (ISuFragment fragment : targetToFragment.get(se.getIdentity())) {
                if (!fragment.getTargetTolerance().isIncluded(se.getVersion())) continue;
                if (se instanceof IShareableUnit) {
                    result.add(fragment, (IShareableUnit)se);
                    continue;
                }
                fragmentTargetsAssembly.add(fragment, (IAssembly)se);
            }
        }
        Set entries = fragmentTargetsAssembly.entrySet();
        for (Map.Entry entry : entries) {
            ISuFragment fragment = (ISuFragment)entry.getKey();
            if (result.contains(fragment)) continue;
            List assemblies = (List)entry.getValue();
            for (IAssembly assembly : assemblies) {
                this.addError(0, Messages.ContextState_Fragment_Targets_Assembly, fragment.getIdentity(), fragment.getVersion(), assembly.getIdentity(), assembly.getVersion());
            }
        }
        return result;
    }

    @Override
    public List<IInstallableUnit> getSelectedIUs(IShareableUnit su, ISuFragment fragment) {
        List fragmentIUs = fragment.getInstallableUnits();
        ArrayList<IInstallableUnit> result = new ArrayList<IInstallableUnit>(fragmentIUs.size());
        for (IInstallableUnit iu : fragmentIUs) {
            if (!this.selectorContext.isSelected(su, fragment, iu.getExpression())) continue;
            result.add(iu);
        }
        return result;
    }

    void logSEs() {
        if (!seLog.isDebugLoggable()) {
            return;
        }
        seLog.debug("SEs in {0}:", this.getFullId());
        for (IShareableEntity iShareableEntity : this.getShareableEntities()) {
            seLog.debug("  {0} {1}", iShareableEntity.getIdentity(), iShareableEntity.getVersion());
            for (Map.Entry entry : this.getTolerances(iShareableEntity).entrySet()) {
                IIdentity id = (IIdentity)entry.getKey();
                VersionRange tolerance = (VersionRange)entry.getValue();
                seLog.debug("    {0} {1}", id, tolerance);
            }
            for (IInstallableUnit iInstallableUnit : this.getIUs(iShareableEntity)) {
                seLog.debug("    {0}", iInstallableUnit.getIdentity());
            }
        }
        for (IShareableItem iShareableItem : this.ius.keySet()) {
            for (IInstallableUnit iInstallableUnit : this.ius.get(iShareableItem)) {
                IInstallableUnitContainer parent = iInstallableUnit.getParent();
                if (this.getShareableEntities().contains(parent)) continue;
                if (this.getParentSEs().contains(parent)) {
                    seLog.debug("IU {0} included by parent SE {1} {2}", iInstallableUnit.getIdentity(), parent.getIdentity(), parent.getVersion());
                    continue;
                }
                seLog.error("Parent {0} {1} of {2} not found in {3}", parent.getIdentity(), parent.getVersion(), iInstallableUnit.getIdentity(), this.getFullId());
            }
        }
        for (ContextState contextState : this.getSubContexts()) {
            contextState.logSEs();
        }
    }

    @Override
    void freeMemory() {
        this.logSizeStats();
        super.freeMemory();
        this.included = null;
        this.done = null;
        this.ics = null;
        this.savedSelections = null;
        for (ContextState subContext : this.getSubContexts()) {
            subContext.freeMemory();
        }
    }

    private void logSizeStats() {
        if (!sizeLog.isDebugLoggable()) {
            return;
        }
        sizeLog.debug("Sizes for {0}", this.getFullId());
        sizeLog.debug("included:        {0}", this.included.size());
        sizeLog.debug("required:        {0}", this.required.size());
        sizeLog.debug("done:            {0}", this.done.size());
        sizeLog.debug("ius2:            {0}", this.ius.getStats());
        sizeLog.debug("ics:             {0}", this.ics.size());
        sizeLog.debug("savedSelections: {0}", this.savedSelections.getStats());
    }

    @Override
    public IInstallationContext getInstallationContext() {
        return this.ic;
    }

    void collectStatus(final CicMultiStatus ms) {
        ExpanderUtils.visitContexts(this, new ExpanderUtils.IContextVisitor(){

            @Override
            public void visit(IContextState state) {
                ContextState cs = (ContextState)state;
                ms.add(cs.status);
                cs.status = null;
            }
        });
    }

    @Override
    public boolean hasToleranceError() {
        final boolean[] result = new boolean[1];
        ExpanderUtils.visitContexts(this, new ExpanderUtils.IContextVisitor(){

            @Override
            public void visit(IContextState state) {
                result[0] = result[0] | ((ContextState)state).hasToleranceError;
            }
        });
        return result[0];
    }

    void setSelectorContext(SelectorContext selectorContext) {
        assert (this.selectorContext == NULL_CONTEXT);
        this.selectorContext = selectorContext;
    }

    private static Collection<IIdentity> getUnselected(Set<IIdentity> selectorIds, Set<IContentSelector> selected) {
        HashSet<IIdentity> selectedIds = new HashSet<IIdentity>(selected.size());
        for (IContentSelector selector : selected) {
            selectedIds.add(selector.getIdentity());
        }
        LinkedList<IIdentity> result = new LinkedList<IIdentity>();
        for (IIdentity selectorId : selectorIds) {
            if (selectedIds.contains(selectorId)) continue;
            result.add(selectorId);
        }
        return result;
    }

    void selectDependentSelectors(IShareableEntity se) {
        Set selectors = se.getSelectors();
        for (IContentSelector selector : selectors) {
            if (!this.isSelected(se, selector)) continue;
            this.selectDependentSelectors(se, selector);
        }
    }

    private void selectDependentSelectors(IShareableEntity se, IContentSelector selector) {
        this.select(se, selector);
        if (!this.canSelectInternalSelections(se, selector)) {
            this.selectorContext.deselect(se, selector);
        } else {
            Set internalSelections = selector.getInternalSelections();
            for (IContentSelector internalSelection : internalSelections) {
                if (this.isSelected(se, internalSelection)) continue;
                this.select(se, internalSelection);
                this.selectDependentSelectors(se, internalSelection);
            }
            Set rses = selector.getRequiredShareableEntities();
            for (IRequiredShareableEntity rse : rses) {
                this.addRequireTolerance(rse, se);
                Set selectorIds = rse.getSelectorIds();
                for (IIdentity selectorId : selectorIds) {
                    this.checkSelector(se, rse.getShareableId(), rse.getTolerance(), selectorId, null);
                    this.saveSelection(rse.getShareableId(), rse.getTolerance(), selectorId);
                }
            }
        }
    }

    private boolean canSelectInternalSelections(IShareableEntity se, IContentSelector selector) {
        Set internalSelections = selector.getInternalSelections();
        for (IContentSelector internalSelection : internalSelections) {
            if (this.isSelected(se, internalSelection) || internalSelection.getExpression() == null) continue;
            return false;
        }
        return true;
    }

    boolean allDone() {
        return this.included.isEmpty();
    }

    @Override
    public void checkRSEs(Map<IIdentity, Version> selectedSEs) {
        MapMap<IIdentity, Version, IShareableEntity> allSEs = MapMap.newHashHash();
        Set<IShareableEntity> ses = this.selectorContext.getShareableEntities();
        for (IShareableEntity se : ses) {
            allSEs.put(se.getIdentity(), se.getVersion(), se);
        }
        MapSet<IIdentity, IIdentity> reported = MapSet.newHash();
        for (Map.Entry<IRequiredShareableEntity, IShareableEntity> entry : this.required.entrySet()) {
            IRequiredShareableEntity rse = entry.getKey();
            IShareableEntity requirer = entry.getValue();
            if (!reported.add(rse.getShareableId(), requirer.getIdentity())) continue;
            Map map = allSEs.get(rse.getShareableId());
            IShareableEntity se = map == null || map.isEmpty() ? null : (selectedSEs != null ? (IShareableEntity)map.get(selectedSEs.get(rse.getShareableId())) : Collections.min(map.values(), Comparators.SE_VERSION));
            if (se != null) {
                Set<IContentSelector> selected = this.selectorContext.getSelected(se);
                Collection<IIdentity> unselected = ContextState.getUnselected(rse.getSelectorIds(), selected);
                for (IIdentity selectorId : unselected) {
                    this.reportUnselectedSelectorRSE(rse, selectorId, requirer);
                }
                continue;
            }
            if (this.getCandidates(rse.getShareableId()).isEmpty()) {
                this.reportUnresolvedRSE(rse, requirer);
                continue;
            }
            this.reportUnselectedRSE(rse, requirer);
        }
    }

    void checkSelector(IShareableEntity se, IIdentity id, VersionRange tolerance, IIdentity selectorId, Set<IOffering> offerings) {
        for (IShareableEntity candidate : this.getCandidates(id)) {
            if (!tolerance.isIncluded(candidate.getVersion())) continue;
            IContentSelector selector = candidate.getSelector(selectorId, false);
            if (selector == null) {
                if (this.anyWidenedTolerances(offerings)) {
                    log.status(Statuses.WARNING.get(204, Messages.ContextState_Undefined_Selector_W, candidate.getIdentity(), candidate.getVersion(), selectorId));
                    continue;
                }
                this.addStatus(Statuses.ERROR.get(204, Messages.ContextState_Undefined_Selector, candidate.getIdentity(), candidate.getVersion(), selectorId));
                continue;
            }
            if (!selector.isInternal()) continue;
            this.addError(0, Messages.ContextState_Illegal_Reference_To_Internal_Selector, selectorId, candidate.getIdentity(), candidate.getVersion(), se.getIdentity(), se.getVersion());
        }
    }

    private boolean anyWidenedTolerances(Set<IOffering> offerings) {
        if (offerings == null) {
            return false;
        }
        for (IOffering offering : offerings) {
            if (!OfferingUtil.areIncludeTolerancesWidened(offering)) continue;
            return true;
        }
        return false;
    }

    IIdentity nextReady() {
        Iterator<IIdentity> i = this.included.iterator();
        while (i.hasNext()) {
            IIdentity id = i.next();
            if (!this.allDepsDone(id)) continue;
            i.remove();
            this.done.add(id);
            return id;
        }
        if (this.findDone()) {
            return this.nextReady();
        }
        IIdentity id = this.findOneFromCycle();
        this.done.add(id);
        this.included.remove(id);
        return id;
    }

    private boolean findDone() {
        log.debug("Calling findDone");
        boolean change = false;
        for (IIdentity id : this.getAllSeIds()) {
            if (this.included.contains(id) || this.done.contains(id) || !this.allDepsDone(id)) continue;
            log.debug("  mark done: {0}", id);
            this.done.add(id);
            change = true;
        }
        return change;
    }

    private boolean allDepsDone(IIdentity id) {
        for (IIdentity depId : this.getDependents(id)) {
            if (this.done.contains(depId)) continue;
            return false;
        }
        return true;
    }

    void addInstallationContext(IInstallationContext subIC) {
        this.ics.put(subIC.getIdentity(), subIC);
    }

    void resolve(ContextState subContext) {
        IInstallationContext subIC = this.ics.get(subContext.getIdentity());
        if (subIC != null) {
            subContext.ic = subIC;
        } else if (!subContext.isEmpty() && (this.status == null || this.status.isOK())) {
            this.reportUnresolvedInstallContext(subContext.getIdentity());
        }
    }

    void validate() {
        MapSet<IIdentity, ISuFragment> fragments = this.getSuFragments();
        if (!fragments.isEmpty()) {
            for (IShareableEntity se : this.getShareableEntities()) {
                if (!fragments.contains(se.getIdentity())) continue;
                this.addError(208, Messages.ContextState_SE_And_Fragment_With_Same_Id, se.getIdentity());
            }
        }
    }

    void add(IInstallableUnit iu) {
        this.ius.add((IShareableItem)((Object)iu.getParent()), iu);
    }

    void select(IShareableEntity se, IContentSelector selector) {
        this.selectorContext.select(se, selector);
    }

    private boolean isSelected(IShareableEntity se, IContentSelector selector) {
        return this.selectorContext.isSelected(se, selector);
    }

    boolean isSelected(IShareableEntity se, ISelectionExpression expr) {
        return this.selectorContext.isSelected(se, expr);
    }

    void saveSelection(IIdentity seId, VersionRange tolerance, IIdentity selectorId) {
        VersionRange prevTolerance = this.savedSelections.get(seId, selectorId);
        if (prevTolerance != null) {
            tolerance = VersionUtil.computeUnion(prevTolerance, tolerance);
        }
        if (tolerance != prevTolerance) {
            this.savedSelections.put(seId, selectorId, tolerance);
        }
    }

    void applySavedSelections(IShareableEntity se) {
        IIdentity seId = se.getIdentity();
        for (Map.Entry<IIdentity, VersionRange> entry : this.savedSelections.get(seId).entrySet()) {
            IContentSelector selector;
            IIdentity selectorId = entry.getKey();
            VersionRange tolerance = entry.getValue();
            if (!tolerance.isIncluded(se.getVersion()) || (selector = se.getSelector(selectorId, false)) == null) continue;
            this.select(se, selector);
        }
    }

    void removeSavedSelections(IIdentity seId) {
        this.savedSelections.remove(seId);
    }

    void addInclude(IIdentity id) {
        this.included.add(id);
    }

    private void addRequireTolerance(IRequiredShareableEntity rse, IShareableEntity requirer) {
        this.required.put(rse, requirer);
        this.addTolerance(requirer, rse.getShareableId(), rse.getTolerance());
    }

    void addIncludeTolerance(IIncludedShareableEntity ise, IShareableEntity includer) {
        this.addTolerance(includer, ise.getIdentity(), ise.getTolerance());
    }

    private void addTolerance(IShareableEntity se, IIdentity id, VersionRange tolerance) {
        VersionRange prevTolerance = this.tolerances.get(se, id);
        if (prevTolerance != null && (tolerance = VersionUtil.computeIntersection(tolerance, prevTolerance)) == null) {
            tolerance = VersionUtil.EMPTY_RANGE;
        }
        this.tolerances.put(se, id, tolerance);
    }

    private void addError(int code, String msg, Object ... args) {
        this.addStatus(Statuses.ERROR.get(code, msg, args));
    }

    private void addStatus(IStatus toAdd) {
        if (this.status == null) {
            this.status = Statuses.ST.createMultiStatus(this.isRoot() ? Messages.ContextState_In_Root_Installation_Context : NLS.bind(Messages.ContextState_In_Installation_Context, (Object)this.getFullId()), new Object[0]);
        }
        this.status.add(toAdd);
        if (log.isDebugLoggable()) {
            log.debug(StatusUtil.toString(toAdd));
        }
    }

    private void reportUnresolvedInstallContext(IIdentity id) {
        this.addError(205, Messages.ContextState_Installation_Context_Not_Resolved, id);
    }

    private void reportUnresolvedRSE(IRequiredShareableEntity rse, IShareableEntity requirer) {
        this.hasToleranceError = true;
        this.addError(201, Messages.ContextState_Required_Component_Not_Found, rse.getShareableId(), requirer.getIdentity());
    }

    private void reportUnselectedSelectorRSE(IRequiredShareableEntity rse, IIdentity selectorId, IShareableEntity requirer) {
        this.hasToleranceError = true;
        this.addError(202, Messages.ContextState_Required_Selector_Not_In_Feature_Selection, selectorId, rse.getShareableId(), rse.getContainingSelector().getIdentity(), requirer.getIdentity());
    }

    private void reportUnselectedRSE(IRequiredShareableEntity rse, IShareableEntity requirer) {
        this.hasToleranceError = true;
        this.addError(203, Messages.ContextState_Required_Component_Not_In_Feature_Selection, rse.getShareableId(), requirer.getIdentity());
    }

    private IIdentity findOneFromCycle() {
        MapSet<Integer, IIdentity> undone = MapSet.newHash();
        int minUndoneDeps = Integer.MAX_VALUE;
        List<IIdentity> cycle = this.findCircularity();
        for (IIdentity id : cycle) {
            int undoneDeps = 0;
            for (IIdentity dep : this.getDependents(id)) {
                if (this.done.contains(dep)) continue;
                ++undoneDeps;
            }
            if (undoneDeps > minUndoneDeps) continue;
            minUndoneDeps = undoneDeps;
            undone.add(undoneDeps, id);
        }
        Set candidates = undone.get(minUndoneDeps);
        IIdentity id = (IIdentity)candidates.iterator().next();
        log.debug(Messages.ContextState_Chose_Component_From_Cycle, id, cycle);
        return id;
    }

    private List<IIdentity> findCircularity() {
        this.logDependents();
        LinkedHashSet<IIdentity> cycle = new LinkedHashSet<IIdentity>(8);
        this.findCircularity(this.included, cycle);
        assert (cycle.size() > 1);
        LinkedList<IIdentity> list = new LinkedList<IIdentity>();
        for (IIdentity id : cycle) {
            list.addFirst(id);
        }
        return list;
    }

    private boolean findCircularity(Collection<IIdentity> ids, Set<IIdentity> cycle) {
        for (IIdentity id : ids) {
            if (this.done.contains(id)) continue;
            if (!cycle.add(id)) {
                Iterator<IIdentity> i = cycle.iterator();
                while (i.hasNext()) {
                    IIdentity id2 = i.next();
                    if (id2.equals(id)) {
                        return true;
                    }
                    i.remove();
                }
                assert (false);
                continue;
            }
            if (this.findCircularity(this.getDependents(id), cycle)) {
                return true;
            }
            cycle.remove(id);
        }
        return false;
    }

    private void logDependents() {
        if (!log.isDebugLoggable()) {
            return;
        }
        StringBuffer sb = new StringBuffer(64 * (this.included.size() + 1));
        sb.append("Dependents not yet done:");
        for (IIdentity id : this.included) {
            sb.append("\n  ").append(id).append(':');
            for (IIdentity dep : this.getDependents(id)) {
                if (this.done.contains(dep)) continue;
                sb.append(' ').append(dep);
            }
        }
        log.debug(sb.toString());
    }

    private static class ToleranceMap
    extends MapMap.MapLinkedHashMap<IShareableEntity, IIdentity, VersionRange> {
        public ToleranceMap() {
            super(new LinkedHashMap(64));
        }

        @Override
        public String toString() {
            return Util.toString(this.toMap(), new Util.MapFormatter(){

                @Override
                protected String emptyString() {
                    return "(empty)";
                }

                @Override
                protected String formatKey(Object value) {
                    IShareableEntity se = (IShareableEntity)value;
                    return se.getIdentity() + " " + se.getVersion();
                }

                @Override
                protected String formatValue(Object value) {
                    return Util.toString((Map)value, new Util.MapFormatter("=", " "));
                }
            });
        }
    }
}

