/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.model.adapterdata;

import com.ibm.cic.common.core.model.IInstallableUnit;
import com.ibm.cic.common.core.model.adapterdata.CommonAdapterData;
import com.ibm.cic.common.core.model.adapterdata.IArtifact;
import com.ibm.cic.common.core.model.adapterdata.IHasAdapterDataChildren;
import com.ibm.cic.common.core.model.adapterdata.IInstallSizeInfo;
import com.ibm.cic.common.core.model.adapterdata.impl.ArtifactKeyUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Platform;

public abstract class IAdapterData
implements IHasAdapterDataChildren,
Cloneable {
    protected ArrayList children = new ArrayList(1);
    private ArrayList installSizes = new ArrayList();
    private Set setActiveAtIndex = new HashSet();
    private IInstallableUnit parent;

    public String toXML(boolean forInconsistentIuCheck) {
        StringBuffer result = new StringBuffer();
        for (CommonAdapterData child : this.children) {
            result.append(child.toXML(forInconsistentIuCheck)).append('\n');
        }
        return result.toString();
    }

    public String toString() {
        return this.installSizes.toString();
    }

    public Collection getInstallSizes() {
        if (this.isReplacementMetadata()) {
            return Collections.EMPTY_LIST;
        }
        return this.getUnfilteredInstallSizes();
    }

    protected Collection getUnfilteredInstallSizes() {
        return Collections.unmodifiableList(this.installSizes);
    }

    public Collection getArtifacts() {
        if (this.isReplacementMetadata()) {
            return Collections.EMPTY_LIST;
        }
        return this.getUnfilteredArtifacts();
    }

    private Collection getUnfilteredArtifacts() {
        ArrayList<IArtifact> artifacts = new ArrayList<IArtifact>(this.installSizes.size());
        for (IInstallSizeInfo installSizeInfo : this.installSizes) {
            IArtifact artifact = IAdapterData.asArtifact(installSizeInfo);
            if (artifact == null) continue;
            artifacts.add(artifact);
        }
        return Collections.unmodifiableList(artifacts);
    }

    public void addArtifact(IArtifact artifact) {
        boolean isActive = false;
        this.addArtifact(artifact, isActive);
    }

    public boolean addArtifact(IArtifact artifact, boolean isActive) {
        IInstallSizeInfo installSizeInfo = IAdapterData.asInstallSizeInfo(artifact);
        return this.addInstallSizeInfo(installSizeInfo, isActive);
    }

    public boolean setArtifacts(IAdapterData adapterData) {
        ArrayList<IInstallSizeInfo> newInstallSizes = new ArrayList<IInstallSizeInfo>(this.installSizes.size());
        HashSet<Integer> newSetActiveAtIndex = new HashSet<Integer>();
        int j = 0;
        int i = 0;
        while (i < adapterData.installSizes.size()) {
            IInstallSizeInfo installSizeInfo = (IInstallSizeInfo)adapterData.installSizes.get(i);
            IArtifact artifact = IAdapterData.asArtifact(installSizeInfo);
            if (artifact != null) {
                boolean foundIt = false;
                while (j < this.installSizes.size()) {
                    IInstallSizeInfo thisInstallSizeInfo = (IInstallSizeInfo)this.installSizes.get(j);
                    IArtifact thisArtifact = IAdapterData.asArtifact(thisInstallSizeInfo);
                    if (thisArtifact != null) {
                        if (!ArtifactKeyUtil.isSameArtifactIgnoreVersion(artifact, thisArtifact)) break;
                        foundIt = true;
                        break;
                    }
                    newInstallSizes.add(thisInstallSizeInfo);
                    ++j;
                }
                if (!foundIt) {
                    return false;
                }
                if (adapterData.setActiveAtIndex.contains(i)) {
                    newSetActiveAtIndex.add(j);
                }
                newInstallSizes.add(installSizeInfo);
                ++j;
            }
            ++i;
        }
        if (!IAdapterData.replaceArtifactXml((IHasAdapterDataChildren)this, adapterData)) {
            return false;
        }
        this.installSizes = newInstallSizes;
        this.setActiveAtIndex = newSetActiveAtIndex;
        return true;
    }

    private static boolean replaceArtifactXml(IHasAdapterDataChildren x, IHasAdapterDataChildren y) {
        ArrayList yc;
        ArrayList xc = IAdapterData.getArtifactXmlChildren(x);
        if (!IAdapterData.artifactXmlMatch(xc, yc = IAdapterData.getArtifactXmlChildren(y))) {
            return false;
        }
        IAdapterData.replaceArtifactXml(x, yc.iterator());
        return true;
    }

    private static void replaceArtifactXml(IHasAdapterDataChildren x, Iterator yIter) {
        CommonAdapterData[] xc;
        CommonAdapterData[] commonAdapterDataArray = xc = x.getChildren();
        int n = xc.length;
        int n2 = 0;
        while (n2 < n) {
            CommonAdapterData data = commonAdapterDataArray[n2];
            if (data.getArtifact() != null) {
                CommonAdapterData newData = (CommonAdapterData)yIter.next();
                data.setArtifact(newData.getArtifact());
            }
            IAdapterData.replaceArtifactXml((IHasAdapterDataChildren)data, yIter);
            ++n2;
        }
    }

    private static ArrayList getArtifactXmlChildren(IHasAdapterDataChildren x) {
        ArrayList result = new ArrayList();
        IAdapterData.getArtifactXmlChildren(x, result);
        return result;
    }

    private static void getArtifactXmlChildren(IHasAdapterDataChildren x, ArrayList result) {
        CommonAdapterData[] xc;
        CommonAdapterData[] commonAdapterDataArray = xc = x.getChildren();
        int n = xc.length;
        int n2 = 0;
        while (n2 < n) {
            CommonAdapterData data = commonAdapterDataArray[n2];
            if (data.getArtifact() != null) {
                result.add(data);
            }
            IAdapterData.getArtifactXmlChildren(data, result);
            ++n2;
        }
    }

    private static boolean artifactXmlMatch(ArrayList xc, ArrayList yc) {
        if (xc.size() != yc.size()) {
            return false;
        }
        Iterator i = xc.iterator();
        Iterator j = yc.iterator();
        while (i.hasNext()) {
            IArtifact ya;
            CommonAdapterData xd = (CommonAdapterData)i.next();
            CommonAdapterData yd = (CommonAdapterData)j.next();
            IArtifact xa = xd.getArtifact();
            if (ArtifactKeyUtil.isSameArtifactIgnoreVersion(xa, ya = yd.getArtifact())) continue;
            return false;
        }
        return true;
    }

    private static IInstallSizeInfo asInstallSizeInfo(IArtifact artifact) {
        IInstallSizeInfo installSizeInfo = (IInstallSizeInfo)Platform.getAdapterManager().getAdapter((Object)artifact, IInstallSizeInfo.class);
        return installSizeInfo;
    }

    public static IArtifact asArtifact(IInstallSizeInfo installSizeInfo) {
        if (installSizeInfo instanceof IAdaptable) {
            IAdaptable adaptable = (IAdaptable)installSizeInfo;
            return (IArtifact)adaptable.getAdapter(IArtifact.class);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addInstallSizeInfo(IInstallSizeInfo installSizeInfo, boolean isActive) {
        ArrayList arrayList = this.installSizes;
        synchronized (arrayList) {
            boolean added = this.installSizes.add(installSizeInfo);
            if (added && isActive) {
                this.setActiveAtIndex.add(this.installSizes.size() - 1);
            }
            return added;
        }
    }

    public boolean isActiveArtifact(IArtifact artifact) {
        IInstallSizeInfo installSizeInfo = IAdapterData.asInstallSizeInfo(artifact);
        return this.isActive(installSizeInfo);
    }

    public boolean isActive(IInstallSizeInfo installSizeInfo) {
        int i = 0;
        while (i < this.installSizes.size()) {
            IInstallSizeInfo isi = (IInstallSizeInfo)this.installSizes.get(i);
            if (installSizeInfo.equals(isi) && this.setActiveAtIndex.contains(i)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public int artifactIndexOf(IArtifact artifact) {
        IInstallSizeInfo installSizeInfo = IAdapterData.asInstallSizeInfo(artifact);
        return this.installSizeIndexOf(installSizeInfo);
    }

    public int installSizeIndexOf(IInstallSizeInfo installSizeInfo) {
        return this.installSizes.indexOf(installSizeInfo);
    }

    public boolean supportsDirectAccess(IArtifact artifact) {
        return false;
    }

    @Override
    public CommonAdapterData[] getChildren() {
        return this.children.toArray(new CommonAdapterData[this.children.size()]);
    }

    public int getChildCount() {
        return this.children.size();
    }

    public CommonAdapterData getChild(int index) {
        return (CommonAdapterData)this.children.get(index);
    }

    public void addChild(CommonAdapterData data) {
        this.children.add(data);
    }

    public boolean isExploded(IInstallSizeInfo installSizeInfo) {
        IArtifact artifact = IAdapterData.asArtifact(installSizeInfo);
        if (artifact != null) {
            return artifact.isExploded();
        }
        return false;
    }

    public IInstallableUnit getParent() {
        return this.parent;
    }

    public void setParent(IInstallableUnit parent) {
        if (parent != this.parent) {
            if (this.parent != null) {
                assert (this.parent.getAdapterData() == this);
                this.parent.setAdapterData(null);
            }
            this.parent = parent;
            if (this.parent != null) {
                this.parent.setAdapterData(this);
            }
        }
    }

    public Object clone() throws CloneNotSupportedException {
        IAdapterData result = (IAdapterData)super.clone();
        result.parent = null;
        ArrayList originalChildren = result.children;
        result.children = new ArrayList(originalChildren.size());
        for (CommonAdapterData child : originalChildren) {
            result.addChild((CommonAdapterData)child.clone());
        }
        return result;
    }

    private boolean isReplacementMetadata() {
        if (this.parent == null) {
            return false;
        }
        String value = this.parent.getProperties().getProperty("replace.metadata");
        return value != null;
    }
}

