/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.model.adapterdata;

import com.ibm.cic.common.core.artifactrepo.IArtifactRepositoryAdapter;
import com.ibm.cic.common.core.internal.artifactrepo.ArtifactRepositoryAdapters;
import com.ibm.cic.common.core.model.adapterdata.ArtifactTypeInfo;
import com.ibm.cic.common.core.model.adapterdata.IArtifactKey;
import com.ibm.cic.common.core.model.adapterdata.IArtifactTypeKeyMapper;
import com.ibm.cic.common.core.model.internal.Messages;
import com.ibm.cic.common.core.utils.NLS;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Map;

public class ArtifactTypesUtil {
    public static Collection getArtifactTypes() {
        Collection namespaces = ArtifactRepositoryAdapters.getAdapterNamespaces();
        LinkedHashSet<String> set = new LinkedHashSet<String>();
        for (String namespace : namespaces) {
            String[] types;
            IArtifactRepositoryAdapter adapter = ArtifactRepositoryAdapters.getAdapter(namespace);
            if (adapter == null) continue;
            String[] stringArray = types = adapter.getSupportedArtifactTypes();
            int n = types.length;
            int n2 = 0;
            while (n2 < n) {
                String type = stringArray[n2];
                set.add(type);
                ++n2;
            }
        }
        ArrayList list = new ArrayList(set);
        Collections.sort(list);
        return list;
    }

    public static IArtifactTypeKeyMapper getArtifactTypeKeyMapperForType(String wantedType) throws ArtifactTypeRegistryException {
        IArtifactTypeKeyMapper[] mappers = ArtifactTypesUtil.getArtifactTypeKeyMappersForType(wantedType);
        if (mappers.length == 0) {
            throw new ArtifactTypeRegistryException(NLS.bind(Messages.ArtifactTypesUtil_typeNotRegistered, (Object)wantedType));
        }
        if (mappers.length > 1) {
            throw new ArtifactTypeRegistryException(NLS.bind(Messages.ArtifactTypesUtil_typeRegisteredMultipleTimes, (Object)wantedType, Arrays.asList(mappers)));
        }
        return mappers[0];
    }

    public static IArtifactTypeKeyMapper getArtifactTypeKeyMapper(String wantedNamespace, String wantedQualifier) throws ArtifactTypeRegistryException {
        IArtifactTypeKeyMapper[] mappers = ArtifactTypesUtil.getArtifactTypeKeyMappers(wantedNamespace, wantedQualifier);
        if (mappers.length == 0) {
            throw new ArtifactTypeRegistryException(NLS.bind(Messages.ArtifactTypesUtil_artifactNotRegistered, (Object)wantedNamespace, (Object)wantedQualifier));
        }
        if (mappers.length > 1) {
            throw new ArtifactTypeRegistryException(NLS.bind(Messages.ArtifactTypesUtil_artifactRegisteredMultipleTimes, wantedNamespace, wantedQualifier, Arrays.asList(mappers)));
        }
        IArtifactTypeKeyMapper mapper = mappers[0];
        return mapper;
    }

    private static IArtifactTypeKeyMapper[] getArtifactTypeKeyMappersForType(String wantedType) {
        Collection namespaces = ArtifactRepositoryAdapters.getAdapterNamespaces();
        ArrayList<IArtifactTypeKeyMapper> list = new ArrayList<IArtifactTypeKeyMapper>();
        for (String namespace : namespaces) {
            String[] types;
            IArtifactRepositoryAdapter adapter = ArtifactRepositoryAdapters.getAdapter(namespace);
            if (adapter == null) continue;
            String[] stringArray = types = adapter.getSupportedArtifactTypes();
            int n = types.length;
            int n2 = 0;
            while (n2 < n) {
                String type = stringArray[n2];
                if (wantedType == null || wantedType.equals(type)) {
                    IArtifactTypeKeyMapper mapper = adapter.getTypeKeyMapper(type);
                    list.add(mapper);
                }
                ++n2;
            }
        }
        return list.toArray(new IArtifactTypeKeyMapper[list.size()]);
    }

    private static IArtifactTypeKeyMapper[] getArtifactTypeKeyMappers(String wantedNamespace, String wantedQualifier) {
        Collection namespaces = ArtifactRepositoryAdapters.getAdapterNamespaces();
        ArrayList<IArtifactTypeKeyMapper> list = new ArrayList<IArtifactTypeKeyMapper>();
        for (String namespace : namespaces) {
            String[] types;
            IArtifactRepositoryAdapter adapter;
            if (!namespace.equals(wantedNamespace) || (adapter = ArtifactRepositoryAdapters.getAdapter(namespace)) == null) continue;
            String[] stringArray = types = adapter.getSupportedArtifactTypes();
            int n = types.length;
            int n2 = 0;
            while (n2 < n) {
                String type = stringArray[n2];
                IArtifactTypeKeyMapper mapper = adapter.getTypeKeyMapper(type);
                ArtifactTypeInfo ati = mapper.getArtifactTypeInfo();
                if (ati.getKeyQualifier().equals(wantedQualifier)) {
                    list.add(mapper);
                }
                ++n2;
            }
        }
        return list.toArray(new IArtifactTypeKeyMapper[list.size()]);
    }

    public static String getArtifactType(IArtifactKey key) {
        Map map = ArtifactTypesUtil.getArtifactTypeValues(key);
        if (map != null) {
            return (String)map.get("type");
        }
        return null;
    }

    public static String getArtifactExt(IArtifactKey key) {
        Map map = ArtifactTypesUtil.getArtifactTypeValues(key);
        if (map != null) {
            return (String)map.get("ext");
        }
        return null;
    }

    public static Map getArtifactTypeValues(IArtifactKey key) {
        String[] strTypes;
        IArtifactRepositoryAdapter types = ArtifactRepositoryAdapters.getAdapter(key.getNamespace());
        String[] stringArray = strTypes = types.getSupportedArtifactTypes();
        int n = strTypes.length;
        int n2 = 0;
        while (n2 < n) {
            String strType = stringArray[n2];
            IArtifactTypeKeyMapper km = types.getTypeKeyMapper(strType);
            ArtifactTypeInfo ati = km.getArtifactTypeInfo();
            if (ati.getKeyQualifier().equals(key.getQualifier())) {
                return km.makeTypeArgsFromKey(key);
            }
            ++n2;
        }
        return null;
    }

    public static class ArtifactTypeRegistryException
    extends Exception {
        public ArtifactTypeRegistryException(String msg) {
            super(msg);
            assert (msg != null);
        }
    }
}

