/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.model;

import com.ibm.cic.common.core.model.internal.IXMLConstants;
import com.ibm.cic.common.core.utils.XMLUtil;

public class Information
implements IXMLConstants {
    private String name;
    private String nameKey;
    private String version;
    private String versionKey;
    private String description;
    private String descriptionKey;
    private String provider;
    private String providerKey;

    public Information(String name) {
        this.name = this.nameKey = name;
    }

    public Information(String name, String description) {
        this(name);
        this.description = this.descriptionKey = description;
    }

    public Information(String name, String version, String description, String provider) {
        this(name, description);
        this.version = this.versionKey = version;
        this.provider = this.providerKey = provider;
    }

    public Information() {
    }

    public String getName() {
        return this.name;
    }

    public String getNameKey() {
        return this.nameKey;
    }

    public void setName(String name) {
        this.name = name;
        if (this.nameKey == null) {
            this.nameKey = name;
        }
    }

    public void setNameKey(String key) {
        this.nameKey = key;
        if (this.name == null) {
            this.name = key;
        }
    }

    public String getVersion() {
        return this.version;
    }

    public String getVersionKey() {
        return this.versionKey;
    }

    public void setVersion(String version) {
        this.version = version;
        if (this.versionKey == null) {
            this.versionKey = version;
        }
    }

    public void setVersionKey(String key) {
        this.versionKey = key;
        if (this.version == null) {
            this.version = key;
        }
    }

    public String getProvider() {
        return this.provider;
    }

    public String getProviderKey() {
        return this.providerKey;
    }

    public void setProvider(String provider) {
        this.provider = provider;
        if (this.providerKey == null) {
            this.providerKey = provider;
        }
    }

    public void setProviderKey(String key) {
        this.providerKey = key;
        if (this.provider == null) {
            this.provider = key;
        }
    }

    public String getDescription() {
        return this.description;
    }

    public String getDescriptionKey() {
        return this.descriptionKey;
    }

    public void setDescription(String description) {
        this.description = description;
        if (this.descriptionKey == null) {
            this.descriptionKey = description;
        }
    }

    public void setDescriptionKey(String key) {
        this.descriptionKey = key;
        if (this.description == null) {
            this.description = key;
        }
    }

    public String toString() {
        return this.toXML();
    }

    private String toXML() {
        return XMLUtil.simpleElement("information", this.getAttributePairs());
    }

    private String[] getAttributePairs() {
        return new String[]{"name", this.nameKey, "version", this.versionKey, "provider", this.providerKey, "description", this.leading(40, this.descriptionKey)};
    }

    private String leading(int num, String s) {
        return s == null || s.length() < num ? s : String.valueOf(s.substring(0, num - 1)) + "...";
    }
}

