/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.model;

import com.ibm.cic.common.core.model.IIdentity;
import com.ibm.cic.common.core.model.IIncludedShareableEntity;
import com.ibm.cic.common.core.model.IShareableEntity;
import com.ibm.cic.common.core.model.IncludedShareableEntitySelector;
import com.ibm.cic.common.core.model.SelectableNode;
import com.ibm.cic.common.core.utils.VersionUtil;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.osgi.service.resolver.VersionRange;
import org.osgi.framework.Version;

public class IncludedShareableEntity
extends SelectableNode
implements IIncludedShareableEntity {
    private VersionRange tolerance;
    private Set includedSelectors;

    public IncludedShareableEntity(IIdentity id, Version version, VersionRange tolerance) {
        super(id, version);
        this.tolerance = tolerance;
    }

    public IncludedShareableEntity(IShareableEntity shareableEntity, VersionRange tolerance) {
        super(shareableEntity.getIdentity(), shareableEntity.getVersion());
        this.setContent(shareableEntity);
        this.tolerance = tolerance;
    }

    public IncludedShareableEntity(IShareableEntity shareableEntity) {
        this(shareableEntity, null);
        this.tolerance = VersionUtil.getDefaultTolerance(shareableEntity.getVersion());
    }

    @Override
    public IShareableEntity getShareableEntity() {
        return (IShareableEntity)this.getContent();
    }

    @Override
    public void setShareableEntity(IShareableEntity shareableEntity) {
        this.setContent(shareableEntity);
    }

    public String toString() {
        return "<includedShareableEntity id='" + this.getIdentity() + "' version='" + this.getVersion() + "' tolerance='" + this.tolerance + "'>";
    }

    @Override
    public VersionRange getTolerance() {
        return this.tolerance;
    }

    @Override
    public void setTolerance(VersionRange tolerance) {
        this.tolerance = tolerance;
    }

    public boolean hasIncludedShareableEntitySelectors() {
        return this.includedSelectors != null && !this.includedSelectors.isEmpty();
    }

    @Override
    public Set getIncludedShareableEntitySelectors() {
        if (this.includedSelectors == null) {
            this.includedSelectors = new LinkedHashSet(2);
        }
        return this.includedSelectors;
    }

    @Override
    public void addIncludedSelector(IncludedShareableEntitySelector selector) {
        this.getIncludedShareableEntitySelectors().add(selector);
    }
}

