/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.model;

import com.ibm.cic.common.core.model.IFix;
import com.ibm.cic.common.core.model.IFixApplicableOffering;
import com.ibm.cic.common.core.model.IIdentity;
import com.ibm.cic.common.core.model.IOffering;
import com.ibm.cic.common.core.model.IProblemResolved;
import com.ibm.cic.common.core.model.IVersionedIdentity;
import com.ibm.cic.common.core.model.SimpleVersionedIdentity;
import com.ibm.cic.common.core.model.internal.Messages;
import com.ibm.cic.common.core.model.utils.OfferingProperty;
import com.ibm.cic.common.core.model.utils.OfferingUtil;
import com.ibm.cic.common.core.model.utils.PlatformFilter;
import com.ibm.cic.common.core.model.utils.SupportedPlatforms;
import com.ibm.cic.common.core.repository.SliceUtils;
import com.ibm.cic.common.core.utils.CicMultiStatus;
import com.ibm.cic.common.core.utils.MapSet;
import com.ibm.cic.common.core.utils.NLS;
import com.ibm.cic.common.core.utils.Statuses;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.osgi.service.resolver.VersionRange;
import org.osgi.framework.Version;

public class FixUtil {
    public static boolean isFixApplicable(IFix fix, Collection offerings) {
        return FixUtil.findApplicableOffering(fix, offerings) != null;
    }

    public static IOffering findApplicableOffering(IFix fix, Collection offerings) {
        for (IOffering offering : offerings) {
            if (!FixUtil.isFixApplicable(fix, offering)) continue;
            return offering;
        }
        return null;
    }

    public static boolean isFixApplicable(IFix fix, IOffering offering) {
        return FixUtil.isFixApplicable(fix, offering.getIdentity(), offering.getVersion());
    }

    public static boolean isFixApplicable(IFix fix, IIdentity offeringId, Version offeringVersion) {
        for (IFixApplicableOffering applicableOffering : fix.getApplicableOfferings()) {
            if (!applicableOffering.getIdentity().equals(offeringId) || !applicableOffering.getTolerance().isIncluded(offeringVersion)) continue;
            return true;
        }
        return false;
    }

    public static boolean canFixApply(IFix fix, IIdentity offeringId) {
        for (IFixApplicableOffering applicableOffering : fix.getApplicableOfferings()) {
            if (!applicableOffering.getIdentity().equals(offeringId)) continue;
            return true;
        }
        return false;
    }

    public static IVersionedIdentity getSingleApplicableOfferingVersion(IFix fix) {
        List list = fix.getApplicableOfferings();
        if (list.size() != 1) {
            return null;
        }
        IFixApplicableOffering applicable = (IFixApplicableOffering)list.get(0);
        VersionRange r = applicable.getTolerance();
        Version theVersion = null;
        if (r.getMinimum().equals((Object)r.getRight()) && r.getIncludeMaximum() && r.getIncludeMinimum()) {
            theVersion = r.getRight();
        }
        if (theVersion == null) {
            return null;
        }
        return new SimpleVersionedIdentity(applicable.getIdentity(), theVersion);
    }

    private static String[] reportFixOfferingApplicabilityNotSatisfied(IFix fix, IApplicableOfferingLocator offeringLocator) {
        ArrayList<String> list = new ArrayList<String>();
        for (IFixApplicableOffering applicableOffering : fix.getApplicableOfferings()) {
            IOffering offering = offeringLocator.getMatchingOffering(applicableOffering);
            if (offering != null) {
                String version = OfferingUtil.getDisplayableVersion(offering);
                list.add(NLS.bind(Messages.FixUtil_offeringApplicabilityWithSample, offering.getName(), applicableOffering.getTolerance(), version));
                continue;
            }
            offering = offeringLocator.getLatestOffering(applicableOffering);
            if (offering != null) {
                list.add(NLS.bind(Messages.FixUtil_offeringApplicability, (Object)offering.getName(), (Object)applicableOffering.getTolerance()));
                continue;
            }
            list.add(NLS.bind(Messages.FixUtil_offeringApplicabilityWithInternalIdOnly, (Object)applicableOffering.getIdentity(), (Object)applicableOffering.getTolerance()));
        }
        return list.toArray(new String[list.size()]);
    }

    public static void reportFixOfferingApplicabilityNotSatisfied(CicMultiStatus ms, IFix fix, IApplicableOfferingLocator offeringLocator) {
        String[] issues;
        String[] stringArray = issues = FixUtil.reportFixOfferingApplicabilityNotSatisfied(fix, offeringLocator);
        int n = issues.length;
        int n2 = 0;
        while (n2 < n) {
            String msg = stringArray[n2];
            ms.add(Statuses.ERROR.get(msg, new Object[0]));
            ++n2;
        }
    }

    public static String getProblemResolvedDescription(IProblemResolved problem) {
        String pDesc = problem.getDescription();
        return pDesc == null || pDesc.length() == 0 ? problem.getDisplayId() : pDesc;
    }

    public static MapSet<String, String> getSupportedPlatforms(IFix fix) {
        String supportedPlatforms = OfferingProperty.getSupportedPlatforms(fix);
        if (supportedPlatforms == null) {
            return null;
        }
        PlatformFilter spFilter = new PlatformFilter(supportedPlatforms);
        MapSet<String, String> supportedPlatformsMap = MapSet.newLinkedHash();
        Set<String> supportOSList = SupportedPlatforms.getInstance().getOsValues();
        for (String os : supportOSList) {
            Set<String> allArchsList = SupportedPlatforms.getInstance().getArchValues(os);
            TreeSet<String> supportedArchs = new TreeSet<String>();
            for (String arch : allArchsList) {
                if (!spFilter.matchesPlatform(os, arch).isOK()) continue;
                supportedArchs.add(arch);
            }
            for (String arch : supportedArchs) {
                if (!SliceUtils.checkPlatform(fix, os, arch).isOK()) continue;
                supportedPlatformsMap.add(os, arch);
            }
        }
        return supportedPlatformsMap;
    }

    public static interface IApplicableOfferingLocator {
        public IOffering getMatchingOffering(IFixApplicableOffering var1);

        public IOffering getLatestOffering(IFixApplicableOffering var1);
    }
}

