/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.internal.volrepo;

import com.ibm.cic.common.core.internal.ComIbmCicCommonCorePlugin;
import com.ibm.cic.common.core.internal.volrepo.DiskMountUtil;
import com.ibm.cic.common.core.internal.volrepo.DiskMounter;
import com.ibm.cic.common.core.internal.volrepo.IDiskMounterFactory;
import com.ibm.cic.common.core.internal.volrepo.Messages;
import com.ibm.cic.common.core.repository.ICicLocation;
import com.ibm.cic.common.core.utils.FileURLUtil;
import com.ibm.cic.common.core.volrepo.IVolumeRepositoryStatusCodes;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;

public class DiskMounterFactory
implements IDiskMounterFactory,
IVolumeRepositoryStatusCodes {
    private static String pluginId = ComIbmCicCommonCorePlugin.getPluginId();
    private final ICicLocation rootDir;
    private final boolean askForDisk1;
    private final String requestedDiskSetId;
    public static final Integer ANY_DISK = -1;

    public DiskMounterFactory(boolean askForDisk1, ICicLocation rootDir, String requestedDiskSetId) {
        this.askForDisk1 = askForDisk1;
        this.rootDir = rootDir;
        this.requestedDiskSetId = requestedDiskSetId;
    }

    @Override
    public DiskMounter mount(Boolean argAskForDisk, Integer argDiskIndex) throws CoreException {
        if (!FileURLUtil.isFileLocation(this.rootDir.toString())) {
            String msg = NLS.bind((String)Messages.DiskMount_failed, (Object)this.rootDir.toString());
            Status status = new Status(4, pluginId, 11, msg, null);
            throw new CoreException((IStatus)status);
        }
        boolean isSimulatedMountPoint = DiskMountUtil.isSimulatedMountPoint(this.rootDir);
        boolean usedAskForDisk1 = argAskForDisk != null ? argAskForDisk : this.askForDisk1;
        int i = argDiskIndex != null ? argDiskIndex : 0;
        Integer diskIndex = ANY_DISK.equals(argDiskIndex) ? null : Integer.valueOf(i);
        MultiStatus ms = new MultiStatus(pluginId, 11, Messages.DiskMount_failed_multi_status, null);
        DiskMounter mounter = null;
        try {
            mounter = new DiskMounter(usedAskForDisk1 || isSimulatedMountPoint, this.rootDir, null, this.requestedDiskSetId, diskIndex);
        }
        catch (CoreException e) {
            IStatus status = e.getStatus();
            if (status.matches(8)) {
                ms.add(status);
                throw new CoreException((IStatus)ms);
            }
            assert (status.matches(4));
            if (isSimulatedMountPoint) {
                ms.add(status);
                throw new CoreException((IStatus)ms);
            }
            if (status.getCode() == 15) {
                ms.add(status);
                throw new CoreException((IStatus)ms);
            }
            ICicLocation appendedDisk1 = this.rootDir.append("disk1");
            try {
                mounter = new DiskMounter(false, appendedDisk1, null, this.requestedDiskSetId, diskIndex);
            }
            catch (CoreException e2) {
                IStatus status2 = e2.getStatus();
                ms.add(status);
                ms.add(status2);
                throw new CoreException((IStatus)ms);
            }
        }
        assert (mounter != null);
        return mounter;
    }

    public ICicLocation getCanonicalRootDir() {
        return this.rootDir;
    }

    public String getRequestedDiskSetId() {
        return this.requestedDiskSetId;
    }
}

