/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.internal.utils;

import com.ibm.cic.common.core.downloads.TransferUtils;
import com.ibm.cic.common.core.internal.ComIbmCicCommonCorePlugin;
import com.ibm.cic.common.core.model.IContent;
import com.ibm.cic.common.core.model.Parser;
import com.ibm.cic.common.logging.Logger;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.xml.sax.SAXException;

public class CicParserUtils {
    public static IContent getObjectFromFile(String fileName) {
        IContent return_value = null;
        try {
            return CicParserUtils.getObjectFromFile(fileName, false);
        }
        catch (IOException e) {
            e.printStackTrace();
            return return_value;
        }
    }

    public static IContent getObjectFromFile(String fileName, boolean includeBuildData) throws IOException {
        try (FileInputStream is = new FileInputStream(new File(fileName));){
            IContent iContent = CicParserUtils.getObjectFromStream(is, fileName, includeBuildData);
            return iContent;
        }
    }

    public static IContent getObjectFromStream(InputStream inputStream, String filePath, boolean includeBuildData) throws IOException {
        IContent return_value = null;
        Parser cp = new Parser(ComIbmCicCommonCorePlugin.getBundleContext());
        cp.setParseBuildData(includeBuildData);
        try {
            if (inputStream != null) {
                return_value = cp.parse(inputStream, filePath);
            }
        }
        catch (SAXException e) {
            Logger.getGlobalLogger().error(e, e.getLocalizedMessage(), new Object[0]);
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        return return_value;
    }

    public static InputStream getStreamForURL(URL url) throws FileNotFoundException {
        InputStream return_value = null;
        try {
            return_value = TransferUtils.getStreamForURL(url, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (FileNotFoundException e) {
            throw e;
        }
        catch (CoreException e) {
            Logger.getGlobalLogger().info(e.getLocalizedMessage(), new Object[]{e});
        }
        return return_value;
    }

    public static IContent getObjectFromFile(URL url, boolean includeBuildData) throws IOException {
        return CicParserUtils.getObjectFromStream(CicParserUtils.getStreamForURL(url), url.getPath(), includeBuildData);
    }
}

