/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.internal.repository;

import com.ibm.cic.common.core.artifactrepo.impl.ContentInfoComputation;
import com.ibm.cic.common.core.downloads.TransferUtils;
import com.ibm.cic.common.core.internal.ComIbmCicCommonCorePlugin;
import com.ibm.cic.common.core.internal.Messages;
import com.ibm.cic.common.core.internal.downloads.FileContentInfo;
import com.ibm.cic.common.core.internal.repository.TocVersionInfo;
import com.ibm.cic.common.core.internal.utils.CicCommonCorePluginTrace;
import com.ibm.cic.common.core.model.internal.DigestAttributes;
import com.ibm.cic.common.core.repository.CicFileLocation;
import com.ibm.cic.common.core.repository.ICicLocation;
import com.ibm.cic.common.core.utils.AdvisoryLockedFile;
import com.ibm.cic.common.core.utils.FileUtil;
import com.ibm.cic.common.core.utils.MetaInfo;
import com.ibm.cic.common.core.utils.NLS;
import com.ibm.cic.common.core.utils.PathUtil;
import com.ibm.cic.common.core.utils.SplitProgressMonitor;
import com.ibm.cic.common.core.utils.UserOptions;
import com.ibm.cic.common.core.utils.XMLUtil;
import com.ibm.cic.common.core.utils.XMLWriter;
import com.ibm.cic.common.downloads.ContentInfoUtil;
import com.ibm.cic.common.downloads.IContentInfo;
import com.ibm.cic.common.downloads.IDownloadSession;
import com.ibm.cic.common.downloads.IMessageDigests;
import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.SyncFailedException;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.osgi.framework.Version;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class TableOfContents {
    private static final CicCommonCorePluginTrace trace = ComIbmCicCommonCorePlugin.getTrace();
    public static final String TOC_XML = "toc.xml";
    public static final ICicLocation TOC_XML_LOCATION = new CicFileLocation("toc.xml");
    private static final String EMPTY_STRING = "";
    private static XMLWriter.ProcessingInstruction tocPI = new XMLWriter.ProcessingInstruction("toc", "version='0.0.1'");

    private TableOfContents() {
    }

    public static synchronized Toc getToc(ICicLocation contentFolderPath, IContentInfo contentInfo, IProgressMonitor monitor) throws Exception {
        return TableOfContents.getTocAt(TableOfContents.getTocParameters(), contentFolderPath.append(TOC_XML), contentInfo, monitor);
    }

    public static synchronized Toc getToc(File file, IContentInfo contentInfo, IProgressMonitor monitor) throws Exception {
        return TableOfContents.getTocAt(TableOfContents.getTocParameters(), file, contentInfo, monitor);
    }

    static synchronized Toc getTocAt(Parameters params, ICicLocation fileLocation, IContentInfo contentInfo, IProgressMonitor monitor) throws Exception {
        return TableOfContents.getTocAt(params, fileLocation.toFile(), contentInfo, monitor);
    }

    static synchronized Toc getTocAt(Parameters params, File file, IContentInfo contentInfo, IProgressMonitor monitor) throws Exception {
        trace.entering();
        Toc toc = new Toc();
        try (TocFile tocFile = null;){
            tocFile = new TocFile(file, true);
            tocFile.lock();
            FileInputStream input = tocFile.getInputStream();
            if (input != null) {
                TableOfContents.parseToc(params, toc, tocFile.getLocation(), new BufferedInputStream(input));
            }
        }
        trace.exiting();
        return toc;
    }

    public static synchronized Toc getToc(IDownloadSession session, URL contentFolderUrl, IContentInfo contentInfo, IProgressMonitor monitor) throws Exception {
        return TableOfContents.getTocAt(session, TableOfContents.getTocParameters(), new URL(PathUtil.concatPathSegments(contentFolderUrl.toString(), TOC_XML)), contentInfo, monitor);
    }

    static synchronized Toc getTocAt(IDownloadSession session, Parameters params, URL tocUrl, IContentInfo contentInfo, IProgressMonitor monitor) throws Exception {
        trace.entering();
        Toc toc = new Toc();
        TableOfContents.parseToc(params, toc, tocUrl.toString(), TransferUtils.getValidatedStream(session, tocUrl, contentInfo, monitor));
        trace.exiting();
        return toc;
    }

    public static synchronized void addTocEntries(IDownloadSession session, ICicLocation contentFolderPath, IContentInfo contentInfoBeforeChanges, Collection entriesToAdd, IOnTocSaved onSaved, IProgressMonitor monitor) throws IOException {
        TableOfContents.addTocEntriesAt(session, TableOfContents.getTocParameters(), contentFolderPath.append(TOC_XML), contentInfoBeforeChanges, entriesToAdd, onSaved, monitor);
    }

    private static Parameters getTocParameters() {
        return new Parameters(UserOptions.useNonArtifactMD5s());
    }

    static void addTocEntriesAt(IDownloadSession session, Parameters params, ICicLocation tocFileLocation, IContentInfo contentInfoBeforeChanges, Collection entriesToAdd, IOnTocSaved onSaved, IProgressMonitor monitor) throws IOException {
        trace.entering();
        Toc toc = new Toc();
        try (AdvisoryLockedFile tocFile = null;){
            tocFile = new TocFile(tocFileLocation.toFile(), false);
            tocFile.lock();
            TocUpdate tocUpdate = new TocUpdate(toc, entriesToAdd, onSaved){

                @Override
                public boolean doUpdate(IProgressMonitor m) {
                    m.beginTask(TableOfContents.EMPTY_STRING, this.tocEntriesToUpdate.size());
                    for (TocEntry toupdate : this.tocEntriesToUpdate) {
                        TocEntry current = this.toc.getEntry(toupdate.getFileName());
                        if (current == null) {
                            this.toc.addEntry(toupdate);
                            this.isDirty = true;
                        } else if (!current.equals(toupdate)) {
                            this.toc.removeEntry(toupdate.getFileName());
                            this.toc.addEntry(toupdate);
                            this.isDirty = true;
                        }
                        m.worked(1);
                    }
                    return this.isDirty;
                }
            };
            TableOfContents.updateToc(params, (TocFile)tocFile, tocUpdate, monitor);
        }
        trace.exiting();
    }

    public static synchronized void removeTocEntries(IDownloadSession session, ICicLocation contentFolderPath, IContentInfo contentInfoBeforeChanges, Collection entriesToRemove, IOnTocSaved onSaved, IProgressMonitor monitor) throws IOException {
        TableOfContents.removeTocEntriesAt(session, TableOfContents.getTocParameters(), contentFolderPath.append(TOC_XML), contentInfoBeforeChanges, entriesToRemove, onSaved, monitor);
    }

    static synchronized void removeTocEntriesAt(IDownloadSession session, Parameters params, ICicLocation tocFileLocation, IContentInfo contentInfoBeforeChanges, Collection entriesToRemove, IOnTocSaved onSaved, IProgressMonitor monitor) throws IOException {
        trace.entering();
        Toc toc = new Toc();
        try (AdvisoryLockedFile tocFile = null;){
            tocFile = new TocFile(tocFileLocation.toFile(), false);
            tocFile.lock();
            TocUpdate tocUpdate = new TocUpdate(toc, entriesToRemove, onSaved){

                @Override
                public boolean doUpdate(IProgressMonitor m) {
                    m.beginTask(TableOfContents.EMPTY_STRING, this.tocEntriesToUpdate.size());
                    for (String toupdate : this.tocEntriesToUpdate) {
                        if (this.toc.removeEntry(toupdate) != null) {
                            this.isDirty = true;
                        }
                        m.worked(1);
                    }
                    return this.isDirty;
                }
            };
            TableOfContents.updateToc(params, (TocFile)tocFile, tocUpdate, monitor);
        }
        trace.exiting();
    }

    private static void parseToc(Parameters params, Toc toc, String location, InputStream input) throws Exception {
        try {
            SAXParser parser = SAXParserFactory.newInstance().newSAXParser();
            parser.parse(input, (DefaultHandler)new TocHandler(params, toc, location));
        }
        catch (Exception e) {
            trace.catching(e);
            throw e;
        }
    }

    private static void updateToc(Parameters params, TocFile tocFile, TocUpdate tocUpdate, IProgressMonitor monitor) throws IOException {
        FileInputStream input = tocFile.getInputStream();
        if (input != null) {
            try {
                SAXParser parser = SAXParserFactory.newInstance().newSAXParser();
                parser.parse((InputStream)new BufferedInputStream(input), (DefaultHandler)new TocHandler(params, tocUpdate.getToc(), tocFile.getLocation()));
            }
            catch (Exception e) {
                trace.catching(e);
                ComIbmCicCommonCorePlugin.log(e.toString());
            }
        }
        TableOfContents.writeToc(params, tocFile, tocUpdate, monitor);
    }

    private static void writeToc(Parameters params, TocFile tocFile, TocUpdate tocUpdate, IProgressMonitor monitor) throws IOException {
        SplitProgressMonitor spm = new SplitProgressMonitor(monitor, 2);
        try {
            if (tocUpdate.doUpdate(spm.next())) {
                if (params.supportDigests()) {
                    TableOfContents.writeXML_version_1(tocFile, tocUpdate, spm.next());
                } else {
                    TableOfContents.writeXML_version_none(tocFile, tocUpdate);
                }
            }
        }
        finally {
            spm.done();
        }
    }

    private static void writeXML_version_none(TocFile tocFile, TocUpdate tocUpdate) throws IOException, UnsupportedEncodingException, SyncFailedException {
        tocFile.seek(0L);
        PrintWriter writer = null;
        try {
            writer = new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)tocFile.getOutputStream(), "UTF-8")));
            writer.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
            writer.println("<toc>");
            Toc toc = tocUpdate.getToc();
            for (TocEntry entry : toc.getEntries()) {
                String fileName = entry.getFileName();
                String fileAlias = entry.getAlias();
                writer.print("    <file name=\"" + XMLUtil.escape(fileName));
                if (fileAlias == null || fileAlias.length() == 0) {
                    writer.println("\"/>");
                    continue;
                }
                writer.println("\" alias=\"" + XMLUtil.escape(fileAlias) + "\"/>");
            }
            writer.println("</toc>");
            writer.flush();
            tocFile.setLength(tocFile.getFilePointer());
            FileUtil.fdSync(tocFile.getFD());
        }
        finally {
            if (writer != null) {
                tocFile.getChannel().close();
                writer.close();
            }
        }
    }

    private static void writeXML_version_1(TocFile tocFile, TocUpdate tocUpdate, IProgressMonitor monitor) throws IOException, UnsupportedEncodingException, SyncFailedException {
        tocFile.seek(0L);
        OutputStream os = null;
        PrintWriter writer = null;
        try {
            FileContentInfo contentInfo = null;
            if (tocUpdate.getOnSaved() != null) {
                String algorithm = ContentInfoComputation.getPreferredAlgorithms()[0];
                contentInfo = new FileContentInfo(null, null);
                os = new ContentInfoComputation.ComputeContentInfoOutputStream(Collections.singletonList(algorithm), contentInfo, tocFile.getOutputStream());
            } else {
                os = tocFile.getOutputStream();
            }
            writer = new PrintWriter(new BufferedWriter(new OutputStreamWriter(os, "UTF-8")));
            writer.println("<?xml version='1.0' encoding='UTF-8'?>");
            Toc toc = tocUpdate.getToc();
            writer.println(tocPI.toString());
            writer.println("<toc fileCount='" + Integer.toString(toc.getEntries().size()) + "'>");
            for (TocEntry entry : toc.getEntries()) {
                FileContentInfo entryContentInfo2;
                long downloadSize2;
                FileContentInfo entryContentInfo;
                long downloadSize;
                StringBuffer sb = new StringBuffer();
                String fileName = entry.getFileName();
                String fileAlias = entry.getAlias();
                sb.append("    <file name='");
                sb.append(XMLUtil.escape(fileName));
                sb.append("'");
                if (fileAlias != null && fileAlias.length() > 0) {
                    sb.append(" alias='");
                    sb.append(XMLUtil.escape(fileAlias));
                    sb.append("'");
                }
                if ((downloadSize = (entryContentInfo = entry.getContentInfo()).getSizeInfo().getDownloadSize()) != Long.MIN_VALUE) {
                    sb.append(" size='");
                    sb.append(downloadSize);
                    sb.append("'");
                }
                ContentInfoUtil.appendMessageDigestsXML(sb, (IMessageDigests)entryContentInfo);
                String fileName2 = entry.getFileName2();
                if (fileName2.length() > 0) {
                    sb.append(" name2='");
                    sb.append(XMLUtil.escape(fileName2));
                    sb.append("'");
                }
                if ((downloadSize2 = (entryContentInfo2 = entry.getContentInfo2()).getSizeInfo().getDownloadSize()) != Long.MIN_VALUE) {
                    sb.append(" size2='");
                    sb.append(downloadSize2);
                    sb.append("'");
                }
                ContentInfoUtil.appendMessageDigestsXML(sb, entryContentInfo2, "2");
                sb.append("/>");
                writer.println(sb.toString());
            }
            writer.println("</toc>");
            writer.flush();
            tocFile.setLength(tocFile.getFilePointer());
            FileUtil.fdSync(tocFile.getFD());
            if (tocUpdate.getOnSaved() != null) {
                tocUpdate.onSave((IPath)new Path(tocFile.getLocation()), contentInfo, monitor);
            }
        }
        finally {
            if (os != null) {
                os.close();
            }
            if (writer != null) {
                try {
                    tocFile.getChannel().close();
                }
                catch (IOException iOException) {}
                writer.close();
            }
        }
    }

    public static interface IOnTocSaved {
        public void onSave(IPath var1, IContentInfo var2, IProgressMonitor var3) throws IOException;
    }

    static class Parameters {
        private final boolean supportDigests;

        public Parameters(boolean supportDigests) {
            this.supportDigests = supportDigests;
        }

        public boolean supportDigests() {
            return this.supportDigests;
        }
    }

    public static class Toc {
        private Version version;
        private final ArrayList entries;

        public Toc(int capacity) {
            this.entries = new ArrayList(capacity);
        }

        public Toc() {
            this.entries = new ArrayList();
        }

        public void ensureCapacity(int minCapacity) {
            this.entries.ensureCapacity(minCapacity);
        }

        public Version getVersion() {
            return this.version;
        }

        public void setVersion(Version version) {
            this.version = version;
        }

        public void addEntry(TocEntry entry) {
            this.entries.add(entry);
        }

        public List getEntries() {
            return Collections.unmodifiableList(this.entries);
        }

        public List getFileNames() {
            return new AbstractList(){

                @Override
                public Object get(int index) {
                    return ((TocEntry)entries.get(index)).getFileName();
                }

                @Override
                public int size() {
                    return entries.size();
                }
            };
        }

        public TocEntry getEntry(String fileName) {
            for (TocEntry tocEntry : this.entries) {
                if (!tocEntry.getFileName().equals(fileName)) continue;
                return tocEntry;
            }
            return null;
        }

        public TocEntry getEntryByAlias(String aliasName) {
            for (TocEntry tocEntry : this.entries) {
                if (!tocEntry.getAlias().equals(aliasName)) continue;
                return tocEntry;
            }
            return null;
        }

        public TocEntry removeEntry(String fileName) {
            Iterator iter = this.entries.iterator();
            while (iter.hasNext()) {
                TocEntry tocEntry = (TocEntry)iter.next();
                if (!tocEntry.getFileName().equals(fileName)) continue;
                iter.remove();
                return tocEntry;
            }
            return null;
        }
    }

    public static class TocEntry {
        private String fileName;
        private String fileName2;
        private String alias;
        private FileContentInfo contentInfo;
        private FileContentInfo contentInfo2;

        public TocEntry(TocEntry rhs) {
            this.fileName = rhs.fileName;
            this.fileName2 = rhs.fileName2;
            this.alias = rhs.alias;
            this.contentInfo = new FileContentInfo(rhs.contentInfo);
            this.contentInfo2 = new FileContentInfo(rhs.contentInfo2);
        }

        public TocEntry(String fileName, String alias, IContentInfo contentInfo) {
            this(fileName, alias, contentInfo, null, null);
        }

        public TocEntry(String fileName, String alias, IContentInfo contentInfo, String fileName2, IContentInfo contentInfo2) {
            assert (fileName != null);
            this.fileName = fileName;
            this.setFileName2(fileName2);
            this.setAlias(alias);
            this.contentInfo = contentInfo == null ? new FileContentInfo(null, new CicFileLocation(this.fileName)) : new FileContentInfo(contentInfo);
            this.contentInfo2 = contentInfo2 == null ? new FileContentInfo(null, new CicFileLocation(this.fileName2)) : new FileContentInfo(contentInfo2);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof TocEntry) {
                TocEntry rhs = (TocEntry)o;
                if (!rhs.fileName.equals(this.fileName)) {
                    return false;
                }
                if (!rhs.fileName2.equals(this.fileName2)) {
                    return false;
                }
                if (!rhs.alias.equals(this.alias)) {
                    return false;
                }
                if (!rhs.contentInfo.getDigestSet().equals(this.contentInfo.getDigestSet())) {
                    return false;
                }
                if (!rhs.contentInfo.getSizeInfo().equals(this.contentInfo.getSizeInfo())) {
                    return false;
                }
                if (!rhs.contentInfo2.getDigestSet().equals(this.contentInfo2.getDigestSet())) {
                    return false;
                }
                return rhs.contentInfo2.getSizeInfo().equals(this.contentInfo2.getSizeInfo());
            }
            return false;
        }

        public int hashCode() {
            int h = this.fileName.hashCode();
            h += h * 7 + this.fileName2.hashCode();
            h += h * 7 + this.alias.hashCode();
            h += h * 7 + this.contentInfo.getDigestSet().hashCode();
            h += h * 7 + this.contentInfo.getSizeInfo().hashCode();
            h += h * 7 + this.contentInfo2.getDigestSet().hashCode();
            h += h * 7 + this.contentInfo2.getSizeInfo().hashCode();
            return h;
        }

        public String getAlias() {
            return this.alias;
        }

        private void setAlias(String alias) {
            this.alias = alias != null ? alias : TableOfContents.EMPTY_STRING;
        }

        public String getFileName() {
            return this.fileName;
        }

        public void setFileName(String fileName) {
            this.fileName = fileName == null ? TableOfContents.EMPTY_STRING : fileName;
        }

        public String getFileName2() {
            return this.fileName2;
        }

        public void setFileName2(String fileName2) {
            this.fileName2 = fileName2 == null ? TableOfContents.EMPTY_STRING : fileName2;
        }

        public FileContentInfo getContentInfo() {
            return this.contentInfo;
        }

        public void setContentInfo(IContentInfo contentInfo) {
            this.contentInfo = new FileContentInfo(contentInfo);
        }

        public FileContentInfo getContentInfo2() {
            return this.contentInfo2;
        }

        public void setContentInfo2(IContentInfo contentInfo2) {
            this.contentInfo2 = new FileContentInfo(contentInfo2);
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("file='");
            sb.append(this.fileName);
            sb.append("'");
            sb.append(" alias='");
            sb.append(this.alias);
            sb.append("' ");
            sb.append(this.contentInfo);
            sb.append(" file2='");
            sb.append(this.fileName2);
            sb.append("' ");
            sb.append(this.contentInfo2);
            return sb.toString();
        }
    }

    private static class TocFile
    extends AdvisoryLockedFile {
        public TocFile(File file, boolean forReadingOnly) throws IOException {
            super(file, forReadingOnly, UserOptions.CIC_REPO_LOCKING.isSet());
        }
    }

    private static class TocHandler
    extends DefaultHandler
    implements TocVersionInfo {
        private final Parameters params;
        protected Toc toc;
        protected String location;
        private Version version;
        private Locator locator;

        public TocHandler(Parameters params, Toc toc, String location) {
            this.params = params;
            this.toc = toc;
            this.location = location;
        }

        @Override
        public void processingInstruction(String target, String data) {
            if ("toc".equals(target)) {
                this.version = MetaInfo.extractVersion(data);
            }
        }

        @Override
        public void setDocumentLocator(Locator locator) {
            this.locator = locator;
        }

        private Version ensureVersionCompatibility() throws SAXParseException {
            Version effective = this.version == null ? VERSION_0 : this.version;
            if (this.params.supportDigests() && !TOLERANCE.isIncluded(effective)) {
                throw new SAXParseException(NLS.bind(Messages.TocParser_incompatible_version, this.location, effective, TOLERANCE), this.locator);
            }
            return effective;
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXParseException {
            if (qName.equals("toc")) {
                String fileCount;
                Version effVer = this.ensureVersionCompatibility();
                this.toc.setVersion(effVer);
                if (TocVersionInfo.TOLERANCE_VERSION1_TO_MAX.isIncluded(effVer) && (fileCount = attributes.getValue("fileCount")) != null) {
                    int iFileCount = Integer.parseInt(fileCount);
                    this.toc.ensureCapacity(iFileCount);
                }
            } else if (qName.equals("file")) {
                String alias = attributes.getValue("alias");
                String name = attributes.getValue("name");
                if (name != null) {
                    FileContentInfo sci = new FileContentInfo(null, new CicFileLocation(name));
                    String name2 = attributes.getValue("name2");
                    FileContentInfo sci2 = null;
                    if (this.params.supportDigests()) {
                        DigestAttributes.setDigestValues(attributes, false, sci);
                        String sz = attributes.getValue("size");
                        if (sz != null) {
                            long size = Long.parseLong(sz);
                            sci.setSize(size);
                        }
                        if (name2 != null) {
                            sci2 = new FileContentInfo(null, new CicFileLocation(name2));
                            DigestAttributes.setDigestValues(attributes, false, sci2, "2");
                            String sz2 = attributes.getValue("size2");
                            if (sz2 != null) {
                                long size = Long.parseLong(sz2);
                                sci2.setSize(size);
                            }
                        }
                    }
                    TocEntry entry = new TocEntry(name, alias, sci, name2, sci2);
                    this.toc.addEntry(entry);
                }
            }
        }

        @Override
        public void warning(SAXParseException e) {
            this.log(2, e);
        }

        @Override
        public void error(SAXParseException e) {
            this.log(4, e);
        }

        @Override
        public void fatalError(SAXParseException e) throws SAXException {
            this.log(4, e);
            throw e;
        }

        private void log(int severity, SAXParseException e) {
            String message = this.getMessage(e);
            ComIbmCicCommonCorePlugin.getDefault().getLog().log((IStatus)new Status(severity, ComIbmCicCommonCorePlugin.getPluginId(), severity, message, null));
        }

        private String getMessage(SAXParseException e) {
            StringBuffer sb = new StringBuffer();
            sb.append(this.location);
            sb.append(": ");
            String systemId = e.getSystemId();
            if (systemId != null) {
                sb.append(systemId);
                sb.append(':');
            }
            sb.append(e.getLineNumber());
            sb.append(':');
            sb.append(e.getColumnNumber());
            sb.append(": ");
            sb.append(e.getMessage());
            return sb.toString();
        }
    }

    private static abstract class TocUpdate {
        Toc toc;
        Collection tocEntriesToUpdate;
        boolean isDirty = false;
        private final IOnTocSaved onSaved;

        public TocUpdate(Toc toc, Collection tocEntriesToUpdate, IOnTocSaved onSaved) {
            this.toc = toc;
            this.tocEntriesToUpdate = tocEntriesToUpdate;
            this.onSaved = onSaved;
        }

        public void onSave(IPath fullPath, IContentInfo contentInfo, IProgressMonitor monitor) throws IOException {
            if (this.onSaved != null) {
                this.onSaved.onSave(fullPath, contentInfo, monitor);
            }
        }

        public abstract boolean doUpdate(IProgressMonitor var1);

        public Toc getToc() {
            return this.toc;
        }

        public IOnTocSaved getOnSaved() {
            return this.onSaved;
        }
    }
}

