/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.internal.repository;

import com.ibm.cic.common.core.model.IIdentity;
import com.ibm.cic.common.core.model.IOffering;
import com.ibm.cic.common.core.model.SimpleIdentity;
import com.ibm.cic.common.core.model.proxy.OfferingReference;
import com.ibm.cic.common.core.repository.ICicLocation;
import com.ibm.cic.common.core.repository.IRepository;
import com.ibm.cic.common.core.repository.UpdateOfferingUtils;
import com.ibm.cic.common.core.repository.digest.RepositoryDigestBaseOfferingData;
import com.ibm.cic.common.core.repository.digest.RepositoryDigestOfferingData;
import com.ibm.cic.common.core.utils.LinkedProperties;
import com.ibm.cic.common.core.utils.NLS;
import com.ibm.cic.common.core.utils.PathUtil;
import com.ibm.cic.common.core.utils.SplitIdVersionUtil;
import com.ibm.cic.common.logging.ExceptionUtil;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import org.osgi.framework.Version;

public class RepositoryUpdateOfferingHandler {
    private static final String PREFIX = "UPDATES_";
    private static final String SEPARATOR = "~";
    private final IRepository m_repository;
    private Map<String, String> m_updates;

    public static boolean isUpdateProperty(String key) {
        return key.startsWith(PREFIX);
    }

    public static String constructKey(RepositoryDigestOfferingData offering) {
        return RepositoryUpdateOfferingHandler.constructKey(offering.getIdentity(), offering.getVersion());
    }

    private static String constructKey(IIdentity id, Version version) {
        return PREFIX + id + SEPARATOR + version;
    }

    public static String constructVal(RepositoryDigestBaseOfferingData updateData) {
        return RepositoryUpdateOfferingHandler.constructVal(updateData.getId(), updateData.getVersion(), updateData.getDisplayVersion());
    }

    private static String constructVal(IIdentity id, Version version, String displayVersion) {
        return id + SEPARATOR + version + SEPARATOR + displayVersion;
    }

    public RepositoryUpdateOfferingHandler(IRepository repository) {
        this.m_repository = repository;
    }

    private Map<String, String> getUpdatesInfo() {
        if (this.m_updates == null) {
            this.m_updates = new HashMap<String, String>();
            LinkedProperties props = this.m_repository.getSiteProperties().getProperties();
            String[] stringArray = props.getPropertyKeys();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String key = stringArray[n2];
                if (RepositoryUpdateOfferingHandler.isUpdateProperty(key)) {
                    this.m_updates.put(key, props.getProperty(key));
                }
                ++n2;
            }
        }
        return this.m_updates;
    }

    private String getUpdateInfo(IOffering offering) {
        return this.getUpdateInfo(offering.getIdentity(), offering.getVersion());
    }

    private String getUpdateInfo(IIdentity id, Version version) {
        return this.getUpdatesInfo().get(RepositoryUpdateOfferingHandler.constructKey(id, version));
    }

    private void setUpdateInfo(IOffering offering, String value) {
        String key = RepositoryUpdateOfferingHandler.constructKey(offering.getIdentity(), offering.getVersion());
        if (value == null) {
            this.getUpdatesInfo().remove(key);
        } else {
            this.getUpdatesInfo().put(key, value);
        }
    }

    public void handleUpdate(OfferingReference offeringRef) {
        String updateInfo = this.getUpdateInfo(offeringRef);
        if (updateInfo != null) {
            offeringRef.setUpdate(RepositoryUpdateOfferingHandler.parseUpdateProperty(updateInfo));
        }
    }

    public boolean isUpdateOffering(IOffering offering) {
        return this.getUpdateInfo(offering) != null;
    }

    public boolean isUpdateOfferingFile(String offeringFileName) {
        String extension = PathUtil.getExtension(offeringFileName);
        String nameAndVersionText = offeringFileName.substring(0, offeringFileName.length() - (extension.length() + 1));
        Object[] idAndVersion = SplitIdVersionUtil.splitIdUnderscoreVersion(nameAndVersionText);
        String id = (String)idAndVersion[0];
        Version version = (Version)idAndVersion[1];
        return version != null && this.getUpdateInfo(new SimpleIdentity(id), version) != null;
    }

    public void refresh() {
        this.m_updates = null;
    }

    public void setUpdateOffering(IOffering offering) {
        if (UpdateOfferingUtils.isUpdate(offering)) {
            this.setUpdateInfo(offering, RepositoryUpdateOfferingHandler.constructVal(UpdateOfferingUtils.getBaseOfferingId(offering), UpdateOfferingUtils.getBaseOfferingVersion(offering), UpdateOfferingUtils.getBaseOfferingDisplayVersion(offering)));
        }
    }

    public void unsetUpdateOffering(IOffering updateOffering) {
        this.setUpdateInfo(updateOffering, null);
        this.terminateUpdateOfferingLogFile(updateOffering);
    }

    private static RepositoryDigestBaseOfferingData parseUpdateProperty(String val) {
        if (val == null) {
            return null;
        }
        StringTokenizer tok = new StringTokenizer(val, SEPARATOR);
        try {
            String id = tok.nextToken();
            String version = tok.nextToken();
            String displayVersion = tok.nextToken();
            return new RepositoryDigestBaseOfferingData(new SimpleIdentity(id), new Version(version), displayVersion);
        }
        catch (NoSuchElementException e) {
            return null;
        }
    }

    public boolean updateMatchesIdAndVersion(IOffering update, IIdentity id, Version ver) {
        RepositoryDigestBaseOfferingData updateData;
        if (!(id != null && !update.getIdentity().equals(id) || ver != null && ver.compareTo(update.getVersion()) >= 0 || (updateData = RepositoryUpdateOfferingHandler.parseUpdateProperty(this.getUpdateInfo(update))) == null)) {
            return !(id != null && !updateData.getId().equals(id) || ver != null && updateData.getVersion().compareTo(ver) > 0);
        }
        return false;
    }

    private void terminateUpdateOfferingLogFile(IOffering offering) {
        try {
            ICicLocation repoLocation = offering.getRepository().getLocation();
            Version baseVersion = UpdateOfferingUtils.getBaseOfferingVersion(offering);
            String simpleName = NLS.bind("update_{0}_{1}_from_{2}.xml", offering.getIdentity(), offering.getVersion(), baseVersion);
            File file = new File(repoLocation.toFile(), simpleName);
            if (file.exists() && file.canWrite()) {
                file.delete();
            }
        }
        catch (Throwable e) {
            ExceptionUtil.log.error(e);
        }
    }
}

