/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.internal.preferences;

import com.ibm.cic.common.core.preferences.CicCommonSettings;
import com.ibm.cic.eclipse.internals.preferences.EclipsePreferences;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;

public abstract class CommonPreferences
extends EclipsePreferences {
    private int depth;
    private String qualifier;
    private IPath location;
    private IEclipsePreferences loadLevel;
    private static boolean initialized = false;
    private static Set loadedNodes = new HashSet();
    private static IPath baseLocation;

    protected CommonPreferences(IEclipsePreferences parent, String key) {
        super(parent, key);
        String path = this.absolutePath();
        this.depth = CommonPreferences.getSegmentCount((String)path);
        if (this.depth < 2) {
            return;
        }
        this.qualifier = CommonPreferences.getSegment((String)path, (int)1);
        if (this.qualifier == null) {
            return;
        }
        this.initializeChildren();
    }

    public abstract String getName();

    protected abstract EclipsePreferences internalCreate(IEclipsePreferences var1, String var2, Object var3);

    protected IEclipsePreferences getLoadLevel() {
        if (this.loadLevel == null) {
            if (this.qualifier == null) {
                return null;
            }
            CommonPreferences node = this;
            int i = 2;
            while (i < this.depth) {
                node = (IEclipsePreferences)node.parent();
                ++i;
            }
            this.loadLevel = node;
        }
        return this.loadLevel;
    }

    protected IPath getLocation() {
        if (this.location == null && this.qualifier != null) {
            this.location = this.computeLocation(CommonPreferences.getBaseLocation(), this.qualifier);
        }
        return this.location;
    }

    private static IPath getBaseLocation() {
        if (baseLocation == null) {
            baseLocation = new Path(CicCommonSettings.getApplicationDataLocation());
        }
        return baseLocation;
    }

    protected boolean isAlreadyLoaded(IEclipsePreferences node) {
        return loadedNodes.contains(node.name());
    }

    protected void loaded() {
        loadedNodes.add(this.name());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initializeChildren() {
        if (initialized || this.parent() == null) {
            return;
        }
        try {
            CommonPreferences commonPreferences = this;
            synchronized (commonPreferences) {
                String[] names;
                String[] stringArray = names = this.computeChildren(CommonPreferences.getBaseLocation());
                int n = names.length;
                int n2 = 0;
                while (n2 < n) {
                    String name2 = stringArray[n2];
                    this.addChild(name2, null);
                    ++n2;
                }
            }
        }
        finally {
            initialized = true;
        }
    }
}

